/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims.internal;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.ims.internal.IImsVideoCallCallback;

public interface IImsVideoCallProvider
extends IInterface {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/ims/internal/IImsVideoCallProvider.aidl:44:1:44:69")
    public void setCallback(IImsVideoCallCallback var1) throws RemoteException;

    public void setCamera(String var1, int var2) throws RemoteException;

    public void setPreviewSurface(Surface var1) throws RemoteException;

    public void setDisplaySurface(Surface var1) throws RemoteException;

    public void setDeviceOrientation(int var1) throws RemoteException;

    public void setZoom(float var1) throws RemoteException;

    public void sendSessionModifyRequest(VideoProfile var1, VideoProfile var2) throws RemoteException;

    public void sendSessionModifyResponse(VideoProfile var1) throws RemoteException;

    public void requestCameraCapabilities() throws RemoteException;

    public void requestCallDataUsage() throws RemoteException;

    public void setPauseImage(Uri var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsVideoCallProvider {
        public static final String DESCRIPTOR = "com.android.ims.internal.IImsVideoCallProvider";
        static final int TRANSACTION_setCallback = 1;
        static final int TRANSACTION_setCamera = 2;
        static final int TRANSACTION_setPreviewSurface = 3;
        static final int TRANSACTION_setDisplaySurface = 4;
        static final int TRANSACTION_setDeviceOrientation = 5;
        static final int TRANSACTION_setZoom = 6;
        static final int TRANSACTION_sendSessionModifyRequest = 7;
        static final int TRANSACTION_sendSessionModifyResponse = 8;
        static final int TRANSACTION_requestCameraCapabilities = 9;
        static final int TRANSACTION_requestCallDataUsage = 10;
        static final int TRANSACTION_setPauseImage = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IImsVideoCallProvider asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IImsVideoCallProvider) {
                return (IImsVideoCallProvider)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setCallback";
                }
                case 2: {
                    return "setCamera";
                }
                case 3: {
                    return "setPreviewSurface";
                }
                case 4: {
                    return "setDisplaySurface";
                }
                case 5: {
                    return "setDeviceOrientation";
                }
                case 6: {
                    return "setZoom";
                }
                case 7: {
                    return "sendSessionModifyRequest";
                }
                case 8: {
                    return "sendSessionModifyResponse";
                }
                case 9: {
                    return "requestCameraCapabilities";
                }
                case 10: {
                    return "requestCallDataUsage";
                }
                case 11: {
                    return "setPauseImage";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    IImsVideoCallCallback _arg0 = IImsVideoCallCallback.Stub.asInterface(data.readStrongBinder());
                    this.setCallback(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.setCamera(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    Surface _arg0 = 0 != data.readInt() ? Surface.CREATOR.createFromParcel(data) : null;
                    this.setPreviewSurface(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    Surface _arg0 = 0 != data.readInt() ? Surface.CREATOR.createFromParcel(data) : null;
                    this.setDisplaySurface(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setDeviceOrientation(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    float _arg0 = data.readFloat();
                    this.setZoom(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    VideoProfile _arg0 = 0 != data.readInt() ? VideoProfile.CREATOR.createFromParcel(data) : null;
                    VideoProfile _arg1 = 0 != data.readInt() ? VideoProfile.CREATOR.createFromParcel(data) : null;
                    this.sendSessionModifyRequest(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    VideoProfile _arg0 = 0 != data.readInt() ? VideoProfile.CREATOR.createFromParcel(data) : null;
                    this.sendSessionModifyResponse(_arg0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    this.requestCameraCapabilities();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    this.requestCallDataUsage();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    Uri _arg0 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    this.setPauseImage(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IImsVideoCallProvider impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IImsVideoCallProvider getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IImsVideoCallProvider {
            private IBinder mRemote;
            public static IImsVideoCallProvider sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCallback(IImsVideoCallCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setCallback(callback2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCamera(String cameraId, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setCamera(cameraId, uid);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPreviewSurface(Surface surface2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (surface2 != null) {
                        _data.writeInt(1);
                        surface2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPreviewSurface(surface2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplaySurface(Surface surface2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (surface2 != null) {
                        _data.writeInt(1);
                        surface2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDisplaySurface(surface2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceOrientation(int rotation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDeviceOrientation(rotation);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setZoom(float value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(value2);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setZoom(value2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSessionModifyRequest(VideoProfile fromProfile, VideoProfile toProfile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (fromProfile != null) {
                        _data.writeInt(1);
                        fromProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (toProfile != null) {
                        _data.writeInt(1);
                        toProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendSessionModifyRequest(fromProfile, toProfile);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSessionModifyResponse(VideoProfile responseProfile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (responseProfile != null) {
                        _data.writeInt(1);
                        responseProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendSessionModifyResponse(responseProfile);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void requestCameraCapabilities() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestCameraCapabilities();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void requestCallDataUsage() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestCallDataUsage();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPauseImage(Uri uri) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (uri != null) {
                        _data.writeInt(1);
                        uri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPauseImage(uri);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsVideoCallProvider {
        @Override
        public void setCallback(IImsVideoCallCallback callback2) throws RemoteException {
        }

        @Override
        public void setCamera(String cameraId, int uid) throws RemoteException {
        }

        @Override
        public void setPreviewSurface(Surface surface2) throws RemoteException {
        }

        @Override
        public void setDisplaySurface(Surface surface2) throws RemoteException {
        }

        @Override
        public void setDeviceOrientation(int rotation) throws RemoteException {
        }

        @Override
        public void setZoom(float value2) throws RemoteException {
        }

        @Override
        public void sendSessionModifyRequest(VideoProfile fromProfile, VideoProfile toProfile) throws RemoteException {
        }

        @Override
        public void sendSessionModifyResponse(VideoProfile responseProfile) throws RemoteException {
        }

        @Override
        public void requestCameraCapabilities() throws RemoteException {
        }

        @Override
        public void requestCallDataUsage() throws RemoteException {
        }

        @Override
        public void setPauseImage(Uri uri) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

