/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsStreamMediaProfile;
import android.telephony.ims.RtpHeaderExtension;
import android.telephony.ims.aidl.IImsCallSessionListener;
import com.android.ims.internal.IImsVideoCallProvider;
import java.util.ArrayList;
import java.util.List;

public interface IImsCallSession
extends IInterface {
    public void close() throws RemoteException;

    public String getCallId() throws RemoteException;

    public ImsCallProfile getCallProfile() throws RemoteException;

    public ImsCallProfile getLocalCallProfile() throws RemoteException;

    public ImsCallProfile getRemoteCallProfile() throws RemoteException;

    public String getProperty(String var1) throws RemoteException;

    public int getState() throws RemoteException;

    public boolean isInCall() throws RemoteException;

    public void setListener(IImsCallSessionListener var1) throws RemoteException;

    public void setMute(boolean var1) throws RemoteException;

    public void start(String var1, ImsCallProfile var2) throws RemoteException;

    public void startConference(String[] var1, ImsCallProfile var2) throws RemoteException;

    public void accept(int var1, ImsStreamMediaProfile var2) throws RemoteException;

    public void deflect(String var1) throws RemoteException;

    public void reject(int var1) throws RemoteException;

    public void transfer(String var1, boolean var2) throws RemoteException;

    public void consultativeTransfer(IImsCallSession var1) throws RemoteException;

    public void terminate(int var1) throws RemoteException;

    public void hold(ImsStreamMediaProfile var1) throws RemoteException;

    public void resume(ImsStreamMediaProfile var1) throws RemoteException;

    public void merge() throws RemoteException;

    public void update(int var1, ImsStreamMediaProfile var2) throws RemoteException;

    public void extendToConference(String[] var1) throws RemoteException;

    public void inviteParticipants(String[] var1) throws RemoteException;

    public void removeParticipants(String[] var1) throws RemoteException;

    public void sendDtmf(char var1, Message var2) throws RemoteException;

    public void startDtmf(char var1) throws RemoteException;

    public void stopDtmf() throws RemoteException;

    public void sendUssd(String var1) throws RemoteException;

    public IImsVideoCallProvider getVideoCallProvider() throws RemoteException;

    public boolean isMultiparty() throws RemoteException;

    public void sendRttModifyRequest(ImsCallProfile var1) throws RemoteException;

    public void sendRttModifyResponse(boolean var1) throws RemoteException;

    public void sendRttMessage(String var1) throws RemoteException;

    public void sendRtpHeaderExtensions(List<RtpHeaderExtension> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsCallSession {
        public static final String DESCRIPTOR = "com.android.ims.internal.IImsCallSession";
        static final int TRANSACTION_close = 1;
        static final int TRANSACTION_getCallId = 2;
        static final int TRANSACTION_getCallProfile = 3;
        static final int TRANSACTION_getLocalCallProfile = 4;
        static final int TRANSACTION_getRemoteCallProfile = 5;
        static final int TRANSACTION_getProperty = 6;
        static final int TRANSACTION_getState = 7;
        static final int TRANSACTION_isInCall = 8;
        static final int TRANSACTION_setListener = 9;
        static final int TRANSACTION_setMute = 10;
        static final int TRANSACTION_start = 11;
        static final int TRANSACTION_startConference = 12;
        static final int TRANSACTION_accept = 13;
        static final int TRANSACTION_deflect = 14;
        static final int TRANSACTION_reject = 15;
        static final int TRANSACTION_transfer = 16;
        static final int TRANSACTION_consultativeTransfer = 17;
        static final int TRANSACTION_terminate = 18;
        static final int TRANSACTION_hold = 19;
        static final int TRANSACTION_resume = 20;
        static final int TRANSACTION_merge = 21;
        static final int TRANSACTION_update = 22;
        static final int TRANSACTION_extendToConference = 23;
        static final int TRANSACTION_inviteParticipants = 24;
        static final int TRANSACTION_removeParticipants = 25;
        static final int TRANSACTION_sendDtmf = 26;
        static final int TRANSACTION_startDtmf = 27;
        static final int TRANSACTION_stopDtmf = 28;
        static final int TRANSACTION_sendUssd = 29;
        static final int TRANSACTION_getVideoCallProvider = 30;
        static final int TRANSACTION_isMultiparty = 31;
        static final int TRANSACTION_sendRttModifyRequest = 32;
        static final int TRANSACTION_sendRttModifyResponse = 33;
        static final int TRANSACTION_sendRttMessage = 34;
        static final int TRANSACTION_sendRtpHeaderExtensions = 35;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IImsCallSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IImsCallSession) {
                return (IImsCallSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "close";
                }
                case 2: {
                    return "getCallId";
                }
                case 3: {
                    return "getCallProfile";
                }
                case 4: {
                    return "getLocalCallProfile";
                }
                case 5: {
                    return "getRemoteCallProfile";
                }
                case 6: {
                    return "getProperty";
                }
                case 7: {
                    return "getState";
                }
                case 8: {
                    return "isInCall";
                }
                case 9: {
                    return "setListener";
                }
                case 10: {
                    return "setMute";
                }
                case 11: {
                    return "start";
                }
                case 12: {
                    return "startConference";
                }
                case 13: {
                    return "accept";
                }
                case 14: {
                    return "deflect";
                }
                case 15: {
                    return "reject";
                }
                case 16: {
                    return "transfer";
                }
                case 17: {
                    return "consultativeTransfer";
                }
                case 18: {
                    return "terminate";
                }
                case 19: {
                    return "hold";
                }
                case 20: {
                    return "resume";
                }
                case 21: {
                    return "merge";
                }
                case 22: {
                    return "update";
                }
                case 23: {
                    return "extendToConference";
                }
                case 24: {
                    return "inviteParticipants";
                }
                case 25: {
                    return "removeParticipants";
                }
                case 26: {
                    return "sendDtmf";
                }
                case 27: {
                    return "startDtmf";
                }
                case 28: {
                    return "stopDtmf";
                }
                case 29: {
                    return "sendUssd";
                }
                case 30: {
                    return "getVideoCallProvider";
                }
                case 31: {
                    return "isMultiparty";
                }
                case 32: {
                    return "sendRttModifyRequest";
                }
                case 33: {
                    return "sendRttModifyResponse";
                }
                case 34: {
                    return "sendRttMessage";
                }
                case 35: {
                    return "sendRtpHeaderExtensions";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    this.close();
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _result = this.getCallId();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ImsCallProfile _result = this.getCallProfile();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    ImsCallProfile _result = this.getLocalCallProfile();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    ImsCallProfile _result = this.getRemoteCallProfile();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.getProperty(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _result = this.getState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isInCall();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    IImsCallSessionListener _arg0 = IImsCallSessionListener.Stub.asInterface(data.readStrongBinder());
                    this.setListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setMute(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ImsCallProfile _arg1 = 0 != data.readInt() ? ImsCallProfile.CREATOR.createFromParcel(data) : null;
                    this.start(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    ImsCallProfile _arg1 = 0 != data.readInt() ? ImsCallProfile.CREATOR.createFromParcel(data) : null;
                    this.startConference(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ImsStreamMediaProfile _arg1 = 0 != data.readInt() ? ImsStreamMediaProfile.CREATOR.createFromParcel(data) : null;
                    this.accept(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.deflect(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.reject(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.transfer(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    IImsCallSession _arg0 = Stub.asInterface(data.readStrongBinder());
                    this.consultativeTransfer(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.terminate(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    ImsStreamMediaProfile _arg0 = 0 != data.readInt() ? ImsStreamMediaProfile.CREATOR.createFromParcel(data) : null;
                    this.hold(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    ImsStreamMediaProfile _arg0 = 0 != data.readInt() ? ImsStreamMediaProfile.CREATOR.createFromParcel(data) : null;
                    this.resume(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    this.merge();
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ImsStreamMediaProfile _arg1 = 0 != data.readInt() ? ImsStreamMediaProfile.CREATOR.createFromParcel(data) : null;
                    this.update(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    this.extendToConference(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    this.inviteParticipants(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    this.removeParticipants(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    char _arg0 = (char)data.readInt();
                    Message _arg1 = 0 != data.readInt() ? Message.CREATOR.createFromParcel(data) : null;
                    this.sendDtmf(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    char _arg0 = (char)data.readInt();
                    this.startDtmf(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    this.stopDtmf();
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.sendUssd(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    IImsVideoCallProvider _result = this.getVideoCallProvider();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isMultiparty();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    ImsCallProfile _arg0 = 0 != data.readInt() ? ImsCallProfile.CREATOR.createFromParcel(data) : null;
                    this.sendRttModifyRequest(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.sendRttModifyResponse(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.sendRttMessage(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    ArrayList<RtpHeaderExtension> _arg0 = data.createTypedArrayList(RtpHeaderExtension.CREATOR);
                    this.sendRtpHeaderExtensions(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IImsCallSession impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IImsCallSession getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IImsCallSession {
            private IBinder mRemote;
            public static IImsCallSession sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().close();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCallId() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getCallId();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImsCallProfile getCallProfile() throws RemoteException {
                ImsCallProfile _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ImsCallProfile imsCallProfile = Stub.getDefaultImpl().getCallProfile();
                        return imsCallProfile;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ImsCallProfile.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImsCallProfile getLocalCallProfile() throws RemoteException {
                ImsCallProfile _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ImsCallProfile imsCallProfile = Stub.getDefaultImpl().getLocalCallProfile();
                        return imsCallProfile;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ImsCallProfile.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImsCallProfile getRemoteCallProfile() throws RemoteException {
                ImsCallProfile _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ImsCallProfile imsCallProfile = Stub.getDefaultImpl().getRemoteCallProfile();
                        return imsCallProfile;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ImsCallProfile.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getProperty(String name) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getProperty(name);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInCall() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isInCall();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setListener(IImsCallSessionListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setListener(listener2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMute(boolean muted) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(muted ? 1 : 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setMute(muted);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start(String callee, ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callee);
                    if (profile != null) {
                        _data.writeInt(1);
                        profile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().start(callee, profile);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startConference(String[] participants, ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(participants);
                    if (profile != null) {
                        _data.writeInt(1);
                        profile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startConference(participants, profile);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(int callType, ImsStreamMediaProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(callType);
                    if (profile != null) {
                        _data.writeInt(1);
                        profile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().accept(callType, profile);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deflect(String deflectNumber) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deflectNumber);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deflect(deflectNumber);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reject(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reject(reason);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transfer(String number, boolean isConfirmationRequired) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(number);
                    _data.writeInt(isConfirmationRequired ? 1 : 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().transfer(number, isConfirmationRequired);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consultativeTransfer(IImsCallSession transferToSession) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(transferToSession != null ? transferToSession.asBinder() : null);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().consultativeTransfer(transferToSession);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void terminate(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().terminate(reason);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hold(ImsStreamMediaProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (profile != null) {
                        _data.writeInt(1);
                        profile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hold(profile);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resume(ImsStreamMediaProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (profile != null) {
                        _data.writeInt(1);
                        profile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().resume(profile);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void merge() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().merge();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update(int callType, ImsStreamMediaProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(callType);
                    if (profile != null) {
                        _data.writeInt(1);
                        profile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().update(callType, profile);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void extendToConference(String[] participants) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(participants);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().extendToConference(participants);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void inviteParticipants(String[] participants) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(participants);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().inviteParticipants(participants);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeParticipants(String[] participants) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(participants);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeParticipants(participants);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendDtmf(char c, Message result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(c);
                    if (result != null) {
                        _data.writeInt(1);
                        result.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendDtmf(c, result);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDtmf(char c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(c);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startDtmf(c);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopDtmf() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopDtmf();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendUssd(String ussdMessage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(ussdMessage);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendUssd(ussdMessage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsVideoCallProvider getVideoCallProvider() throws RemoteException {
                IImsVideoCallProvider _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsVideoCallProvider iImsVideoCallProvider = Stub.getDefaultImpl().getVideoCallProvider();
                        return iImsVideoCallProvider;
                    }
                    _reply.readException();
                    _result = IImsVideoCallProvider.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMultiparty() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isMultiparty();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRttModifyRequest(ImsCallProfile toProfile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (toProfile != null) {
                        _data.writeInt(1);
                        toProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendRttModifyRequest(toProfile);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRttModifyResponse(boolean status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status ? 1 : 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendRttModifyResponse(status);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRttMessage(String rttMessage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(rttMessage);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendRttMessage(rttMessage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRtpHeaderExtensions(List<RtpHeaderExtension> extensions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(extensions);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendRtpHeaderExtensions(extensions);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsCallSession {
        @Override
        public void close() throws RemoteException {
        }

        @Override
        public String getCallId() throws RemoteException {
            return null;
        }

        @Override
        public ImsCallProfile getCallProfile() throws RemoteException {
            return null;
        }

        @Override
        public ImsCallProfile getLocalCallProfile() throws RemoteException {
            return null;
        }

        @Override
        public ImsCallProfile getRemoteCallProfile() throws RemoteException {
            return null;
        }

        @Override
        public String getProperty(String name) throws RemoteException {
            return null;
        }

        @Override
        public int getState() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isInCall() throws RemoteException {
            return false;
        }

        @Override
        public void setListener(IImsCallSessionListener listener2) throws RemoteException {
        }

        @Override
        public void setMute(boolean muted) throws RemoteException {
        }

        @Override
        public void start(String callee, ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void startConference(String[] participants, ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void accept(int callType, ImsStreamMediaProfile profile) throws RemoteException {
        }

        @Override
        public void deflect(String deflectNumber) throws RemoteException {
        }

        @Override
        public void reject(int reason) throws RemoteException {
        }

        @Override
        public void transfer(String number, boolean isConfirmationRequired) throws RemoteException {
        }

        @Override
        public void consultativeTransfer(IImsCallSession transferToSession) throws RemoteException {
        }

        @Override
        public void terminate(int reason) throws RemoteException {
        }

        @Override
        public void hold(ImsStreamMediaProfile profile) throws RemoteException {
        }

        @Override
        public void resume(ImsStreamMediaProfile profile) throws RemoteException {
        }

        @Override
        public void merge() throws RemoteException {
        }

        @Override
        public void update(int callType, ImsStreamMediaProfile profile) throws RemoteException {
        }

        @Override
        public void extendToConference(String[] participants) throws RemoteException {
        }

        @Override
        public void inviteParticipants(String[] participants) throws RemoteException {
        }

        @Override
        public void removeParticipants(String[] participants) throws RemoteException {
        }

        @Override
        public void sendDtmf(char c, Message result) throws RemoteException {
        }

        @Override
        public void startDtmf(char c) throws RemoteException {
        }

        @Override
        public void stopDtmf() throws RemoteException {
        }

        @Override
        public void sendUssd(String ussdMessage) throws RemoteException {
        }

        @Override
        public IImsVideoCallProvider getVideoCallProvider() throws RemoteException {
            return null;
        }

        @Override
        public boolean isMultiparty() throws RemoteException {
            return false;
        }

        @Override
        public void sendRttModifyRequest(ImsCallProfile toProfile) throws RemoteException {
        }

        @Override
        public void sendRttModifyResponse(boolean status) throws RemoteException {
        }

        @Override
        public void sendRttMessage(String rttMessage) throws RemoteException {
        }

        @Override
        public void sendRtpHeaderExtensions(List<RtpHeaderExtension> extensions) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

