/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone.internal;

import com.android.i18n.timezone.internal.BufferIterator;
import com.android.i18n.timezone.internal.Memory;
import com.android.i18n.timezone.internal.MemoryMappedFile;

public class NioBufferIterator
extends BufferIterator {
    private final MemoryMappedFile file;
    private final long address;
    private final int length;
    private final boolean swap;
    private int position;

    NioBufferIterator(MemoryMappedFile file2, long address, int length, boolean swap) {
        file2.checkNotClosed();
        this.file = file2;
        this.address = address;
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        long MAX_VALID_ADDRESS = -1L;
        if (Long.compareUnsigned(address, -1L - (long)length) > 0) {
            throw new IllegalArgumentException("length " + length + " would overflow 64-bit address space");
        }
        this.length = length;
        this.swap = swap;
    }

    @Override
    public void seek(int offset2) {
        this.position = offset2;
    }

    @Override
    public void skip(int byteCount) {
        this.position += byteCount;
    }

    @Override
    public int pos() {
        return this.position;
    }

    @Override
    public void readByteArray(byte[] bytes, int arrayOffset, int byteCount) {
        NioBufferIterator.checkArrayBounds(arrayOffset, bytes.length, byteCount);
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, byteCount);
        Memory.peekByteArray(this.address + (long)this.position, bytes, arrayOffset, byteCount);
        this.position += byteCount;
    }

    @Override
    public byte readByte() {
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, 1);
        byte result = Memory.peekByte(this.address + (long)this.position);
        ++this.position;
        return result;
    }

    @Override
    public int readInt() {
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, 4);
        int result = Memory.peekInt(this.address + (long)this.position, this.swap);
        this.position += 4;
        return result;
    }

    @Override
    public void readIntArray(int[] ints, int arrayOffset, int intCount) {
        NioBufferIterator.checkArrayBounds(arrayOffset, ints.length, intCount);
        this.file.checkNotClosed();
        int byteCount = 4 * intCount;
        NioBufferIterator.checkReadBounds(this.position, this.length, byteCount);
        Memory.peekIntArray(this.address + (long)this.position, ints, arrayOffset, intCount, this.swap);
        this.position += byteCount;
    }

    @Override
    public void readLongArray(long[] longs, int arrayOffset, int longCount) {
        NioBufferIterator.checkArrayBounds(arrayOffset, longs.length, longCount);
        this.file.checkNotClosed();
        int byteCount = 8 * longCount;
        NioBufferIterator.checkReadBounds(this.position, this.length, byteCount);
        Memory.peekLongArray(this.address + (long)this.position, longs, arrayOffset, longCount, this.swap);
        this.position += byteCount;
    }

    @Override
    public short readShort() {
        this.file.checkNotClosed();
        NioBufferIterator.checkReadBounds(this.position, this.length, 2);
        short result = Memory.peekShort(this.address + (long)this.position, this.swap);
        this.position += 2;
        return result;
    }

    private static void checkReadBounds(int position, int length, int byteCount) {
        if (position < 0 || byteCount < 0) {
            throw new IndexOutOfBoundsException("Invalid read args: position=" + position + ", byteCount=" + byteCount);
        }
        int finalReadPos = position + byteCount;
        if (finalReadPos < 0 || finalReadPos > length) {
            throw new IndexOutOfBoundsException("Read outside range: position=" + position + ", byteCount=" + byteCount + ", length=" + length);
        }
    }

    private static void checkArrayBounds(int arrayOffset, int arrayLength, int count) {
        if (arrayOffset < 0 || count < 0) {
            throw new IndexOutOfBoundsException("Invalid args: arrayOffset=" + arrayOffset + ", count=" + count);
        }
        int targetPos = arrayOffset + count;
        if (targetPos < 0 || targetPos > arrayLength) {
            throw new IndexOutOfBoundsException("Write outside range: arrayLength=" + arrayLength + ", arrayOffset=" + arrayOffset + ", count=" + count);
        }
    }
}

