/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TzDataSetVersion {
    public static final String DEFAULT_FILE_NAME = "tz_version";
    public static final int CURRENT_FORMAT_MAJOR_VERSION = 5;
    public static final int CURRENT_FORMAT_MINOR_VERSION = 1;
    private static final String FULL_CURRENT_FORMAT_VERSION_STRING = TzDataSetVersion.toFormatVersionString(5, 1);
    private static final int FORMAT_VERSION_STRING_LENGTH = FULL_CURRENT_FORMAT_VERSION_STRING.length();
    private static final Pattern FORMAT_VERSION_PATTERN = Pattern.compile("(\\d{3})\\.(\\d{3})");
    private static final Pattern RULES_VERSION_PATTERN = Pattern.compile("(\\d{4}\\w)");
    private static final int RULES_VERSION_LENGTH = 5;
    private static final Pattern REVISION_PATTERN = Pattern.compile("(\\d{3})");
    private static final int REVISION_LENGTH = 3;
    private static final int TZ_DATA_VERSION_FILE_LENGTH = FORMAT_VERSION_STRING_LENGTH + 1 + 5 + 1 + 3;
    private static final Pattern TZ_DATA_VERSION_FILE_PATTERN = Pattern.compile(FORMAT_VERSION_PATTERN.pattern() + "\\|" + RULES_VERSION_PATTERN.pattern() + "\\|" + REVISION_PATTERN.pattern() + ".*");
    private final int formatMajorVersion;
    private final int formatMinorVersion;
    private final String rulesVersion;
    private final int revision;

    public static int currentFormatMajorVersion() {
        return 5;
    }

    public static int currentFormatMinorVersion() {
        return 1;
    }

    public TzDataSetVersion(int formatMajorVersion, int formatMinorVersion, String rulesVersion, int revision) throws TzDataSetException {
        this.formatMajorVersion = TzDataSetVersion.validate3DigitVersion(formatMajorVersion);
        this.formatMinorVersion = TzDataSetVersion.validate3DigitVersion(formatMinorVersion);
        if (!RULES_VERSION_PATTERN.matcher(rulesVersion).matches()) {
            throw new TzDataSetException("Invalid rulesVersion: " + rulesVersion);
        }
        this.rulesVersion = rulesVersion;
        this.revision = TzDataSetVersion.validate3DigitVersion(revision);
    }

    public static TzDataSetVersion fromBytes(byte[] bytes) throws TzDataSetException {
        String tzDataVersion = new String(bytes, StandardCharsets.US_ASCII);
        try {
            Matcher matcher = TZ_DATA_VERSION_FILE_PATTERN.matcher(tzDataVersion);
            if (!matcher.matches()) {
                throw new TzDataSetException("Invalid tz data version string: \"" + tzDataVersion + "\"");
            }
            String formatMajorVersion = matcher.group(1);
            String formatMinorVersion = matcher.group(2);
            String rulesVersion = matcher.group(3);
            String revision = matcher.group(4);
            return new TzDataSetVersion(TzDataSetVersion.from3DigitVersionString(formatMajorVersion), TzDataSetVersion.from3DigitVersionString(formatMinorVersion), rulesVersion, TzDataSetVersion.from3DigitVersionString(revision));
        }
        catch (IndexOutOfBoundsException e) {
            throw new TzDataSetException("tz data version string too short: \"" + tzDataVersion + "\"");
        }
    }

    public static TzDataSetVersion readFromFile(File file2) throws IOException, TzDataSetException {
        byte[] versionBytes = TzDataSetVersion.readBytes(file2, TZ_DATA_VERSION_FILE_LENGTH);
        return TzDataSetVersion.fromBytes(versionBytes);
    }

    public int getFormatMajorVersion() {
        return this.formatMajorVersion;
    }

    public int getFormatMinorVersion() {
        return this.formatMinorVersion;
    }

    public String getRulesVersion() {
        return this.rulesVersion;
    }

    public int getRevision() {
        return this.revision;
    }

    public byte[] toBytes() {
        return TzDataSetVersion.toBytes(this.formatMajorVersion, this.formatMinorVersion, this.rulesVersion, this.revision);
    }

    private static byte[] toBytes(int majorFormatVersion, int minorFormatVerison, String rulesVersion, int revision) {
        return (TzDataSetVersion.toFormatVersionString(majorFormatVersion, minorFormatVerison) + "|" + rulesVersion + "|" + TzDataSetVersion.to3DigitVersionString(revision)).getBytes(StandardCharsets.US_ASCII);
    }

    public static boolean isCompatibleWithThisDevice(TzDataSetVersion tzDataVersion) {
        return 5 == tzDataVersion.formatMajorVersion && 1 <= tzDataVersion.formatMinorVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TzDataSetVersion that = (TzDataSetVersion)o;
        if (this.formatMajorVersion != that.formatMajorVersion) {
            return false;
        }
        if (this.formatMinorVersion != that.formatMinorVersion) {
            return false;
        }
        if (this.revision != that.revision) {
            return false;
        }
        return this.rulesVersion.equals(that.rulesVersion);
    }

    public int hashCode() {
        int result = this.formatMajorVersion;
        result = 31 * result + this.formatMinorVersion;
        result = 31 * result + this.rulesVersion.hashCode();
        result = 31 * result + this.revision;
        return result;
    }

    public String toString() {
        return "TzDataSetVersion{formatMajorVersion=" + this.formatMajorVersion + ", formatMinorVersion=" + this.formatMinorVersion + ", rulesVersion='" + this.rulesVersion + '\'' + ", revision=" + this.revision + '}';
    }

    private static String to3DigitVersionString(int version) {
        try {
            return String.format(Locale.ROOT, "%03d", TzDataSetVersion.validate3DigitVersion(version));
        }
        catch (TzDataSetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static int from3DigitVersionString(String versionString) throws TzDataSetException {
        String parseErrorMessage = "versionString must be a zero padded, 3 digit, positive decimal integer";
        if (versionString.length() != 3) {
            throw new TzDataSetException("versionString must be a zero padded, 3 digit, positive decimal integer");
        }
        try {
            int version = Integer.parseInt(versionString);
            return TzDataSetVersion.validate3DigitVersion(version);
        }
        catch (NumberFormatException e) {
            throw new TzDataSetException("versionString must be a zero padded, 3 digit, positive decimal integer", e);
        }
    }

    private static int validate3DigitVersion(int value2) throws TzDataSetException {
        if (value2 < 0 || value2 > 999) {
            throw new TzDataSetException("Expected 0 <= value <= 999, was " + value2);
        }
        return value2;
    }

    private static String toFormatVersionString(int majorFormatVersion, int minorFormatVersion) {
        return TzDataSetVersion.to3DigitVersionString(majorFormatVersion) + "." + TzDataSetVersion.to3DigitVersionString(minorFormatVersion);
    }

    private static byte[] readBytes(File file2, int maxBytes) throws IOException {
        if (maxBytes <= 0) {
            throw new IllegalArgumentException("maxBytes ==" + maxBytes);
        }
        try (FileInputStream in = new FileInputStream(file2);){
            byte[] max = new byte[maxBytes];
            int bytesRead = in.read(max, 0, maxBytes);
            byte[] toReturn = new byte[bytesRead];
            System.arraycopy(max, 0, toReturn, 0, bytesRead);
            byte[] byArray = toReturn;
            return byArray;
        }
    }

    public static class TzDataSetException
    extends Exception {
        public TzDataSetException(String message) {
            super(message);
        }

        public TzDataSetException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

