/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacksController;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.IBinder;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.window.WindowContextController;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.ref.Reference;

public class WindowContext
extends ContextWrapper {
    private final WindowManager mWindowManager;
    private final int mType;
    private final Bundle mOptions;
    private final ComponentCallbacksController mCallbacksController = new ComponentCallbacksController();
    private final WindowContextController mController;

    public WindowContext(Context base, int type, Bundle options) {
        super(base);
        this.mType = type;
        this.mOptions = options;
        this.mWindowManager = WindowManagerImpl.createWindowContextWindowManager((Context)this);
        IBinder token = this.getWindowContextToken();
        this.mController = new WindowContextController(token);
        Reference.reachabilityFence(this);
    }

    public void attachToDisplayArea() {
        this.mController.attachToDisplayArea(this.mType, this.getDisplayId(), this.mOptions);
    }

    @Override
    public Object getSystemService(String name) {
        if ("window".equals(name)) {
            return this.mWindowManager;
        }
        return super.getSystemService(name);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @VisibleForTesting
    public void release() {
        this.mController.detachIfNeeded();
        this.destroy();
    }

    @Override
    public void destroy() {
        this.mCallbacksController.clearCallbacks();
        this.getBaseContext().destroy();
        Reference.reachabilityFence(this);
    }

    @Override
    public void registerComponentCallbacks(ComponentCallbacks callback2) {
        this.mCallbacksController.registerCallbacks(callback2);
    }

    @Override
    public void unregisterComponentCallbacks(ComponentCallbacks callback2) {
        this.mCallbacksController.unregisterCallbacks(callback2);
    }

    void dispatchConfigurationChanged(Configuration newConfig) {
        this.mCallbacksController.dispatchConfigurationChanged(newConfig);
    }
}

