/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseIntArray;
import java.util.Arrays;

public class SizeConfigurationBuckets
implements Parcelable {
    private final int[] mHorizontal;
    private final int[] mVertical;
    private final int[] mSmallest;
    public static final Parcelable.Creator<SizeConfigurationBuckets> CREATOR = new Parcelable.Creator<SizeConfigurationBuckets>(){

        public SizeConfigurationBuckets[] newArray(int size) {
            return new SizeConfigurationBuckets[size];
        }

        @Override
        public SizeConfigurationBuckets createFromParcel(Parcel in) {
            return new SizeConfigurationBuckets(in);
        }
    };

    public SizeConfigurationBuckets(Configuration[] sizeConfigurations) {
        SparseIntArray horizontal = new SparseIntArray();
        SparseIntArray vertical = new SparseIntArray();
        SparseIntArray smallest = new SparseIntArray();
        for (int i = sizeConfigurations.length - 1; i >= 0; --i) {
            Configuration config = sizeConfigurations[i];
            if (config.screenHeightDp != 0) {
                vertical.put(config.screenHeightDp, 0);
            }
            if (config.screenWidthDp != 0) {
                horizontal.put(config.screenWidthDp, 0);
            }
            if (config.smallestScreenWidthDp == 0) continue;
            smallest.put(config.smallestScreenWidthDp, 0);
        }
        this.mHorizontal = horizontal.copyKeys();
        this.mVertical = vertical.copyKeys();
        this.mSmallest = smallest.copyKeys();
    }

    public static int filterDiff(int diff, Configuration oldConfig, Configuration newConfig, SizeConfigurationBuckets buckets) {
        int newSmallest;
        int oldSmallest;
        if (buckets == null) {
            return diff & 0xFFFFF3FF;
        }
        if ((diff & 0x400) != 0) {
            boolean crosses;
            boolean bl = crosses = buckets.crossesHorizontalSizeThreshold(oldConfig.screenWidthDp, newConfig.screenWidthDp) || buckets.crossesVerticalSizeThreshold(oldConfig.screenHeightDp, newConfig.screenHeightDp);
            if (!crosses) {
                diff &= 0xFFFFFBFF;
            }
        }
        if ((diff & 0x800) != 0 && !buckets.crossesSmallestSizeThreshold(oldSmallest = oldConfig.smallestScreenWidthDp, newSmallest = newConfig.smallestScreenWidthDp)) {
            diff &= 0xFFFFF7FF;
        }
        return diff;
    }

    private boolean crossesHorizontalSizeThreshold(int firstDp, int secondDp) {
        return SizeConfigurationBuckets.crossesSizeThreshold(this.mHorizontal, firstDp, secondDp);
    }

    private boolean crossesVerticalSizeThreshold(int firstDp, int secondDp) {
        return SizeConfigurationBuckets.crossesSizeThreshold(this.mVertical, firstDp, secondDp);
    }

    private boolean crossesSmallestSizeThreshold(int firstDp, int secondDp) {
        return SizeConfigurationBuckets.crossesSizeThreshold(this.mSmallest, firstDp, secondDp);
    }

    private static boolean crossesSizeThreshold(int[] thresholds, int firstDp, int secondDp) {
        if (thresholds == null) {
            return false;
        }
        for (int i = thresholds.length - 1; i >= 0; --i) {
            int threshold = thresholds[i];
            if ((firstDp >= threshold || secondDp < threshold) && (firstDp < threshold || secondDp >= threshold)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.mHorizontal) + " " + Arrays.toString(this.mVertical) + " " + Arrays.toString(this.mSmallest);
    }

    public SizeConfigurationBuckets(int[] horizontal, int[] vertical, int[] smallest) {
        this.mHorizontal = horizontal;
        this.mVertical = vertical;
        this.mSmallest = smallest;
    }

    public int[] getHorizontal() {
        return this.mHorizontal;
    }

    public int[] getVertical() {
        return this.mVertical;
    }

    public int[] getSmallest() {
        return this.mSmallest;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mHorizontal != null) {
            flg = (byte)(flg | 1);
        }
        if (this.mVertical != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mSmallest != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        if (this.mHorizontal != null) {
            dest.writeIntArray(this.mHorizontal);
        }
        if (this.mVertical != null) {
            dest.writeIntArray(this.mVertical);
        }
        if (this.mSmallest != null) {
            dest.writeIntArray(this.mSmallest);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    SizeConfigurationBuckets(Parcel in) {
        byte flg = in.readByte();
        int[] horizontal = (flg & 1) == 0 ? null : in.createIntArray();
        int[] vertical = (flg & 2) == 0 ? null : in.createIntArray();
        int[] smallest = (flg & 4) == 0 ? null : in.createIntArray();
        this.mHorizontal = horizontal;
        this.mVertical = vertical;
        this.mSmallest = smallest;
    }

    @Deprecated
    private void __metadata() {
    }
}

