/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.TransitionInfo;
import android.window.TransitionRequestInfo;

public interface ITransitionPlayer
extends IInterface {
    public static final String DESCRIPTOR = "android.window.ITransitionPlayer";

    public void onTransitionReady(IBinder var1, TransitionInfo var2, SurfaceControl.Transaction var3, SurfaceControl.Transaction var4) throws RemoteException;

    public void requestStartTransition(IBinder var1, TransitionRequestInfo var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITransitionPlayer {
        static final int TRANSACTION_onTransitionReady = 1;
        static final int TRANSACTION_requestStartTransition = 2;

        public Stub() {
            this.attachInterface(this, ITransitionPlayer.DESCRIPTOR);
        }

        public static ITransitionPlayer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITransitionPlayer.DESCRIPTOR);
            if (iin != null && iin instanceof ITransitionPlayer) {
                return (ITransitionPlayer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTransitionReady";
                }
                case 2: {
                    return "requestStartTransition";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITransitionPlayer.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    TransitionInfo _arg1 = 0 != data.readInt() ? TransitionInfo.CREATOR.createFromParcel(data) : null;
                    SurfaceControl.Transaction _arg2 = 0 != data.readInt() ? SurfaceControl.Transaction.CREATOR.createFromParcel(data) : null;
                    SurfaceControl.Transaction _arg3 = 0 != data.readInt() ? SurfaceControl.Transaction.CREATOR.createFromParcel(data) : null;
                    this.onTransitionReady(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    TransitionRequestInfo _arg1 = 0 != data.readInt() ? TransitionRequestInfo.CREATOR.createFromParcel(data) : null;
                    this.requestStartTransition(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITransitionPlayer impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITransitionPlayer getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITransitionPlayer {
            private IBinder mRemote;
            public static ITransitionPlayer sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITransitionPlayer.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTransitionReady(IBinder transitionToken, TransitionInfo info, SurfaceControl.Transaction t, SurfaceControl.Transaction finishT) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITransitionPlayer.DESCRIPTOR);
                    _data.writeStrongBinder(transitionToken);
                    if (info != null) {
                        _data.writeInt(1);
                        info.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (t != null) {
                        _data.writeInt(1);
                        t.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (finishT != null) {
                        _data.writeInt(1);
                        finishT.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTransitionReady(transitionToken, info, t, finishT);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestStartTransition(IBinder transitionToken, TransitionRequestInfo request) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITransitionPlayer.DESCRIPTOR);
                    _data.writeStrongBinder(transitionToken);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestStartTransition(transitionToken, request);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITransitionPlayer {
        @Override
        public void onTransitionReady(IBinder transitionToken, TransitionInfo info, SurfaceControl.Transaction t, SurfaceControl.Transaction finishT) throws RemoteException {
        }

        @Override
        public void requestStartTransition(IBinder transitionToken, TransitionRequestInfo request) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

