/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.os.LocaleList;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.TimePickerClockDelegate;

public class TextInputTimePickerView
extends RelativeLayout {
    public static final int HOURS = 0;
    public static final int MINUTES = 1;
    public static final int AMPM = 2;
    private static final int AM = 0;
    private static final int PM = 1;
    private final EditText mHourEditText;
    private final EditText mMinuteEditText;
    private final TextView mInputSeparatorView;
    private final Spinner mAmPmSpinner;
    private final TextView mErrorLabel;
    private final TextView mHourLabel;
    private final TextView mMinuteLabel;
    private boolean mIs24Hour;
    private boolean mHourFormatStartsAtZero;
    private OnValueTypedListener mListener;
    private boolean mErrorShowing;
    private boolean mTimeSet;

    public TextInputTimePickerView(Context context) {
        this(context, null);
    }

    public TextInputTimePickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextInputTimePickerView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public TextInputTimePickerView(final Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs, defStyle, defStyleRes);
        TextInputTimePickerView.inflate(context, 17367349, this);
        this.mHourEditText = (EditText)this.findViewById(16909090);
        this.mMinuteEditText = (EditText)this.findViewById(16909091);
        this.mInputSeparatorView = (TextView)this.findViewById(16909093);
        this.mErrorLabel = (TextView)this.findViewById(16909122);
        this.mHourLabel = (TextView)this.findViewById(16909123);
        this.mMinuteLabel = (TextView)this.findViewById(16909124);
        this.mHourEditText.addTextChangedListener(new TextWatcher(){

            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void afterTextChanged(Editable editable) {
                if (TextInputTimePickerView.this.parseAndSetHourInternal(editable.toString()) && editable.length() > 1) {
                    AccessibilityManager am = (AccessibilityManager)context.getSystemService("accessibility");
                    if (!am.isEnabled()) {
                        TextInputTimePickerView.this.mMinuteEditText.requestFocus();
                    }
                }
            }
        });
        this.mMinuteEditText.addTextChangedListener(new TextWatcher(){

            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void afterTextChanged(Editable editable) {
                TextInputTimePickerView.this.parseAndSetMinuteInternal(editable.toString());
            }
        });
        this.mAmPmSpinner = (Spinner)this.findViewById(16908756);
        String[] amPmStrings = TimePicker.getAmPmStrings(context);
        ArrayAdapter<CharSequence> adapter = new ArrayAdapter<CharSequence>(context, 0x1090009);
        adapter.add(TimePickerClockDelegate.obtainVerbatim(amPmStrings[0]));
        adapter.add(TimePickerClockDelegate.obtainVerbatim(amPmStrings[1]));
        this.mAmPmSpinner.setAdapter(adapter);
        this.mAmPmSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id2) {
                if (position == 0) {
                    TextInputTimePickerView.this.mListener.onValueChanged(2, 0);
                } else {
                    TextInputTimePickerView.this.mListener.onValueChanged(2, 1);
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
    }

    void setListener(OnValueTypedListener listener2) {
        this.mListener = listener2;
    }

    void setHourFormat(int maxCharLength) {
        this.mHourEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxCharLength)});
        this.mMinuteEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxCharLength)});
        LocaleList locales = this.mContext.getResources().getConfiguration().getLocales();
        this.mHourEditText.setImeHintLocales(locales);
        this.mMinuteEditText.setImeHintLocales(locales);
    }

    boolean validateInput() {
        String hourText = TextUtils.isEmpty(this.mHourEditText.getText()) ? this.mHourEditText.getHint().toString() : this.mHourEditText.getText().toString();
        String minuteText = TextUtils.isEmpty(this.mMinuteEditText.getText()) ? this.mMinuteEditText.getHint().toString() : this.mMinuteEditText.getText().toString();
        boolean inputValid = this.parseAndSetHourInternal(hourText) && this.parseAndSetMinuteInternal(minuteText);
        this.setError(!inputValid);
        return inputValid;
    }

    void updateSeparator(String separatorText) {
        this.mInputSeparatorView.setText(separatorText);
    }

    private void setError(boolean enabled) {
        this.mErrorShowing = enabled;
        this.mErrorLabel.setVisibility(enabled ? 0 : 4);
        this.mHourLabel.setVisibility(enabled ? 4 : 0);
        this.mMinuteLabel.setVisibility(enabled ? 4 : 0);
    }

    private void setTimeSet(boolean timeSet) {
        this.mTimeSet = this.mTimeSet || timeSet;
    }

    private boolean isTimeSet() {
        return this.mTimeSet;
    }

    void updateTextInputValues(int localizedHour, int minute, int amOrPm, boolean is24Hour, boolean hourFormatStartsAtZero) {
        String hourFormat = "%d";
        String minuteFormat = "%02d";
        this.mIs24Hour = is24Hour;
        this.mHourFormatStartsAtZero = hourFormatStartsAtZero;
        this.mAmPmSpinner.setVisibility(is24Hour ? 4 : 0);
        if (amOrPm == 0) {
            this.mAmPmSpinner.setSelection(0);
        } else {
            this.mAmPmSpinner.setSelection(1);
        }
        if (this.isTimeSet()) {
            this.mHourEditText.setText(String.format("%d", localizedHour));
            this.mMinuteEditText.setText(String.format("%02d", minute));
        } else {
            this.mHourEditText.setHint(String.format("%d", localizedHour));
            this.mMinuteEditText.setHint(String.format("%02d", minute));
        }
        if (this.mErrorShowing) {
            this.validateInput();
        }
    }

    private boolean parseAndSetHourInternal(String input) {
        try {
            int hour = Integer.parseInt(input);
            if (!this.isValidLocalizedHour(hour)) {
                int minHour = this.mHourFormatStartsAtZero ? 0 : 1;
                int maxHour = this.mIs24Hour ? 23 : 11 + minHour;
                this.mListener.onValueChanged(0, this.getHourOfDayFromLocalizedHour(MathUtils.constrain(hour, minHour, maxHour)));
                return false;
            }
            this.mListener.onValueChanged(0, this.getHourOfDayFromLocalizedHour(hour));
            this.setTimeSet(true);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean parseAndSetMinuteInternal(String input) {
        try {
            int minutes = Integer.parseInt(input);
            if (minutes < 0 || minutes > 59) {
                this.mListener.onValueChanged(1, MathUtils.constrain(minutes, 0, 59));
                return false;
            }
            this.mListener.onValueChanged(1, minutes);
            this.setTimeSet(true);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isValidLocalizedHour(int localizedHour) {
        int minHour = this.mHourFormatStartsAtZero ? 0 : 1;
        int maxHour = (this.mIs24Hour ? 23 : 11) + minHour;
        return localizedHour >= minHour && localizedHour <= maxHour;
    }

    private int getHourOfDayFromLocalizedHour(int localizedHour) {
        int hourOfDay = localizedHour;
        if (this.mIs24Hour) {
            if (!this.mHourFormatStartsAtZero && localizedHour == 24) {
                hourOfDay = 0;
            }
        } else {
            if (!this.mHourFormatStartsAtZero && localizedHour == 12) {
                hourOfDay = 0;
            }
            if (this.mAmPmSpinner.getSelectedItemPosition() == 1) {
                hourOfDay += 12;
            }
        }
        return hourOfDay;
    }

    static interface OnValueTypedListener {
        public void onValueChanged(int var1, int var2);
    }
}

