/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class RadioGroup
extends LinearLayout {
    private static final String LOG_TAG = RadioGroup.class.getSimpleName();
    private int mCheckedId = -1;
    @UnsupportedAppUsage
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private boolean mProtectFromCheckedChange = false;
    @UnsupportedAppUsage
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;
    private int mInitialCheckedId = -1;

    public RadioGroup(Context context) {
        super(context);
        this.setOrientation(1);
        this.init();
    }

    public RadioGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.getImportantForAutofill() == 0) {
            this.setImportantForAutofill(1);
        }
        this.setImportantForAccessibility(1);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.RadioGroup, 16842878, 0);
        this.saveAttributeDataForStyleable(context, R.styleable.RadioGroup, attrs, attributes, 16842878, 0);
        int value2 = attributes.getResourceId(1, -1);
        if (value2 != -1) {
            this.mCheckedId = value2;
            this.mInitialCheckedId = value2;
        }
        int index = attributes.getInt(0, 1);
        this.setOrientation(index);
        attributes.recycle();
        this.init();
    }

    private void init() {
        this.mChildOnCheckedChangeListener = new CheckedStateTracker();
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener(this.mPassThroughListener);
    }

    @Override
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener2) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener2;
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId != -1) {
            this.mProtectFromCheckedChange = true;
            this.setCheckedStateForView(this.mCheckedId, true);
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(this.mCheckedId);
        }
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        RadioButton button;
        if (child instanceof RadioButton && (button = (RadioButton)child).isChecked()) {
            this.mProtectFromCheckedChange = true;
            if (this.mCheckedId != -1) {
                this.setCheckedStateForView(this.mCheckedId, false);
            }
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(button.getId());
        }
        super.addView(child, index, params);
    }

    public void check(int id2) {
        if (id2 != -1 && id2 == this.mCheckedId) {
            return;
        }
        if (this.mCheckedId != -1) {
            this.setCheckedStateForView(this.mCheckedId, false);
        }
        if (id2 != -1) {
            this.setCheckedStateForView(id2, true);
        }
        this.setCheckedId(id2);
    }

    private void setCheckedId(int id2) {
        AutofillManager afm;
        boolean changed = id2 != this.mCheckedId;
        this.mCheckedId = id2;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
        if (changed && (afm = this.mContext.getSystemService(AutofillManager.class)) != null) {
            afm.notifyValueChanged(this);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        Object checkedView = this.findViewById(viewId);
        if (checkedView != null && checkedView instanceof RadioButton) {
            ((RadioButton)checkedView).setChecked(checked);
        }
    }

    public int getCheckedRadioButtonId() {
        return this.mCheckedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener2) {
        this.mOnCheckedChangeListener = listener2;
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    @Override
    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return RadioGroup.class.getName();
    }

    @Override
    protected void onProvideStructure(ViewStructure structure, int viewFor, int flags) {
        super.onProvideStructure(structure, viewFor, flags);
        if (viewFor == 1) {
            structure.setDataIsSensitive(this.mCheckedId != this.mInitialCheckedId);
        }
    }

    @Override
    public void autofill(AutofillValue value2) {
        if (!this.isEnabled()) {
            return;
        }
        if (!value2.isList()) {
            Log.w(LOG_TAG, value2 + " could not be autofilled into " + this);
            return;
        }
        int index = value2.getListValue();
        View child = this.getChildAt(index);
        if (child == null) {
            Log.w("View", "RadioGroup.autoFill(): no child with index " + index);
            return;
        }
        this.check(child.getId());
    }

    @Override
    public int getAutofillType() {
        return this.isEnabled() ? 3 : 0;
    }

    @Override
    public AutofillValue getAutofillValue() {
        if (!this.isEnabled()) {
            return null;
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getId() != this.mCheckedId) continue;
            return AutofillValue.forList(i);
        }
        return null;
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (this.getOrientation() == 0) {
            info.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain(1, this.getVisibleChildWithTextCount(), false, 1));
        } else {
            info.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain(this.getVisibleChildWithTextCount(), 1, false, 1));
        }
    }

    private int getVisibleChildWithTextCount() {
        int count = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!(this.getChildAt(i) instanceof RadioButton) || !this.isVisibleWithText((RadioButton)this.getChildAt(i))) continue;
            ++count;
        }
        return count;
    }

    int getIndexWithinVisibleButtons(View child) {
        if (!(child instanceof RadioButton)) {
            return -1;
        }
        int index = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!(this.getChildAt(i) instanceof RadioButton)) continue;
            RadioButton button = (RadioButton)this.getChildAt(i);
            if (button == child) {
                return index;
            }
            if (!this.isVisibleWithText(button)) continue;
            ++index;
        }
        return -1;
    }

    private boolean isVisibleWithText(RadioButton button) {
        return button.getVisibility() == 0 && !TextUtils.isEmpty(button.getText());
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        @Override
        public void onChildViewAdded(View parent, View child) {
            if (parent == RadioGroup.this && child instanceof RadioButton) {
                int id2 = child.getId();
                if (id2 == -1) {
                    id2 = View.generateViewId();
                    child.setId(id2);
                }
                ((RadioButton)child).setOnCheckedChangeWidgetListener(RadioGroup.this.mChildOnCheckedChangeListener);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        @Override
        public void onChildViewRemoved(View parent, View child) {
            if (parent == RadioGroup.this && child instanceof RadioButton) {
                ((RadioButton)child).setOnCheckedChangeWidgetListener(null);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        @Override
        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (RadioGroup.this.mProtectFromCheckedChange) {
                return;
            }
            RadioGroup.this.mProtectFromCheckedChange = true;
            if (RadioGroup.this.mCheckedId != -1) {
                RadioGroup.this.setCheckedStateForView(RadioGroup.this.mCheckedId, false);
            }
            RadioGroup.this.mProtectFromCheckedChange = false;
            int id2 = buttonView.getId();
            RadioGroup.this.setCheckedId(id2);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RadioGroup var1, int var2);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, float initWeight) {
            super(w, h, initWeight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        @Override
        protected void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.hasValue(widthAttr) ? a.getLayoutDimension(widthAttr, "layout_width") : -2;
            this.height = a.hasValue(heightAttr) ? a.getLayoutDimension(heightAttr, "layout_height") : -2;
        }
    }
}

