/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.FloatProperty;
import android.util.IntArray;
import android.util.Log;
import android.util.MathUtils;
import android.util.StateSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.R;
import com.android.internal.widget.ExploreByTouchHelper;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;

public class RadialTimePickerView
extends View {
    private static final String TAG = "RadialTimePickerView";
    public static final int HOURS = 0;
    public static final int MINUTES = 1;
    private static final int HOURS_INNER = 2;
    private static final int SELECTOR_CIRCLE = 0;
    private static final int SELECTOR_DOT = 1;
    private static final int SELECTOR_LINE = 2;
    private static final int AM = 0;
    private static final int PM = 1;
    private static final int HOURS_IN_CIRCLE = 12;
    private static final int MINUTES_IN_CIRCLE = 60;
    private static final int DEGREES_FOR_ONE_HOUR = 30;
    private static final int DEGREES_FOR_ONE_MINUTE = 6;
    private static final int[] HOURS_NUMBERS = new int[]{12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] HOURS_NUMBERS_24 = new int[]{0, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] MINUTES_NUMBERS = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
    private static final int ANIM_DURATION_NORMAL = 500;
    private static final int ANIM_DURATION_TOUCH = 60;
    private static final int[] SNAP_PREFER_30S_MAP = new int[361];
    private static final int NUM_POSITIONS = 12;
    private static final float[] COS_30 = new float[12];
    private static final float[] SIN_30 = new float[12];
    private static final int MISSING_COLOR = -65281;
    private final FloatProperty<RadialTimePickerView> HOURS_TO_MINUTES = new FloatProperty<RadialTimePickerView>("hoursToMinutes"){

        @Override
        public Float get(RadialTimePickerView radialTimePickerView) {
            return Float.valueOf(radialTimePickerView.mHoursToMinutes);
        }

        @Override
        public void setValue(RadialTimePickerView object, float value2) {
            object.mHoursToMinutes = value2;
            object.invalidate();
        }
    };
    private final String[] mHours12Texts = new String[12];
    private final String[] mOuterHours24Texts = new String[12];
    private final String[] mInnerHours24Texts = new String[12];
    private final String[] mMinutesTexts = new String[12];
    private final Paint[] mPaint = new Paint[2];
    private final Paint mPaintCenter = new Paint();
    private final Paint[] mPaintSelector = new Paint[3];
    private final Paint mPaintBackground = new Paint();
    private final Typeface mTypeface;
    private final ColorStateList[] mTextColor = new ColorStateList[3];
    private final int[] mTextSize = new int[3];
    private final int[] mTextInset = new int[3];
    private final float[][] mOuterTextX = new float[2][12];
    private final float[][] mOuterTextY = new float[2][12];
    private final float[] mInnerTextX = new float[12];
    private final float[] mInnerTextY = new float[12];
    private final int[] mSelectionDegrees = new int[2];
    private final RadialPickerTouchHelper mTouchHelper;
    private final Path mSelectorPath = new Path();
    private boolean mIs24HourMode;
    private boolean mShowHours;
    private ObjectAnimator mHoursToMinutesAnimator;
    private float mHoursToMinutes;
    private boolean mIsOnInnerCircle;
    private int mSelectorRadius;
    private int mSelectorStroke;
    private int mSelectorDotRadius;
    private int mCenterDotRadius;
    private int mSelectorColor;
    private int mSelectorDotColor;
    private int mXCenter;
    private int mYCenter;
    private int mCircleRadius;
    private int mMinDistForInnerNumber;
    private int mMaxDistForOuterNumber;
    private int mHalfwayDist;
    private String[] mOuterTextHours;
    private String[] mInnerTextHours;
    private String[] mMinutesText;
    private int mAmOrPm;
    private float mDisabledAlpha;
    private OnValueSelectedListener mListener;
    private boolean mInputEnabled = true;
    boolean mChangedDuringTouch = false;

    private static void preparePrefer30sMap() {
        int snappedOutputDegrees = 0;
        int count = 1;
        int expectedCount = 8;
        for (int degrees = 0; degrees < 361; ++degrees) {
            RadialTimePickerView.SNAP_PREFER_30S_MAP[degrees] = snappedOutputDegrees;
            if (count == expectedCount) {
                expectedCount = (snappedOutputDegrees += 6) == 360 ? 7 : (snappedOutputDegrees % 30 == 0 ? 14 : 4);
                count = 1;
                continue;
            }
            ++count;
        }
    }

    private static int snapPrefer30s(int degrees) {
        if (SNAP_PREFER_30S_MAP == null) {
            return -1;
        }
        return SNAP_PREFER_30S_MAP[degrees];
    }

    private static int snapOnly30s(int degrees, int forceHigherOrLower) {
        int stepSize = 30;
        int floor = degrees / 30 * 30;
        int ceiling = floor + 30;
        if (forceHigherOrLower == 1) {
            degrees = ceiling;
        } else if (forceHigherOrLower == -1) {
            if (degrees == floor) {
                floor -= 30;
            }
            degrees = floor;
        } else {
            degrees = degrees - floor < ceiling - degrees ? floor : ceiling;
        }
        return degrees;
    }

    public RadialTimePickerView(Context context) {
        this(context, null);
    }

    public RadialTimePickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843933);
    }

    public RadialTimePickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public RadialTimePickerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs);
        this.applyAttributes(attrs, defStyleAttr, defStyleRes);
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010033, outValue, true);
        this.mDisabledAlpha = outValue.getFloat();
        this.mTypeface = Typeface.create("sans-serif", 0);
        this.mPaint[0] = new Paint();
        this.mPaint[0].setAntiAlias(true);
        this.mPaint[0].setTextAlign(Paint.Align.CENTER);
        this.mPaint[1] = new Paint();
        this.mPaint[1].setAntiAlias(true);
        this.mPaint[1].setTextAlign(Paint.Align.CENTER);
        this.mPaintCenter.setAntiAlias(true);
        this.mPaintSelector[0] = new Paint();
        this.mPaintSelector[0].setAntiAlias(true);
        this.mPaintSelector[1] = new Paint();
        this.mPaintSelector[1].setAntiAlias(true);
        this.mPaintSelector[2] = new Paint();
        this.mPaintSelector[2].setAntiAlias(true);
        this.mPaintSelector[2].setStrokeWidth(2.0f);
        this.mPaintBackground.setAntiAlias(true);
        Resources res = this.getResources();
        this.mSelectorRadius = res.getDimensionPixelSize(17105573);
        this.mSelectorStroke = res.getDimensionPixelSize(17105574);
        this.mSelectorDotRadius = res.getDimensionPixelSize(17105572);
        this.mCenterDotRadius = res.getDimensionPixelSize(17105564);
        this.mTextSize[0] = res.getDimensionPixelSize(17105579);
        this.mTextSize[1] = res.getDimensionPixelSize(17105579);
        this.mTextSize[2] = res.getDimensionPixelSize(17105578);
        this.mTextInset[0] = res.getDimensionPixelSize(17105577);
        this.mTextInset[1] = res.getDimensionPixelSize(17105577);
        this.mTextInset[2] = res.getDimensionPixelSize(17105576);
        this.mShowHours = true;
        this.mHoursToMinutes = 0.0f;
        this.mIs24HourMode = false;
        this.mAmOrPm = 0;
        this.mTouchHelper = new RadialPickerTouchHelper();
        this.setAccessibilityDelegate(this.mTouchHelper);
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        this.initHoursAndMinutesText();
        this.initData();
        Calendar calendar = Calendar.getInstance(AndroidLocale.getDefault());
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        this.setCurrentHourInternal(currentHour, false, false);
        this.setCurrentMinuteInternal(currentMinute, false);
        this.setHapticFeedbackEnabled(true);
    }

    void applyAttributes(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int selectorActivatedColor;
        Context context = this.getContext();
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.TimePicker, attrs, a, defStyleAttr, defStyleRes);
        ColorStateList numbersTextColor = a.getColorStateList(3);
        ColorStateList numbersInnerTextColor = a.getColorStateList(9);
        this.mTextColor[0] = numbersTextColor == null ? ColorStateList.valueOf(-65281) : numbersTextColor;
        this.mTextColor[2] = numbersInnerTextColor == null ? ColorStateList.valueOf(-65281) : numbersInnerTextColor;
        this.mTextColor[1] = this.mTextColor[0];
        ColorStateList selectorColors = a.getColorStateList(5);
        if (selectorColors != null) {
            int[] stateSetEnabledActivated = StateSet.get(40);
            selectorActivatedColor = selectorColors.getColorForState(stateSetEnabledActivated, 0);
        } else {
            selectorActivatedColor = -65281;
        }
        this.mPaintCenter.setColor(selectorActivatedColor);
        int[] stateSetActivated = StateSet.get(40);
        this.mSelectorColor = selectorActivatedColor;
        this.mSelectorDotColor = this.mTextColor[0].getColorForState(stateSetActivated, 0);
        this.mPaintBackground.setColor(a.getColor(4, context.getColor(17171109)));
        a.recycle();
    }

    public void initialize(int hour, int minute, boolean is24HourMode) {
        if (this.mIs24HourMode != is24HourMode) {
            this.mIs24HourMode = is24HourMode;
            this.initData();
        }
        this.setCurrentHourInternal(hour, false, false);
        this.setCurrentMinuteInternal(minute, false);
    }

    public void setCurrentItemShowing(int item, boolean animate) {
        switch (item) {
            case 0: {
                this.showHours(animate);
                break;
            }
            case 1: {
                this.showMinutes(animate);
                break;
            }
            default: {
                Log.e(TAG, "ClockView does not support showing item " + item);
            }
        }
    }

    public int getCurrentItemShowing() {
        return this.mShowHours ? 0 : 1;
    }

    public void setOnValueSelectedListener(OnValueSelectedListener listener2) {
        this.mListener = listener2;
    }

    public void setCurrentHour(int hour) {
        this.setCurrentHourInternal(hour, true, false);
    }

    private void setCurrentHourInternal(int hour, boolean callback2, boolean autoAdvance) {
        int degrees;
        this.mSelectionDegrees[0] = degrees = hour % 12 * 30;
        int amOrPm = hour == 0 || hour % 24 < 12 ? 0 : 1;
        boolean isOnInnerCircle = this.getInnerCircleForHour(hour);
        if (this.mAmOrPm != amOrPm || this.mIsOnInnerCircle != isOnInnerCircle) {
            this.mAmOrPm = amOrPm;
            this.mIsOnInnerCircle = isOnInnerCircle;
            this.initData();
            this.mTouchHelper.invalidateRoot();
        }
        this.invalidate();
        if (callback2 && this.mListener != null) {
            this.mListener.onValueSelected(0, hour, autoAdvance);
        }
    }

    public int getCurrentHour() {
        return this.getHourForDegrees(this.mSelectionDegrees[0], this.mIsOnInnerCircle);
    }

    private int getHourForDegrees(int degrees, boolean innerCircle) {
        int hour = degrees / 30 % 12;
        if (this.mIs24HourMode) {
            if (!innerCircle && hour == 0) {
                hour = 12;
            } else if (innerCircle && hour != 0) {
                hour += 12;
            }
        } else if (this.mAmOrPm == 1) {
            hour += 12;
        }
        return hour;
    }

    private int getDegreesForHour(int hour) {
        if (this.mIs24HourMode) {
            if (hour >= 12) {
                hour -= 12;
            }
        } else if (hour == 12) {
            hour = 0;
        }
        return hour * 30;
    }

    private boolean getInnerCircleForHour(int hour) {
        return this.mIs24HourMode && (hour == 0 || hour > 12);
    }

    public void setCurrentMinute(int minute) {
        this.setCurrentMinuteInternal(minute, true);
    }

    private void setCurrentMinuteInternal(int minute, boolean callback2) {
        this.mSelectionDegrees[1] = minute % 60 * 6;
        this.invalidate();
        if (callback2 && this.mListener != null) {
            this.mListener.onValueSelected(1, minute, false);
        }
    }

    public int getCurrentMinute() {
        return this.getMinuteForDegrees(this.mSelectionDegrees[1]);
    }

    private int getMinuteForDegrees(int degrees) {
        return degrees / 6;
    }

    private int getDegreesForMinute(int minute) {
        return minute * 6;
    }

    public boolean setAmOrPm(int amOrPm) {
        if (this.mAmOrPm == amOrPm || this.mIs24HourMode) {
            return false;
        }
        this.mAmOrPm = amOrPm;
        this.invalidate();
        this.mTouchHelper.invalidateRoot();
        return true;
    }

    public int getAmOrPm() {
        return this.mAmOrPm;
    }

    public void showHours(boolean animate) {
        this.showPicker(true, animate);
    }

    public void showMinutes(boolean animate) {
        this.showPicker(false, animate);
    }

    private void initHoursAndMinutesText() {
        for (int i = 0; i < 12; ++i) {
            this.mHours12Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mInnerHours24Texts[i] = String.format("%02d", HOURS_NUMBERS_24[i]);
            this.mOuterHours24Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mMinutesTexts[i] = String.format("%02d", MINUTES_NUMBERS[i]);
        }
    }

    private void initData() {
        if (this.mIs24HourMode) {
            this.mOuterTextHours = this.mOuterHours24Texts;
            this.mInnerTextHours = this.mInnerHours24Texts;
        } else {
            this.mOuterTextHours = this.mHours12Texts;
            this.mInnerTextHours = this.mHours12Texts;
        }
        this.mMinutesText = this.mMinutesTexts;
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right2, int bottom2) {
        if (!changed) {
            return;
        }
        this.mXCenter = this.getWidth() / 2;
        this.mYCenter = this.getHeight() / 2;
        this.mCircleRadius = Math.min(this.mXCenter, this.mYCenter);
        this.mMinDistForInnerNumber = this.mCircleRadius - this.mTextInset[2] - this.mSelectorRadius;
        this.mMaxDistForOuterNumber = this.mCircleRadius - this.mTextInset[0] + this.mSelectorRadius;
        this.mHalfwayDist = this.mCircleRadius - (this.mTextInset[0] + this.mTextInset[2]) / 2;
        this.calculatePositionsHours();
        this.calculatePositionsMinutes();
        this.mTouchHelper.invalidateRoot();
    }

    @Override
    public void onDraw(Canvas canvas) {
        float alphaMod = this.mInputEnabled ? 1.0f : this.mDisabledAlpha;
        this.drawCircleBackground(canvas);
        Path selectorPath = this.mSelectorPath;
        this.drawSelector(canvas, selectorPath);
        this.drawHours(canvas, selectorPath, alphaMod);
        this.drawMinutes(canvas, selectorPath, alphaMod);
        this.drawCenter(canvas, alphaMod);
    }

    private void showPicker(boolean hours, boolean animate) {
        if (this.mShowHours == hours) {
            return;
        }
        this.mShowHours = hours;
        if (animate) {
            this.animatePicker(hours, 500L);
        } else {
            if (this.mHoursToMinutesAnimator != null && this.mHoursToMinutesAnimator.isStarted()) {
                this.mHoursToMinutesAnimator.cancel();
                this.mHoursToMinutesAnimator = null;
            }
            this.mHoursToMinutes = hours ? 0.0f : 1.0f;
        }
        this.initData();
        this.invalidate();
        this.mTouchHelper.invalidateRoot();
    }

    private void animatePicker(boolean hoursToMinutes, long duration) {
        float target;
        float f = target = hoursToMinutes ? 0.0f : 1.0f;
        if (this.mHoursToMinutes == target) {
            if (this.mHoursToMinutesAnimator != null && this.mHoursToMinutesAnimator.isStarted()) {
                this.mHoursToMinutesAnimator.cancel();
                this.mHoursToMinutesAnimator = null;
            }
            return;
        }
        this.mHoursToMinutesAnimator = ObjectAnimator.ofFloat(this, this.HOURS_TO_MINUTES, target);
        this.mHoursToMinutesAnimator.setAutoCancel(true);
        this.mHoursToMinutesAnimator.setDuration(duration);
        this.mHoursToMinutesAnimator.start();
    }

    private void drawCircleBackground(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius, this.mPaintBackground);
    }

    private void drawHours(Canvas canvas, Path selectorPath, float alphaMod) {
        int hoursAlpha = (int)(255.0f * (1.0f - this.mHoursToMinutes) * alphaMod + 0.5f);
        if (hoursAlpha > 0) {
            canvas.save(2);
            canvas.clipPath(selectorPath, Region.Op.DIFFERENCE);
            this.drawHoursClipped(canvas, hoursAlpha, false);
            canvas.restore();
            canvas.save(2);
            canvas.clipPath(selectorPath, Region.Op.INTERSECT);
            this.drawHoursClipped(canvas, hoursAlpha, true);
            canvas.restore();
        }
    }

    private void drawHoursClipped(Canvas canvas, int hoursAlpha, boolean showActivated) {
        this.drawTextElements(canvas, this.mTextSize[0], this.mTypeface, this.mTextColor[0], this.mOuterTextHours, this.mOuterTextX[0], this.mOuterTextY[0], this.mPaint[0], hoursAlpha, showActivated && !this.mIsOnInnerCircle, this.mSelectionDegrees[0], showActivated);
        if (this.mIs24HourMode && this.mInnerTextHours != null) {
            this.drawTextElements(canvas, this.mTextSize[2], this.mTypeface, this.mTextColor[2], this.mInnerTextHours, this.mInnerTextX, this.mInnerTextY, this.mPaint[0], hoursAlpha, showActivated && this.mIsOnInnerCircle, this.mSelectionDegrees[0], showActivated);
        }
    }

    private void drawMinutes(Canvas canvas, Path selectorPath, float alphaMod) {
        int minutesAlpha = (int)(255.0f * this.mHoursToMinutes * alphaMod + 0.5f);
        if (minutesAlpha > 0) {
            canvas.save(2);
            canvas.clipPath(selectorPath, Region.Op.DIFFERENCE);
            this.drawMinutesClipped(canvas, minutesAlpha, false);
            canvas.restore();
            canvas.save(2);
            canvas.clipPath(selectorPath, Region.Op.INTERSECT);
            this.drawMinutesClipped(canvas, minutesAlpha, true);
            canvas.restore();
        }
    }

    private void drawMinutesClipped(Canvas canvas, int minutesAlpha, boolean showActivated) {
        this.drawTextElements(canvas, this.mTextSize[1], this.mTypeface, this.mTextColor[1], this.mMinutesText, this.mOuterTextX[1], this.mOuterTextY[1], this.mPaint[1], minutesAlpha, showActivated, this.mSelectionDegrees[1], showActivated);
    }

    private void drawCenter(Canvas canvas, float alphaMod) {
        this.mPaintCenter.setAlpha((int)(255.0f * alphaMod + 0.5f));
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCenterDotRadius, this.mPaintCenter);
    }

    private int getMultipliedAlpha(int argb, int alpha) {
        return (int)((double)Color.alpha(argb) * ((double)alpha / 255.0) + 0.5);
    }

    private void drawSelector(Canvas canvas, Path selectorPath) {
        float dotScale;
        int hoursIndex = this.mIsOnInnerCircle ? 2 : 0;
        int hoursInset = this.mTextInset[hoursIndex];
        int hoursAngleDeg = this.mSelectionDegrees[hoursIndex % 2];
        float hoursDotScale = this.mSelectionDegrees[hoursIndex % 2] % 30 != 0 ? 1.0f : 0.0f;
        boolean minutesIndex = true;
        int minutesInset = this.mTextInset[1];
        int minutesAngleDeg = this.mSelectionDegrees[1];
        float minutesDotScale = this.mSelectionDegrees[1] % 30 != 0 ? 1.0f : 0.0f;
        int selRadius = this.mSelectorRadius;
        float selLength = (float)this.mCircleRadius - MathUtils.lerp(hoursInset, minutesInset, this.mHoursToMinutes);
        double selAngleRad = Math.toRadians(MathUtils.lerpDeg(hoursAngleDeg, minutesAngleDeg, this.mHoursToMinutes));
        float selCenterX = (float)this.mXCenter + selLength * (float)Math.sin(selAngleRad);
        float selCenterY = (float)this.mYCenter - selLength * (float)Math.cos(selAngleRad);
        Paint paint = this.mPaintSelector[0];
        paint.setColor(this.mSelectorColor);
        canvas.drawCircle(selCenterX, selCenterY, selRadius, paint);
        if (selectorPath != null) {
            selectorPath.reset();
            selectorPath.addCircle(selCenterX, selCenterY, selRadius, Path.Direction.CCW);
        }
        if ((dotScale = MathUtils.lerp(hoursDotScale, minutesDotScale, this.mHoursToMinutes)) > 0.0f) {
            Paint dotPaint = this.mPaintSelector[1];
            dotPaint.setColor(this.mSelectorDotColor);
            canvas.drawCircle(selCenterX, selCenterY, (float)this.mSelectorDotRadius * dotScale, dotPaint);
        }
        double sin = Math.sin(selAngleRad);
        double cos = Math.cos(selAngleRad);
        float lineLength = selLength - (float)selRadius;
        int centerX = this.mXCenter + (int)((double)this.mCenterDotRadius * sin);
        int centerY = this.mYCenter - (int)((double)this.mCenterDotRadius * cos);
        float linePointX = centerX + (int)((double)lineLength * sin);
        float linePointY = centerY - (int)((double)lineLength * cos);
        Paint linePaint = this.mPaintSelector[2];
        linePaint.setColor(this.mSelectorColor);
        linePaint.setStrokeWidth(this.mSelectorStroke);
        canvas.drawLine(this.mXCenter, this.mYCenter, linePointX, linePointY, linePaint);
    }

    private void calculatePositionsHours() {
        float numbersRadius = this.mCircleRadius - this.mTextInset[0];
        RadialTimePickerView.calculatePositions(this.mPaint[0], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[0], this.mOuterTextX[0], this.mOuterTextY[0]);
        if (this.mIs24HourMode) {
            int innerNumbersRadius = this.mCircleRadius - this.mTextInset[2];
            RadialTimePickerView.calculatePositions(this.mPaint[0], innerNumbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[2], this.mInnerTextX, this.mInnerTextY);
        }
    }

    private void calculatePositionsMinutes() {
        float numbersRadius = this.mCircleRadius - this.mTextInset[1];
        RadialTimePickerView.calculatePositions(this.mPaint[1], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[1], this.mOuterTextX[1], this.mOuterTextY[1]);
    }

    private static void calculatePositions(Paint paint, float radius, float xCenter, float yCenter, float textSize, float[] x, float[] y) {
        paint.setTextSize(textSize);
        yCenter -= (paint.descent() + paint.ascent()) / 2.0f;
        for (int i = 0; i < 12; ++i) {
            x[i] = xCenter - radius * COS_30[i];
            y[i] = yCenter - radius * SIN_30[i];
        }
    }

    private void drawTextElements(Canvas canvas, float textSize, Typeface typeface, ColorStateList textColor, String[] texts, float[] textX, float[] textY, Paint paint, int alpha, boolean showActivated, int activatedDegrees, boolean activatedOnly) {
        paint.setTextSize(textSize);
        paint.setTypeface(typeface);
        float activatedIndex = (float)activatedDegrees / 30.0f;
        int activatedFloor = (int)activatedIndex;
        int activatedCeil = (int)Math.ceil(activatedIndex) % 12;
        for (int i = 0; i < 12; ++i) {
            boolean activated;
            boolean bl = activated = activatedFloor == i || activatedCeil == i;
            if (activatedOnly && !activated) continue;
            int stateMask = 8 | (showActivated && activated ? 32 : 0);
            int color2 = textColor.getColorForState(StateSet.get(stateMask), 0);
            paint.setColor(color2);
            paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
            canvas.drawText(texts[i], textX[i], textY[i], paint);
        }
    }

    private int getDegreesFromXY(float x, float y, boolean constrainOutside) {
        int outerBound;
        int innerBound;
        if (this.mIs24HourMode && this.mShowHours) {
            innerBound = this.mMinDistForInnerNumber;
            outerBound = this.mMaxDistForOuterNumber;
        } else {
            int index = this.mShowHours ? 0 : 1;
            int center = this.mCircleRadius - this.mTextInset[index];
            innerBound = center - this.mSelectorRadius;
            outerBound = center + this.mSelectorRadius;
        }
        double dX = x - (float)this.mXCenter;
        double dY = y - (float)this.mYCenter;
        double distFromCenter = Math.sqrt(dX * dX + dY * dY);
        if (distFromCenter < (double)innerBound || constrainOutside && distFromCenter > (double)outerBound) {
            return -1;
        }
        int degrees = (int)(Math.toDegrees(Math.atan2(dY, dX) + 1.5707963267948966) + 0.5);
        if (degrees < 0) {
            return degrees + 360;
        }
        return degrees;
    }

    private boolean getInnerCircleFromXY(float x, float y) {
        if (this.mIs24HourMode && this.mShowHours) {
            double dX = x - (float)this.mXCenter;
            double dY = y - (float)this.mYCenter;
            double distFromCenter = Math.sqrt(dX * dX + dY * dY);
            return distFromCenter <= (double)this.mHalfwayDist;
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mInputEnabled) {
            return true;
        }
        int action2 = event.getActionMasked();
        if (action2 == 2 || action2 == 1 || action2 == 0) {
            boolean forceSelection = false;
            boolean autoAdvance = false;
            if (action2 == 0) {
                this.mChangedDuringTouch = false;
            } else if (action2 == 1) {
                autoAdvance = true;
                if (!this.mChangedDuringTouch) {
                    forceSelection = true;
                }
            }
            this.mChangedDuringTouch |= this.handleTouchInput(event.getX(), event.getY(), forceSelection, autoAdvance);
        }
        return true;
    }

    private boolean handleTouchInput(float x, float y, boolean forceSelection, boolean autoAdvance) {
        int newValue;
        int type;
        boolean valueChanged;
        boolean isOnInnerCircle = this.getInnerCircleFromXY(x, y);
        int degrees = this.getDegreesFromXY(x, y, false);
        if (degrees == -1) {
            return false;
        }
        this.animatePicker(this.mShowHours, 60L);
        if (this.mShowHours) {
            int snapDegrees = RadialTimePickerView.snapOnly30s(degrees, 0) % 360;
            valueChanged = this.mIsOnInnerCircle != isOnInnerCircle || this.mSelectionDegrees[0] != snapDegrees;
            this.mIsOnInnerCircle = isOnInnerCircle;
            this.mSelectionDegrees[0] = snapDegrees;
            type = 0;
            newValue = this.getCurrentHour();
        } else {
            int snapDegrees = RadialTimePickerView.snapPrefer30s(degrees) % 360;
            valueChanged = this.mSelectionDegrees[1] != snapDegrees;
            this.mSelectionDegrees[1] = snapDegrees;
            type = 1;
            newValue = this.getCurrentMinute();
        }
        if (valueChanged || forceSelection || autoAdvance) {
            if (this.mListener != null) {
                this.mListener.onValueSelected(type, newValue, autoAdvance);
            }
            if (valueChanged || forceSelection) {
                this.performHapticFeedback(4);
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent event) {
        if (this.mTouchHelper.dispatchHoverEvent(event)) {
            return true;
        }
        return super.dispatchHoverEvent(event);
    }

    public void setInputEnabled(boolean inputEnabled) {
        this.mInputEnabled = inputEnabled;
        this.invalidate();
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        if (!this.isEnabled()) {
            return null;
        }
        int degrees = this.getDegreesFromXY(event.getX(), event.getY(), false);
        if (degrees != -1) {
            return PointerIcon.getSystemIcon(this.getContext(), 1002);
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    static {
        RadialTimePickerView.preparePrefer30sMap();
        double increment = 0.5235987755982988;
        double angle = 1.5707963267948966;
        for (int i = 0; i < 12; ++i) {
            RadialTimePickerView.COS_30[i] = (float)Math.cos(angle);
            RadialTimePickerView.SIN_30[i] = (float)Math.sin(angle);
            angle += 0.5235987755982988;
        }
    }

    private class RadialPickerTouchHelper
    extends ExploreByTouchHelper {
        private final Rect mTempRect;
        private final int TYPE_HOUR = 1;
        private final int TYPE_MINUTE = 2;
        private final int SHIFT_TYPE = 0;
        private final int MASK_TYPE = 15;
        private final int SHIFT_VALUE = 8;
        private final int MASK_VALUE = 255;
        private final int MINUTE_INCREMENT = 5;

        public RadialPickerTouchHelper() {
            super(RadialTimePickerView.this);
            this.mTempRect = new Rect();
            this.TYPE_HOUR = 1;
            this.TYPE_MINUTE = 2;
            this.SHIFT_TYPE = 0;
            this.MASK_TYPE = 15;
            this.SHIFT_VALUE = 8;
            this.MASK_VALUE = 255;
            this.MINUTE_INCREMENT = 5;
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
        }

        @Override
        public boolean performAccessibilityAction(View host, int action2, Bundle arguments) {
            if (super.performAccessibilityAction(host, action2, arguments)) {
                return true;
            }
            switch (action2) {
                case 4096: {
                    this.adjustPicker(1);
                    return true;
                }
                case 8192: {
                    this.adjustPicker(-1);
                    return true;
                }
            }
            return false;
        }

        private void adjustPicker(int step) {
            int maxValue;
            int minValue;
            int initialStep;
            int stepSize;
            if (RadialTimePickerView.this.mShowHours) {
                stepSize = 1;
                int currentHour24 = RadialTimePickerView.this.getCurrentHour();
                if (RadialTimePickerView.this.mIs24HourMode) {
                    initialStep = currentHour24;
                    minValue = 0;
                    maxValue = 23;
                } else {
                    initialStep = this.hour24To12(currentHour24);
                    minValue = 1;
                    maxValue = 12;
                }
            } else {
                stepSize = 5;
                initialStep = RadialTimePickerView.this.getCurrentMinute() / stepSize;
                minValue = 0;
                maxValue = 55;
            }
            int nextValue = (initialStep + step) * stepSize;
            int clampedValue = MathUtils.constrain(nextValue, minValue, maxValue);
            if (RadialTimePickerView.this.mShowHours) {
                RadialTimePickerView.this.setCurrentHour(clampedValue);
            } else {
                RadialTimePickerView.this.setCurrentMinute(clampedValue);
            }
        }

        @Override
        protected int getVirtualViewAt(float x, float y) {
            int id2;
            int degrees = RadialTimePickerView.this.getDegreesFromXY(x, y, true);
            if (degrees != -1) {
                int snapDegrees = RadialTimePickerView.snapOnly30s(degrees, 0) % 360;
                if (RadialTimePickerView.this.mShowHours) {
                    boolean isOnInnerCircle = RadialTimePickerView.this.getInnerCircleFromXY(x, y);
                    int hour24 = RadialTimePickerView.this.getHourForDegrees(snapDegrees, isOnInnerCircle);
                    int hour = RadialTimePickerView.this.mIs24HourMode ? hour24 : this.hour24To12(hour24);
                    id2 = this.makeId(1, hour);
                } else {
                    int snappedOffset;
                    int current = RadialTimePickerView.this.getCurrentMinute();
                    int touched = RadialTimePickerView.this.getMinuteForDegrees(degrees);
                    int snapped = RadialTimePickerView.this.getMinuteForDegrees(snapDegrees);
                    int currentOffset = this.getCircularDiff(current, touched, 60);
                    int minute = currentOffset < (snappedOffset = this.getCircularDiff(snapped, touched, 60)) ? current : snapped;
                    id2 = this.makeId(2, minute);
                }
            } else {
                id2 = Integer.MIN_VALUE;
            }
            return id2;
        }

        private int getCircularDiff(int first, int second, int max) {
            int midpoint;
            int diff = Math.abs(first - second);
            return diff > (midpoint = max / 2) ? max - diff : diff;
        }

        @Override
        protected void getVisibleVirtualViews(IntArray virtualViewIds) {
            if (RadialTimePickerView.this.mShowHours) {
                int min = RadialTimePickerView.this.mIs24HourMode ? 0 : 1;
                int max = RadialTimePickerView.this.mIs24HourMode ? 23 : 12;
                for (int i = min; i <= max; ++i) {
                    virtualViewIds.add(this.makeId(1, i));
                }
            } else {
                int current = RadialTimePickerView.this.getCurrentMinute();
                for (int i = 0; i < 60; i += 5) {
                    virtualViewIds.add(this.makeId(2, i));
                    if (current <= i || current >= i + 5) continue;
                    virtualViewIds.add(this.makeId(2, current));
                }
            }
        }

        @Override
        protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setClassName(this.getClass().getName());
            int type = this.getTypeFromId(virtualViewId);
            int value2 = this.getValueFromId(virtualViewId);
            CharSequence description = this.getVirtualViewDescription(type, value2);
            event.setContentDescription(description);
        }

        @Override
        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            node.setClassName(this.getClass().getName());
            node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
            int type = this.getTypeFromId(virtualViewId);
            int value2 = this.getValueFromId(virtualViewId);
            CharSequence description = this.getVirtualViewDescription(type, value2);
            node.setContentDescription(description);
            this.getBoundsForVirtualView(virtualViewId, this.mTempRect);
            node.setBoundsInParent(this.mTempRect);
            boolean selected = this.isVirtualViewSelected(type, value2);
            node.setSelected(selected);
            int nextId = this.getVirtualViewIdAfter(type, value2);
            if (nextId != Integer.MIN_VALUE) {
                node.setTraversalBefore(RadialTimePickerView.this, nextId);
            }
        }

        private int getVirtualViewIdAfter(int type, int value2) {
            if (type == 1) {
                int max;
                int nextValue = value2 + 1;
                int n = max = RadialTimePickerView.this.mIs24HourMode ? 23 : 12;
                if (nextValue <= max) {
                    return this.makeId(type, nextValue);
                }
            } else if (type == 2) {
                int current = RadialTimePickerView.this.getCurrentMinute();
                int snapValue = value2 - value2 % 5;
                int nextValue = snapValue + 5;
                if (value2 < current && nextValue > current) {
                    return this.makeId(type, current);
                }
                if (nextValue < 60) {
                    return this.makeId(type, nextValue);
                }
            }
            return Integer.MIN_VALUE;
        }

        @Override
        protected boolean onPerformActionForVirtualView(int virtualViewId, int action2, Bundle arguments) {
            if (action2 == 16) {
                int type = this.getTypeFromId(virtualViewId);
                int value2 = this.getValueFromId(virtualViewId);
                if (type == 1) {
                    int hour = RadialTimePickerView.this.mIs24HourMode ? value2 : this.hour12To24(value2, RadialTimePickerView.this.mAmOrPm);
                    RadialTimePickerView.this.setCurrentHour(hour);
                    return true;
                }
                if (type == 2) {
                    RadialTimePickerView.this.setCurrentMinute(value2);
                    return true;
                }
            }
            return false;
        }

        private int hour12To24(int hour12, int amOrPm) {
            int hour24 = hour12;
            if (hour12 == 12) {
                if (amOrPm == 0) {
                    hour24 = 0;
                }
            } else if (amOrPm == 1) {
                hour24 += 12;
            }
            return hour24;
        }

        private int hour24To12(int hour24) {
            if (hour24 == 0) {
                return 12;
            }
            if (hour24 > 12) {
                return hour24 - 12;
            }
            return hour24;
        }

        private void getBoundsForVirtualView(int virtualViewId, Rect bounds2) {
            float degrees;
            float radius;
            float centerRadius;
            int type = this.getTypeFromId(virtualViewId);
            int value2 = this.getValueFromId(virtualViewId);
            if (type == 1) {
                boolean innerCircle = RadialTimePickerView.this.getInnerCircleForHour(value2);
                if (innerCircle) {
                    centerRadius = RadialTimePickerView.this.mCircleRadius - RadialTimePickerView.this.mTextInset[2];
                    radius = RadialTimePickerView.this.mSelectorRadius;
                } else {
                    centerRadius = RadialTimePickerView.this.mCircleRadius - RadialTimePickerView.this.mTextInset[0];
                    radius = RadialTimePickerView.this.mSelectorRadius;
                }
                degrees = RadialTimePickerView.this.getDegreesForHour(value2);
            } else if (type == 2) {
                centerRadius = RadialTimePickerView.this.mCircleRadius - RadialTimePickerView.this.mTextInset[1];
                degrees = RadialTimePickerView.this.getDegreesForMinute(value2);
                radius = RadialTimePickerView.this.mSelectorRadius;
            } else {
                centerRadius = 0.0f;
                degrees = 0.0f;
                radius = 0.0f;
            }
            double radians = Math.toRadians(degrees);
            float xCenter = (float)RadialTimePickerView.this.mXCenter + centerRadius * (float)Math.sin(radians);
            float yCenter = (float)RadialTimePickerView.this.mYCenter - centerRadius * (float)Math.cos(radians);
            bounds2.set((int)(xCenter - radius), (int)(yCenter - radius), (int)(xCenter + radius), (int)(yCenter + radius));
        }

        private CharSequence getVirtualViewDescription(int type, int value2) {
            String description = type == 1 || type == 2 ? Integer.toString(value2) : null;
            return description;
        }

        private boolean isVirtualViewSelected(int type, int value2) {
            boolean selected = type == 1 ? RadialTimePickerView.this.getCurrentHour() == value2 : (type == 2 ? RadialTimePickerView.this.getCurrentMinute() == value2 : false);
            return selected;
        }

        private int makeId(int type, int value2) {
            return type << 0 | value2 << 8;
        }

        private int getTypeFromId(int id2) {
            return id2 >>> 0 & 0xF;
        }

        private int getValueFromId(int id2) {
            return id2 >>> 8 & 0xFF;
        }
    }

    static interface OnValueSelectedListener {
        public void onValueSelected(int var1, int var2, boolean var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface PickerType {
    }
}

