/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ImageDecoder;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import android.view.accessibility.AccessibilityEvent;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.io.IOException;

@RemoteViews.RemoteView
public class ImageView
extends View {
    private static final String LOG_TAG = "ImageView";
    @UnsupportedAppUsage
    private Uri mUri;
    @UnsupportedAppUsage
    private int mResource = 0;
    private Matrix mMatrix;
    private ScaleType mScaleType;
    private boolean mHaveFrame = false;
    @UnsupportedAppUsage
    private boolean mAdjustViewBounds = false;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mMaxWidth = Integer.MAX_VALUE;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mMaxHeight = Integer.MAX_VALUE;
    private ColorFilter mColorFilter = null;
    private boolean mHasColorFilter = false;
    private Xfermode mXfermode;
    private boolean mHasXfermode = false;
    @UnsupportedAppUsage
    private int mAlpha = 255;
    private boolean mHasAlpha = false;
    private final int mViewAlphaScale = 256;
    @UnsupportedAppUsage
    private Drawable mDrawable = null;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private BitmapDrawable mRecycleableBitmapDrawable = null;
    private ColorStateList mDrawableTintList = null;
    private BlendMode mDrawableBlendMode = null;
    private boolean mHasDrawableTint = false;
    private boolean mHasDrawableBlendMode = false;
    private int[] mState = null;
    private boolean mMergeState = false;
    private int mLevel = 0;
    @UnsupportedAppUsage
    private int mDrawableWidth;
    @UnsupportedAppUsage
    private int mDrawableHeight;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124051687L)
    private Matrix mDrawMatrix = null;
    private final RectF mTempSrc = new RectF();
    private final RectF mTempDst = new RectF();
    @UnsupportedAppUsage
    private boolean mCropToPadding;
    private int mBaseline = -1;
    private boolean mBaselineAlignBottom = false;
    private static boolean sCompatDone;
    private static boolean sCompatAdjustViewBounds;
    private static boolean sCompatUseCorrectStreamDensity;
    private static boolean sCompatDrawableVisibilityDispatch;
    private static final ScaleType[] sScaleTypeArray;
    private static final Matrix.ScaleToFit[] sS2FArray;

    public ImageView(Context context) {
        super(context);
        this.initImageView();
    }

    public ImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initImageView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ImageView, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.ImageView, attrs, a, defStyleAttr, defStyleRes);
        Drawable d = a.getDrawable(0);
        if (d != null) {
            this.setImageDrawable(d);
        }
        this.mBaselineAlignBottom = a.getBoolean(6, false);
        this.mBaseline = a.getDimensionPixelSize(8, -1);
        this.setAdjustViewBounds(a.getBoolean(2, false));
        this.setMaxWidth(a.getDimensionPixelSize(3, Integer.MAX_VALUE));
        this.setMaxHeight(a.getDimensionPixelSize(4, Integer.MAX_VALUE));
        int index = a.getInt(1, -1);
        if (index >= 0) {
            this.setScaleType(sScaleTypeArray[index]);
        }
        if (a.hasValue(5)) {
            this.mDrawableTintList = a.getColorStateList(5);
            this.mHasDrawableTint = true;
            this.mDrawableBlendMode = BlendMode.SRC_ATOP;
            this.mHasDrawableBlendMode = true;
        }
        if (a.hasValue(9)) {
            this.mDrawableBlendMode = Drawable.parseBlendMode(a.getInt(9, -1), this.mDrawableBlendMode);
            this.mHasDrawableBlendMode = true;
        }
        this.applyImageTint();
        int alpha = a.getInt(10, 255);
        if (alpha != 255) {
            this.setImageAlpha(alpha);
        }
        this.mCropToPadding = a.getBoolean(7, false);
        a.recycle();
    }

    private void initImageView() {
        this.mMatrix = new Matrix();
        this.mScaleType = ScaleType.FIT_CENTER;
        if (!sCompatDone) {
            int targetSdkVersion = this.mContext.getApplicationInfo().targetSdkVersion;
            sCompatAdjustViewBounds = targetSdkVersion <= 17;
            sCompatUseCorrectStreamDensity = targetSdkVersion > 23;
            sCompatDrawableVisibilityDispatch = targetSdkVersion < 24;
            sCompatDone = true;
        }
        if (this.getImportantForAutofill() == 0) {
            this.setImportantForAutofill(2);
        }
        if (this.getImportantForContentCapture() == 0) {
            this.setImportantForContentCapture(1);
        }
    }

    @Override
    protected boolean verifyDrawable(Drawable dr) {
        return this.mDrawable == dr || super.verifyDrawable(dr);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mDrawable != null) {
            this.mDrawable.jumpToCurrentState();
        }
    }

    @Override
    public void invalidateDrawable(Drawable dr) {
        if (dr == this.mDrawable) {
            if (dr != null) {
                int w = dr.getIntrinsicWidth();
                int h = dr.getIntrinsicHeight();
                if (w != this.mDrawableWidth || h != this.mDrawableHeight) {
                    this.mDrawableWidth = w;
                    this.mDrawableHeight = h;
                    this.configureBounds();
                }
            }
            this.invalidate();
        } else {
            super.invalidateDrawable(dr);
        }
    }

    @Override
    public boolean hasOverlappingRendering() {
        return this.getBackground() != null && this.getBackground().getCurrent() != null;
    }

    @Override
    public void onPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        super.onPopulateAccessibilityEventInternal(event);
        CharSequence contentDescription = this.getContentDescription();
        if (!TextUtils.isEmpty(contentDescription)) {
            event.getText().add(contentDescription);
        }
    }

    public boolean getAdjustViewBounds() {
        return this.mAdjustViewBounds;
    }

    @RemotableViewMethod
    public void setAdjustViewBounds(boolean adjustViewBounds) {
        this.mAdjustViewBounds = adjustViewBounds;
        if (adjustViewBounds) {
            this.setScaleType(ScaleType.FIT_CENTER);
        }
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    @RemotableViewMethod
    public void setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    @RemotableViewMethod
    public void setMaxHeight(int maxHeight) {
        this.mMaxHeight = maxHeight;
    }

    public Drawable getDrawable() {
        if (this.mDrawable == this.mRecycleableBitmapDrawable) {
            this.mRecycleableBitmapDrawable = null;
        }
        return this.mDrawable;
    }

    @RemotableViewMethod(asyncImpl="setImageResourceAsync")
    public void setImageResource(int resId) {
        int oldWidth = this.mDrawableWidth;
        int oldHeight = this.mDrawableHeight;
        this.updateDrawable(null);
        this.mResource = resId;
        this.mUri = null;
        this.resolveUri();
        if (oldWidth != this.mDrawableWidth || oldHeight != this.mDrawableHeight) {
            this.requestLayout();
        }
        this.invalidate();
    }

    @UnsupportedAppUsage
    public Runnable setImageResourceAsync(int resId) {
        Drawable d = null;
        if (resId != 0) {
            try {
                d = this.getContext().getDrawable(resId);
            }
            catch (Exception e) {
                Log.w(LOG_TAG, "Unable to find resource: " + resId, e);
                resId = 0;
            }
        }
        return new ImageDrawableCallback(d, null, resId);
    }

    @RemotableViewMethod(asyncImpl="setImageURIAsync")
    public void setImageURI(Uri uri) {
        if (this.mResource != 0 || this.mUri != uri && (uri == null || this.mUri == null || !uri.equals(this.mUri))) {
            this.updateDrawable(null);
            this.mResource = 0;
            this.mUri = uri;
            int oldWidth = this.mDrawableWidth;
            int oldHeight = this.mDrawableHeight;
            this.resolveUri();
            if (oldWidth != this.mDrawableWidth || oldHeight != this.mDrawableHeight) {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    @UnsupportedAppUsage
    public Runnable setImageURIAsync(Uri uri) {
        if (this.mResource != 0 || this.mUri != uri && (uri == null || this.mUri == null || !uri.equals(this.mUri))) {
            Drawable d;
            Drawable drawable2 = d = uri == null ? null : this.getDrawableFromUri(uri);
            if (d == null) {
                uri = null;
            }
            return new ImageDrawableCallback(d, uri, 0);
        }
        return null;
    }

    public void setImageDrawable(Drawable drawable2) {
        if (this.mDrawable != drawable2) {
            this.mResource = 0;
            this.mUri = null;
            int oldWidth = this.mDrawableWidth;
            int oldHeight = this.mDrawableHeight;
            this.updateDrawable(drawable2);
            if (oldWidth != this.mDrawableWidth || oldHeight != this.mDrawableHeight) {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    @RemotableViewMethod(asyncImpl="setImageIconAsync")
    public void setImageIcon(Icon icon2) {
        this.setImageDrawable(icon2 == null ? null : icon2.loadDrawable(this.mContext));
    }

    public Runnable setImageIconAsync(Icon icon2) {
        return new ImageDrawableCallback(icon2 == null ? null : icon2.loadDrawable(this.mContext), null, 0);
    }

    @RemotableViewMethod
    public void setImageTintList(ColorStateList tint) {
        this.mDrawableTintList = tint;
        this.mHasDrawableTint = true;
        this.applyImageTint();
    }

    public ColorStateList getImageTintList() {
        return this.mDrawableTintList;
    }

    public void setImageTintMode(PorterDuff.Mode tintMode) {
        this.setImageTintBlendMode(tintMode != null ? BlendMode.fromValue(tintMode.nativeInt) : null);
    }

    @RemotableViewMethod
    public void setImageTintBlendMode(BlendMode blendMode) {
        this.mDrawableBlendMode = blendMode;
        this.mHasDrawableBlendMode = true;
        this.applyImageTint();
    }

    public PorterDuff.Mode getImageTintMode() {
        return this.mDrawableBlendMode != null ? BlendMode.blendModeToPorterDuffMode(this.mDrawableBlendMode) : null;
    }

    public BlendMode getImageTintBlendMode() {
        return this.mDrawableBlendMode;
    }

    private void applyImageTint() {
        if (this.mDrawable != null && (this.mHasDrawableTint || this.mHasDrawableBlendMode)) {
            this.mDrawable = this.mDrawable.mutate();
            if (this.mHasDrawableTint) {
                this.mDrawable.setTintList(this.mDrawableTintList);
            }
            if (this.mHasDrawableBlendMode) {
                this.mDrawable.setTintBlendMode(this.mDrawableBlendMode);
            }
            if (this.mDrawable.isStateful()) {
                this.mDrawable.setState(this.getDrawableState());
            }
        }
    }

    @RemotableViewMethod
    public void setImageBitmap(Bitmap bm) {
        this.mDrawable = null;
        if (this.mRecycleableBitmapDrawable == null) {
            this.mRecycleableBitmapDrawable = new BitmapDrawable(this.mContext.getResources(), bm);
        } else {
            this.mRecycleableBitmapDrawable.setBitmap(bm);
        }
        this.setImageDrawable(this.mRecycleableBitmapDrawable);
    }

    public void setImageState(int[] state, boolean merge) {
        this.mState = state;
        this.mMergeState = merge;
        if (this.mDrawable != null) {
            this.refreshDrawableState();
            this.resizeFromDrawable();
        }
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.resizeFromDrawable();
    }

    @RemotableViewMethod
    public void setImageLevel(int level) {
        this.mLevel = level;
        if (this.mDrawable != null) {
            this.mDrawable.setLevel(level);
            this.resizeFromDrawable();
        }
    }

    public void setScaleType(ScaleType scaleType) {
        if (scaleType == null) {
            throw new NullPointerException();
        }
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            this.requestLayout();
            this.invalidate();
        }
    }

    public ScaleType getScaleType() {
        return this.mScaleType;
    }

    public Matrix getImageMatrix() {
        if (this.mDrawMatrix == null) {
            return new Matrix(Matrix.IDENTITY_MATRIX);
        }
        return this.mDrawMatrix;
    }

    public void setImageMatrix(Matrix matrix) {
        if (matrix != null && matrix.isIdentity()) {
            matrix = null;
        }
        if (matrix == null && !this.mMatrix.isIdentity() || matrix != null && !this.mMatrix.equals(matrix)) {
            this.mMatrix.set(matrix);
            this.configureBounds();
            this.invalidate();
        }
    }

    public boolean getCropToPadding() {
        return this.mCropToPadding;
    }

    public void setCropToPadding(boolean cropToPadding) {
        if (this.mCropToPadding != cropToPadding) {
            this.mCropToPadding = cropToPadding;
            this.requestLayout();
            this.invalidate();
        }
    }

    @UnsupportedAppUsage
    private void resolveUri() {
        if (this.mDrawable != null) {
            return;
        }
        if (this.getResources() == null) {
            return;
        }
        Drawable d = null;
        if (this.mResource != 0) {
            try {
                d = this.mContext.getDrawable(this.mResource);
            }
            catch (Exception e) {
                Log.w(LOG_TAG, "Unable to find resource: " + this.mResource, e);
                this.mResource = 0;
            }
        } else if (this.mUri != null) {
            d = this.getDrawableFromUri(this.mUri);
            if (d == null) {
                Log.w(LOG_TAG, "resolveUri failed on bad bitmap uri: " + this.mUri);
                this.mUri = null;
            }
        } else {
            return;
        }
        this.updateDrawable(d);
    }

    private Drawable getDrawableFromUri(Uri uri) {
        String scheme = uri.getScheme();
        if ("android.resource".equals(scheme)) {
            try {
                ContentResolver.OpenResourceIdResult r = this.mContext.getContentResolver().getResourceId(uri);
                return r.r.getDrawable(r.id, this.mContext.getTheme());
            }
            catch (Exception e) {
                Log.w(LOG_TAG, "Unable to open content: " + uri, e);
            }
        } else if ("content".equals(scheme) || "file".equals(scheme)) {
            try {
                Resources res = sCompatUseCorrectStreamDensity ? this.getResources() : null;
                ImageDecoder.Source src = ImageDecoder.createSource(this.mContext.getContentResolver(), uri, res);
                return ImageDecoder.decodeDrawable(src, (decoder, info, s) -> decoder.setAllocator(1));
            }
            catch (IOException e) {
                Log.w(LOG_TAG, "Unable to open content: " + uri, e);
            }
        } else {
            return Drawable.createFromPath(uri.toString());
        }
        return null;
    }

    @Override
    public int[] onCreateDrawableState(int extraSpace) {
        if (this.mState == null) {
            return super.onCreateDrawableState(extraSpace);
        }
        if (!this.mMergeState) {
            return this.mState;
        }
        return ImageView.mergeDrawableStates(super.onCreateDrawableState(extraSpace + this.mState.length), this.mState);
    }

    @UnsupportedAppUsage
    private void updateDrawable(Drawable d) {
        if (d != this.mRecycleableBitmapDrawable && this.mRecycleableBitmapDrawable != null) {
            this.mRecycleableBitmapDrawable.setBitmap(null);
        }
        boolean sameDrawable = false;
        if (this.mDrawable != null) {
            sameDrawable = this.mDrawable == d;
            this.mDrawable.setCallback(null);
            this.unscheduleDrawable(this.mDrawable);
            if (!sCompatDrawableVisibilityDispatch && !sameDrawable && this.isAttachedToWindow()) {
                this.mDrawable.setVisible(false, false);
            }
        }
        this.mDrawable = d;
        if (d != null) {
            d.setCallback(this);
            d.setLayoutDirection(this.getLayoutDirection());
            if (d.isStateful()) {
                d.setState(this.getDrawableState());
            }
            if (!sameDrawable || sCompatDrawableVisibilityDispatch) {
                boolean visible = sCompatDrawableVisibilityDispatch ? this.getVisibility() == 0 : this.isAttachedToWindow() && this.getWindowVisibility() == 0 && this.isShown();
                d.setVisible(visible, true);
            }
            d.setLevel(this.mLevel);
            this.mDrawableWidth = d.getIntrinsicWidth();
            this.mDrawableHeight = d.getIntrinsicHeight();
            this.applyImageTint();
            this.applyColorFilter();
            this.applyAlpha();
            this.applyXfermode();
            this.configureBounds();
        } else {
            this.mDrawableHeight = -1;
            this.mDrawableWidth = -1;
        }
    }

    @UnsupportedAppUsage
    private void resizeFromDrawable() {
        Drawable d = this.mDrawable;
        if (d != null) {
            int h;
            int w = d.getIntrinsicWidth();
            if (w < 0) {
                w = this.mDrawableWidth;
            }
            if ((h = d.getIntrinsicHeight()) < 0) {
                h = this.mDrawableHeight;
            }
            if (w != this.mDrawableWidth || h != this.mDrawableHeight) {
                this.mDrawableWidth = w;
                this.mDrawableHeight = h;
                this.requestLayout();
            }
        }
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (this.mDrawable != null) {
            this.mDrawable.setLayoutDirection(layoutDirection);
        }
    }

    @UnsupportedAppUsage
    private static Matrix.ScaleToFit scaleTypeToScaleToFit(ScaleType st) {
        return sS2FArray[st.nativeInt - 1];
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize;
        int widthSize;
        int w;
        int h;
        this.resolveUri();
        float desiredAspect = 0.0f;
        boolean resizeWidth = false;
        boolean resizeHeight = false;
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        if (this.mDrawable == null) {
            this.mDrawableWidth = -1;
            this.mDrawableHeight = -1;
            h = 0;
            w = 0;
        } else {
            w = this.mDrawableWidth;
            h = this.mDrawableHeight;
            if (w <= 0) {
                w = 1;
            }
            if (h <= 0) {
                h = 1;
            }
            if (this.mAdjustViewBounds) {
                resizeWidth = widthSpecMode != 0x40000000;
                resizeHeight = heightSpecMode != 0x40000000;
                desiredAspect = (float)w / (float)h;
            }
        }
        int pleft = this.mPaddingLeft;
        int pright = this.mPaddingRight;
        int ptop = this.mPaddingTop;
        int pbottom = this.mPaddingBottom;
        if (resizeWidth || resizeHeight) {
            float actualAspect;
            widthSize = this.resolveAdjustedSize(w + pleft + pright, this.mMaxWidth, widthMeasureSpec);
            heightSize = this.resolveAdjustedSize(h + ptop + pbottom, this.mMaxHeight, heightMeasureSpec);
            if (desiredAspect != 0.0f && (double)Math.abs((actualAspect = (float)(widthSize - pleft - pright) / (float)(heightSize - ptop - pbottom)) - desiredAspect) > 1.0E-7) {
                boolean done = false;
                if (resizeWidth) {
                    int newWidth = (int)(desiredAspect * (float)(heightSize - ptop - pbottom)) + pleft + pright;
                    if (!resizeHeight && !sCompatAdjustViewBounds) {
                        widthSize = this.resolveAdjustedSize(newWidth, this.mMaxWidth, widthMeasureSpec);
                    }
                    if (newWidth <= widthSize) {
                        widthSize = newWidth;
                        done = true;
                    }
                }
                if (!done && resizeHeight) {
                    int newHeight = (int)((float)(widthSize - pleft - pright) / desiredAspect) + ptop + pbottom;
                    if (!resizeWidth && !sCompatAdjustViewBounds) {
                        heightSize = this.resolveAdjustedSize(newHeight, this.mMaxHeight, heightMeasureSpec);
                    }
                    if (newHeight <= heightSize) {
                        heightSize = newHeight;
                    }
                }
            }
        } else {
            w += pleft + pright;
            h += ptop + pbottom;
            w = Math.max(w, this.getSuggestedMinimumWidth());
            h = Math.max(h, this.getSuggestedMinimumHeight());
            widthSize = ImageView.resolveSizeAndState(w, widthMeasureSpec, 0);
            heightSize = ImageView.resolveSizeAndState(h, heightMeasureSpec, 0);
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private int resolveAdjustedSize(int desiredSize, int maxSize, int measureSpec) {
        int result = desiredSize;
        int specMode = View.MeasureSpec.getMode(measureSpec);
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = Math.min(desiredSize, maxSize);
                break;
            }
            case -2147483648: {
                result = Math.min(Math.min(desiredSize, specSize), maxSize);
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    @Override
    protected boolean setFrame(int l, int t, int r, int b) {
        boolean changed = super.setFrame(l, t, r, b);
        this.mHaveFrame = true;
        this.configureBounds();
        return changed;
    }

    private void configureBounds() {
        boolean fits;
        if (this.mDrawable == null || !this.mHaveFrame) {
            return;
        }
        int dwidth = this.mDrawableWidth;
        int dheight = this.mDrawableHeight;
        int vwidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
        int vheight = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
        boolean bl = fits = !(dwidth >= 0 && vwidth != dwidth || dheight >= 0 && vheight != dheight);
        if (dwidth <= 0 || dheight <= 0 || ScaleType.FIT_XY == this.mScaleType) {
            this.mDrawable.setBounds(0, 0, vwidth, vheight);
            this.mDrawMatrix = null;
        } else {
            this.mDrawable.setBounds(0, 0, dwidth, dheight);
            if (ScaleType.MATRIX == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix.isIdentity() ? null : this.mMatrix;
            } else if (fits) {
                this.mDrawMatrix = null;
            } else if (ScaleType.CENTER == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix;
                this.mDrawMatrix.setTranslate(Math.round((float)(vwidth - dwidth) * 0.5f), Math.round((float)(vheight - dheight) * 0.5f));
            } else if (ScaleType.CENTER_CROP == this.mScaleType) {
                float scale;
                this.mDrawMatrix = this.mMatrix;
                float dx = 0.0f;
                float dy = 0.0f;
                if (dwidth * vheight > vwidth * dheight) {
                    scale = (float)vheight / (float)dheight;
                    dx = ((float)vwidth - (float)dwidth * scale) * 0.5f;
                } else {
                    scale = (float)vwidth / (float)dwidth;
                    dy = ((float)vheight - (float)dheight * scale) * 0.5f;
                }
                this.mDrawMatrix.setScale(scale, scale);
                this.mDrawMatrix.postTranslate(Math.round(dx), Math.round(dy));
            } else if (ScaleType.CENTER_INSIDE == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix;
                float scale = dwidth <= vwidth && dheight <= vheight ? 1.0f : Math.min((float)vwidth / (float)dwidth, (float)vheight / (float)dheight);
                float dx = Math.round(((float)vwidth - (float)dwidth * scale) * 0.5f);
                float dy = Math.round(((float)vheight - (float)dheight * scale) * 0.5f);
                this.mDrawMatrix.setScale(scale, scale);
                this.mDrawMatrix.postTranslate(dx, dy);
            } else {
                this.mTempSrc.set(0.0f, 0.0f, dwidth, dheight);
                this.mTempDst.set(0.0f, 0.0f, vwidth, vheight);
                this.mDrawMatrix = this.mMatrix;
                this.mDrawMatrix.setRectToRect(this.mTempSrc, this.mTempDst, ImageView.scaleTypeToScaleToFit(this.mScaleType));
            }
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.mDrawable;
        if (drawable2 != null && drawable2.isStateful() && drawable2.setState(this.getDrawableState())) {
            this.invalidateDrawable(drawable2);
        }
    }

    @Override
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mDrawable != null) {
            this.mDrawable.setHotspot(x, y);
        }
    }

    public void animateTransform(Matrix matrix) {
        if (this.mDrawable == null) {
            return;
        }
        if (matrix == null) {
            int vwidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
            int vheight = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
            this.mDrawable.setBounds(0, 0, vwidth, vheight);
            this.mDrawMatrix = null;
        } else {
            this.mDrawable.setBounds(0, 0, this.mDrawableWidth, this.mDrawableHeight);
            if (this.mDrawMatrix == null) {
                this.mDrawMatrix = new Matrix();
            }
            this.mDrawMatrix.set(matrix);
        }
        this.invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawable == null) {
            return;
        }
        if (this.mDrawableWidth == 0 || this.mDrawableHeight == 0) {
            return;
        }
        if (this.mDrawMatrix == null && this.mPaddingTop == 0 && this.mPaddingLeft == 0) {
            this.mDrawable.draw(canvas);
        } else {
            int saveCount = canvas.getSaveCount();
            canvas.save();
            if (this.mCropToPadding) {
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.mRight - this.mLeft - this.mPaddingRight, scrollY + this.mBottom - this.mTop - this.mPaddingBottom);
            }
            canvas.translate(this.mPaddingLeft, this.mPaddingTop);
            if (this.mDrawMatrix != null) {
                canvas.concat(this.mDrawMatrix);
            }
            this.mDrawable.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    @Override
    @ViewDebug.ExportedProperty(category="layout")
    public int getBaseline() {
        if (this.mBaselineAlignBottom) {
            return this.getMeasuredHeight();
        }
        return this.mBaseline;
    }

    public void setBaseline(int baseline) {
        if (this.mBaseline != baseline) {
            this.mBaseline = baseline;
            this.requestLayout();
        }
    }

    public void setBaselineAlignBottom(boolean aligned) {
        if (this.mBaselineAlignBottom != aligned) {
            this.mBaselineAlignBottom = aligned;
            this.requestLayout();
        }
    }

    public boolean getBaselineAlignBottom() {
        return this.mBaselineAlignBottom;
    }

    public void setColorFilter(int color2, PorterDuff.Mode mode) {
        this.setColorFilter(new PorterDuffColorFilter(color2, mode));
    }

    @RemotableViewMethod
    public void setColorFilter(int color2) {
        this.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
    }

    public void clearColorFilter() {
        this.setColorFilter(null);
    }

    public void setXfermode(Xfermode mode) {
        if (this.mXfermode != mode) {
            this.mXfermode = mode;
            this.mHasXfermode = true;
            this.applyXfermode();
            this.invalidate();
        }
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.mColorFilter != cf) {
            this.mColorFilter = cf;
            this.mHasColorFilter = true;
            this.applyColorFilter();
            this.invalidate();
        }
    }

    public int getImageAlpha() {
        return this.mAlpha;
    }

    @RemotableViewMethod
    public void setImageAlpha(int alpha) {
        this.setAlpha(alpha);
    }

    @Deprecated
    @RemotableViewMethod
    public void setAlpha(int alpha) {
        if (this.mAlpha != (alpha &= 0xFF)) {
            this.mAlpha = alpha;
            this.mHasAlpha = true;
            this.applyAlpha();
            this.invalidate();
        }
    }

    private void applyXfermode() {
        if (this.mDrawable != null && this.mHasXfermode) {
            this.mDrawable = this.mDrawable.mutate();
            this.mDrawable.setXfermode(this.mXfermode);
        }
    }

    private void applyColorFilter() {
        if (this.mDrawable != null && this.mHasColorFilter) {
            this.mDrawable = this.mDrawable.mutate();
            this.mDrawable.setColorFilter(this.mColorFilter);
        }
    }

    private void applyAlpha() {
        if (this.mDrawable != null && this.mHasAlpha) {
            this.mDrawable = this.mDrawable.mutate();
            this.mDrawable.setAlpha(this.mAlpha * 256 >> 8);
        }
    }

    @Override
    public boolean isOpaque() {
        return super.isOpaque() || this.mDrawable != null && this.mXfermode == null && this.mDrawable.getOpacity() == -1 && this.mAlpha * 256 >> 8 == 255 && this.isFilledByImage();
    }

    private boolean isFilledByImage() {
        if (this.mDrawable == null) {
            return false;
        }
        Rect bounds2 = this.mDrawable.getBounds();
        Matrix matrix = this.mDrawMatrix;
        if (matrix == null) {
            return bounds2.left <= 0 && bounds2.top <= 0 && bounds2.right >= this.getWidth() && bounds2.bottom >= this.getHeight();
        }
        if (matrix.rectStaysRect()) {
            RectF boundsSrc = this.mTempSrc;
            RectF boundsDst = this.mTempDst;
            boundsSrc.set(bounds2);
            matrix.mapRect(boundsDst, boundsSrc);
            return boundsDst.left <= 0.0f && boundsDst.top <= 0.0f && boundsDst.right >= (float)this.getWidth() && boundsDst.bottom >= (float)this.getHeight();
        }
        return false;
    }

    @Override
    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (this.mDrawable != null && !sCompatDrawableVisibilityDispatch) {
            this.mDrawable.setVisible(isVisible, false);
        }
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mDrawable != null && sCompatDrawableVisibilityDispatch) {
            this.mDrawable.setVisible(visibility == 0, false);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mDrawable != null && sCompatDrawableVisibilityDispatch) {
            this.mDrawable.setVisible(this.getVisibility() == 0, false);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mDrawable != null && sCompatDrawableVisibilityDispatch) {
            this.mDrawable.setVisible(false, false);
        }
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return ImageView.class.getName();
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder stream) {
        super.encodeProperties(stream);
        stream.addProperty("layout:baseline", this.getBaseline());
    }

    @Override
    public boolean isDefaultFocusHighlightNeeded(Drawable background, Drawable foreground) {
        boolean lackFocusState = this.mDrawable == null || !this.mDrawable.isStateful() || !this.mDrawable.hasFocusStateSpecified();
        return super.isDefaultFocusHighlightNeeded(background, foreground) && lackFocusState;
    }

    static {
        sScaleTypeArray = new ScaleType[]{ScaleType.MATRIX, ScaleType.FIT_XY, ScaleType.FIT_START, ScaleType.FIT_CENTER, ScaleType.FIT_END, ScaleType.CENTER, ScaleType.CENTER_CROP, ScaleType.CENTER_INSIDE};
        sS2FArray = new Matrix.ScaleToFit[]{Matrix.ScaleToFit.FILL, Matrix.ScaleToFit.START, Matrix.ScaleToFit.CENTER, Matrix.ScaleToFit.END};
    }

    public static enum ScaleType {
        MATRIX(0),
        FIT_XY(1),
        FIT_START(2),
        FIT_CENTER(3),
        FIT_END(4),
        CENTER(5),
        CENTER_CROP(6),
        CENTER_INSIDE(7);

        final int nativeInt;

        private ScaleType(int ni) {
            this.nativeInt = ni;
        }
    }

    private class ImageDrawableCallback
    implements Runnable {
        private final Drawable drawable;
        private final Uri uri;
        private final int resource;

        ImageDrawableCallback(Drawable drawable2, Uri uri, int resource) {
            this.drawable = drawable2;
            this.uri = uri;
            this.resource = resource;
        }

        @Override
        public void run() {
            ImageView.this.setImageDrawable(this.drawable);
            ImageView.this.mUri = this.uri;
            ImageView.this.mResource = this.resource;
        }
    }
}

