/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.animation.ValueAnimator;
import android.app.AppGlobals;
import android.app.PendingIntent;
import android.app.RemoteAction;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.UndoManager;
import android.content.UndoOperation;
import android.content.UndoOwner;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.RenderNode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ParcelableParcel;
import android.os.SystemClock;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextUtils;
import android.text.method.KeyListener;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.WordIterator;
import android.text.style.EasyEditSpan;
import android.text.style.SuggestionRangeSpan;
import android.text.style.SuggestionSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.URLSpan;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContentInfo;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.DragAndDropPermissions;
import android.view.DragEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.LinearInterpolator;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.EditorTouchState;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.Magnifier;
import android.widget.PopupWindow;
import android.widget.SelectionActionModeHelper;
import android.widget.SpellChecker;
import android.widget.TextView;
import android.widget.TextViewOnReceiveContentListener;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.view.FloatingActionMode;
import com.android.internal.widget.EditableInputConnection;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Editor {
    private static final String TAG = "Editor";
    private static final boolean DEBUG_UNDO = false;
    private static final boolean FLAG_USE_MAGNIFIER = true;
    private static final int CURSOR_START_FLOAT_DISTANCE_PX = 20;
    private static final int DELAY_BEFORE_HANDLE_FADES_OUT = 4000;
    private static final int RECENT_CUT_COPY_DURATION_MS = 15000;
    static final int BLINK = 500;
    private static final int DRAG_SHADOW_MAX_TEXT_LENGTH = 20;
    private static final int UNSET_X_VALUE = -1;
    private static final int UNSET_LINE = -1;
    private static final String UNDO_OWNER_TAG = "Editor";
    private static final int MENU_ITEM_ORDER_ASSIST = 0;
    private static final int MENU_ITEM_ORDER_UNDO = 2;
    private static final int MENU_ITEM_ORDER_REDO = 3;
    private static final int MENU_ITEM_ORDER_CUT = 4;
    private static final int MENU_ITEM_ORDER_COPY = 5;
    private static final int MENU_ITEM_ORDER_PASTE = 6;
    private static final int MENU_ITEM_ORDER_SHARE = 7;
    private static final int MENU_ITEM_ORDER_SELECT_ALL = 8;
    private static final int MENU_ITEM_ORDER_REPLACE = 9;
    private static final int MENU_ITEM_ORDER_AUTOFILL = 10;
    private static final int MENU_ITEM_ORDER_PASTE_AS_PLAIN_TEXT = 11;
    private static final int MENU_ITEM_ORDER_SECONDARY_ASSIST_ACTIONS_START = 50;
    private static final int MENU_ITEM_ORDER_PROCESS_TEXT_INTENT_ACTIONS_START = 100;
    private static final int FLAG_MISSPELLED_OR_GRAMMAR_ERROR = 10;
    private final TextViewOnReceiveContentListener mDefaultOnReceiveContentListener = new TextViewOnReceiveContentListener();
    private final UndoManager mUndoManager = new UndoManager();
    private UndoOwner mUndoOwner = this.mUndoManager.getOwner("Editor", this);
    final UndoInputFilter mUndoInputFilter = new UndoInputFilter(this);
    boolean mAllowUndo = true;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    InsertionPointCursorController mInsertionPointCursorController;
    SelectionModifierCursorController mSelectionModifierCursorController;
    private ActionMode mTextActionMode;
    @UnsupportedAppUsage
    private boolean mInsertionControllerEnabled;
    @UnsupportedAppUsage
    private boolean mSelectionControllerEnabled;
    private final boolean mHapticTextHandleEnabled;
    private MagnifierMotionAnimator mMagnifierAnimator;
    private final Runnable mUpdateMagnifierRunnable = new Runnable(){

        @Override
        public void run() {
            Editor.this.mMagnifierAnimator.update();
        }
    };
    private final ViewTreeObserver.OnDrawListener mMagnifierOnDrawListener = new ViewTreeObserver.OnDrawListener(){

        @Override
        public void onDraw() {
            if (Editor.this.mMagnifierAnimator != null) {
                Editor.this.mTextView.post(Editor.this.mUpdateMagnifierRunnable);
            }
        }
    };
    private CorrectionHighlighter mCorrectionHighlighter;
    private boolean mHasPendingRestartInputForSetText = false;
    InputContentType mInputContentType;
    InputMethodState mInputMethodState;
    private TextRenderNode[] mTextRenderNodes;
    boolean mFrozenWithFocus;
    boolean mSelectionMoved;
    boolean mTouchFocusSelected;
    KeyListener mKeyListener;
    int mInputType = 0;
    boolean mDiscardNextActionUp;
    boolean mIgnoreActionUpEvent;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private long mShowCursor;
    private boolean mRenderCursorRegardlessTiming;
    private Blink mBlink;
    private boolean mDrawCursorOnMagnifier;
    boolean mCursorVisible = true;
    boolean mSelectAllOnFocus;
    boolean mTextIsSelectable;
    CharSequence mError;
    boolean mErrorWasChanged;
    private ErrorPopup mErrorPopup;
    private boolean mShowErrorAfterAttach;
    boolean mInBatchEditControllers;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    boolean mShowSoftInputOnFocus = true;
    private boolean mPreserveSelection;
    private boolean mRestartActionModeOnNextRefresh;
    private boolean mRequestingLinkActionMode;
    private SelectionActionModeHelper mSelectionActionModeHelper;
    boolean mIsBeingLongClicked;
    boolean mIsBeingLongClickedByAccessibility;
    private SuggestionsPopupWindow mSuggestionsPopupWindow;
    SuggestionRangeSpan mSuggestionRangeSpan;
    private Runnable mShowSuggestionRunnable;
    Drawable mDrawableForCursor = null;
    @UnsupportedAppUsage(maxTargetSdk=28)
    Drawable mSelectHandleLeft;
    @UnsupportedAppUsage(maxTargetSdk=28)
    Drawable mSelectHandleRight;
    @UnsupportedAppUsage(maxTargetSdk=28)
    Drawable mSelectHandleCenter;
    private PositionListener mPositionListener;
    private float mContextMenuAnchorX;
    private float mContextMenuAnchorY;
    ActionMode.Callback mCustomSelectionActionModeCallback;
    ActionMode.Callback mCustomInsertionActionModeCallback;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    boolean mCreatedWithASelection;
    private int mLastButtonState;
    private final EditorTouchState mTouchState = new EditorTouchState();
    private Runnable mInsertionActionModeRunnable;
    private SpanController mSpanController;
    private WordIterator mWordIterator;
    SpellChecker mSpellChecker;
    private WordIterator mWordIteratorWithText;
    private boolean mUpdateWordIteratorText;
    private Rect mTempRect;
    private final TextView mTextView;
    final ProcessTextIntentActionsHandler mProcessTextIntentActionsHandler;
    private final CursorAnchorInfoNotifier mCursorAnchorInfoNotifier = new CursorAnchorInfoNotifier();
    private final Runnable mShowFloatingToolbar = new Runnable(){

        @Override
        public void run() {
            if (Editor.this.mTextActionMode != null) {
                Editor.this.mTextActionMode.hide(0L);
            }
        }
    };
    boolean mIsInsertionActionModeStartPending = false;
    private final SuggestionHelper mSuggestionHelper = new SuggestionHelper();
    private boolean mFlagCursorDragFromAnywhereEnabled;
    private float mCursorDragDirectionMinXYRatio;
    private boolean mFlagInsertionHandleGesturesEnabled;
    private final boolean mNewMagnifierEnabled;
    private static final int MIN_LINE_HEIGHT_FOR_MAGNIFIER = 20;
    private static final int MAX_LINE_HEIGHT_FOR_MAGNIFIER = 32;
    private int mMinLineHeightForMagnifier;
    private int mMaxLineHeightForMagnifier;
    private float mInitialZoom = 1.0f;
    private final float mLineSlopRatio;
    private static final int LINE_CHANGE_SLOP_MAX_DP = 45;
    private static final int LINE_CHANGE_SLOP_MIN_DP = 8;
    private int mLineChangeSlopMax;
    private int mLineChangeSlopMin;
    static final int EXTRACT_NOTHING = -2;
    static final int EXTRACT_UNKNOWN = -1;
    private final MenuItem.OnMenuItemClickListener mOnContextMenuItemClickListener = new MenuItem.OnMenuItemClickListener(){

        @Override
        public boolean onMenuItemClick(MenuItem item) {
            if (Editor.this.mProcessTextIntentActionsHandler.performMenuItemAction(item)) {
                return true;
            }
            return Editor.this.mTextView.onTextContextMenuItem(item.getItemId());
        }
    };
    public static final int HANDLE_TYPE_SELECTION_START = 0;
    public static final int HANDLE_TYPE_SELECTION_END = 1;

    Editor(TextView textView) {
        this.mTextView = textView;
        this.mTextView.setFilters(this.mTextView.getFilters());
        this.mProcessTextIntentActionsHandler = new ProcessTextIntentActionsHandler(this);
        this.mHapticTextHandleEnabled = this.mTextView.getContext().getResources().getBoolean(17891538);
        this.mFlagCursorDragFromAnywhereEnabled = AppGlobals.getIntCoreSetting("widget__enable_cursor_drag_from_anywhere", 1) != 0;
        int cursorDragMinAngleFromVertical = AppGlobals.getIntCoreSetting("widget__min_angle_from_vertical_to_start_cursor_drag", 45);
        this.mCursorDragDirectionMinXYRatio = EditorTouchState.getXYRatio(cursorDragMinAngleFromVertical);
        this.mFlagInsertionHandleGesturesEnabled = AppGlobals.getIntCoreSetting("widget__enable_insertion_handle_gestures", 0) != 0;
        this.mNewMagnifierEnabled = AppGlobals.getIntCoreSetting("widget__enable_new_magnifier", 0) != 0;
        this.mLineSlopRatio = AppGlobals.getFloatCoreSetting("widget__line_slop_ratio", 0.5f);
        this.mLineChangeSlopMax = (int)TypedValue.applyDimension(1, 45.0f, this.mTextView.getContext().getResources().getDisplayMetrics());
        this.mLineChangeSlopMin = (int)TypedValue.applyDimension(1, 8.0f, this.mTextView.getContext().getResources().getDisplayMetrics());
    }

    @VisibleForTesting
    public boolean getFlagCursorDragFromAnywhereEnabled() {
        return this.mFlagCursorDragFromAnywhereEnabled;
    }

    @VisibleForTesting
    public void setFlagCursorDragFromAnywhereEnabled(boolean enabled) {
        this.mFlagCursorDragFromAnywhereEnabled = enabled;
    }

    @VisibleForTesting
    public void setCursorDragMinAngleFromVertical(int degreesFromVertical) {
        this.mCursorDragDirectionMinXYRatio = EditorTouchState.getXYRatio(degreesFromVertical);
    }

    @VisibleForTesting
    public boolean getFlagInsertionHandleGesturesEnabled() {
        return this.mFlagInsertionHandleGesturesEnabled;
    }

    @VisibleForTesting
    public void setFlagInsertionHandleGesturesEnabled(boolean enabled) {
        this.mFlagInsertionHandleGesturesEnabled = enabled;
    }

    private MagnifierMotionAnimator getMagnifierAnimator() {
        if (this.mMagnifierAnimator == null) {
            Magnifier.Builder builder2 = this.mNewMagnifierEnabled ? this.createBuilderWithInlineMagnifierDefaults() : Magnifier.createBuilderWithOldMagnifierDefaults(this.mTextView);
            this.mMagnifierAnimator = new MagnifierMotionAnimator(builder2.build());
        }
        return this.mMagnifierAnimator;
    }

    private Magnifier.Builder createBuilderWithInlineMagnifierDefaults() {
        Magnifier.Builder params = new Magnifier.Builder(this.mTextView);
        float zoom = AppGlobals.getFloatCoreSetting("widget__magnifier_zoom_factor", 1.5f);
        float aspectRatio = AppGlobals.getFloatCoreSetting("widget__magnifier_aspect_ratio", 5.5f);
        if (zoom < 1.2f || zoom > 1.8f) {
            zoom = 1.5f;
        }
        if (aspectRatio < 3.0f || aspectRatio > 8.0f) {
            aspectRatio = 5.5f;
        }
        this.mInitialZoom = zoom;
        this.mMinLineHeightForMagnifier = (int)TypedValue.applyDimension(1, 20.0f, this.mTextView.getContext().getResources().getDisplayMetrics());
        this.mMaxLineHeightForMagnifier = (int)TypedValue.applyDimension(1, 32.0f, this.mTextView.getContext().getResources().getDisplayMetrics());
        Layout layout2 = this.mTextView.getLayout();
        int line = layout2.getLineForOffset(this.mTextView.getSelectionStart());
        int sourceHeight = layout2.getLineBottomWithoutSpacing(line) - layout2.getLineTop(line);
        int height = (int)((float)sourceHeight * zoom);
        int width = (int)(aspectRatio * (float)Math.max(sourceHeight, this.mMinLineHeightForMagnifier));
        params.setFishEyeStyle().setSize(width, height).setSourceSize(width, sourceHeight).setElevation(0.0f).setInitialZoom(zoom).setClippingEnabled(false);
        Context context = this.mTextView.getContext();
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Magnifier, 17956994, 0);
        params.setDefaultSourceToMagnifierOffset(a.getDimensionPixelSize(3, 0), a.getDimensionPixelSize(4, 0));
        a.recycle();
        return params.setSourceBounds(1, 0, 1, 0);
    }

    ParcelableParcel saveInstanceState() {
        ParcelableParcel state = new ParcelableParcel(this.getClass().getClassLoader());
        Parcel parcel = state.getParcel();
        this.mUndoManager.saveInstanceState(parcel);
        this.mUndoInputFilter.saveInstanceState(parcel);
        return state;
    }

    void restoreInstanceState(ParcelableParcel state) {
        Parcel parcel = state.getParcel();
        this.mUndoManager.restoreInstanceState(parcel, state.getClassLoader());
        this.mUndoInputFilter.restoreInstanceState(parcel);
        this.mUndoOwner = this.mUndoManager.getOwner("Editor", this);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public TextViewOnReceiveContentListener getDefaultOnReceiveContentListener() {
        return this.mDefaultOnReceiveContentListener;
    }

    void forgetUndoRedo() {
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        this.mUndoManager.forgetUndos(owners, -1);
        this.mUndoManager.forgetRedos(owners, -1);
    }

    boolean canUndo() {
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        return this.mAllowUndo && this.mUndoManager.countUndos(owners) > 0;
    }

    boolean canRedo() {
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        return this.mAllowUndo && this.mUndoManager.countRedos(owners) > 0;
    }

    void undo() {
        if (!this.mAllowUndo) {
            return;
        }
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        this.mUndoManager.undo(owners, 1);
    }

    void redo() {
        if (!this.mAllowUndo) {
            return;
        }
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        this.mUndoManager.redo(owners, 1);
    }

    void replace() {
        if (this.mSuggestionsPopupWindow == null) {
            this.mSuggestionsPopupWindow = new SuggestionsPopupWindow();
        }
        this.hideCursorAndSpanControllers();
        this.mSuggestionsPopupWindow.show();
        int middle = (this.mTextView.getSelectionStart() + this.mTextView.getSelectionEnd()) / 2;
        Selection.setSelection((Spannable)this.mTextView.getText(), middle);
    }

    void onAttachedToWindow() {
        ViewTreeObserver observer;
        if (this.mShowErrorAfterAttach) {
            this.showError();
            this.mShowErrorAfterAttach = false;
        }
        if ((observer = this.mTextView.getViewTreeObserver()).isAlive()) {
            if (this.mInsertionPointCursorController != null) {
                observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
            }
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.resetTouchOffsets();
                observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
            }
            observer.addOnDrawListener(this.mMagnifierOnDrawListener);
        }
        this.updateSpellCheckSpans(0, this.mTextView.getText().length(), true);
        if (this.mTextView.hasSelection()) {
            this.refreshTextActionMode();
        }
        this.getPositionListener().addSubscriber(this.mCursorAnchorInfoNotifier, true);
        this.resumeBlink();
    }

    void onDetachedFromWindow() {
        ViewTreeObserver observer;
        this.getPositionListener().removeSubscriber(this.mCursorAnchorInfoNotifier);
        if (this.mError != null) {
            this.hideError();
        }
        this.suspendBlink();
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.onDetached();
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.onDetached();
        }
        if (this.mShowSuggestionRunnable != null) {
            this.mTextView.removeCallbacks(this.mShowSuggestionRunnable);
        }
        if (this.mInsertionActionModeRunnable != null) {
            this.mTextView.removeCallbacks(this.mInsertionActionModeRunnable);
        }
        this.mTextView.removeCallbacks(this.mShowFloatingToolbar);
        this.discardTextDisplayLists();
        if (this.mSpellChecker != null) {
            this.mSpellChecker.closeSession();
            this.mSpellChecker = null;
        }
        if ((observer = this.mTextView.getViewTreeObserver()).isAlive()) {
            observer.removeOnDrawListener(this.mMagnifierOnDrawListener);
        }
        this.hideCursorAndSpanControllers();
        this.stopTextActionModeWithPreservingSelection();
        this.mDefaultOnReceiveContentListener.clearInputConnectionInfo();
    }

    private void discardTextDisplayLists() {
        if (this.mTextRenderNodes != null) {
            for (int i = 0; i < this.mTextRenderNodes.length; ++i) {
                RenderNode displayList;
                RenderNode renderNode = displayList = this.mTextRenderNodes[i] != null ? this.mTextRenderNodes[i].renderNode : null;
                if (displayList == null || !displayList.hasDisplayList()) continue;
                displayList.discardDisplayList();
            }
        }
    }

    private void showError() {
        if (this.mTextView.getWindowToken() == null) {
            this.mShowErrorAfterAttach = true;
            return;
        }
        if (this.mErrorPopup == null) {
            LayoutInflater inflater = LayoutInflater.from(this.mTextView.getContext());
            TextView err = (TextView)inflater.inflate(17367343, null);
            float scale = this.mTextView.getResources().getDisplayMetrics().density;
            this.mErrorPopup = new ErrorPopup(err, (int)(200.0f * scale + 0.5f), (int)(50.0f * scale + 0.5f));
            this.mErrorPopup.setFocusable(false);
            this.mErrorPopup.setInputMethodMode(1);
        }
        TextView tv = (TextView)this.mErrorPopup.getContentView();
        this.chooseSize(this.mErrorPopup, this.mError, tv);
        tv.setText(this.mError);
        this.mErrorPopup.showAsDropDown(this.mTextView, this.getErrorX(), this.getErrorY(), 51);
        this.mErrorPopup.fixDirection(this.mErrorPopup.isAboveAnchor());
    }

    public void setError(CharSequence error, Drawable icon2) {
        this.mError = TextUtils.stringOrSpannedString(error);
        this.mErrorWasChanged = true;
        if (this.mError == null) {
            this.setErrorIcon(null);
            if (this.mErrorPopup != null) {
                if (this.mErrorPopup.isShowing()) {
                    this.mErrorPopup.dismiss();
                }
                this.mErrorPopup = null;
            }
            this.mShowErrorAfterAttach = false;
        } else {
            this.setErrorIcon(icon2);
            if (this.mTextView.isFocused()) {
                this.showError();
            }
        }
    }

    private void setErrorIcon(Drawable icon2) {
        TextView.Drawables dr = this.mTextView.mDrawables;
        if (dr == null) {
            this.mTextView.mDrawables = dr = new TextView.Drawables(this.mTextView.getContext());
        }
        dr.setErrorDrawable(icon2, this.mTextView);
        this.mTextView.resetResolvedDrawables();
        this.mTextView.invalidate();
        this.mTextView.requestLayout();
    }

    private void hideError() {
        if (this.mErrorPopup != null && this.mErrorPopup.isShowing()) {
            this.mErrorPopup.dismiss();
        }
        this.mShowErrorAfterAttach = false;
    }

    private int getErrorX() {
        int errorX;
        float scale = this.mTextView.getResources().getDisplayMetrics().density;
        TextView.Drawables dr = this.mTextView.mDrawables;
        int layoutDirection = this.mTextView.getLayoutDirection();
        switch (layoutDirection) {
            default: {
                int offset2 = -(dr != null ? dr.mDrawableSizeRight : 0) / 2 + (int)(25.0f * scale + 0.5f);
                errorX = this.mTextView.getWidth() - this.mErrorPopup.getWidth() - this.mTextView.getPaddingRight() + offset2;
                break;
            }
            case 1: {
                int offset3 = (dr != null ? dr.mDrawableSizeLeft : 0) / 2 - (int)(25.0f * scale + 0.5f);
                errorX = this.mTextView.getPaddingLeft() + offset3;
            }
        }
        return errorX;
    }

    private int getErrorY() {
        int height;
        int compoundPaddingTop = this.mTextView.getCompoundPaddingTop();
        int vspace = this.mTextView.getBottom() - this.mTextView.getTop() - this.mTextView.getCompoundPaddingBottom() - compoundPaddingTop;
        TextView.Drawables dr = this.mTextView.mDrawables;
        int layoutDirection = this.mTextView.getLayoutDirection();
        switch (layoutDirection) {
            default: {
                height = dr != null ? dr.mDrawableHeightRight : 0;
                break;
            }
            case 1: {
                height = dr != null ? dr.mDrawableHeightLeft : 0;
            }
        }
        int icontop = compoundPaddingTop + (vspace - height) / 2;
        float scale = this.mTextView.getResources().getDisplayMetrics().density;
        return icontop + height - this.mTextView.getHeight() - (int)(2.0f * scale + 0.5f);
    }

    void createInputContentTypeIfNeeded() {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
    }

    void createInputMethodStateIfNeeded() {
        if (this.mInputMethodState == null) {
            this.mInputMethodState = new InputMethodState();
        }
    }

    private boolean isCursorVisible() {
        return this.mCursorVisible && this.mTextView.isTextEditable();
    }

    boolean shouldRenderCursor() {
        if (!this.isCursorVisible()) {
            return false;
        }
        if (this.mRenderCursorRegardlessTiming) {
            return true;
        }
        long showCursorDelta = SystemClock.uptimeMillis() - this.mShowCursor;
        return showCursorDelta % 1000L < 500L;
    }

    void prepareCursorControllers() {
        boolean windowSupportsHandles = false;
        ViewGroup.LayoutParams params = this.mTextView.getRootView().getLayoutParams();
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams windowParams = (WindowManager.LayoutParams)params;
            windowSupportsHandles = windowParams.type < 1000 || windowParams.type > 1999;
        }
        boolean enabled = windowSupportsHandles && this.mTextView.getLayout() != null;
        this.mInsertionControllerEnabled = enabled && (this.mDrawCursorOnMagnifier || this.isCursorVisible());
        boolean bl = this.mSelectionControllerEnabled = enabled && this.mTextView.textCanBeSelected();
        if (!this.mInsertionControllerEnabled) {
            this.hideInsertionPointCursorController();
            if (this.mInsertionPointCursorController != null) {
                this.mInsertionPointCursorController.onDetached();
                this.mInsertionPointCursorController = null;
            }
        }
        if (!this.mSelectionControllerEnabled) {
            this.stopTextActionMode();
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.onDetached();
                this.mSelectionModifierCursorController = null;
            }
        }
    }

    void hideInsertionPointCursorController() {
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.hide();
        }
    }

    void hideCursorAndSpanControllers() {
        this.hideCursorControllers();
        this.hideSpanControllers();
    }

    private void hideSpanControllers() {
        if (this.mSpanController != null) {
            this.mSpanController.hide();
        }
    }

    private void hideCursorControllers() {
        if (this.mSuggestionsPopupWindow != null && (this.mTextView.isInExtractedMode() || !this.mSuggestionsPopupWindow.isShowingUp())) {
            this.mSuggestionsPopupWindow.hide();
        }
        this.hideInsertionPointCursorController();
    }

    private void updateSpellCheckSpans(int start, int end, boolean createSpellChecker) {
        this.mTextView.removeAdjacentSuggestionSpans(start);
        this.mTextView.removeAdjacentSuggestionSpans(end);
        if (this.mTextView.isTextEditable() && this.mTextView.isSuggestionsEnabled() && !this.mTextView.isInExtractedMode()) {
            InputMethodManager imm = this.getInputMethodManager();
            if (imm != null && imm.isInputMethodSuppressingSpellChecker()) {
                return;
            }
            if (this.mSpellChecker == null && createSpellChecker) {
                this.mSpellChecker = new SpellChecker(this.mTextView);
            }
            if (this.mSpellChecker != null) {
                this.mSpellChecker.spellCheck(start, end);
            }
        }
    }

    void onScreenStateChanged(int screenState) {
        switch (screenState) {
            case 1: {
                this.resumeBlink();
                break;
            }
            case 0: {
                this.suspendBlink();
            }
        }
    }

    private void suspendBlink() {
        if (this.mBlink != null) {
            this.mBlink.cancel();
        }
    }

    private void resumeBlink() {
        if (this.mBlink != null) {
            this.mBlink.uncancel();
            this.makeBlink();
        }
    }

    void adjustInputType(boolean password, boolean passwordInputType, boolean webPasswordInputType, boolean numberPasswordInputType) {
        if ((this.mInputType & 0xF) == 1) {
            if (password || passwordInputType) {
                this.mInputType = this.mInputType & 0xFFFFF00F | 0x80;
            }
            if (webPasswordInputType) {
                this.mInputType = this.mInputType & 0xFFFFF00F | 0xE0;
            }
        } else if ((this.mInputType & 0xF) == 2 && numberPasswordInputType) {
            this.mInputType = this.mInputType & 0xFFFFF00F | 0x10;
        }
    }

    private void chooseSize(PopupWindow pop, CharSequence text, TextView tv) {
        int wid = tv.getPaddingLeft() + tv.getPaddingRight();
        int ht = tv.getPaddingTop() + tv.getPaddingBottom();
        int defaultWidthInPixels = this.mTextView.getResources().getDimensionPixelSize(17105560);
        StaticLayout l = StaticLayout.Builder.obtain(text, 0, text.length(), tv.getPaint(), defaultWidthInPixels).setUseLineSpacingFromFallbacks(tv.mUseFallbackLineSpacing).build();
        float max = 0.0f;
        for (int i = 0; i < l.getLineCount(); ++i) {
            max = Math.max(max, l.getLineWidth(i));
        }
        pop.setWidth(wid + (int)Math.ceil(max));
        pop.setHeight(ht + l.getHeight());
    }

    void setFrame() {
        if (this.mErrorPopup != null) {
            TextView tv = (TextView)this.mErrorPopup.getContentView();
            this.chooseSize(this.mErrorPopup, this.mError, tv);
            this.mErrorPopup.update(this.mTextView, this.getErrorX(), this.getErrorY(), this.mErrorPopup.getWidth(), this.mErrorPopup.getHeight());
        }
    }

    private int getWordStart(int offset2) {
        int retOffset = this.getWordIteratorWithText().prevBoundary(offset2);
        retOffset = this.getWordIteratorWithText().isOnPunctuation(retOffset) ? this.getWordIteratorWithText().getPunctuationBeginning(offset2) : this.getWordIteratorWithText().getPrevWordBeginningOnTwoWordsBoundary(offset2);
        if (retOffset == -1) {
            return offset2;
        }
        return retOffset;
    }

    private int getWordEnd(int offset2) {
        int retOffset = this.getWordIteratorWithText().nextBoundary(offset2);
        retOffset = this.getWordIteratorWithText().isAfterPunctuation(retOffset) ? this.getWordIteratorWithText().getPunctuationEnd(offset2) : this.getWordIteratorWithText().getNextWordEndOnTwoWordBoundary(offset2);
        if (retOffset == -1) {
            return offset2;
        }
        return retOffset;
    }

    private boolean needsToSelectAllToSelectWordOrParagraph() {
        if (this.mTextView.hasPasswordTransformationMethod()) {
            return true;
        }
        int inputType = this.mTextView.getInputType();
        int klass = inputType & 0xF;
        int variation = inputType & 0xFF0;
        return klass == 2 || klass == 3 || klass == 4 || variation == 16 || variation == 32 || variation == 208 || variation == 176;
    }

    boolean selectCurrentWord() {
        int selectionEnd;
        int selectionStart;
        if (!this.mTextView.canSelectText()) {
            return false;
        }
        if (this.needsToSelectAllToSelectWordOrParagraph()) {
            return this.mTextView.selectAllText();
        }
        long lastTouchOffsets = this.getLastTouchOffsets();
        int minOffset = TextUtils.unpackRangeStartFromLong(lastTouchOffsets);
        int maxOffset = TextUtils.unpackRangeEndFromLong(lastTouchOffsets);
        if (minOffset < 0 || minOffset > this.mTextView.getText().length()) {
            return false;
        }
        if (maxOffset < 0 || maxOffset > this.mTextView.getText().length()) {
            return false;
        }
        URLSpan[] urlSpans = ((Spanned)this.mTextView.getText()).getSpans(minOffset, maxOffset, URLSpan.class);
        if (urlSpans.length >= 1) {
            URLSpan urlSpan = urlSpans[0];
            selectionStart = ((Spanned)this.mTextView.getText()).getSpanStart(urlSpan);
            selectionEnd = ((Spanned)this.mTextView.getText()).getSpanEnd(urlSpan);
        } else {
            WordIterator wordIterator = this.getWordIterator();
            wordIterator.setCharSequence(this.mTextView.getText(), minOffset, maxOffset);
            selectionStart = wordIterator.getBeginning(minOffset);
            selectionEnd = wordIterator.getEnd(maxOffset);
            if (selectionStart == -1 || selectionEnd == -1 || selectionStart == selectionEnd) {
                long range = this.getCharClusterRange(minOffset);
                selectionStart = TextUtils.unpackRangeStartFromLong(range);
                selectionEnd = TextUtils.unpackRangeEndFromLong(range);
            }
        }
        Selection.setSelection((Spannable)this.mTextView.getText(), selectionStart, selectionEnd);
        return selectionEnd > selectionStart;
    }

    private boolean selectCurrentParagraph() {
        int end;
        int maxLastTouchOffset;
        if (!this.mTextView.canSelectText()) {
            return false;
        }
        if (this.needsToSelectAllToSelectWordOrParagraph()) {
            return this.mTextView.selectAllText();
        }
        long lastTouchOffsets = this.getLastTouchOffsets();
        int minLastTouchOffset = TextUtils.unpackRangeStartFromLong(lastTouchOffsets);
        long paragraphsRange = this.getParagraphsRange(minLastTouchOffset, maxLastTouchOffset = TextUtils.unpackRangeEndFromLong(lastTouchOffsets));
        int start = TextUtils.unpackRangeStartFromLong(paragraphsRange);
        if (start < (end = TextUtils.unpackRangeEndFromLong(paragraphsRange))) {
            Selection.setSelection((Spannable)this.mTextView.getText(), start, end);
            return true;
        }
        return false;
    }

    private long getParagraphsRange(int startOffset, int endOffset) {
        int lineEndOffset;
        int maxLine;
        int prevLineEndOffset;
        int minLine;
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return TextUtils.packRangeInLong(-1, -1);
        }
        CharSequence text = this.mTextView.getText();
        for (minLine = layout2.getLineForOffset(startOffset); minLine > 0 && text.charAt((prevLineEndOffset = layout2.getLineEnd(minLine - 1)) - 1) != '\n'; --minLine) {
        }
        for (maxLine = layout2.getLineForOffset(endOffset); maxLine < layout2.getLineCount() - 1 && text.charAt((lineEndOffset = layout2.getLineEnd(maxLine)) - 1) != '\n'; ++maxLine) {
        }
        return TextUtils.packRangeInLong(layout2.getLineStart(minLine), layout2.getLineEnd(maxLine));
    }

    void onLocaleChanged() {
        this.mWordIterator = null;
        this.mWordIteratorWithText = null;
    }

    public WordIterator getWordIterator() {
        if (this.mWordIterator == null) {
            this.mWordIterator = new WordIterator(this.mTextView.getTextServicesLocale());
        }
        return this.mWordIterator;
    }

    private WordIterator getWordIteratorWithText() {
        if (this.mWordIteratorWithText == null) {
            this.mWordIteratorWithText = new WordIterator(this.mTextView.getTextServicesLocale());
            this.mUpdateWordIteratorText = true;
        }
        if (this.mUpdateWordIteratorText) {
            CharSequence text = this.mTextView.getText();
            this.mWordIteratorWithText.setCharSequence(text, 0, text.length());
            this.mUpdateWordIteratorText = false;
        }
        return this.mWordIteratorWithText;
    }

    private int getNextCursorOffset(int offset2, boolean findAfterGivenOffset) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return offset2;
        }
        return findAfterGivenOffset == layout2.isRtlCharAt(offset2) ? layout2.getOffsetToLeftOf(offset2) : layout2.getOffsetToRightOf(offset2);
    }

    private long getCharClusterRange(int offset2) {
        int textLength = this.mTextView.getText().length();
        if (offset2 < textLength) {
            int clusterEndOffset = this.getNextCursorOffset(offset2, true);
            return TextUtils.packRangeInLong(this.getNextCursorOffset(clusterEndOffset, false), clusterEndOffset);
        }
        if (offset2 - 1 >= 0) {
            int clusterStartOffset = this.getNextCursorOffset(offset2, false);
            return TextUtils.packRangeInLong(clusterStartOffset, this.getNextCursorOffset(clusterStartOffset, true));
        }
        return TextUtils.packRangeInLong(offset2, offset2);
    }

    private boolean touchPositionIsInSelection() {
        int selectionEnd;
        int selectionStart = this.mTextView.getSelectionStart();
        if (selectionStart == (selectionEnd = this.mTextView.getSelectionEnd())) {
            return false;
        }
        if (selectionStart > selectionEnd) {
            int tmp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = tmp;
            Selection.setSelection((Spannable)this.mTextView.getText(), selectionStart, selectionEnd);
        }
        SelectionModifierCursorController selectionController = this.getSelectionController();
        int minOffset = selectionController.getMinTouchOffset();
        int maxOffset = selectionController.getMaxTouchOffset();
        return minOffset >= selectionStart && maxOffset < selectionEnd;
    }

    private PositionListener getPositionListener() {
        if (this.mPositionListener == null) {
            this.mPositionListener = new PositionListener();
        }
        return this.mPositionListener;
    }

    private boolean isOffsetVisible(int offset2) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return false;
        }
        int line = layout2.getLineForOffset(offset2);
        int lineBottom = layout2.getLineBottom(line);
        int primaryHorizontal = (int)layout2.getPrimaryHorizontal(offset2);
        return this.mTextView.isPositionVisible(primaryHorizontal + this.mTextView.viewportToContentHorizontalOffset(), lineBottom + this.mTextView.viewportToContentVerticalOffset());
    }

    private boolean isPositionOnText(float x, float y) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return false;
        }
        int line = this.mTextView.getLineAtCoordinate(y);
        if ((x = this.mTextView.convertToLocalHorizontalCoordinate(x)) < layout2.getLineLeft(line)) {
            return false;
        }
        return !(x > layout2.getLineRight(line));
    }

    private void startDragAndDrop() {
        this.getSelectionActionModeHelper().onSelectionDrag();
        if (this.mTextView.isInExtractedMode()) {
            return;
        }
        int start = this.mTextView.getSelectionStart();
        int end = this.mTextView.getSelectionEnd();
        CharSequence selectedText = this.mTextView.getTransformedText(start, end);
        ClipData data = ClipData.newPlainText(null, selectedText);
        DragLocalState localState = new DragLocalState(this.mTextView, start, end);
        this.mTextView.startDragAndDrop(data, this.getTextThumbnailBuilder(start, end), localState, 256);
        this.stopTextActionMode();
        if (this.hasSelectionController()) {
            this.getSelectionController().resetTouchOffsets();
        }
    }

    public boolean performLongClick(boolean handled) {
        if (this.mIsBeingLongClickedByAccessibility) {
            if (!handled) {
                this.toggleInsertionActionMode();
            }
            return true;
        }
        if (!handled && !this.isPositionOnText(this.mTouchState.getLastDownX(), this.mTouchState.getLastDownY()) && !this.mTouchState.isOnHandle() && this.mInsertionControllerEnabled) {
            int offset2 = this.mTextView.getOffsetForPosition(this.mTouchState.getLastDownX(), this.mTouchState.getLastDownY());
            Selection.setSelection((Spannable)this.mTextView.getText(), offset2);
            this.getInsertionController().show();
            this.mIsInsertionActionModeStartPending = true;
            handled = true;
            MetricsLogger.action(this.mTextView.getContext(), 629, 0);
        }
        if (!handled && this.mTextActionMode != null) {
            if (this.touchPositionIsInSelection()) {
                this.startDragAndDrop();
                MetricsLogger.action(this.mTextView.getContext(), 629, 2);
            } else {
                this.stopTextActionMode();
                this.selectCurrentWordAndStartDrag();
                MetricsLogger.action(this.mTextView.getContext(), 629, 1);
            }
            handled = true;
        }
        if (!handled && (handled = this.selectCurrentWordAndStartDrag())) {
            MetricsLogger.action(this.mTextView.getContext(), 629, 1);
        }
        return handled;
    }

    private void toggleInsertionActionMode() {
        if (this.mTextActionMode != null) {
            this.stopTextActionMode();
        } else {
            this.startInsertionActionMode();
        }
    }

    float getLastUpPositionX() {
        return this.mTouchState.getLastUpX();
    }

    float getLastUpPositionY() {
        return this.mTouchState.getLastUpY();
    }

    private long getLastTouchOffsets() {
        SelectionModifierCursorController selectionController = this.getSelectionController();
        int minOffset = selectionController.getMinTouchOffset();
        int maxOffset = selectionController.getMaxTouchOffset();
        return TextUtils.packRangeInLong(minOffset, maxOffset);
    }

    void onFocusChanged(boolean focused, int direction) {
        this.mShowCursor = SystemClock.uptimeMillis();
        this.ensureEndedBatchEdit();
        if (focused) {
            int selStart = this.mTextView.getSelectionStart();
            int selEnd = this.mTextView.getSelectionEnd();
            boolean isFocusHighlighted = this.mSelectAllOnFocus && selStart == 0 && selEnd == this.mTextView.getText().length();
            boolean bl = this.mCreatedWithASelection = this.mFrozenWithFocus && this.mTextView.hasSelection() && !isFocusHighlighted;
            if (!this.mFrozenWithFocus || selStart < 0 || selEnd < 0) {
                MovementMethod mMovement;
                int lastTapPosition = this.getLastTapPosition();
                if (lastTapPosition >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), lastTapPosition);
                }
                if ((mMovement = this.mTextView.getMovementMethod()) != null) {
                    mMovement.onTakeFocus(this.mTextView, (Spannable)this.mTextView.getText(), direction);
                }
                if ((this.mTextView.isInExtractedMode() || this.mSelectionMoved) && selStart >= 0 && selEnd >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), selStart, selEnd);
                }
                if (this.mSelectAllOnFocus) {
                    this.mTextView.selectAllText();
                }
                this.mTouchFocusSelected = true;
            }
            this.mFrozenWithFocus = false;
            this.mSelectionMoved = false;
            if (this.mError != null) {
                this.showError();
            }
            this.makeBlink();
        } else {
            if (this.mError != null) {
                this.hideError();
            }
            this.mTextView.onEndBatchEdit();
            if (this.mTextView.isInExtractedMode()) {
                this.hideCursorAndSpanControllers();
                this.stopTextActionModeWithPreservingSelection();
            } else {
                this.hideCursorAndSpanControllers();
                if (this.mTextView.isTemporarilyDetached()) {
                    this.stopTextActionModeWithPreservingSelection();
                } else {
                    this.stopTextActionMode();
                }
                this.downgradeEasyCorrectionSpans();
            }
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.resetTouchOffsets();
            }
            this.ensureNoSelectionIfNonSelectable();
        }
    }

    private void ensureNoSelectionIfNonSelectable() {
        if (!this.mTextView.textCanBeSelected() && this.mTextView.hasSelection()) {
            Selection.setSelection((Spannable)this.mTextView.getText(), this.mTextView.length(), this.mTextView.length());
        }
    }

    private void downgradeEasyCorrectionSpans() {
        CharSequence text = this.mTextView.getText();
        if (text instanceof Spannable) {
            Spannable spannable = (Spannable)text;
            SuggestionSpan[] suggestionSpans = spannable.getSpans(0, spannable.length(), SuggestionSpan.class);
            for (int i = 0; i < suggestionSpans.length; ++i) {
                int flags = suggestionSpans[i].getFlags();
                if ((flags & 1) == 0 || (flags & 0xA) != 0) continue;
                suggestionSpans[i].setFlags(flags &= 0xFFFFFFFE);
            }
        }
    }

    void sendOnTextChanged(int start, int before, int after) {
        this.getSelectionActionModeHelper().onTextChanged(start, start + before);
        this.updateSpellCheckSpans(start, start + after, false);
        this.mUpdateWordIteratorText = true;
        this.hideCursorControllers();
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.resetTouchOffsets();
        }
        this.stopTextActionMode();
    }

    private int getLastTapPosition() {
        int lastTapPosition;
        if (this.mSelectionModifierCursorController != null && (lastTapPosition = this.mSelectionModifierCursorController.getMinTouchOffset()) >= 0) {
            if (lastTapPosition > this.mTextView.getText().length()) {
                lastTapPosition = this.mTextView.getText().length();
            }
            return lastTapPosition;
        }
        return -1;
    }

    void onWindowFocusChanged(boolean hasWindowFocus) {
        if (hasWindowFocus) {
            if (this.mBlink != null) {
                this.mBlink.uncancel();
                this.makeBlink();
            }
            if (this.mTextView.hasSelection() && !this.extractedTextModeWillBeStarted()) {
                this.refreshTextActionMode();
            }
        } else {
            if (this.mBlink != null) {
                this.mBlink.cancel();
            }
            if (this.mInputContentType != null) {
                this.mInputContentType.enterDown = false;
            }
            this.hideCursorAndSpanControllers();
            this.stopTextActionModeWithPreservingSelection();
            if (this.mSuggestionsPopupWindow != null) {
                this.mSuggestionsPopupWindow.onParentLostFocus();
            }
            this.ensureEndedBatchEdit();
            this.ensureNoSelectionIfNonSelectable();
        }
    }

    private boolean shouldFilterOutTouchEvent(MotionEvent event) {
        if (!event.isFromSource(8194)) {
            return false;
        }
        boolean primaryButtonStateChanged = ((this.mLastButtonState ^ event.getButtonState()) & 1) != 0;
        int action2 = event.getActionMasked();
        if (!(action2 != 0 && action2 != 1 || primaryButtonStateChanged)) {
            return true;
        }
        return action2 == 2 && !event.isButtonPressed(1);
    }

    @VisibleForTesting
    public void onTouchEvent(MotionEvent event) {
        boolean filterOutEvent = this.shouldFilterOutTouchEvent(event);
        this.mLastButtonState = event.getButtonState();
        if (filterOutEvent) {
            if (event.getActionMasked() == 1) {
                this.mDiscardNextActionUp = true;
            }
            return;
        }
        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.mTextView.getContext());
        this.mTouchState.update(event, viewConfiguration);
        this.updateFloatingToolbarVisibility(event);
        if (this.hasInsertionController()) {
            this.getInsertionController().onTouchEvent(event);
        }
        if (this.hasSelectionController()) {
            this.getSelectionController().onTouchEvent(event);
        }
        if (this.mShowSuggestionRunnable != null) {
            this.mTextView.removeCallbacks(this.mShowSuggestionRunnable);
            this.mShowSuggestionRunnable = null;
        }
        if (event.getActionMasked() == 0) {
            this.mTouchFocusSelected = false;
            this.mIgnoreActionUpEvent = false;
        }
    }

    private void updateFloatingToolbarVisibility(MotionEvent event) {
        if (this.mTextActionMode != null) {
            switch (event.getActionMasked()) {
                case 2: {
                    this.hideFloatingToolbar(-1);
                    break;
                }
                case 1: 
                case 3: {
                    this.showFloatingToolbar();
                }
            }
        }
    }

    void hideFloatingToolbar(int duration) {
        if (this.mTextActionMode != null) {
            this.mTextView.removeCallbacks(this.mShowFloatingToolbar);
            this.mTextActionMode.hide(duration);
        }
    }

    private void showFloatingToolbar() {
        if (this.mTextActionMode != null) {
            int delay = ViewConfiguration.getDoubleTapTimeout();
            this.mTextView.postDelayed(this.mShowFloatingToolbar, delay);
            this.invalidateActionModeAsync();
        }
    }

    private InputMethodManager getInputMethodManager() {
        return this.mTextView.getContext().getSystemService(InputMethodManager.class);
    }

    public void beginBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = true;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = ++ims.mBatchEditNesting) == 1) {
            ims.mCursorChanged = false;
            ims.mChangedDelta = 0;
            if (ims.mContentChanged) {
                ims.mChangedStart = 0;
                ims.mChangedEnd = this.mTextView.getText().length();
            } else {
                ims.mChangedStart = -1;
                ims.mChangedEnd = -1;
                ims.mContentChanged = false;
            }
            this.mUndoInputFilter.beginBatchEdit();
            this.mTextView.onBeginBatchEdit();
        }
    }

    public void endBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = false;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = --ims.mBatchEditNesting) == 0) {
            this.finishBatchEdit(ims);
        }
    }

    void ensureEndedBatchEdit() {
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ims.mBatchEditNesting != 0) {
            ims.mBatchEditNesting = 0;
            this.finishBatchEdit(ims);
        }
    }

    void finishBatchEdit(InputMethodState ims) {
        this.mTextView.onEndBatchEdit();
        this.mUndoInputFilter.endBatchEdit();
        if (ims.mContentChanged || ims.mSelectionModeChanged) {
            this.mTextView.updateAfterEdit();
            this.reportExtractedText();
        } else if (ims.mCursorChanged) {
            this.mTextView.invalidateCursor();
        }
        this.sendUpdateSelection();
        if (this.mTextActionMode != null) {
            CursorController cursorController;
            CursorController cursorController2 = cursorController = this.mTextView.hasSelection() ? this.getSelectionController() : this.getInsertionController();
            if (cursorController != null && !cursorController.isActive() && !cursorController.isCursorBeingModified()) {
                cursorController.show();
            }
        }
    }

    void scheduleRestartInputForSetText() {
        this.mHasPendingRestartInputForSetText = true;
    }

    void maybeFireScheduledRestartInputForSetText() {
        if (this.mHasPendingRestartInputForSetText) {
            InputMethodManager imm = this.getInputMethodManager();
            if (imm != null) {
                imm.restartInput(this.mTextView);
            }
            this.mHasPendingRestartInputForSetText = false;
        }
    }

    boolean extractText(ExtractedTextRequest request, ExtractedText outText) {
        return this.extractTextInternal(request, -1, -1, -1, outText);
    }

    private boolean extractTextInternal(ExtractedTextRequest request, int partialStartOffset, int partialEndOffset, int delta, ExtractedText outText) {
        if (request == null || outText == null) {
            return false;
        }
        CharSequence content2 = this.mTextView.getText();
        if (content2 == null) {
            return false;
        }
        if (partialStartOffset != -2) {
            int N = content2.length();
            if (partialStartOffset < 0) {
                outText.partialEndOffset = -1;
                outText.partialStartOffset = -1;
                partialStartOffset = 0;
                partialEndOffset = N;
            } else {
                partialEndOffset += delta;
                if (content2 instanceof Spanned) {
                    Spanned spanned = (Spanned)content2;
                    ParcelableSpan[] spans = spanned.getSpans(partialStartOffset, partialEndOffset, ParcelableSpan.class);
                    int i = spans.length;
                    while (i > 0) {
                        int j;
                        if ((j = spanned.getSpanStart(spans[--i])) < partialStartOffset) {
                            partialStartOffset = j;
                        }
                        if ((j = spanned.getSpanEnd(spans[i])) <= partialEndOffset) continue;
                        partialEndOffset = j;
                    }
                }
                outText.partialStartOffset = partialStartOffset;
                outText.partialEndOffset = partialEndOffset - delta;
                if (partialStartOffset > N) {
                    partialStartOffset = N;
                } else if (partialStartOffset < 0) {
                    partialStartOffset = 0;
                }
                if (partialEndOffset > N) {
                    partialEndOffset = N;
                } else if (partialEndOffset < 0) {
                    partialEndOffset = 0;
                }
            }
            outText.text = (request.flags & 1) != 0 ? content2.subSequence(partialStartOffset, partialEndOffset) : TextUtils.substring(content2, partialStartOffset, partialEndOffset);
        } else {
            outText.partialStartOffset = 0;
            outText.partialEndOffset = 0;
            outText.text = "";
        }
        outText.flags = 0;
        if (MetaKeyKeyListener.getMetaState(content2, 2048) != 0) {
            outText.flags |= 2;
        }
        if (this.mTextView.isSingleLine()) {
            outText.flags |= 1;
        }
        outText.startOffset = 0;
        outText.selectionStart = this.mTextView.getSelectionStart();
        outText.selectionEnd = this.mTextView.getSelectionEnd();
        outText.hint = this.mTextView.getHint();
        return true;
    }

    boolean reportExtractedText() {
        InputMethodState ims = this.mInputMethodState;
        if (ims == null) {
            return false;
        }
        boolean wasContentChanged = ims.mContentChanged;
        if (!wasContentChanged && !ims.mSelectionModeChanged) {
            return false;
        }
        ims.mContentChanged = false;
        ims.mSelectionModeChanged = false;
        ExtractedTextRequest req = ims.mExtractedTextRequest;
        if (req == null) {
            return false;
        }
        InputMethodManager imm = this.getInputMethodManager();
        if (imm == null) {
            return false;
        }
        if (ims.mChangedStart < 0 && !wasContentChanged) {
            ims.mChangedStart = -2;
        }
        if (this.extractTextInternal(req, ims.mChangedStart, ims.mChangedEnd, ims.mChangedDelta, ims.mExtractedText)) {
            imm.updateExtractedText(this.mTextView, req.token, ims.mExtractedText);
            ims.mChangedStart = -1;
            ims.mChangedEnd = -1;
            ims.mChangedDelta = 0;
            ims.mContentChanged = false;
            return true;
        }
        return false;
    }

    private void sendUpdateSelection() {
        InputMethodManager imm;
        if (null != this.mInputMethodState && this.mInputMethodState.mBatchEditNesting <= 0 && !this.mHasPendingRestartInputForSetText && null != (imm = this.getInputMethodManager())) {
            int selectionStart = this.mTextView.getSelectionStart();
            int selectionEnd = this.mTextView.getSelectionEnd();
            int candStart = -1;
            int candEnd = -1;
            if (this.mTextView.getText() instanceof Spannable) {
                Spannable sp = (Spannable)this.mTextView.getText();
                candStart = EditableInputConnection.getComposingSpanStart(sp);
                candEnd = EditableInputConnection.getComposingSpanEnd(sp);
            }
            imm.updateSelection(this.mTextView, selectionStart, selectionEnd, candStart, candEnd);
        }
    }

    void onDraw(Canvas canvas, Layout layout2, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        InputMethodManager imm;
        int selectionStart = this.mTextView.getSelectionStart();
        int selectionEnd = this.mTextView.getSelectionEnd();
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ims.mBatchEditNesting == 0 && (imm = this.getInputMethodManager()) != null && imm.isActive(this.mTextView) && (ims.mContentChanged || ims.mSelectionModeChanged)) {
            this.reportExtractedText();
        }
        if (this.mCorrectionHighlighter != null) {
            this.mCorrectionHighlighter.draw(canvas, cursorOffsetVertical);
        }
        if (highlight != null && selectionStart == selectionEnd && this.mDrawableForCursor != null) {
            this.drawCursor(canvas, cursorOffsetVertical);
            highlight = null;
        }
        if (this.mSelectionActionModeHelper != null) {
            this.mSelectionActionModeHelper.onDraw(canvas);
            if (this.mSelectionActionModeHelper.isDrawingHighlight()) {
                highlight = null;
            }
        }
        if (this.mTextView.canHaveDisplayList() && canvas.isHardwareAccelerated()) {
            this.drawHardwareAccelerated(canvas, layout2, highlight, highlightPaint, cursorOffsetVertical);
        } else {
            layout2.draw(canvas, highlight, highlightPaint, cursorOffsetVertical);
        }
    }

    private void drawHardwareAccelerated(Canvas canvas, Layout layout2, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        long lineRange = layout2.getLineRangeForDraw(canvas);
        int firstLine = TextUtils.unpackRangeStartFromLong(lineRange);
        int lastLine = TextUtils.unpackRangeEndFromLong(lineRange);
        if (lastLine < 0) {
            return;
        }
        layout2.drawBackground(canvas, highlight, highlightPaint, cursorOffsetVertical, firstLine, lastLine);
        if (layout2 instanceof DynamicLayout) {
            int i;
            int startBlock;
            if (this.mTextRenderNodes == null) {
                this.mTextRenderNodes = ArrayUtils.emptyArray(TextRenderNode.class);
            }
            DynamicLayout dynamicLayout = (DynamicLayout)layout2;
            int[] blockEndLines = dynamicLayout.getBlockEndLines();
            int[] blockIndices = dynamicLayout.getBlockIndices();
            int numberOfBlocks = dynamicLayout.getNumberOfBlocks();
            int indexFirstChangedBlock = dynamicLayout.getIndexFirstChangedBlock();
            ArraySet<Integer> blockSet = dynamicLayout.getBlocksAlwaysNeedToBeRedrawn();
            if (blockSet != null) {
                for (int i2 = 0; i2 < blockSet.size(); ++i2) {
                    int blockIndex = dynamicLayout.getBlockIndex(blockSet.valueAt(i2));
                    if (blockIndex == -1 || this.mTextRenderNodes[blockIndex] == null) continue;
                    this.mTextRenderNodes[blockIndex].needsToBeShifted = true;
                }
            }
            if ((startBlock = Arrays.binarySearch(blockEndLines, 0, numberOfBlocks, firstLine)) < 0) {
                startBlock = -(startBlock + 1);
            }
            startBlock = Math.min(indexFirstChangedBlock, startBlock);
            int startIndexToFindAvailableRenderNode = 0;
            int lastIndex = numberOfBlocks;
            for (i = startBlock; i < numberOfBlocks; ++i) {
                int blockIndex = blockIndices[i];
                if (i >= indexFirstChangedBlock && blockIndex != -1 && this.mTextRenderNodes[blockIndex] != null) {
                    this.mTextRenderNodes[blockIndex].needsToBeShifted = true;
                }
                if (blockEndLines[i] < firstLine) continue;
                startIndexToFindAvailableRenderNode = this.drawHardwareAcceleratedInner(canvas, layout2, highlight, highlightPaint, cursorOffsetVertical, blockEndLines, blockIndices, i, numberOfBlocks, startIndexToFindAvailableRenderNode);
                if (blockEndLines[i] < lastLine) continue;
                lastIndex = Math.max(indexFirstChangedBlock, i + 1);
                break;
            }
            if (blockSet != null) {
                for (i = 0; i < blockSet.size(); ++i) {
                    int block = blockSet.valueAt(i);
                    int blockIndex = dynamicLayout.getBlockIndex(block);
                    if (blockIndex != -1 && this.mTextRenderNodes[blockIndex] != null && !this.mTextRenderNodes[blockIndex].needsToBeShifted) continue;
                    startIndexToFindAvailableRenderNode = this.drawHardwareAcceleratedInner(canvas, layout2, highlight, highlightPaint, cursorOffsetVertical, blockEndLines, blockIndices, block, numberOfBlocks, startIndexToFindAvailableRenderNode);
                }
            }
            dynamicLayout.setIndexFirstChangedBlock(lastIndex);
        } else {
            layout2.drawText(canvas, firstLine, lastLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int drawHardwareAcceleratedInner(Canvas canvas, Layout layout2, Path highlight, Paint highlightPaint, int cursorOffsetVertical, int[] blockEndLines, int[] blockIndices, int blockInfoIndex, int numberOfBlocks, int startIndexToFindAvailableRenderNode) {
        boolean blockIsInvalid;
        int blockEndLine = blockEndLines[blockInfoIndex];
        int blockIndex = blockIndices[blockInfoIndex];
        boolean bl = blockIsInvalid = blockIndex == -1;
        if (blockIsInvalid) {
            blockIndices[blockInfoIndex] = blockIndex = this.getAvailableDisplayListIndex(blockIndices, numberOfBlocks, startIndexToFindAvailableRenderNode);
            if (this.mTextRenderNodes[blockIndex] != null) {
                this.mTextRenderNodes[blockIndex].isDirty = true;
            }
            startIndexToFindAvailableRenderNode = blockIndex + 1;
        }
        if (this.mTextRenderNodes[blockIndex] == null) {
            this.mTextRenderNodes[blockIndex] = new TextRenderNode("Text " + blockIndex);
        }
        boolean blockDisplayListIsInvalid = this.mTextRenderNodes[blockIndex].needsRecord();
        RenderNode blockDisplayList = this.mTextRenderNodes[blockIndex].renderNode;
        if (this.mTextRenderNodes[blockIndex].needsToBeShifted || blockDisplayListIsInvalid) {
            int blockBeginLine = blockInfoIndex == 0 ? 0 : blockEndLines[blockInfoIndex - 1] + 1;
            int top = layout2.getLineTop(blockBeginLine);
            int bottom2 = layout2.getLineBottom(blockEndLine);
            int left = 0;
            int right2 = this.mTextView.getWidth();
            if (this.mTextView.getHorizontallyScrolling()) {
                float min = Float.MAX_VALUE;
                float max = Float.MIN_VALUE;
                for (int line = blockBeginLine; line <= blockEndLine; ++line) {
                    min = Math.min(min, layout2.getLineLeft(line));
                    max = Math.max(max, layout2.getLineRight(line));
                }
                left = (int)min;
                right2 = (int)(max + 0.5f);
            }
            if (blockDisplayListIsInvalid) {
                RecordingCanvas recordingCanvas = blockDisplayList.beginRecording(right2 - left, bottom2 - top);
                try {
                    recordingCanvas.translate(-left, -top);
                    layout2.drawText(recordingCanvas, blockBeginLine, blockEndLine);
                    this.mTextRenderNodes[blockIndex].isDirty = false;
                }
                finally {
                    blockDisplayList.endRecording();
                    blockDisplayList.setClipToBounds(false);
                }
            }
            blockDisplayList.setLeftTopRightBottom(left, top, right2, bottom2);
            this.mTextRenderNodes[blockIndex].needsToBeShifted = false;
        }
        ((RecordingCanvas)canvas).drawRenderNode(blockDisplayList);
        return startIndexToFindAvailableRenderNode;
    }

    private int getAvailableDisplayListIndex(int[] blockIndices, int numberOfBlocks, int searchStartIndex) {
        int length = this.mTextRenderNodes.length;
        for (int i = searchStartIndex; i < length; ++i) {
            boolean blockIndexFound = false;
            for (int j = 0; j < numberOfBlocks; ++j) {
                if (blockIndices[j] != i) continue;
                blockIndexFound = true;
                break;
            }
            if (blockIndexFound) continue;
            return i;
        }
        this.mTextRenderNodes = GrowingArrayUtils.append(this.mTextRenderNodes, length, null);
        return length;
    }

    private void drawCursor(Canvas canvas, int cursorOffsetVertical) {
        boolean translate;
        boolean bl = translate = cursorOffsetVertical != 0;
        if (translate) {
            canvas.translate(0.0f, cursorOffsetVertical);
        }
        if (this.mDrawableForCursor != null) {
            this.mDrawableForCursor.draw(canvas);
        }
        if (translate) {
            canvas.translate(0.0f, -cursorOffsetVertical);
        }
    }

    void invalidateHandlesAndActionMode() {
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.invalidateHandles();
        }
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.invalidateHandle();
        }
        if (this.mTextActionMode != null) {
            this.invalidateActionMode();
        }
    }

    void invalidateTextDisplayList(Layout layout2, int start, int end) {
        if (this.mTextRenderNodes != null && layout2 instanceof DynamicLayout) {
            int i;
            int firstLine = layout2.getLineForOffset(start);
            int lastLine = layout2.getLineForOffset(end);
            DynamicLayout dynamicLayout = (DynamicLayout)layout2;
            int[] blockEndLines = dynamicLayout.getBlockEndLines();
            int[] blockIndices = dynamicLayout.getBlockIndices();
            int numberOfBlocks = dynamicLayout.getNumberOfBlocks();
            for (i = 0; i < numberOfBlocks && blockEndLines[i] < firstLine; ++i) {
            }
            while (i < numberOfBlocks) {
                int blockIndex = blockIndices[i];
                if (blockIndex != -1) {
                    this.mTextRenderNodes[blockIndex].isDirty = true;
                }
                if (blockEndLines[i] >= lastLine) break;
                ++i;
            }
        }
    }

    @UnsupportedAppUsage
    void invalidateTextDisplayList() {
        if (this.mTextRenderNodes != null) {
            for (int i = 0; i < this.mTextRenderNodes.length; ++i) {
                if (this.mTextRenderNodes[i] == null) continue;
                this.mTextRenderNodes[i].isDirty = true;
            }
        }
    }

    void updateCursorPosition() {
        this.loadCursorDrawable();
        if (this.mDrawableForCursor == null) {
            return;
        }
        Layout layout2 = this.mTextView.getLayout();
        int offset2 = this.mTextView.getSelectionStart();
        int line = layout2.getLineForOffset(offset2);
        int top = layout2.getLineTop(line);
        int bottom2 = layout2.getLineBottomWithoutSpacing(line);
        boolean clamped = layout2.shouldClampCursor(line);
        this.updateCursorPosition(top, bottom2, layout2.getPrimaryHorizontal(offset2, clamped));
    }

    void refreshTextActionMode() {
        if (this.extractedTextModeWillBeStarted()) {
            this.mRestartActionModeOnNextRefresh = false;
            return;
        }
        boolean hasSelection = this.mTextView.hasSelection();
        SelectionModifierCursorController selectionController = this.getSelectionController();
        InsertionPointCursorController insertionController = this.getInsertionController();
        if (selectionController != null && selectionController.isCursorBeingModified() || insertionController != null && insertionController.isCursorBeingModified()) {
            this.mRestartActionModeOnNextRefresh = false;
            return;
        }
        if (hasSelection) {
            this.hideInsertionPointCursorController();
            if (this.mTextActionMode == null) {
                if (this.mRestartActionModeOnNextRefresh) {
                    this.startSelectionActionModeAsync(false);
                }
            } else if (selectionController == null || !selectionController.isActive()) {
                this.stopTextActionModeWithPreservingSelection();
                this.startSelectionActionModeAsync(false);
            } else {
                this.mTextActionMode.invalidateContentRect();
            }
        } else if (insertionController == null || !insertionController.isActive()) {
            this.stopTextActionMode();
        } else if (this.mTextActionMode != null) {
            this.mTextActionMode.invalidateContentRect();
        }
        this.mRestartActionModeOnNextRefresh = false;
    }

    void startInsertionActionMode() {
        if (this.mInsertionActionModeRunnable != null) {
            this.mTextView.removeCallbacks(this.mInsertionActionModeRunnable);
        }
        if (this.extractedTextModeWillBeStarted()) {
            return;
        }
        this.stopTextActionMode();
        TextActionModeCallback actionModeCallback = new TextActionModeCallback(1);
        this.mTextActionMode = this.mTextView.startActionMode(actionModeCallback, 1);
        if (this.mTextActionMode != null && this.getInsertionController() != null) {
            this.getInsertionController().show();
        }
    }

    TextView getTextView() {
        return this.mTextView;
    }

    ActionMode getTextActionMode() {
        return this.mTextActionMode;
    }

    void setRestartActionModeOnNextRefresh(boolean value2) {
        this.mRestartActionModeOnNextRefresh = value2;
    }

    void startSelectionActionModeAsync(boolean adjustSelection) {
        this.getSelectionActionModeHelper().startSelectionActionModeAsync(adjustSelection);
    }

    void startLinkActionModeAsync(int start, int end) {
        if (!(this.mTextView.getText() instanceof Spannable)) {
            return;
        }
        this.stopTextActionMode();
        this.mRequestingLinkActionMode = true;
        this.getSelectionActionModeHelper().startLinkActionModeAsync(start, end);
    }

    void invalidateActionModeAsync() {
        this.getSelectionActionModeHelper().invalidateActionModeAsync();
    }

    private void invalidateActionMode() {
        if (this.mTextActionMode != null) {
            this.mTextActionMode.invalidate();
        }
    }

    private SelectionActionModeHelper getSelectionActionModeHelper() {
        if (this.mSelectionActionModeHelper == null) {
            this.mSelectionActionModeHelper = new SelectionActionModeHelper(this);
        }
        return this.mSelectionActionModeHelper;
    }

    private boolean selectCurrentWordAndStartDrag() {
        if (this.mInsertionActionModeRunnable != null) {
            this.mTextView.removeCallbacks(this.mInsertionActionModeRunnable);
        }
        if (this.extractedTextModeWillBeStarted()) {
            return false;
        }
        if (!this.checkField()) {
            return false;
        }
        if (!this.mTextView.hasSelection() && !this.selectCurrentWord()) {
            return false;
        }
        this.stopTextActionModeWithPreservingSelection();
        this.getSelectionController().enterDrag(2);
        return true;
    }

    boolean checkField() {
        if (!this.mTextView.canSelectText() || !this.mTextView.requestFocus()) {
            Log.w("TextView", "TextView does not support text selection. Selection cancelled.");
            return false;
        }
        return true;
    }

    boolean startActionModeInternal(@TextActionMode int actionMode) {
        InputMethodManager imm;
        boolean selectionStarted;
        boolean selectableText;
        if (this.extractedTextModeWillBeStarted()) {
            return false;
        }
        if (this.mTextActionMode != null) {
            this.invalidateActionMode();
            return false;
        }
        if (!(actionMode == 2 || this.checkField() && this.mTextView.hasSelection())) {
            return false;
        }
        TextActionModeCallback actionModeCallback = new TextActionModeCallback(actionMode);
        this.mTextActionMode = this.mTextView.startActionMode(actionModeCallback, 1);
        boolean bl = selectableText = this.mTextView.isTextEditable() || this.mTextView.isTextSelectable();
        if (actionMode == 2 && !selectableText && this.mTextActionMode instanceof FloatingActionMode) {
            ((FloatingActionMode)this.mTextActionMode).setOutsideTouchable(true, () -> this.stopTextActionMode());
        }
        boolean bl2 = selectionStarted = this.mTextActionMode != null;
        if (selectionStarted && this.mTextView.isTextEditable() && !this.mTextView.isTextSelectable() && this.mShowSoftInputOnFocus && (imm = this.getInputMethodManager()) != null) {
            imm.showSoftInput(this.mTextView, 0, null);
        }
        return selectionStarted;
    }

    private boolean extractedTextModeWillBeStarted() {
        if (!this.mTextView.isInExtractedMode()) {
            InputMethodManager imm = this.getInputMethodManager();
            return imm != null && imm.isFullscreenMode();
        }
        return false;
    }

    private boolean shouldOfferToShowSuggestions() {
        int selectionEnd;
        CharSequence text = this.mTextView.getText();
        if (!(text instanceof Spannable)) {
            return false;
        }
        Spannable spannable = (Spannable)text;
        int selectionStart = this.mTextView.getSelectionStart();
        SuggestionSpan[] suggestionSpans = spannable.getSpans(selectionStart, selectionEnd = this.mTextView.getSelectionEnd(), SuggestionSpan.class);
        if (suggestionSpans.length == 0) {
            return false;
        }
        if (selectionStart == selectionEnd) {
            for (int i = 0; i < suggestionSpans.length; ++i) {
                if (suggestionSpans[i].getSuggestions().length <= 0) continue;
                return true;
            }
            return false;
        }
        int minSpanStart = this.mTextView.getText().length();
        int maxSpanEnd = 0;
        int unionOfSpansCoveringSelectionStartStart = this.mTextView.getText().length();
        int unionOfSpansCoveringSelectionStartEnd = 0;
        boolean hasValidSuggestions = false;
        for (int i = 0; i < suggestionSpans.length; ++i) {
            int spanStart = spannable.getSpanStart(suggestionSpans[i]);
            int spanEnd = spannable.getSpanEnd(suggestionSpans[i]);
            minSpanStart = Math.min(minSpanStart, spanStart);
            maxSpanEnd = Math.max(maxSpanEnd, spanEnd);
            if (selectionStart < spanStart || selectionStart > spanEnd) continue;
            hasValidSuggestions = hasValidSuggestions || suggestionSpans[i].getSuggestions().length > 0;
            unionOfSpansCoveringSelectionStartStart = Math.min(unionOfSpansCoveringSelectionStartStart, spanStart);
            unionOfSpansCoveringSelectionStartEnd = Math.max(unionOfSpansCoveringSelectionStartEnd, spanEnd);
        }
        if (!hasValidSuggestions) {
            return false;
        }
        if (unionOfSpansCoveringSelectionStartStart >= unionOfSpansCoveringSelectionStartEnd) {
            return false;
        }
        return minSpanStart >= unionOfSpansCoveringSelectionStartStart && maxSpanEnd <= unionOfSpansCoveringSelectionStartEnd;
    }

    private boolean isCursorInsideEasyCorrectionSpan() {
        Spannable spannable = (Spannable)this.mTextView.getText();
        SuggestionSpan[] suggestionSpans = spannable.getSpans(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), SuggestionSpan.class);
        for (int i = 0; i < suggestionSpans.length; ++i) {
            if ((suggestionSpans[i].getFlags() & 1) == 0) continue;
            return true;
        }
        return false;
    }

    void onTouchUpEvent(MotionEvent event) {
        if (this.getSelectionActionModeHelper().resetSelection(this.getTextView().getOffsetForPosition(event.getX(), event.getY()))) {
            return;
        }
        boolean selectAllGotFocus = this.mSelectAllOnFocus && this.mTextView.didTouchFocusSelect();
        this.hideCursorAndSpanControllers();
        this.stopTextActionMode();
        CharSequence text = this.mTextView.getText();
        if (!selectAllGotFocus && text.length() > 0) {
            boolean shouldInsertCursor;
            int offset2 = this.mTextView.getOffsetForPosition(event.getX(), event.getY());
            boolean bl = shouldInsertCursor = !this.mRequestingLinkActionMode;
            if (shouldInsertCursor) {
                Selection.setSelection((Spannable)text, offset2);
                if (this.mSpellChecker != null) {
                    this.mSpellChecker.onSelectionChanged();
                }
            }
            if (!this.extractedTextModeWillBeStarted()) {
                if (this.isCursorInsideEasyCorrectionSpan()) {
                    if (this.mInsertionActionModeRunnable != null) {
                        this.mTextView.removeCallbacks(this.mInsertionActionModeRunnable);
                    }
                    this.mShowSuggestionRunnable = this::replace;
                    this.mTextView.postDelayed(this.mShowSuggestionRunnable, ViewConfiguration.getDoubleTapTimeout());
                } else if (this.hasInsertionController()) {
                    if (shouldInsertCursor) {
                        this.getInsertionController().show();
                    } else {
                        this.getInsertionController().hide();
                    }
                }
            }
        }
    }

    void onTextOperationUserChanged() {
        if (this.mSpellChecker != null) {
            this.mSpellChecker.resetSession();
        }
    }

    protected void stopTextActionMode() {
        if (this.mTextActionMode != null) {
            this.mTextActionMode.finish();
        }
    }

    private void stopTextActionModeWithPreservingSelection() {
        if (this.mTextActionMode != null) {
            this.mRestartActionModeOnNextRefresh = true;
        }
        this.mPreserveSelection = true;
        this.stopTextActionMode();
        this.mPreserveSelection = false;
    }

    boolean hasInsertionController() {
        return this.mInsertionControllerEnabled;
    }

    boolean hasSelectionController() {
        return this.mSelectionControllerEnabled;
    }

    @VisibleForTesting
    public InsertionPointCursorController getInsertionController() {
        if (!this.mInsertionControllerEnabled) {
            return null;
        }
        if (this.mInsertionPointCursorController == null) {
            this.mInsertionPointCursorController = new InsertionPointCursorController();
            ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
            observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        return this.mInsertionPointCursorController;
    }

    @VisibleForTesting
    public SelectionModifierCursorController getSelectionController() {
        if (!this.mSelectionControllerEnabled) {
            return null;
        }
        if (this.mSelectionModifierCursorController == null) {
            this.mSelectionModifierCursorController = new SelectionModifierCursorController();
            ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
            observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        return this.mSelectionModifierCursorController;
    }

    @VisibleForTesting
    public Drawable getCursorDrawable() {
        return this.mDrawableForCursor;
    }

    private void updateCursorPosition(int top, int bottom2, float horizontal) {
        this.loadCursorDrawable();
        int left = this.clampHorizontalPosition(this.mDrawableForCursor, horizontal);
        int width = this.mDrawableForCursor.getIntrinsicWidth();
        this.mDrawableForCursor.setBounds(left, top - this.mTempRect.top, left + width, bottom2 + this.mTempRect.bottom);
    }

    private int clampHorizontalPosition(Drawable drawable2, float horizontal) {
        horizontal = Math.max(0.5f, horizontal - 0.5f);
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        int drawableWidth = 0;
        if (drawable2 != null) {
            drawable2.getPadding(this.mTempRect);
            drawableWidth = drawable2.getIntrinsicWidth();
        } else {
            this.mTempRect.setEmpty();
        }
        int scrollX = this.mTextView.getScrollX();
        float horizontalDiff = horizontal - (float)scrollX;
        int viewClippedWidth = this.mTextView.getWidth() - this.mTextView.getCompoundPaddingLeft() - this.mTextView.getCompoundPaddingRight();
        int left = horizontalDiff >= (float)viewClippedWidth - 1.0f ? viewClippedWidth + scrollX - (drawableWidth - this.mTempRect.right) : (Math.abs(horizontalDiff) <= 1.0f || TextUtils.isEmpty(this.mTextView.getText()) && (float)(0x100000 - scrollX) <= (float)viewClippedWidth + 1.0f && horizontal <= 1.0f ? scrollX - this.mTempRect.left : (int)horizontal - this.mTempRect.left);
        return left;
    }

    public void onCommitCorrection(CorrectionInfo info) {
        if (this.mCorrectionHighlighter == null) {
            this.mCorrectionHighlighter = new CorrectionHighlighter();
        } else {
            this.mCorrectionHighlighter.invalidate(false);
        }
        this.mCorrectionHighlighter.highlight(info);
        this.mUndoInputFilter.freezeLastEdit();
    }

    void onScrollChanged() {
        if (this.mPositionListener != null) {
            this.mPositionListener.onScrollChanged();
        }
        if (this.mTextActionMode != null) {
            this.mTextActionMode.invalidateContentRect();
        }
    }

    private boolean shouldBlink() {
        if (!this.isCursorVisible() || !this.mTextView.isFocused()) {
            return false;
        }
        int start = this.mTextView.getSelectionStart();
        if (start < 0) {
            return false;
        }
        int end = this.mTextView.getSelectionEnd();
        if (end < 0) {
            return false;
        }
        return start == end;
    }

    void makeBlink() {
        if (this.shouldBlink()) {
            this.mShowCursor = SystemClock.uptimeMillis();
            if (this.mBlink == null) {
                this.mBlink = new Blink();
            }
            this.mTextView.removeCallbacks(this.mBlink);
            this.mTextView.postDelayed(this.mBlink, 500L);
        } else if (this.mBlink != null) {
            this.mTextView.removeCallbacks(this.mBlink);
        }
    }

    private View.DragShadowBuilder getTextThumbnailBuilder(int start, int end) {
        TextView shadowView = (TextView)View.inflate(this.mTextView.getContext(), 17367332, null);
        if (shadowView == null) {
            throw new IllegalArgumentException("Unable to inflate text drag thumbnail");
        }
        if (end - start > 20) {
            long range = this.getCharClusterRange(start + 20);
            end = TextUtils.unpackRangeEndFromLong(range);
        }
        CharSequence text = this.mTextView.getTransformedText(start, end);
        shadowView.setText(text);
        shadowView.setTextColor(this.mTextView.getTextColors());
        shadowView.setTextAppearance(16);
        shadowView.setGravity(17);
        shadowView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        int size = View.MeasureSpec.makeMeasureSpec(0, 0);
        shadowView.measure(size, size);
        shadowView.layout(0, 0, shadowView.getMeasuredWidth(), shadowView.getMeasuredHeight());
        shadowView.invalidate();
        return new View.DragShadowBuilder(shadowView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDrop(DragEvent event) {
        boolean dragDropIntoItself;
        int offset2 = this.mTextView.getOffsetForPosition(event.getX(), event.getY());
        Object localState = event.getLocalState();
        DragLocalState dragLocalState = null;
        if (localState instanceof DragLocalState) {
            dragLocalState = (DragLocalState)localState;
        }
        boolean bl = dragDropIntoItself = dragLocalState != null && dragLocalState.sourceTextView == this.mTextView;
        if (dragDropIntoItself && offset2 >= dragLocalState.start && offset2 < dragLocalState.end) {
            return;
        }
        DragAndDropPermissions permissions = DragAndDropPermissions.obtain(event);
        if (permissions != null) {
            permissions.takeTransient();
        }
        this.mTextView.beginBatchEdit();
        this.mUndoInputFilter.freezeLastEdit();
        try {
            int originalLength = this.mTextView.getText().length();
            Selection.setSelection((Spannable)this.mTextView.getText(), offset2);
            ClipData clip = event.getClipData();
            ContentInfo payload = new ContentInfo.Builder(clip, 3).setDragAndDropPermissions(permissions).build();
            this.mTextView.performReceiveContent(payload);
            if (dragDropIntoItself) {
                this.deleteSourceAfterLocalDrop(dragLocalState, offset2, originalLength);
            }
        }
        finally {
            this.mTextView.endBatchEdit();
            this.mUndoInputFilter.freezeLastEdit();
        }
    }

    private void deleteSourceAfterLocalDrop(DragLocalState dragLocalState, int dropOffset, int lengthBeforeDrop) {
        CharSequence t;
        int dragSourceStart = dragLocalState.start;
        int dragSourceEnd = dragLocalState.end;
        if (dropOffset <= dragSourceStart) {
            int shift = this.mTextView.getText().length() - lengthBeforeDrop;
            dragSourceStart += shift;
            dragSourceEnd += shift;
        }
        this.mTextView.deleteText_internal(dragSourceStart, dragSourceEnd);
        int prevCharIdx = Math.max(0, dragSourceStart - 1);
        int nextCharIdx = Math.min(this.mTextView.getText().length(), dragSourceStart + 1);
        if (nextCharIdx > prevCharIdx + 1 && Character.isSpaceChar((t = this.mTextView.getTransformedText(prevCharIdx, nextCharIdx)).charAt(0)) && Character.isSpaceChar(t.charAt(1))) {
            this.mTextView.deleteText_internal(prevCharIdx, prevCharIdx + 1);
        }
    }

    public void addSpanWatchers(Spannable text) {
        int textLength = text.length();
        if (this.mKeyListener != null) {
            text.setSpan(this.mKeyListener, 0, textLength, 18);
        }
        if (this.mSpanController == null) {
            this.mSpanController = new SpanController();
        }
        text.setSpan(this.mSpanController, 0, textLength, 18);
    }

    void setContextMenuAnchor(float x, float y) {
        this.mContextMenuAnchorX = x;
        this.mContextMenuAnchorY = y;
    }

    void onCreateContextMenu(ContextMenu menu2) {
        if (this.mIsBeingLongClicked || Float.isNaN(this.mContextMenuAnchorX) || Float.isNaN(this.mContextMenuAnchorY)) {
            return;
        }
        int offset2 = this.mTextView.getOffsetForPosition(this.mContextMenuAnchorX, this.mContextMenuAnchorY);
        if (offset2 == -1) {
            return;
        }
        this.stopTextActionModeWithPreservingSelection();
        if (this.mTextView.canSelectText()) {
            boolean isOnSelection;
            boolean bl = isOnSelection = this.mTextView.hasSelection() && offset2 >= this.mTextView.getSelectionStart() && offset2 <= this.mTextView.getSelectionEnd();
            if (!isOnSelection) {
                Selection.setSelection((Spannable)this.mTextView.getText(), offset2);
                this.stopTextActionMode();
            }
        }
        if (this.shouldOfferToShowSuggestions()) {
            SuggestionInfo[] suggestionInfoArray = new SuggestionInfo[5];
            for (int i = 0; i < suggestionInfoArray.length; ++i) {
                suggestionInfoArray[i] = new SuggestionInfo();
            }
            SubMenu subMenu = menu2.addSubMenu(0, 0, 9, 17041268);
            int numItems = this.mSuggestionHelper.getSuggestionInfo(suggestionInfoArray, null);
            for (int i = 0; i < numItems; ++i) {
                final SuggestionInfo info = suggestionInfoArray[i];
                subMenu.add(0, 0, i, info.mText).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                    @Override
                    public boolean onMenuItemClick(MenuItem item) {
                        Editor.this.replaceWithSuggestion(info);
                        return true;
                    }
                });
            }
        }
        menu2.add(0, 16908338, 2, 17041534).setAlphabeticShortcut('z').setOnMenuItemClickListener(this.mOnContextMenuItemClickListener).setEnabled(this.mTextView.canUndo());
        menu2.add(0, 16908339, 3, 17041249).setOnMenuItemClickListener(this.mOnContextMenuItemClickListener).setEnabled(this.mTextView.canRedo());
        menu2.add(0, 0x1020020, 4, 17039363).setAlphabeticShortcut('x').setOnMenuItemClickListener(this.mOnContextMenuItemClickListener).setEnabled(this.mTextView.canCut());
        menu2.add(0, 0x1020021, 5, 0x1040001).setAlphabeticShortcut('c').setOnMenuItemClickListener(this.mOnContextMenuItemClickListener).setEnabled(this.mTextView.canCopy());
        menu2.add(0, 0x1020022, 6, 17039371).setAlphabeticShortcut('v').setEnabled(this.mTextView.canPaste()).setOnMenuItemClickListener(this.mOnContextMenuItemClickListener);
        menu2.add(0, 16908337, 11, 17039385).setEnabled(this.mTextView.canPasteAsPlainText()).setOnMenuItemClickListener(this.mOnContextMenuItemClickListener);
        menu2.add(0, 16908341, 7, 17041385).setEnabled(this.mTextView.canShare()).setOnMenuItemClickListener(this.mOnContextMenuItemClickListener);
        menu2.add(0, 16908319, 8, 17039373).setAlphabeticShortcut('a').setEnabled(this.mTextView.canSelectAllText()).setOnMenuItemClickListener(this.mOnContextMenuItemClickListener);
        menu2.add(0, 16908355, 10, 17039386).setEnabled(this.mTextView.canRequestAutofill()).setOnMenuItemClickListener(this.mOnContextMenuItemClickListener);
        this.mPreserveSelection = true;
    }

    private SuggestionSpan findEquivalentSuggestionSpan(SuggestionSpanInfo suggestionSpanInfo) {
        SuggestionSpan[] suggestionSpans;
        Editable editable = (Editable)this.mTextView.getText();
        if (editable.getSpanStart(suggestionSpanInfo.mSuggestionSpan) >= 0) {
            return suggestionSpanInfo.mSuggestionSpan;
        }
        for (SuggestionSpan suggestionSpan : suggestionSpans = editable.getSpans(suggestionSpanInfo.mSpanStart, suggestionSpanInfo.mSpanEnd, SuggestionSpan.class)) {
            int end;
            int start = editable.getSpanStart(suggestionSpan);
            if (start != suggestionSpanInfo.mSpanStart || (end = editable.getSpanEnd(suggestionSpan)) != suggestionSpanInfo.mSpanEnd || !suggestionSpan.equals(suggestionSpanInfo.mSuggestionSpan)) continue;
            return suggestionSpan;
        }
        return null;
    }

    private void replaceWithSuggestion(SuggestionInfo suggestionInfo) {
        SuggestionSpan targetSuggestionSpan = this.findEquivalentSuggestionSpan(suggestionInfo.mSuggestionSpanInfo);
        if (targetSuggestionSpan == null) {
            return;
        }
        Editable editable = (Editable)this.mTextView.getText();
        int spanStart = editable.getSpanStart(targetSuggestionSpan);
        int spanEnd = editable.getSpanEnd(targetSuggestionSpan);
        if (spanStart < 0 || spanEnd <= spanStart) {
            return;
        }
        String originalText = TextUtils.substring(editable, spanStart, spanEnd);
        SuggestionSpan[] suggestionSpans = editable.getSpans(spanStart, spanEnd, SuggestionSpan.class);
        int length = suggestionSpans.length;
        int[] suggestionSpansStarts = new int[length];
        int[] suggestionSpansEnds = new int[length];
        int[] suggestionSpansFlags = new int[length];
        for (int i = 0; i < length; ++i) {
            SuggestionSpan suggestionSpan = suggestionSpans[i];
            suggestionSpansStarts[i] = editable.getSpanStart(suggestionSpan);
            suggestionSpansEnds[i] = editable.getSpanEnd(suggestionSpan);
            suggestionSpansFlags[i] = editable.getSpanFlags(suggestionSpan);
            int suggestionSpanFlags = suggestionSpan.getFlags();
            if ((suggestionSpanFlags & 0xA) == 0) continue;
            suggestionSpanFlags &= 0xFFFFFFFD;
            suggestionSpanFlags &= 0xFFFFFFF7;
            suggestionSpan.setFlags(suggestionSpanFlags &= 0xFFFFFFFE);
        }
        int suggestionStart = suggestionInfo.mSuggestionStart;
        int suggestionEnd = suggestionInfo.mSuggestionEnd;
        String suggestion = suggestionInfo.mText.subSequence(suggestionStart, suggestionEnd).toString();
        this.mTextView.replaceText_internal(spanStart, spanEnd, suggestion);
        String[] suggestions = targetSuggestionSpan.getSuggestions();
        suggestions[suggestionInfo.mSuggestionIndex] = originalText;
        int lengthDelta = suggestion.length() - (spanEnd - spanStart);
        for (int i = 0; i < length; ++i) {
            if (suggestionSpansStarts[i] > spanStart || suggestionSpansEnds[i] < spanEnd) continue;
            this.mTextView.setSpan_internal(suggestionSpans[i], suggestionSpansStarts[i], suggestionSpansEnds[i] + lengthDelta, suggestionSpansFlags[i]);
        }
        int newCursorPosition = spanEnd + lengthDelta;
        this.mTextView.setCursorPosition_internal(newCursorPosition, newCursorPosition);
    }

    @VisibleForTesting
    public void setLineChangeSlopMinMaxForTesting(int min, int max) {
        this.mLineChangeSlopMin = min;
        this.mLineChangeSlopMax = max;
    }

    @VisibleForTesting
    public int getCurrentLineAdjustedForSlop(Layout layout2, int prevLine, float y) {
        int trueLine = this.mTextView.getLineAtCoordinate(y);
        if (layout2 == null || prevLine > layout2.getLineCount() || layout2.getLineCount() <= 0 || prevLine < 0) {
            return trueLine;
        }
        if (Math.abs(trueLine - prevLine) >= 2) {
            return trueLine;
        }
        int lineHeight = this.mTextView.getLineHeight();
        int slop = (int)(this.mLineSlopRatio * (float)lineHeight);
        slop = Math.max(this.mLineChangeSlopMin, Math.min(this.mLineChangeSlopMax, lineHeight + slop)) - lineHeight;
        slop = Math.max(0, slop);
        float verticalOffset = this.mTextView.viewportToContentVerticalOffset();
        if (trueLine > prevLine && y >= (float)(layout2.getLineBottom(prevLine) + slop) + verticalOffset) {
            return trueLine;
        }
        if (trueLine < prevLine && y <= (float)(layout2.getLineTop(prevLine) - slop) + verticalOffset) {
            return trueLine;
        }
        return prevLine;
    }

    void loadCursorDrawable() {
        if (this.mDrawableForCursor == null) {
            this.mDrawableForCursor = this.mTextView.getTextCursorDrawable();
        }
    }

    void loadHandleDrawables(boolean overwrite) {
        if (this.mSelectHandleCenter == null || overwrite) {
            this.mSelectHandleCenter = this.mTextView.getTextSelectHandle();
            if (this.hasInsertionController()) {
                this.getInsertionController().reloadHandleDrawable();
            }
        }
        if (this.mSelectHandleLeft == null || this.mSelectHandleRight == null || overwrite) {
            this.mSelectHandleLeft = this.mTextView.getTextSelectHandleLeft();
            this.mSelectHandleRight = this.mTextView.getTextSelectHandleRight();
            if (this.hasSelectionController()) {
                this.getSelectionController().reloadHandleDrawables();
            }
        }
    }

    private static boolean isValidRange(CharSequence text, int start, int end) {
        return 0 <= start && start <= end && end <= text.length();
    }

    static void logCursor(String location, String msgFormat, Object ... msgArgs) {
        if (msgFormat == null) {
            Log.d("Editor", location);
        } else {
            Log.d("Editor", location + ": " + String.format(msgFormat, msgArgs));
        }
    }

    static /* synthetic */ void access$6600(Editor x0) {
        x0.toggleInsertionActionMode();
    }

    static class ProcessTextIntentActionsHandler {
        private final Editor mEditor;
        private final TextView mTextView;
        private final Context mContext;
        private final PackageManager mPackageManager;
        private final String mPackageName;
        private final SparseArray<Intent> mAccessibilityIntents = new SparseArray();
        private final SparseArray<AccessibilityNodeInfo.AccessibilityAction> mAccessibilityActions = new SparseArray();
        private final List<ResolveInfo> mSupportedActivities = new ArrayList<ResolveInfo>();

        private ProcessTextIntentActionsHandler(Editor editor2) {
            this.mEditor = Objects.requireNonNull(editor2);
            this.mTextView = Objects.requireNonNull(this.mEditor.mTextView);
            this.mContext = Objects.requireNonNull(this.mTextView.getContext());
            this.mPackageManager = Objects.requireNonNull(this.mContext.getPackageManager());
            this.mPackageName = Objects.requireNonNull(this.mContext.getPackageName());
        }

        public void onInitializeMenu(Menu menu2) {
            this.loadSupportedActivities();
            int size = this.mSupportedActivities.size();
            for (int i = 0; i < size; ++i) {
                ResolveInfo resolveInfo = this.mSupportedActivities.get(i);
                menu2.add(0, 0, 100 + i, this.getLabel(resolveInfo)).setIntent(this.createProcessTextIntentForResolveInfo(resolveInfo)).setShowAsAction(0);
            }
        }

        public boolean performMenuItemAction(MenuItem item) {
            return this.fireIntent(item.getIntent());
        }

        public void initializeAccessibilityActions() {
            this.mAccessibilityIntents.clear();
            this.mAccessibilityActions.clear();
            int i = 0;
            this.loadSupportedActivities();
            for (ResolveInfo resolveInfo : this.mSupportedActivities) {
                int actionId = 0x10000100 + i++;
                this.mAccessibilityActions.put(actionId, new AccessibilityNodeInfo.AccessibilityAction(actionId, this.getLabel(resolveInfo)));
                this.mAccessibilityIntents.put(actionId, this.createProcessTextIntentForResolveInfo(resolveInfo));
            }
        }

        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo nodeInfo) {
            for (int i = 0; i < this.mAccessibilityActions.size(); ++i) {
                nodeInfo.addAction(this.mAccessibilityActions.valueAt(i));
            }
        }

        public boolean performAccessibilityAction(int actionId) {
            return this.fireIntent(this.mAccessibilityIntents.get(actionId));
        }

        private boolean fireIntent(Intent intent) {
            if (intent != null && "android.intent.action.PROCESS_TEXT".equals(intent.getAction())) {
                String selectedText = this.mTextView.getSelectedText();
                selectedText = TextUtils.trimToParcelableSize(selectedText);
                intent.putExtra("android.intent.extra.PROCESS_TEXT", selectedText);
                this.mEditor.mPreserveSelection = true;
                this.mTextView.startActivityForResult(intent, 100);
                return true;
            }
            return false;
        }

        private void loadSupportedActivities() {
            this.mSupportedActivities.clear();
            if (!this.mContext.canStartActivityForResult()) {
                return;
            }
            PackageManager packageManager = this.mTextView.getContext().getPackageManager();
            List<ResolveInfo> unfiltered = packageManager.queryIntentActivities(this.createProcessTextIntent(), 0);
            for (ResolveInfo info : unfiltered) {
                if (!this.isSupportedActivity(info)) continue;
                this.mSupportedActivities.add(info);
            }
        }

        private boolean isSupportedActivity(ResolveInfo info) {
            return this.mPackageName.equals(info.activityInfo.packageName) || info.activityInfo.exported && (info.activityInfo.permission == null || this.mContext.checkSelfPermission(info.activityInfo.permission) == 0);
        }

        private Intent createProcessTextIntentForResolveInfo(ResolveInfo info) {
            return this.createProcessTextIntent().putExtra("android.intent.extra.PROCESS_TEXT_READONLY", !this.mTextView.isTextEditable()).setClassName(info.activityInfo.packageName, info.activityInfo.name);
        }

        private Intent createProcessTextIntent() {
            return new Intent().setAction("android.intent.action.PROCESS_TEXT").setType("text/plain");
        }

        private CharSequence getLabel(ResolveInfo resolveInfo) {
            return resolveInfo.loadLabel(this.mPackageManager);
        }
    }

    public static class EditOperation
    extends UndoOperation<Editor> {
        private static final int TYPE_INSERT = 0;
        private static final int TYPE_DELETE = 1;
        private static final int TYPE_REPLACE = 2;
        private int mType;
        private String mOldText;
        private String mNewText;
        private int mStart;
        private int mOldCursorPos;
        private int mNewCursorPos;
        private boolean mFrozen;
        private boolean mIsComposition;
        public static final Parcelable.ClassLoaderCreator<EditOperation> CREATOR = new Parcelable.ClassLoaderCreator<EditOperation>(){

            @Override
            public EditOperation createFromParcel(Parcel in) {
                return new EditOperation(in, null);
            }

            @Override
            public EditOperation createFromParcel(Parcel in, ClassLoader loader) {
                return new EditOperation(in, loader);
            }

            public EditOperation[] newArray(int size) {
                return new EditOperation[size];
            }
        };

        public EditOperation(Editor editor2, String oldText, int dstart, String newText, boolean isComposition) {
            super(editor2.mUndoOwner);
            this.mOldText = oldText;
            this.mNewText = newText;
            this.mType = this.mNewText.length() > 0 && this.mOldText.length() == 0 ? 0 : (this.mNewText.length() == 0 && this.mOldText.length() > 0 ? 1 : 2);
            this.mStart = dstart;
            this.mOldCursorPos = editor2.mTextView.getSelectionStart();
            this.mNewCursorPos = dstart + this.mNewText.length();
            this.mIsComposition = isComposition;
        }

        public EditOperation(Parcel src, ClassLoader loader) {
            super(src, loader);
            this.mType = src.readInt();
            this.mOldText = src.readString();
            this.mNewText = src.readString();
            this.mStart = src.readInt();
            this.mOldCursorPos = src.readInt();
            this.mNewCursorPos = src.readInt();
            this.mFrozen = src.readInt() == 1;
            this.mIsComposition = src.readInt() == 1;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeString(this.mOldText);
            dest.writeString(this.mNewText);
            dest.writeInt(this.mStart);
            dest.writeInt(this.mOldCursorPos);
            dest.writeInt(this.mNewCursorPos);
            dest.writeInt(this.mFrozen ? 1 : 0);
            dest.writeInt(this.mIsComposition ? 1 : 0);
        }

        private int getNewTextEnd() {
            return this.mStart + this.mNewText.length();
        }

        private int getOldTextEnd() {
            return this.mStart + this.mOldText.length();
        }

        @Override
        public void commit() {
        }

        @Override
        public void undo() {
            Editor editor2 = (Editor)this.getOwnerData();
            Editable text = (Editable)editor2.mTextView.getText();
            EditOperation.modifyText(text, this.mStart, this.getNewTextEnd(), this.mOldText, this.mStart, this.mOldCursorPos);
        }

        @Override
        public void redo() {
            Editor editor2 = (Editor)this.getOwnerData();
            Editable text = (Editable)editor2.mTextView.getText();
            EditOperation.modifyText(text, this.mStart, this.getOldTextEnd(), this.mNewText, this.mStart, this.mNewCursorPos);
        }

        private boolean mergeWith(EditOperation edit) {
            if (this.mFrozen) {
                return false;
            }
            switch (this.mType) {
                case 0: {
                    return this.mergeInsertWith(edit);
                }
                case 1: {
                    return this.mergeDeleteWith(edit);
                }
                case 2: {
                    return this.mergeReplaceWith(edit);
                }
            }
            return false;
        }

        private boolean mergeInsertWith(EditOperation edit) {
            if (edit.mType == 0) {
                if (this.getNewTextEnd() != edit.mStart) {
                    return false;
                }
                this.mNewText = this.mNewText + edit.mNewText;
                this.mNewCursorPos = edit.mNewCursorPos;
                this.mFrozen = edit.mFrozen;
                this.mIsComposition = edit.mIsComposition;
                return true;
            }
            if (this.mIsComposition && edit.mType == 2 && this.mStart <= edit.mStart && this.getNewTextEnd() >= edit.getOldTextEnd()) {
                this.mNewText = this.mNewText.substring(0, edit.mStart - this.mStart) + edit.mNewText + this.mNewText.substring(edit.getOldTextEnd() - this.mStart, this.mNewText.length());
                this.mNewCursorPos = edit.mNewCursorPos;
                this.mIsComposition = edit.mIsComposition;
                return true;
            }
            return false;
        }

        private boolean mergeDeleteWith(EditOperation edit) {
            if (edit.mType != 1) {
                return false;
            }
            if (this.mStart != edit.getOldTextEnd()) {
                return false;
            }
            this.mStart = edit.mStart;
            this.mOldText = edit.mOldText + this.mOldText;
            this.mNewCursorPos = edit.mNewCursorPos;
            this.mIsComposition = edit.mIsComposition;
            return true;
        }

        private boolean mergeReplaceWith(EditOperation edit) {
            if (edit.mType == 0 && this.getNewTextEnd() == edit.mStart) {
                this.mNewText = this.mNewText + edit.mNewText;
                this.mNewCursorPos = edit.mNewCursorPos;
                return true;
            }
            if (!this.mIsComposition) {
                return false;
            }
            if (edit.mType == 1 && this.mStart <= edit.mStart && this.getNewTextEnd() >= edit.getOldTextEnd()) {
                this.mNewText = this.mNewText.substring(0, edit.mStart - this.mStart) + this.mNewText.substring(edit.getOldTextEnd() - this.mStart, this.mNewText.length());
                if (this.mNewText.isEmpty()) {
                    this.mType = 1;
                }
                this.mNewCursorPos = edit.mNewCursorPos;
                this.mIsComposition = edit.mIsComposition;
                return true;
            }
            if (edit.mType == 2 && this.mStart == edit.mStart && TextUtils.equals(this.mNewText, edit.mOldText)) {
                this.mNewText = edit.mNewText;
                this.mNewCursorPos = edit.mNewCursorPos;
                this.mIsComposition = edit.mIsComposition;
                return true;
            }
            return false;
        }

        public void forceMergeWith(EditOperation edit) {
            if (this.mergeWith(edit)) {
                return;
            }
            Editor editor2 = (Editor)this.getOwnerData();
            Editable editable = (Editable)editor2.mTextView.getText();
            SpannableStringBuilder originalText = new SpannableStringBuilder(editable.toString());
            EditOperation.modifyText(originalText, this.mStart, this.getNewTextEnd(), this.mOldText, this.mStart, this.mOldCursorPos);
            SpannableStringBuilder finalText = new SpannableStringBuilder(editable.toString());
            EditOperation.modifyText(finalText, edit.mStart, edit.getOldTextEnd(), edit.mNewText, edit.mStart, edit.mNewCursorPos);
            this.mType = 2;
            this.mNewText = ((Object)finalText).toString();
            this.mOldText = ((Object)originalText).toString();
            this.mStart = 0;
            this.mNewCursorPos = edit.mNewCursorPos;
            this.mIsComposition = edit.mIsComposition;
        }

        private static void modifyText(Editable text, int deleteFrom, int deleteTo, CharSequence newText, int newTextInsertAt, int newCursorPos) {
            if (Editor.isValidRange(text, deleteFrom, deleteTo) && newTextInsertAt <= text.length() - (deleteTo - deleteFrom)) {
                if (deleteFrom != deleteTo) {
                    text.delete(deleteFrom, deleteTo);
                }
                if (newText.length() != 0) {
                    text.insert(newTextInsertAt, newText);
                }
            }
            if (0 <= newCursorPos && newCursorPos <= text.length()) {
                Selection.setSelection(text, newCursorPos);
            }
        }

        private String getTypeString() {
            switch (this.mType) {
                case 0: {
                    return "insert";
                }
                case 1: {
                    return "delete";
                }
                case 2: {
                    return "replace";
                }
            }
            return "";
        }

        public String toString() {
            return "[mType=" + this.getTypeString() + ", mOldText=" + this.mOldText + ", mNewText=" + this.mNewText + ", mStart=" + this.mStart + ", mOldCursorPos=" + this.mOldCursorPos + ", mNewCursorPos=" + this.mNewCursorPos + ", mFrozen=" + this.mFrozen + ", mIsComposition=" + this.mIsComposition + "]";
        }
    }

    public static class UndoInputFilter
    implements InputFilter {
        private final Editor mEditor;
        private boolean mIsUserEdit;
        private boolean mHasComposition;
        private boolean mExpanding;
        private boolean mPreviousOperationWasInSameBatchEdit;
        private static final int MERGE_EDIT_MODE_FORCE_MERGE = 0;
        private static final int MERGE_EDIT_MODE_NEVER_MERGE = 1;
        private static final int MERGE_EDIT_MODE_NORMAL = 2;

        public UndoInputFilter(Editor editor2) {
            this.mEditor = editor2;
        }

        public void saveInstanceState(Parcel parcel) {
            parcel.writeInt(this.mIsUserEdit ? 1 : 0);
            parcel.writeInt(this.mHasComposition ? 1 : 0);
            parcel.writeInt(this.mExpanding ? 1 : 0);
            parcel.writeInt(this.mPreviousOperationWasInSameBatchEdit ? 1 : 0);
        }

        public void restoreInstanceState(Parcel parcel) {
            this.mIsUserEdit = parcel.readInt() != 0;
            this.mHasComposition = parcel.readInt() != 0;
            this.mExpanding = parcel.readInt() != 0;
            this.mPreviousOperationWasInSameBatchEdit = parcel.readInt() != 0;
        }

        public void beginBatchEdit() {
            this.mIsUserEdit = true;
        }

        public void endBatchEdit() {
            this.mIsUserEdit = false;
            this.mPreviousOperationWasInSameBatchEdit = false;
        }

        @Override
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (!this.canUndoEdit(source, start, end, dest, dstart, dend)) {
                return null;
            }
            boolean hadComposition = this.mHasComposition;
            this.mHasComposition = UndoInputFilter.isComposition(source);
            boolean wasExpanding = this.mExpanding;
            boolean shouldCreateSeparateState = false;
            if (end - start != dend - dstart) {
                boolean bl = this.mExpanding = end - start > dend - dstart;
                if (hadComposition && this.mExpanding != wasExpanding) {
                    shouldCreateSeparateState = true;
                }
            }
            this.handleEdit(source, start, end, dest, dstart, dend, shouldCreateSeparateState);
            return null;
        }

        void freezeLastEdit() {
            this.mEditor.mUndoManager.beginUpdate("Edit text");
            EditOperation lastEdit = this.getLastEdit();
            if (lastEdit != null) {
                lastEdit.mFrozen = true;
            }
            this.mEditor.mUndoManager.endUpdate();
        }

        private void handleEdit(CharSequence source, int start, int end, Spanned dest, int dstart, int dend, boolean shouldCreateSeparateState) {
            int mergeMode = this.isInTextWatcher() || this.mPreviousOperationWasInSameBatchEdit ? 0 : (shouldCreateSeparateState ? 1 : 2);
            String newText = TextUtils.substring(source, start, end);
            String oldText = TextUtils.substring(dest, dstart, dend);
            EditOperation edit = new EditOperation(this.mEditor, oldText, dstart, newText, this.mHasComposition);
            if (this.mHasComposition && TextUtils.equals(edit.mNewText, edit.mOldText)) {
                return;
            }
            this.recordEdit(edit, mergeMode);
        }

        private EditOperation getLastEdit() {
            UndoManager um = this.mEditor.mUndoManager;
            return um.getLastOperation(EditOperation.class, this.mEditor.mUndoOwner, 1);
        }

        private void recordEdit(EditOperation edit, int mergeMode) {
            UndoManager um = this.mEditor.mUndoManager;
            um.beginUpdate("Edit text");
            EditOperation lastEdit = this.getLastEdit();
            if (lastEdit == null) {
                um.addOperation(edit, 0);
            } else if (mergeMode == 0) {
                lastEdit.forceMergeWith(edit);
            } else if (!this.mIsUserEdit) {
                um.commitState(this.mEditor.mUndoOwner);
                um.addOperation(edit, 0);
            } else if (mergeMode != 2 || !lastEdit.mergeWith(edit)) {
                um.commitState(this.mEditor.mUndoOwner);
                um.addOperation(edit, 0);
            }
            this.mPreviousOperationWasInSameBatchEdit = this.mIsUserEdit;
            um.endUpdate();
        }

        private boolean canUndoEdit(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (!this.mEditor.mAllowUndo) {
                return false;
            }
            if (this.mEditor.mUndoManager.isInUndo()) {
                return false;
            }
            if (!Editor.isValidRange(source, start, end) || !Editor.isValidRange(dest, dstart, dend)) {
                return false;
            }
            return start != end || dstart != dend;
        }

        private static boolean isComposition(CharSequence source) {
            int composeEnd;
            if (!(source instanceof Spannable)) {
                return false;
            }
            Spannable text = (Spannable)source;
            int composeBegin = EditableInputConnection.getComposingSpanStart(text);
            return composeBegin < (composeEnd = EditableInputConnection.getComposingSpanEnd(text));
        }

        private boolean isInTextWatcher() {
            CharSequence text = this.mEditor.mTextView.getText();
            return text instanceof SpannableStringBuilder && ((SpannableStringBuilder)text).getTextWatcherDepth() > 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface MergeMode {
        }
    }

    static class InputMethodState {
        ExtractedTextRequest mExtractedTextRequest;
        final ExtractedText mExtractedText = new ExtractedText();
        int mBatchEditNesting;
        boolean mCursorChanged;
        boolean mSelectionModeChanged;
        boolean mContentChanged;
        int mChangedStart;
        int mChangedEnd;
        int mChangedDelta;

        InputMethodState() {
        }
    }

    static class InputContentType {
        int imeOptions = 0;
        @UnsupportedAppUsage
        String privateImeOptions;
        CharSequence imeActionLabel;
        int imeActionId;
        Bundle extras;
        TextView.OnEditorActionListener onEditorActionListener;
        boolean enterDown;
        LocaleList imeHintLocales;

        InputContentType() {
        }
    }

    private static class ErrorPopup
    extends PopupWindow {
        private boolean mAbove = false;
        private final TextView mView;
        private int mPopupInlineErrorBackgroundId = 0;
        private int mPopupInlineErrorAboveBackgroundId = 0;

        ErrorPopup(TextView v, int width, int height) {
            super(v, width, height);
            this.mView = v;
            this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 311);
            this.mView.setBackgroundResource(this.mPopupInlineErrorBackgroundId);
        }

        void fixDirection(boolean above) {
            this.mAbove = above;
            if (above) {
                this.mPopupInlineErrorAboveBackgroundId = this.getResourceId(this.mPopupInlineErrorAboveBackgroundId, 310);
            } else {
                this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 311);
            }
            this.mView.setBackgroundResource(above ? this.mPopupInlineErrorAboveBackgroundId : this.mPopupInlineErrorBackgroundId);
        }

        private int getResourceId(int currentId, int index) {
            if (currentId == 0) {
                TypedArray styledAttributes = this.mView.getContext().obtainStyledAttributes(R.styleable.Theme);
                currentId = styledAttributes.getResourceId(index, 0);
                styledAttributes.recycle();
            }
            return currentId;
        }

        @Override
        public void update(int x, int y, int w, int h, boolean force) {
            super.update(x, y, w, h, force);
            boolean above = this.isAboveAnchor();
            if (above != this.mAbove) {
                this.fixDirection(above);
            }
        }
    }

    private class CorrectionHighlighter {
        private final Path mPath = new Path();
        private final Paint mPaint = new Paint(1);
        private int mStart;
        private int mEnd;
        private long mFadingStartTime;
        private RectF mTempRectF;
        private static final int FADE_OUT_DURATION = 400;

        public CorrectionHighlighter() {
            this.mPaint.setCompatibilityScaling(((Editor)Editor.this).mTextView.getResources().getCompatibilityInfo().applicationScale);
            this.mPaint.setStyle(Paint.Style.FILL);
        }

        public void highlight(CorrectionInfo info) {
            this.mStart = info.getOffset();
            this.mEnd = this.mStart + info.getNewText().length();
            this.mFadingStartTime = SystemClock.uptimeMillis();
            if (this.mStart < 0 || this.mEnd < 0) {
                this.stopAnimation();
            }
        }

        public void draw(Canvas canvas, int cursorOffsetVertical) {
            if (this.updatePath() && this.updatePaint()) {
                if (cursorOffsetVertical != 0) {
                    canvas.translate(0.0f, cursorOffsetVertical);
                }
                canvas.drawPath(this.mPath, this.mPaint);
                if (cursorOffsetVertical != 0) {
                    canvas.translate(0.0f, -cursorOffsetVertical);
                }
                this.invalidate(true);
            } else {
                this.stopAnimation();
                this.invalidate(false);
            }
        }

        private boolean updatePaint() {
            long duration = SystemClock.uptimeMillis() - this.mFadingStartTime;
            if (duration > 400L) {
                return false;
            }
            float coef = 1.0f - (float)duration / 400.0f;
            int highlightColorAlpha = Color.alpha(((Editor)Editor.this).mTextView.mHighlightColor);
            int color2 = (((Editor)Editor.this).mTextView.mHighlightColor & 0xFFFFFF) + ((int)((float)highlightColorAlpha * coef) << 24);
            this.mPaint.setColor(color2);
            return true;
        }

        private boolean updatePath() {
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                return false;
            }
            int length = Editor.this.mTextView.getText().length();
            int start = Math.min(length, this.mStart);
            int end = Math.min(length, this.mEnd);
            this.mPath.reset();
            layout2.getSelectionPath(start, end, this.mPath);
            return true;
        }

        private void invalidate(boolean delayed) {
            if (Editor.this.mTextView.getLayout() == null) {
                return;
            }
            if (this.mTempRectF == null) {
                this.mTempRectF = new RectF();
            }
            this.mPath.computeBounds(this.mTempRectF, false);
            int left = Editor.this.mTextView.getCompoundPaddingLeft();
            int top = Editor.this.mTextView.getExtendedPaddingTop() + Editor.this.mTextView.getVerticalOffset(true);
            if (delayed) {
                Editor.this.mTextView.postInvalidateOnAnimation(left + (int)this.mTempRectF.left, top + (int)this.mTempRectF.top, left + (int)this.mTempRectF.right, top + (int)this.mTempRectF.bottom);
            } else {
                Editor.this.mTextView.postInvalidate((int)this.mTempRectF.left, (int)this.mTempRectF.top, (int)this.mTempRectF.right, (int)this.mTempRectF.bottom);
            }
        }

        private void stopAnimation() {
            Editor.this.mCorrectionHighlighter = null;
        }
    }

    @VisibleForTesting
    public class SelectionModifierCursorController
    implements CursorController {
        private SelectionHandleView mStartHandle;
        private SelectionHandleView mEndHandle;
        private int mMinTouchOffset;
        private int mMaxTouchOffset;
        private boolean mGestureStayedInTapRegion;
        private int mStartOffset = -1;
        private boolean mHaventMovedEnoughToStartDrag;
        private int mLineSelectionIsOn = -1;
        private boolean mSwitchedLines = false;
        private int mDragAcceleratorMode = 0;
        private static final int DRAG_ACCELERATOR_MODE_INACTIVE = 0;
        private static final int DRAG_ACCELERATOR_MODE_CHARACTER = 1;
        private static final int DRAG_ACCELERATOR_MODE_WORD = 2;
        private static final int DRAG_ACCELERATOR_MODE_PARAGRAPH = 3;

        SelectionModifierCursorController() {
            this.resetTouchOffsets();
        }

        @Override
        public void show() {
            if (Editor.this.mTextView.isInBatchEditMode()) {
                return;
            }
            Editor.this.loadHandleDrawables(false);
            this.initHandles();
        }

        private void initHandles() {
            if (this.mStartHandle == null) {
                this.mStartHandle = new SelectionHandleView(Editor.this.mSelectHandleLeft, Editor.this.mSelectHandleRight, 16909418, 0);
            }
            if (this.mEndHandle == null) {
                this.mEndHandle = new SelectionHandleView(Editor.this.mSelectHandleRight, Editor.this.mSelectHandleLeft, 16909417, 1);
            }
            this.mStartHandle.show();
            this.mEndHandle.show();
            Editor.this.hideInsertionPointCursorController();
        }

        private void reloadHandleDrawables() {
            if (this.mStartHandle == null) {
                return;
            }
            this.mStartHandle.setDrawables(Editor.this.mSelectHandleLeft, Editor.this.mSelectHandleRight);
            this.mEndHandle.setDrawables(Editor.this.mSelectHandleRight, Editor.this.mSelectHandleLeft);
        }

        @Override
        public void hide() {
            if (this.mStartHandle != null) {
                this.mStartHandle.hide();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.hide();
            }
        }

        public void enterDrag(int dragAcceleratorMode) {
            this.show();
            this.mDragAcceleratorMode = dragAcceleratorMode;
            this.mStartOffset = Editor.this.mTextView.getOffsetForPosition(Editor.this.mTouchState.getLastDownX(), Editor.this.mTouchState.getLastDownY());
            this.mLineSelectionIsOn = Editor.this.mTextView.getLineAtCoordinate(Editor.this.mTouchState.getLastDownY());
            this.hide();
            Editor.this.mTextView.getParent().requestDisallowInterceptTouchEvent(true);
            Editor.this.mTextView.cancelLongPress();
        }

        public void onTouchEvent(MotionEvent event) {
            float eventX = event.getX();
            float eventY = event.getY();
            boolean isMouse = event.isFromSource(8194);
            switch (event.getActionMasked()) {
                case 0: {
                    if (Editor.this.extractedTextModeWillBeStarted()) {
                        this.hide();
                        break;
                    }
                    this.mMinTouchOffset = this.mMaxTouchOffset = Editor.this.mTextView.getOffsetForPosition(eventX, eventY);
                    if (this.mGestureStayedInTapRegion && Editor.this.mTouchState.isMultiTapInSameArea() && (isMouse || Editor.this.isPositionOnText(eventX, eventY) || Editor.this.mTouchState.isOnHandle())) {
                        if (Editor.this.mTouchState.isDoubleTap()) {
                            Editor.this.selectCurrentWordAndStartDrag();
                        } else if (Editor.this.mTouchState.isTripleClick()) {
                            this.selectCurrentParagraphAndStartDrag();
                        }
                        Editor.this.mDiscardNextActionUp = true;
                    }
                    this.mGestureStayedInTapRegion = true;
                    this.mHaventMovedEnoughToStartDrag = true;
                    break;
                }
                case 5: 
                case 6: {
                    if (!Editor.this.mTextView.getContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) break;
                    this.updateMinAndMaxOffsets(event);
                    break;
                }
                case 2: {
                    if (this.mGestureStayedInTapRegion) {
                        ViewConfiguration viewConfig = ViewConfiguration.get(Editor.this.mTextView.getContext());
                        this.mGestureStayedInTapRegion = EditorTouchState.isDistanceWithin(Editor.this.mTouchState.getLastDownX(), Editor.this.mTouchState.getLastDownY(), eventX, eventY, viewConfig.getScaledDoubleTapTouchSlop());
                    }
                    if (this.mHaventMovedEnoughToStartDrag) {
                        boolean bl = this.mHaventMovedEnoughToStartDrag = !Editor.this.mTouchState.isMovedEnoughForDrag();
                    }
                    if (isMouse && !this.isDragAcceleratorActive()) {
                        int offset2 = Editor.this.mTextView.getOffsetForPosition(eventX, eventY);
                        if (Editor.this.mTextView.hasSelection() && (!this.mHaventMovedEnoughToStartDrag || this.mStartOffset != offset2) && offset2 >= Editor.this.mTextView.getSelectionStart() && offset2 <= Editor.this.mTextView.getSelectionEnd()) {
                            Editor.this.startDragAndDrop();
                            break;
                        }
                        if (this.mStartOffset != offset2) {
                            Editor.this.stopTextActionMode();
                            this.enterDrag(1);
                            Editor.this.mDiscardNextActionUp = true;
                            this.mHaventMovedEnoughToStartDrag = false;
                        }
                    }
                    if (this.mStartHandle != null && this.mStartHandle.isShowing()) break;
                    this.updateSelection(event);
                    if (!Editor.this.mTextView.hasSelection() || this.mEndHandle == null || !this.isDragAcceleratorActive()) break;
                    this.mEndHandle.updateMagnifier(event);
                    break;
                }
                case 1: {
                    if (this.mEndHandle != null) {
                        this.mEndHandle.dismissMagnifier();
                    }
                    if (!this.isDragAcceleratorActive()) break;
                    this.updateSelection(event);
                    Editor.this.mTextView.getParent().requestDisallowInterceptTouchEvent(false);
                    this.resetDragAcceleratorState();
                    if (!Editor.this.mTextView.hasSelection()) break;
                    Editor.this.startSelectionActionModeAsync(this.mHaventMovedEnoughToStartDrag);
                }
            }
        }

        private void updateSelection(MotionEvent event) {
            if (Editor.this.mTextView.getLayout() != null) {
                switch (this.mDragAcceleratorMode) {
                    case 1: {
                        this.updateCharacterBasedSelection(event);
                        break;
                    }
                    case 2: {
                        this.updateWordBasedSelection(event);
                        break;
                    }
                    case 3: {
                        this.updateParagraphBasedSelection(event);
                    }
                }
            }
        }

        private boolean selectCurrentParagraphAndStartDrag() {
            if (Editor.this.mInsertionActionModeRunnable != null) {
                Editor.this.mTextView.removeCallbacks(Editor.this.mInsertionActionModeRunnable);
            }
            Editor.this.stopTextActionMode();
            if (!Editor.this.selectCurrentParagraph()) {
                return false;
            }
            this.enterDrag(3);
            return true;
        }

        private void updateCharacterBasedSelection(MotionEvent event) {
            int offset2 = Editor.this.mTextView.getOffsetForPosition(event.getX(), event.getY());
            this.updateSelectionInternal(this.mStartOffset, offset2, event.isFromSource(4098));
        }

        private void updateWordBasedSelection(MotionEvent event) {
            int startOffset;
            int currLine;
            if (this.mHaventMovedEnoughToStartDrag) {
                return;
            }
            boolean isMouse = event.isFromSource(8194);
            ViewConfiguration viewConfig = ViewConfiguration.get(Editor.this.mTextView.getContext());
            float eventX = event.getX();
            float eventY = event.getY();
            if (isMouse) {
                currLine = Editor.this.mTextView.getLineAtCoordinate(eventY);
            } else {
                float y = eventY;
                if (this.mSwitchedLines) {
                    int touchSlop = viewConfig.getScaledTouchSlop();
                    float fingerOffset = this.mStartHandle != null ? this.mStartHandle.getIdealVerticalOffset() : (float)touchSlop;
                    y = eventY - fingerOffset;
                }
                currLine = Editor.this.getCurrentLineAdjustedForSlop(Editor.this.mTextView.getLayout(), this.mLineSelectionIsOn, y);
                if (!this.mSwitchedLines && currLine != this.mLineSelectionIsOn) {
                    this.mSwitchedLines = true;
                    return;
                }
            }
            int offset2 = Editor.this.mTextView.getOffsetAtCoordinate(currLine, eventX);
            if (this.mStartOffset < offset2) {
                offset2 = Editor.this.getWordEnd(offset2);
                startOffset = Editor.this.getWordStart(this.mStartOffset);
            } else {
                offset2 = Editor.this.getWordStart(offset2);
                startOffset = Editor.this.getWordEnd(this.mStartOffset);
                if (startOffset == offset2) {
                    offset2 = Editor.this.getNextCursorOffset(offset2, false);
                }
            }
            this.mLineSelectionIsOn = currLine;
            this.updateSelectionInternal(startOffset, offset2, event.isFromSource(4098));
        }

        private void updateParagraphBasedSelection(MotionEvent event) {
            int offset2 = Editor.this.mTextView.getOffsetForPosition(event.getX(), event.getY());
            int start = Math.min(offset2, this.mStartOffset);
            int end = Math.max(offset2, this.mStartOffset);
            long paragraphsRange = Editor.this.getParagraphsRange(start, end);
            int selectionStart = TextUtils.unpackRangeStartFromLong(paragraphsRange);
            int selectionEnd = TextUtils.unpackRangeEndFromLong(paragraphsRange);
            this.updateSelectionInternal(selectionStart, selectionEnd, event.isFromSource(4098));
        }

        private void updateSelectionInternal(int selectionStart, int selectionEnd, boolean fromTouchScreen) {
            boolean performHapticFeedback = fromTouchScreen && Editor.this.mHapticTextHandleEnabled && (Editor.this.mTextView.getSelectionStart() != selectionStart || Editor.this.mTextView.getSelectionEnd() != selectionEnd);
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), selectionStart, selectionEnd);
            if (performHapticFeedback) {
                Editor.this.mTextView.performHapticFeedback(9);
            }
        }

        private void updateMinAndMaxOffsets(MotionEvent event) {
            int pointerCount = event.getPointerCount();
            for (int index = 0; index < pointerCount; ++index) {
                int offset2 = Editor.this.mTextView.getOffsetForPosition(event.getX(index), event.getY(index));
                if (offset2 < this.mMinTouchOffset) {
                    this.mMinTouchOffset = offset2;
                }
                if (offset2 <= this.mMaxTouchOffset) continue;
                this.mMaxTouchOffset = offset2;
            }
        }

        public int getMinTouchOffset() {
            return this.mMinTouchOffset;
        }

        public int getMaxTouchOffset() {
            return this.mMaxTouchOffset;
        }

        public void resetTouchOffsets() {
            this.mMaxTouchOffset = -1;
            this.mMinTouchOffset = -1;
            this.resetDragAcceleratorState();
        }

        private void resetDragAcceleratorState() {
            this.mStartOffset = -1;
            this.mDragAcceleratorMode = 0;
            this.mSwitchedLines = false;
            int selectionStart = Editor.this.mTextView.getSelectionStart();
            int selectionEnd = Editor.this.mTextView.getSelectionEnd();
            if (selectionStart < 0 || selectionEnd < 0) {
                Selection.removeSelection((Spannable)Editor.this.mTextView.getText());
            } else if (selectionStart > selectionEnd) {
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), selectionEnd, selectionStart);
            }
        }

        public boolean isSelectionStartDragged() {
            return this.mStartHandle != null && this.mStartHandle.isDragging();
        }

        @Override
        public boolean isCursorBeingModified() {
            return this.isDragAcceleratorActive() || this.isSelectionStartDragged() || this.mEndHandle != null && this.mEndHandle.isDragging();
        }

        public boolean isDragAcceleratorActive() {
            return this.mDragAcceleratorMode != 0;
        }

        @Override
        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        @Override
        public void onDetached() {
            ViewTreeObserver observer = Editor.this.mTextView.getViewTreeObserver();
            observer.removeOnTouchModeChangeListener(this);
            if (this.mStartHandle != null) {
                this.mStartHandle.onDetached();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.onDetached();
            }
        }

        @Override
        public boolean isActive() {
            return this.mStartHandle != null && this.mStartHandle.isShowing();
        }

        public void invalidateHandles() {
            if (this.mStartHandle != null) {
                this.mStartHandle.invalidate();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.invalidate();
            }
        }
    }

    @VisibleForTesting
    public class InsertionPointCursorController
    implements CursorController {
        private InsertionHandleView mHandle;
        private boolean mIsDraggingCursor;
        private boolean mIsTouchSnappedToHandleDuringDrag;
        private int mPrevLineDuringDrag;

        public void onTouchEvent(MotionEvent event) {
            if (Editor.this.hasSelectionController() && Editor.this.getSelectionController().isCursorBeingModified()) {
                return;
            }
            switch (event.getActionMasked()) {
                case 2: {
                    if (event.isFromSource(8194)) break;
                    if (this.mIsDraggingCursor) {
                        this.performCursorDrag(event);
                        break;
                    }
                    if (!Editor.this.mFlagCursorDragFromAnywhereEnabled || Editor.this.mTextView.getLayout() == null || !Editor.this.mTextView.isFocused() || !Editor.this.mTouchState.isMovedEnoughForDrag() || !(Editor.this.mTouchState.getInitialDragDirectionXYRatio() > Editor.this.mCursorDragDirectionMinXYRatio) && !Editor.this.mTouchState.isOnHandle()) break;
                    this.startCursorDrag(event);
                    break;
                }
                case 1: 
                case 3: {
                    if (!this.mIsDraggingCursor) break;
                    this.endCursorDrag(event);
                }
            }
        }

        private void positionCursorDuringDrag(MotionEvent event) {
            this.mPrevLineDuringDrag = this.getLineDuringDrag(event);
            int offset2 = Editor.this.mTextView.getOffsetAtCoordinate(this.mPrevLineDuringDrag, event.getX());
            int oldSelectionStart = Editor.this.mTextView.getSelectionStart();
            int oldSelectionEnd = Editor.this.mTextView.getSelectionEnd();
            if (offset2 == oldSelectionStart && offset2 == oldSelectionEnd) {
                return;
            }
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), offset2);
            Editor.this.updateCursorPosition();
            if (Editor.this.mHapticTextHandleEnabled) {
                Editor.this.mTextView.performHapticFeedback(9);
            }
        }

        private int getLineDuringDrag(MotionEvent event) {
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (this.mPrevLineDuringDrag == -1) {
                return Editor.this.getCurrentLineAdjustedForSlop(layout2, this.mPrevLineDuringDrag, event.getY());
            }
            float fingerY = Editor.this.mTouchState.isOnHandle() ? event.getRawY() - (float)Editor.this.mTextView.getLocationOnScreen()[1] : event.getY();
            float cursorY = fingerY - (float)this.getHandle().getIdealFingerToCursorOffset();
            int line = Editor.this.getCurrentLineAdjustedForSlop(layout2, this.mPrevLineDuringDrag, cursorY);
            if (this.mIsTouchSnappedToHandleDuringDrag) {
                return line;
            }
            if (line < this.mPrevLineDuringDrag) {
                return Math.min(this.mPrevLineDuringDrag, Editor.this.getCurrentLineAdjustedForSlop(layout2, this.mPrevLineDuringDrag, fingerY));
            }
            this.mIsTouchSnappedToHandleDuringDrag = true;
            return line;
        }

        private void startCursorDrag(MotionEvent event) {
            this.mIsDraggingCursor = true;
            this.mIsTouchSnappedToHandleDuringDrag = false;
            this.mPrevLineDuringDrag = -1;
            Editor.this.mTextView.getParent().requestDisallowInterceptTouchEvent(true);
            Editor.this.mTextView.cancelLongPress();
            this.positionCursorDuringDrag(event);
            this.show();
            this.getHandle().removeHiderCallback();
            this.getHandle().updateMagnifier(event);
        }

        private void performCursorDrag(MotionEvent event) {
            this.positionCursorDuringDrag(event);
            this.getHandle().updateMagnifier(event);
        }

        private void endCursorDrag(MotionEvent event) {
            this.mIsDraggingCursor = false;
            this.mIsTouchSnappedToHandleDuringDrag = false;
            this.mPrevLineDuringDrag = -1;
            this.getHandle().dismissMagnifier();
            this.getHandle().hideAfterDelay();
            Editor.this.mTextView.getParent().requestDisallowInterceptTouchEvent(false);
        }

        @Override
        public void show() {
            this.getHandle().show();
            long durationSinceCutOrCopy = SystemClock.uptimeMillis() - TextView.sLastCutCopyOrTextChangedTime;
            if (Editor.this.mInsertionActionModeRunnable != null && (this.mIsDraggingCursor || Editor.this.mTouchState.isMultiTap() || Editor.this.isCursorInsideEasyCorrectionSpan())) {
                Editor.this.mTextView.removeCallbacks(Editor.this.mInsertionActionModeRunnable);
            }
            if (!(this.mIsDraggingCursor || Editor.this.mTouchState.isMultiTap() || Editor.this.isCursorInsideEasyCorrectionSpan() || durationSinceCutOrCopy >= 15000L || Editor.this.mTextActionMode != null)) {
                if (Editor.this.mInsertionActionModeRunnable == null) {
                    Editor.this.mInsertionActionModeRunnable = new Runnable(){

                        @Override
                        public void run() {
                            Editor.this.startInsertionActionMode();
                        }
                    };
                }
                Editor.this.mTextView.postDelayed(Editor.this.mInsertionActionModeRunnable, ViewConfiguration.getDoubleTapTimeout() + 1);
            }
            if (!this.mIsDraggingCursor) {
                this.getHandle().hideAfterDelay();
            }
            if (Editor.this.mSelectionModifierCursorController != null) {
                Editor.this.mSelectionModifierCursorController.hide();
            }
        }

        @Override
        public void hide() {
            if (this.mHandle != null) {
                this.mHandle.hide();
            }
        }

        @Override
        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        public InsertionHandleView getHandle() {
            if (this.mHandle == null) {
                Editor.this.loadHandleDrawables(false);
                this.mHandle = new InsertionHandleView(Editor.this.mSelectHandleCenter);
            }
            return this.mHandle;
        }

        private void reloadHandleDrawable() {
            if (this.mHandle == null) {
                return;
            }
            this.mHandle.setDrawables(Editor.this.mSelectHandleCenter, Editor.this.mSelectHandleCenter);
        }

        @Override
        public void onDetached() {
            ViewTreeObserver observer = Editor.this.mTextView.getViewTreeObserver();
            observer.removeOnTouchModeChangeListener(this);
            if (this.mHandle != null) {
                this.mHandle.onDetached();
            }
        }

        @Override
        public boolean isCursorBeingModified() {
            return this.mIsDraggingCursor || this.mHandle != null && this.mHandle.isDragging();
        }

        @Override
        public boolean isActive() {
            return this.mHandle != null && this.mHandle.isShowing();
        }

        public void invalidateHandle() {
            if (this.mHandle != null) {
                this.mHandle.invalidate();
            }
        }
    }

    private static interface CursorController
    extends ViewTreeObserver.OnTouchModeChangeListener {
        public void show();

        public void hide();

        public void onDetached();

        public boolean isCursorBeingModified();

        public boolean isActive();
    }

    @VisibleForTesting
    public class SelectionHandleView
    extends HandleView {
        private final int mHandleType;
        private boolean mInWord;
        private float mTouchWordDelta;
        private float mPrevX;
        private boolean mLanguageDirectionChanged;
        private final float mTextViewEdgeSlop;
        private final int[] mTextViewLocation;

        public SelectionHandleView(Drawable drawableLtr, Drawable drawableRtl, int id2, int handleType) {
            super(drawableLtr, drawableRtl, id2);
            this.mInWord = false;
            this.mLanguageDirectionChanged = false;
            this.mTextViewLocation = new int[2];
            this.mHandleType = handleType;
            ViewConfiguration viewConfiguration = ViewConfiguration.get(Editor.this.mTextView.getContext());
            this.mTextViewEdgeSlop = viewConfiguration.getScaledTouchSlop() * 4;
        }

        private boolean isStartHandle() {
            return this.mHandleType == 0;
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            if (isRtlRun == this.isStartHandle()) {
                return drawable2.getIntrinsicWidth() / 4;
            }
            return drawable2.getIntrinsicWidth() * 3 / 4;
        }

        @Override
        protected int getHorizontalGravity(boolean isRtlRun) {
            return isRtlRun == this.isStartHandle() ? 3 : 5;
        }

        @Override
        public int getCurrentCursorOffset() {
            return this.isStartHandle() ? Editor.this.mTextView.getSelectionStart() : Editor.this.mTextView.getSelectionEnd();
        }

        @Override
        protected void updateSelection(int offset2) {
            if (this.isStartHandle()) {
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), offset2, Editor.this.mTextView.getSelectionEnd());
            } else {
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), Editor.this.mTextView.getSelectionStart(), offset2);
            }
            this.updateDrawable(false);
            if (Editor.this.mTextActionMode != null) {
                Editor.this.invalidateActionMode();
            }
        }

        @Override
        protected void updatePosition(float x, float y, boolean fromTouchScreen) {
            boolean isExpanding;
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                this.positionAndAdjustForCrossingHandles(Editor.this.mTextView.getOffsetForPosition(x, y), fromTouchScreen);
                return;
            }
            if (this.mPreviousLineTouched == -1) {
                this.mPreviousLineTouched = Editor.this.mTextView.getLineAtCoordinate(y);
            }
            boolean positionCursor = false;
            int anotherHandleOffset = this.isStartHandle() ? Editor.this.mTextView.getSelectionEnd() : Editor.this.mTextView.getSelectionStart();
            int currLine = Editor.this.getCurrentLineAdjustedForSlop(layout2, this.mPreviousLineTouched, y);
            int initialOffset = this.getOffsetAtCoordinate(layout2, currLine, x);
            if (this.isStartHandle() && initialOffset >= anotherHandleOffset || !this.isStartHandle() && initialOffset <= anotherHandleOffset) {
                currLine = layout2.getLineForOffset(anotherHandleOffset);
                initialOffset = this.getOffsetAtCoordinate(layout2, currLine, x);
            }
            int offset2 = initialOffset;
            int wordEnd = Editor.this.getWordEnd(offset2);
            int wordStart = Editor.this.getWordStart(offset2);
            if (this.mPrevX == -1.0f) {
                this.mPrevX = x;
            }
            int currentOffset = this.getCurrentCursorOffset();
            boolean rtlAtCurrentOffset = this.isAtRtlRun(layout2, currentOffset);
            boolean atRtl = this.isAtRtlRun(layout2, offset2);
            boolean isLvlBoundary = layout2.isLevelBoundary(offset2);
            if (isLvlBoundary || rtlAtCurrentOffset && !atRtl || !rtlAtCurrentOffset && atRtl) {
                this.mLanguageDirectionChanged = true;
                this.mTouchWordDelta = 0.0f;
                this.positionAndAdjustForCrossingHandles(offset2, fromTouchScreen);
                return;
            }
            if (this.mLanguageDirectionChanged && !isLvlBoundary) {
                this.positionAndAdjustForCrossingHandles(offset2, fromTouchScreen);
                this.mTouchWordDelta = 0.0f;
                this.mLanguageDirectionChanged = false;
                return;
            }
            float xDiff = x - this.mPrevX;
            if (this.isStartHandle()) {
                isExpanding = currLine < this.mPreviousLineTouched;
            } else {
                boolean bl = isExpanding = currLine > this.mPreviousLineTouched;
            }
            isExpanding = atRtl == this.isStartHandle() ? (isExpanding |= xDiff > 0.0f) : (isExpanding |= xDiff < 0.0f);
            if (Editor.this.mTextView.getHorizontallyScrolling() && this.positionNearEdgeOfScrollingView(x, atRtl) && (this.isStartHandle() && Editor.this.mTextView.getScrollX() != 0 || !this.isStartHandle() && Editor.this.mTextView.canScrollHorizontally(atRtl ? -1 : 1)) && (isExpanding && (this.isStartHandle() && offset2 < currentOffset || !this.isStartHandle() && offset2 > currentOffset) || !isExpanding)) {
                this.mTouchWordDelta = 0.0f;
                int nextOffset = atRtl == this.isStartHandle() ? layout2.getOffsetToRightOf(this.mPreviousOffset) : layout2.getOffsetToLeftOf(this.mPreviousOffset);
                this.positionAndAdjustForCrossingHandles(nextOffset, fromTouchScreen);
                return;
            }
            if (isExpanding) {
                boolean snapToWord;
                int wordBoundary;
                int n = wordBoundary = this.isStartHandle() ? wordStart : wordEnd;
                boolean bl = (!this.mInWord || (this.isStartHandle() ? currLine < this.mPrevLine : currLine > this.mPrevLine)) && atRtl == this.isAtRtlRun(layout2, wordBoundary) ? true : (snapToWord = false);
                if (snapToWord) {
                    int offsetThresholdToSnap;
                    if (layout2.getLineForOffset(wordBoundary) != currLine) {
                        wordBoundary = this.isStartHandle() ? layout2.getLineStart(currLine) : layout2.getLineEnd(currLine);
                    }
                    int n2 = offsetThresholdToSnap = this.isStartHandle() ? wordEnd - (wordEnd - wordBoundary) / 2 : wordStart + (wordBoundary - wordStart) / 2;
                    offset2 = this.isStartHandle() && (offset2 <= offsetThresholdToSnap || currLine < this.mPrevLine) ? wordStart : (!this.isStartHandle() && (offset2 >= offsetThresholdToSnap || currLine > this.mPrevLine) ? wordEnd : this.mPreviousOffset);
                }
                if (this.isStartHandle() && offset2 < initialOffset || !this.isStartHandle() && offset2 > initialOffset) {
                    float adjustedX = this.getHorizontal(layout2, offset2);
                    this.mTouchWordDelta = Editor.this.mTextView.convertToLocalHorizontalCoordinate(x) - adjustedX;
                } else {
                    this.mTouchWordDelta = 0.0f;
                }
                positionCursor = true;
            } else {
                boolean shrinking;
                int adjustedOffset = this.getOffsetAtCoordinate(layout2, currLine, x - this.mTouchWordDelta);
                boolean bl = this.isStartHandle() ? adjustedOffset > this.mPreviousOffset || currLine > this.mPrevLine : (shrinking = adjustedOffset < this.mPreviousOffset || currLine < this.mPrevLine);
                if (shrinking) {
                    if (currLine != this.mPrevLine) {
                        int n = offset2 = this.isStartHandle() ? wordStart : wordEnd;
                        if (this.isStartHandle() && offset2 < initialOffset || !this.isStartHandle() && offset2 > initialOffset) {
                            float adjustedX = this.getHorizontal(layout2, offset2);
                            this.mTouchWordDelta = Editor.this.mTextView.convertToLocalHorizontalCoordinate(x) - adjustedX;
                        } else {
                            this.mTouchWordDelta = 0.0f;
                        }
                    } else {
                        offset2 = adjustedOffset;
                    }
                    positionCursor = true;
                } else if (this.isStartHandle() && adjustedOffset < this.mPreviousOffset || !this.isStartHandle() && adjustedOffset > this.mPreviousOffset) {
                    this.mTouchWordDelta = Editor.this.mTextView.convertToLocalHorizontalCoordinate(x) - this.getHorizontal(layout2, this.mPreviousOffset);
                }
            }
            if (positionCursor) {
                this.mPreviousLineTouched = currLine;
                this.positionAndAdjustForCrossingHandles(offset2, fromTouchScreen);
            }
            this.mPrevX = x;
        }

        @Override
        protected void positionAtCursorOffset(int offset2, boolean forceUpdatePosition, boolean fromTouchScreen) {
            super.positionAtCursorOffset(offset2, forceUpdatePosition, fromTouchScreen);
            this.mInWord = offset2 != -1 && !Editor.this.getWordIteratorWithText().isBoundary(offset2);
        }

        @Override
        public boolean onTouchEvent(MotionEvent event) {
            if (!Editor.this.mTextView.isFromPrimePointer(event, true)) {
                return true;
            }
            boolean superResult = super.onTouchEvent(event);
            switch (event.getActionMasked()) {
                case 0: {
                    this.mTouchWordDelta = 0.0f;
                    this.mPrevX = -1.0f;
                    this.updateMagnifier(event);
                    break;
                }
                case 2: {
                    this.updateMagnifier(event);
                    break;
                }
                case 1: 
                case 3: {
                    this.dismissMagnifier();
                }
            }
            return superResult;
        }

        private void positionAndAdjustForCrossingHandles(int offset2, boolean fromTouchScreen) {
            int anotherHandleOffset;
            int n = anotherHandleOffset = this.isStartHandle() ? Editor.this.mTextView.getSelectionEnd() : Editor.this.mTextView.getSelectionStart();
            if (this.isStartHandle() && offset2 >= anotherHandleOffset || !this.isStartHandle() && offset2 <= anotherHandleOffset) {
                this.mTouchWordDelta = 0.0f;
                Layout layout2 = Editor.this.mTextView.getLayout();
                if (layout2 != null && offset2 != anotherHandleOffset) {
                    float horiz = this.getHorizontal(layout2, offset2);
                    float anotherHandleHoriz = this.getHorizontal(layout2, anotherHandleOffset, !this.isStartHandle());
                    float currentHoriz = this.getHorizontal(layout2, this.mPreviousOffset);
                    if (currentHoriz < anotherHandleHoriz && horiz < anotherHandleHoriz || currentHoriz > anotherHandleHoriz && horiz > anotherHandleHoriz) {
                        int currentOffset = this.getCurrentCursorOffset();
                        int offsetToGetRunRange = this.isStartHandle() ? currentOffset : Math.max(currentOffset - 1, 0);
                        long range = layout2.getRunRange(offsetToGetRunRange);
                        offset2 = this.isStartHandle() ? TextUtils.unpackRangeStartFromLong(range) : TextUtils.unpackRangeEndFromLong(range);
                        this.positionAtCursorOffset(offset2, false, fromTouchScreen);
                        return;
                    }
                }
                offset2 = Editor.this.getNextCursorOffset(anotherHandleOffset, !this.isStartHandle());
            }
            this.positionAtCursorOffset(offset2, false, fromTouchScreen);
        }

        private boolean positionNearEdgeOfScrollingView(float x, boolean atRtl) {
            int leftEdge;
            int rightEdge;
            Editor.this.mTextView.getLocationOnScreen(this.mTextViewLocation);
            boolean nearEdge = atRtl == this.isStartHandle() ? x > (float)(rightEdge = this.mTextViewLocation[0] + Editor.this.mTextView.getWidth() - Editor.this.mTextView.getPaddingRight()) - this.mTextViewEdgeSlop : x < (float)(leftEdge = this.mTextViewLocation[0] + Editor.this.mTextView.getPaddingLeft()) + this.mTextViewEdgeSlop;
            return nearEdge;
        }

        @Override
        protected boolean isAtRtlRun(Layout layout2, int offset2) {
            int offsetToCheck = this.isStartHandle() ? offset2 : Math.max(offset2 - 1, 0);
            return layout2.isRtlCharAt(offsetToCheck);
        }

        @Override
        public float getHorizontal(Layout layout2, int offset2) {
            return this.getHorizontal(layout2, offset2, this.isStartHandle());
        }

        private float getHorizontal(Layout layout2, int offset2, boolean startHandle) {
            int line = layout2.getLineForOffset(offset2);
            int offsetToCheck = startHandle ? offset2 : Math.max(offset2 - 1, 0);
            boolean isRtlChar = layout2.isRtlCharAt(offsetToCheck);
            boolean isRtlParagraph = layout2.getParagraphDirection(line) == -1;
            return isRtlChar == isRtlParagraph ? layout2.getPrimaryHorizontal(offset2) : layout2.getSecondaryHorizontal(offset2);
        }

        @Override
        protected int getOffsetAtCoordinate(Layout layout2, int line, float x) {
            int secondaryDiff;
            float localX = Editor.this.mTextView.convertToLocalHorizontalCoordinate(x);
            int primaryOffset = layout2.getOffsetForHorizontal(line, localX, true);
            if (!layout2.isLevelBoundary(primaryOffset)) {
                return primaryOffset;
            }
            int secondaryOffset = layout2.getOffsetForHorizontal(line, localX, false);
            int currentOffset = this.getCurrentCursorOffset();
            int primaryDiff = Math.abs(primaryOffset - currentOffset);
            if (primaryDiff < (secondaryDiff = Math.abs(secondaryOffset - currentOffset))) {
                return primaryOffset;
            }
            if (primaryDiff > secondaryDiff) {
                return secondaryOffset;
            }
            int offsetToCheck = this.isStartHandle() ? currentOffset : Math.max(currentOffset - 1, 0);
            boolean isRtlChar = layout2.isRtlCharAt(offsetToCheck);
            boolean isRtlParagraph = layout2.getParagraphDirection(line) == -1;
            return isRtlChar == isRtlParagraph ? primaryOffset : secondaryOffset;
        }

        @Override
        protected int getMagnifierHandleTrigger() {
            return this.isStartHandle() ? 1 : 2;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HandleType {
    }

    private class InsertionHandleView
    extends HandleView {
        private float mLastDownRawX;
        private float mLastDownRawY;
        private Runnable mHider;
        private boolean mIsTouchDown;
        private boolean mPendingDismissOnUp;
        private final int mDrawableOpacity;
        private float mTouchDownX;
        private float mTouchDownY;
        private int mOffsetDown;
        private boolean mOffsetChanged;
        private boolean mIsInActionMode;
        private long mLastUpTime;
        private final int mDeltaHeight;

        InsertionHandleView(Drawable drawable2) {
            super(drawable2, drawable2, 16909094);
            this.mIsTouchDown = false;
            this.mPendingDismissOnUp = false;
            int deltaHeight = 0;
            int opacity = 255;
            if (Editor.this.mFlagInsertionHandleGesturesEnabled) {
                deltaHeight = AppGlobals.getIntCoreSetting("widget__insertion_handle_delta_height", 25);
                opacity = AppGlobals.getIntCoreSetting("widget__insertion_handle_opacity", 50);
                if (deltaHeight < -25 || deltaHeight > 50) {
                    deltaHeight = 25;
                }
                if (opacity < 10 || opacity > 100) {
                    opacity = 50;
                }
                opacity = opacity * 255 / 100;
            }
            this.mDeltaHeight = deltaHeight;
            this.mDrawableOpacity = opacity;
        }

        private void hideAfterDelay() {
            if (this.mHider == null) {
                this.mHider = new Runnable(){

                    @Override
                    public void run() {
                        InsertionHandleView.this.hide();
                    }
                };
            } else {
                this.removeHiderCallback();
            }
            Editor.this.mTextView.postDelayed(this.mHider, 4000L);
        }

        private void removeHiderCallback() {
            if (this.mHider != null) {
                Editor.this.mTextView.removeCallbacks(this.mHider);
            }
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            return drawable2.getIntrinsicWidth() / 2;
        }

        @Override
        protected int getHorizontalGravity(boolean isRtlRun) {
            return 1;
        }

        @Override
        protected int getCursorOffset() {
            int offset2 = super.getCursorOffset();
            if (Editor.this.mDrawableForCursor != null) {
                Editor.this.mDrawableForCursor.getPadding(Editor.this.mTempRect);
                offset2 += (Editor.this.mDrawableForCursor.getIntrinsicWidth() - ((Editor)Editor.this).mTempRect.left - ((Editor)Editor.this).mTempRect.right) / 2;
            }
            return offset2;
        }

        @Override
        int getCursorHorizontalPosition(Layout layout2, int offset2) {
            if (Editor.this.mDrawableForCursor != null) {
                float horizontal = this.getHorizontal(layout2, offset2);
                return Editor.this.clampHorizontalPosition(Editor.this.mDrawableForCursor, horizontal) + ((Editor)Editor.this).mTempRect.left;
            }
            return super.getCursorHorizontalPosition(layout2, offset2);
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (Editor.this.mFlagInsertionHandleGesturesEnabled) {
                int height = Math.max(this.getPreferredHeight() + this.mDeltaHeight, this.mDrawable.getIntrinsicHeight());
                this.setMeasuredDimension(this.getPreferredWidth(), height);
                return;
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean onTouchEvent(MotionEvent ev) {
            if (!Editor.access$300(Editor.this).isFromPrimePointer(ev, true)) {
                return true;
            }
            if (Editor.access$6400(Editor.this) && Editor.access$6500(Editor.this)) {
                return this.touchThrough(ev);
            }
            result = super.onTouchEvent(ev);
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mLastDownRawX = ev.getRawX();
                    this.mLastDownRawY = ev.getRawY();
                    this.updateMagnifier(ev);
                    break;
                }
                case 2: {
                    this.updateMagnifier(ev);
                    break;
                }
                case 1: {
                    if (this.offsetHasBeenChanged()) ** GOTO lbl22
                    config = ViewConfiguration.get(Editor.access$300(Editor.this).getContext());
                    isWithinTouchSlop = EditorTouchState.isDistanceWithin(this.mLastDownRawX, this.mLastDownRawY, ev.getRawX(), ev.getRawY(), config.getScaledTouchSlop());
                    if (isWithinTouchSlop) {
                        Editor.access$6600(Editor.this);
                    }
                    ** GOTO lbl24
lbl22:
                    // 1 sources

                    if (Editor.access$500(Editor.this) != null) {
                        Editor.access$500(Editor.this).invalidateContentRect();
                    }
                }
lbl24:
                // 5 sources

                case 3: {
                    this.hideAfterDelay();
                    this.dismissMagnifier();
                    break;
                }
            }
            return result;
        }

        private boolean touchThrough(MotionEvent ev) {
            int end;
            int start;
            int actionType = ev.getActionMasked();
            switch (actionType) {
                case 0: {
                    this.mIsTouchDown = true;
                    this.mOffsetChanged = false;
                    this.mOffsetDown = Editor.this.mTextView.getSelectionStart();
                    this.mTouchDownX = ev.getX();
                    this.mTouchDownY = ev.getY();
                    boolean bl = this.mIsInActionMode = Editor.this.mTextActionMode != null;
                    if (ev.getEventTime() - this.mLastUpTime < (long)ViewConfiguration.getDoubleTapTimeout()) {
                        Editor.this.stopTextActionMode();
                    }
                    Editor.this.mTouchState.setIsOnHandle(true);
                    break;
                }
                case 1: {
                    this.mLastUpTime = ev.getEventTime();
                }
            }
            boolean ret = Editor.this.mTextView.onTouchEvent(this.transformEventForTouchThrough(ev));
            if (actionType == 1 || actionType == 3) {
                this.mIsTouchDown = false;
                if (this.mPendingDismissOnUp) {
                    this.dismiss();
                }
                Editor.this.mTouchState.setIsOnHandle(false);
            }
            if (!(this.mOffsetChanged || (start = Editor.this.mTextView.getSelectionStart()) == (end = Editor.this.mTextView.getSelectionEnd()) && this.mOffsetDown == start)) {
                this.mOffsetChanged = true;
            }
            if (!this.mOffsetChanged && actionType == 1) {
                if (this.mIsInActionMode) {
                    Editor.this.stopTextActionMode();
                } else {
                    Editor.this.startInsertionActionMode();
                }
            }
            return ret;
        }

        private MotionEvent transformEventForTouchThrough(MotionEvent ev) {
            Layout layout2 = Editor.this.mTextView.getLayout();
            int line = layout2.getLineForOffset(this.getCurrentCursorOffset());
            int textHeight = layout2.getLineBottomWithoutSpacing(line) - layout2.getLineTop(line);
            Matrix m = new Matrix();
            m.setTranslate(ev.getRawX() - ev.getX() + (float)(this.getMeasuredWidth() >> 1) - this.mTouchDownX, ev.getRawY() - ev.getY() - (float)(textHeight >> 1) - this.mTouchDownY);
            ev.transform(m);
            Editor.this.mTextView.toLocalMotionEvent(ev);
            return ev;
        }

        @Override
        public boolean isShowing() {
            if (this.mPendingDismissOnUp) {
                return false;
            }
            return super.isShowing();
        }

        @Override
        public void show() {
            super.show();
            this.mPendingDismissOnUp = false;
            this.mDrawable.setAlpha(this.mDrawableOpacity);
        }

        @Override
        public void dismiss() {
            if (this.mIsTouchDown) {
                this.mPendingDismissOnUp = true;
                this.mDrawable.setAlpha(0);
            } else {
                super.dismiss();
                this.mPendingDismissOnUp = false;
            }
        }

        @Override
        protected void updateDrawable(boolean updateDrawableWhenDragging) {
            super.updateDrawable(updateDrawableWhenDragging);
            this.mDrawable.setAlpha(this.mDrawableOpacity);
        }

        @Override
        public int getCurrentCursorOffset() {
            return Editor.this.mTextView.getSelectionStart();
        }

        @Override
        public void updateSelection(int offset2) {
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), offset2);
        }

        @Override
        protected void updatePosition(float x, float y, boolean fromTouchScreen) {
            int offset2;
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 != null) {
                if (this.mPreviousLineTouched == -1) {
                    this.mPreviousLineTouched = Editor.this.mTextView.getLineAtCoordinate(y);
                }
                int currLine = Editor.this.getCurrentLineAdjustedForSlop(layout2, this.mPreviousLineTouched, y);
                offset2 = this.getOffsetAtCoordinate(layout2, currLine, x);
                this.mPreviousLineTouched = currLine;
            } else {
                offset2 = -1;
            }
            this.positionAtCursorOffset(offset2, false, fromTouchScreen);
            if (Editor.this.mTextActionMode != null) {
                Editor.this.invalidateActionMode();
            }
        }

        @Override
        void onHandleMoved() {
            super.onHandleMoved();
            this.removeHiderCallback();
        }

        @Override
        public void onDetached() {
            super.onDetached();
            this.removeHiderCallback();
        }

        @Override
        protected int getMagnifierHandleTrigger() {
            return 0;
        }
    }

    @VisibleForTesting
    public abstract class HandleView
    extends View
    implements TextViewPositionListener {
        protected Drawable mDrawable;
        protected Drawable mDrawableLtr;
        protected Drawable mDrawableRtl;
        private final PopupWindow mContainer;
        private int mPositionX;
        private int mPositionY;
        private boolean mIsDragging;
        private float mTouchToWindowOffsetX;
        private float mTouchToWindowOffsetY;
        protected int mHotspotX;
        protected int mHorizontalGravity;
        private float mTouchOffsetY;
        private final float mIdealVerticalOffset;
        private int mLastParentX;
        private int mLastParentY;
        private int mLastParentXOnScreen;
        private int mLastParentYOnScreen;
        protected int mPreviousOffset;
        private boolean mPositionHasChanged;
        private int mMinSize;
        protected int mPrevLine;
        protected int mPreviousLineTouched;
        private float mCurrentDragInitialTouchRawX;
        private float mTextViewScaleX;
        private float mTextViewScaleY;
        private final int mIdealFingerToCursorOffset;
        private static final int HISTORY_SIZE = 5;
        private static final int TOUCH_UP_FILTER_DELAY_AFTER = 150;
        private static final int TOUCH_UP_FILTER_DELAY_BEFORE = 350;
        private final long[] mPreviousOffsetsTimes;
        private final int[] mPreviousOffsets;
        private int mPreviousOffsetIndex;
        private int mNumberPreviousOffsets;

        private HandleView(Drawable drawableLtr, Drawable drawableRtl, int id2) {
            super(Editor.this.mTextView.getContext());
            this.mPreviousOffset = -1;
            this.mPositionHasChanged = true;
            this.mPrevLine = -1;
            this.mPreviousLineTouched = -1;
            this.mCurrentDragInitialTouchRawX = -1.0f;
            this.mPreviousOffsetsTimes = new long[5];
            this.mPreviousOffsets = new int[5];
            this.mPreviousOffsetIndex = 0;
            this.mNumberPreviousOffsets = 0;
            this.setId(id2);
            this.mContainer = new PopupWindow(Editor.this.mTextView.getContext(), null, 16843464);
            this.mContainer.setSplitTouchEnabled(true);
            this.mContainer.setClippingEnabled(false);
            this.mContainer.setWindowLayoutType(1002);
            this.mContainer.setWidth(-2);
            this.mContainer.setHeight(-2);
            this.mContainer.setContentView(this);
            this.setDrawables(drawableLtr, drawableRtl);
            this.mMinSize = Editor.this.mTextView.getContext().getResources().getDimensionPixelSize(17105538);
            int handleHeight = this.getPreferredHeight();
            this.mTouchOffsetY = -0.3f * (float)handleHeight;
            int distance = AppGlobals.getIntCoreSetting("widget__finger_to_cursor_distance", -1);
            if (distance < 0 || distance > 100) {
                this.mIdealVerticalOffset = 0.7f * (float)handleHeight;
                this.mIdealFingerToCursorOffset = (int)(this.mIdealVerticalOffset - this.mTouchOffsetY);
            } else {
                this.mIdealFingerToCursorOffset = (int)TypedValue.applyDimension(1, distance, Editor.this.mTextView.getContext().getResources().getDisplayMetrics());
                this.mIdealVerticalOffset = (float)this.mIdealFingerToCursorOffset + this.mTouchOffsetY;
            }
        }

        public float getIdealVerticalOffset() {
            return this.mIdealVerticalOffset;
        }

        int getIdealFingerToCursorOffset() {
            return this.mIdealFingerToCursorOffset;
        }

        void setDrawables(Drawable drawableLtr, Drawable drawableRtl) {
            this.mDrawableLtr = drawableLtr;
            this.mDrawableRtl = drawableRtl;
            this.updateDrawable(true);
        }

        protected void updateDrawable(boolean updateDrawableWhenDragging) {
            if (!updateDrawableWhenDragging && this.mIsDragging) {
                return;
            }
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                return;
            }
            int offset2 = this.getCurrentCursorOffset();
            boolean isRtlCharAtOffset = this.isAtRtlRun(layout2, offset2);
            Drawable oldDrawable = this.mDrawable;
            this.mDrawable = isRtlCharAtOffset ? this.mDrawableRtl : this.mDrawableLtr;
            this.mHotspotX = this.getHotspotX(this.mDrawable, isRtlCharAtOffset);
            this.mHorizontalGravity = this.getHorizontalGravity(isRtlCharAtOffset);
            if (oldDrawable != this.mDrawable && this.isShowing()) {
                this.mPositionX = this.getCursorHorizontalPosition(layout2, offset2) - this.mHotspotX - this.getHorizontalOffset() + this.getCursorOffset();
                this.mPositionX += Editor.this.mTextView.viewportToContentHorizontalOffset();
                this.mPositionHasChanged = true;
                this.updatePosition(this.mLastParentX, this.mLastParentY, false, false);
                this.postInvalidate();
            }
        }

        protected abstract int getHotspotX(Drawable var1, boolean var2);

        protected abstract int getHorizontalGravity(boolean var1);

        private void startTouchUpFilter(int offset2) {
            this.mNumberPreviousOffsets = 0;
            this.addPositionToTouchUpFilter(offset2);
        }

        private void addPositionToTouchUpFilter(int offset2) {
            this.mPreviousOffsetIndex = (this.mPreviousOffsetIndex + 1) % 5;
            this.mPreviousOffsets[this.mPreviousOffsetIndex] = offset2;
            this.mPreviousOffsetsTimes[this.mPreviousOffsetIndex] = SystemClock.uptimeMillis();
            ++this.mNumberPreviousOffsets;
        }

        private void filterOnTouchUp(boolean fromTouchScreen) {
            long now = SystemClock.uptimeMillis();
            int i = 0;
            int index = this.mPreviousOffsetIndex;
            int iMax = Math.min(this.mNumberPreviousOffsets, 5);
            while (i < iMax && now - this.mPreviousOffsetsTimes[index] < 150L) {
                index = (this.mPreviousOffsetIndex - ++i + 5) % 5;
            }
            if (i > 0 && i < iMax && now - this.mPreviousOffsetsTimes[index] > 350L) {
                this.positionAtCursorOffset(this.mPreviousOffsets[index], false, fromTouchScreen);
            }
        }

        public boolean offsetHasBeenChanged() {
            return this.mNumberPreviousOffsets > 1;
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(this.getPreferredWidth(), this.getPreferredHeight());
        }

        @Override
        public void invalidate() {
            super.invalidate();
            if (this.isShowing()) {
                this.positionAtCursorOffset(this.getCurrentCursorOffset(), true, false);
            }
        }

        protected int getPreferredWidth() {
            return Math.max(this.mDrawable.getIntrinsicWidth(), this.mMinSize);
        }

        protected int getPreferredHeight() {
            return Math.max(this.mDrawable.getIntrinsicHeight(), this.mMinSize);
        }

        public void show() {
            if (this.isShowing()) {
                return;
            }
            Editor.this.getPositionListener().addSubscriber(this, true);
            this.mPreviousOffset = -1;
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), false, false);
        }

        protected void dismiss() {
            this.mIsDragging = false;
            this.mContainer.dismiss();
            this.onDetached();
        }

        public void hide() {
            this.dismiss();
            Editor.this.getPositionListener().removeSubscriber(this);
        }

        public boolean isShowing() {
            return this.mContainer.isShowing();
        }

        private boolean shouldShow() {
            if (this.mIsDragging) {
                return true;
            }
            if (Editor.this.mTextView.isInBatchEditMode()) {
                return false;
            }
            return Editor.this.mTextView.isPositionVisible(this.mPositionX + this.mHotspotX + this.getHorizontalOffset(), this.mPositionY);
        }

        private void setVisible(boolean visible) {
            this.mContainer.getContentView().setVisibility(visible ? 0 : 4);
        }

        public abstract int getCurrentCursorOffset();

        protected abstract void updateSelection(int var1);

        protected abstract void updatePosition(float var1, float var2, boolean var3);

        protected abstract int getMagnifierHandleTrigger();

        protected boolean isAtRtlRun(Layout layout2, int offset2) {
            return layout2.isRtlCharAt(offset2);
        }

        @VisibleForTesting
        public float getHorizontal(Layout layout2, int offset2) {
            return layout2.getPrimaryHorizontal(offset2);
        }

        protected int getOffsetAtCoordinate(Layout layout2, int line, float x) {
            return Editor.this.mTextView.getOffsetAtCoordinate(line, x);
        }

        protected void positionAtCursorOffset(int offset2, boolean forceUpdatePosition, boolean fromTouchScreen) {
            boolean offsetChanged;
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                Editor.this.prepareCursorControllers();
                return;
            }
            layout2 = Editor.this.mTextView.getLayout();
            boolean bl = offsetChanged = offset2 != this.mPreviousOffset;
            if (offsetChanged || forceUpdatePosition) {
                int line;
                if (offsetChanged) {
                    this.updateSelection(offset2);
                    if (fromTouchScreen && Editor.this.mHapticTextHandleEnabled) {
                        Editor.this.mTextView.performHapticFeedback(9);
                    }
                    this.addPositionToTouchUpFilter(offset2);
                }
                this.mPrevLine = line = layout2.getLineForOffset(offset2);
                this.mPositionX = this.getCursorHorizontalPosition(layout2, offset2) - this.mHotspotX - this.getHorizontalOffset() + this.getCursorOffset();
                this.mPositionY = layout2.getLineBottomWithoutSpacing(line);
                this.mPositionX += Editor.this.mTextView.viewportToContentHorizontalOffset();
                this.mPositionY += Editor.this.mTextView.viewportToContentVerticalOffset();
                this.mPreviousOffset = offset2;
                this.mPositionHasChanged = true;
            }
        }

        int getCursorHorizontalPosition(Layout layout2, int offset2) {
            return (int)(this.getHorizontal(layout2, offset2) - 0.5f);
        }

        @Override
        public void updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), parentScrolled, false);
            if (parentPositionChanged || this.mPositionHasChanged) {
                if (this.mIsDragging) {
                    if (parentPositionX != this.mLastParentX || parentPositionY != this.mLastParentY) {
                        this.mTouchToWindowOffsetX += (float)(parentPositionX - this.mLastParentX);
                        this.mTouchToWindowOffsetY += (float)(parentPositionY - this.mLastParentY);
                        this.mLastParentX = parentPositionX;
                        this.mLastParentY = parentPositionY;
                    }
                    this.onHandleMoved();
                }
                if (this.shouldShow()) {
                    int[] pts = new int[]{this.mPositionX + this.mHotspotX + this.getHorizontalOffset(), this.mPositionY};
                    Editor.this.mTextView.transformFromViewToWindowSpace(pts);
                    pts[0] = pts[0] - (this.mHotspotX + this.getHorizontalOffset());
                    if (this.isShowing()) {
                        this.mContainer.update(pts[0], pts[1], -1, -1);
                    } else {
                        this.mContainer.showAtLocation(Editor.this.mTextView, 0, pts[0], pts[1]);
                    }
                } else if (this.isShowing()) {
                    this.dismiss();
                }
                this.mPositionHasChanged = false;
            }
        }

        @Override
        protected void onDraw(Canvas c) {
            int drawWidth = this.mDrawable.getIntrinsicWidth();
            int left = this.getHorizontalOffset();
            this.mDrawable.setBounds(left, 0, left + drawWidth, this.mDrawable.getIntrinsicHeight());
            this.mDrawable.draw(c);
        }

        private int getHorizontalOffset() {
            int left;
            int width = this.getPreferredWidth();
            int drawWidth = this.mDrawable.getIntrinsicWidth();
            switch (this.mHorizontalGravity) {
                case 3: {
                    left = 0;
                    break;
                }
                default: {
                    left = (width - drawWidth) / 2;
                    break;
                }
                case 5: {
                    left = width - drawWidth;
                }
            }
            return left;
        }

        protected int getCursorOffset() {
            return 0;
        }

        private boolean tooLargeTextForMagnifier() {
            if (Editor.this.mNewMagnifierEnabled) {
                int line;
                Layout layout2 = Editor.this.mTextView.getLayout();
                return layout2.getLineBottomWithoutSpacing(line = layout2.getLineForOffset(this.getCurrentCursorOffset())) - layout2.getLineTop(line) >= Editor.this.mMaxLineHeightForMagnifier;
            }
            float magnifierContentHeight = Math.round((float)Editor.this.mMagnifierAnimator.mMagnifier.getHeight() / Editor.this.mMagnifierAnimator.mMagnifier.getZoom());
            Paint.FontMetrics fontMetrics = Editor.this.mTextView.getPaint().getFontMetrics();
            float glyphHeight = fontMetrics.descent - fontMetrics.ascent;
            return glyphHeight * this.mTextViewScaleY > magnifierContentHeight;
        }

        private boolean checkForTransforms() {
            if (Editor.this.mMagnifierAnimator.mMagnifierIsShowing) {
                return true;
            }
            if (Editor.this.mTextView.getRotation() != 0.0f || Editor.this.mTextView.getRotationX() != 0.0f || Editor.this.mTextView.getRotationY() != 0.0f) {
                return false;
            }
            this.mTextViewScaleX = Editor.this.mTextView.getScaleX();
            this.mTextViewScaleY = Editor.this.mTextView.getScaleY();
            for (ViewParent viewParent = Editor.this.mTextView.getParent(); viewParent != null; viewParent = viewParent.getParent()) {
                if (!(viewParent instanceof View)) continue;
                View view = (View)((Object)viewParent);
                if (view.getRotation() != 0.0f || view.getRotationX() != 0.0f || view.getRotationY() != 0.0f) {
                    return false;
                }
                this.mTextViewScaleX *= view.getScaleX();
                this.mTextViewScaleY *= view.getScaleY();
            }
            return true;
        }

        private boolean obtainMagnifierShowCoordinates(MotionEvent event, PointF showPosInView) {
            float rightBound;
            float leftBound;
            boolean sameLineSelection;
            int otherHandleOffset;
            int offset2;
            int trigger = this.getMagnifierHandleTrigger();
            switch (trigger) {
                case 0: {
                    offset2 = Editor.this.mTextView.getSelectionStart();
                    otherHandleOffset = -1;
                    break;
                }
                case 1: {
                    offset2 = Editor.this.mTextView.getSelectionStart();
                    otherHandleOffset = Editor.this.mTextView.getSelectionEnd();
                    break;
                }
                case 2: {
                    offset2 = Editor.this.mTextView.getSelectionEnd();
                    otherHandleOffset = Editor.this.mTextView.getSelectionStart();
                    break;
                }
                default: {
                    offset2 = -1;
                    otherHandleOffset = -1;
                }
            }
            if (offset2 == -1) {
                return false;
            }
            if (event.getActionMasked() == 0) {
                this.mCurrentDragInitialTouchRawX = event.getRawX();
            } else if (event.getActionMasked() == 1) {
                this.mCurrentDragInitialTouchRawX = -1.0f;
            }
            Layout layout2 = Editor.this.mTextView.getLayout();
            int lineNumber = layout2.getLineForOffset(offset2);
            boolean bl = sameLineSelection = otherHandleOffset != -1 && lineNumber == layout2.getLineForOffset(otherHandleOffset);
            boolean rtl = sameLineSelection && offset2 < otherHandleOffset != this.getHorizontal(Editor.this.mTextView.getLayout(), offset2) < this.getHorizontal(Editor.this.mTextView.getLayout(), otherHandleOffset);
            int[] textViewLocationOnScreen = new int[2];
            Editor.this.mTextView.getLocationOnScreen(textViewLocationOnScreen);
            float touchXInView = event.getRawX() - (float)textViewLocationOnScreen[0];
            if (Editor.this.mNewMagnifierEnabled) {
                leftBound = 0.0f;
                rightBound = Editor.this.mTextView.getWidth();
                if (touchXInView < leftBound || touchXInView > rightBound) {
                    return false;
                }
            } else {
                leftBound = Editor.this.mTextView.getTotalPaddingLeft() - Editor.this.mTextView.getScrollX();
                rightBound = Editor.this.mTextView.getTotalPaddingLeft() - Editor.this.mTextView.getScrollX();
                leftBound = sameLineSelection && trigger == 2 ^ rtl ? (leftBound += this.getHorizontal(Editor.this.mTextView.getLayout(), otherHandleOffset)) : (leftBound += Editor.this.mTextView.getLayout().getLineLeft(lineNumber));
                rightBound = sameLineSelection && trigger == 1 ^ rtl ? (rightBound += this.getHorizontal(Editor.this.mTextView.getLayout(), otherHandleOffset)) : (rightBound += Editor.this.mTextView.getLayout().getLineRight(lineNumber));
                rightBound *= this.mTextViewScaleX;
                float contentWidth = Math.round((float)Editor.this.mMagnifierAnimator.mMagnifier.getWidth() / Editor.this.mMagnifierAnimator.mMagnifier.getZoom());
                if (touchXInView < (leftBound *= this.mTextViewScaleX) - contentWidth / 2.0f || touchXInView > rightBound + contentWidth / 2.0f) {
                    return false;
                }
            }
            float scaledTouchXInView = this.mTextViewScaleX == 1.0f ? touchXInView : (event.getRawX() - this.mCurrentDragInitialTouchRawX) * this.mTextViewScaleX + this.mCurrentDragInitialTouchRawX - (float)textViewLocationOnScreen[0];
            showPosInView.x = Math.max(leftBound, Math.min(rightBound, scaledTouchXInView));
            showPosInView.y = ((float)(Editor.this.mTextView.getLayout().getLineTop(lineNumber) + Editor.this.mTextView.getLayout().getLineBottomWithoutSpacing(lineNumber)) / 2.0f + (float)Editor.this.mTextView.getTotalPaddingTop() - (float)Editor.this.mTextView.getScrollY()) * this.mTextViewScaleY;
            return true;
        }

        private boolean handleOverlapsMagnifier(HandleView handle, Rect magnifierRect) {
            PopupWindow window = handle.mContainer;
            if (!window.hasDecorView()) {
                return false;
            }
            Rect handleRect = new Rect(window.getDecorViewLayoutParams().x, window.getDecorViewLayoutParams().y, window.getDecorViewLayoutParams().x + window.getContentView().getWidth(), window.getDecorViewLayoutParams().y + window.getContentView().getHeight());
            return Rect.intersects(handleRect, magnifierRect);
        }

        private HandleView getOtherSelectionHandle() {
            SelectionModifierCursorController controller = Editor.this.getSelectionController();
            if (controller == null || !controller.isActive()) {
                return null;
            }
            return controller.mStartHandle != this ? controller.mStartHandle : controller.mEndHandle;
        }

        private void updateHandlesVisibility() {
            Point magnifierTopLeft = Editor.this.mMagnifierAnimator.mMagnifier.getPosition();
            if (magnifierTopLeft == null) {
                return;
            }
            Rect magnifierRect = new Rect(magnifierTopLeft.x, magnifierTopLeft.y, magnifierTopLeft.x + Editor.this.mMagnifierAnimator.mMagnifier.getWidth(), magnifierTopLeft.y + Editor.this.mMagnifierAnimator.mMagnifier.getHeight());
            this.setVisible(!this.handleOverlapsMagnifier(this, magnifierRect) && !Editor.this.mDrawCursorOnMagnifier);
            HandleView otherHandle = this.getOtherSelectionHandle();
            if (otherHandle != null) {
                otherHandle.setVisible(!this.handleOverlapsMagnifier(otherHandle, magnifierRect));
            }
        }

        protected void updateMagnifier(MotionEvent event) {
            boolean shouldShow;
            if (Editor.this.getMagnifierAnimator() == null) {
                return;
            }
            PointF showPosInView = new PointF();
            boolean bl = shouldShow = this.checkForTransforms() && !this.tooLargeTextForMagnifier() && this.obtainMagnifierShowCoordinates(event, showPosInView);
            if (shouldShow) {
                Editor.this.mRenderCursorRegardlessTiming = true;
                Editor.this.mTextView.invalidateCursorPath();
                Editor.this.suspendBlink();
                if (Editor.this.mNewMagnifierEnabled) {
                    Layout layout2 = Editor.this.mTextView.getLayout();
                    int line = layout2.getLineForOffset(this.getCurrentCursorOffset());
                    int lineLeft = (int)layout2.getLineLeft(line);
                    int lineRight = (int)layout2.getLineRight(line);
                    Editor.this.mDrawCursorOnMagnifier = showPosInView.x < (float)((lineLeft += Editor.this.mTextView.getTotalPaddingLeft() - Editor.this.mTextView.getScrollX()) - 20) || showPosInView.x > (float)((lineRight += Editor.this.mTextView.getTotalPaddingLeft() - Editor.this.mTextView.getScrollX()) + 20);
                    Editor.this.mMagnifierAnimator.mMagnifier.setDrawCursor(Editor.this.mDrawCursorOnMagnifier, Editor.this.mDrawableForCursor);
                    boolean cursorVisible = Editor.this.mCursorVisible;
                    boolean bl2 = Editor.this.mCursorVisible = !Editor.this.mDrawCursorOnMagnifier;
                    if (Editor.this.mCursorVisible && !cursorVisible) {
                        Editor.this.updateCursorPosition();
                    }
                    int lineHeight = layout2.getLineBottomWithoutSpacing(line) - layout2.getLineTop(line);
                    float zoom = Editor.this.mInitialZoom;
                    if (lineHeight < Editor.this.mMinLineHeightForMagnifier) {
                        zoom = zoom * (float)Editor.this.mMinLineHeightForMagnifier / (float)lineHeight;
                    }
                    Editor.this.mMagnifierAnimator.mMagnifier.updateSourceFactors(lineHeight, zoom);
                    Editor.this.mMagnifierAnimator.mMagnifier.show(showPosInView.x, showPosInView.y);
                } else {
                    Editor.this.mMagnifierAnimator.show(showPosInView.x, showPosInView.y);
                }
                this.updateHandlesVisibility();
            } else {
                this.dismissMagnifier();
            }
        }

        protected void dismissMagnifier() {
            if (Editor.this.mMagnifierAnimator != null) {
                Editor.this.mMagnifierAnimator.dismiss();
                Editor.this.mRenderCursorRegardlessTiming = false;
                Editor.this.mDrawCursorOnMagnifier = false;
                if (!Editor.this.mCursorVisible) {
                    Editor.this.mCursorVisible = true;
                    Editor.this.mTextView.invalidate();
                }
                Editor.this.resumeBlink();
                this.setVisible(true);
                HandleView otherHandle = this.getOtherSelectionHandle();
                if (otherHandle != null) {
                    otherHandle.setVisible(true);
                }
            }
        }

        @Override
        public boolean onTouchEvent(MotionEvent ev) {
            Editor.this.updateFloatingToolbarVisibility(ev);
            switch (ev.getActionMasked()) {
                case 0: {
                    this.startTouchUpFilter(this.getCurrentCursorOffset());
                    PositionListener positionListener = Editor.this.getPositionListener();
                    this.mLastParentX = positionListener.getPositionX();
                    this.mLastParentY = positionListener.getPositionY();
                    this.mLastParentXOnScreen = positionListener.getPositionXOnScreen();
                    this.mLastParentYOnScreen = positionListener.getPositionYOnScreen();
                    float xInWindow = ev.getRawX() - (float)this.mLastParentXOnScreen + (float)this.mLastParentX;
                    float yInWindow = ev.getRawY() - (float)this.mLastParentYOnScreen + (float)this.mLastParentY;
                    this.mTouchToWindowOffsetX = xInWindow - (float)this.mPositionX;
                    this.mTouchToWindowOffsetY = yInWindow - (float)this.mPositionY;
                    this.mIsDragging = true;
                    this.mPreviousLineTouched = -1;
                    break;
                }
                case 2: {
                    float newVerticalOffset;
                    float xInWindow = ev.getRawX() - (float)this.mLastParentXOnScreen + (float)this.mLastParentX;
                    float yInWindow = ev.getRawY() - (float)this.mLastParentYOnScreen + (float)this.mLastParentY;
                    float previousVerticalOffset = this.mTouchToWindowOffsetY - (float)this.mLastParentY;
                    float currentVerticalOffset = yInWindow - (float)this.mPositionY - (float)this.mLastParentY;
                    if (previousVerticalOffset < this.mIdealVerticalOffset) {
                        newVerticalOffset = Math.min(currentVerticalOffset, this.mIdealVerticalOffset);
                        newVerticalOffset = Math.max(newVerticalOffset, previousVerticalOffset);
                    } else {
                        newVerticalOffset = Math.max(currentVerticalOffset, this.mIdealVerticalOffset);
                        newVerticalOffset = Math.min(newVerticalOffset, previousVerticalOffset);
                    }
                    this.mTouchToWindowOffsetY = newVerticalOffset + (float)this.mLastParentY;
                    float newPosX = xInWindow - this.mTouchToWindowOffsetX + (float)this.mHotspotX + (float)this.getHorizontalOffset();
                    float newPosY = yInWindow - this.mTouchToWindowOffsetY + this.mTouchOffsetY;
                    this.updatePosition(newPosX, newPosY, ev.isFromSource(4098));
                    break;
                }
                case 1: {
                    this.filterOnTouchUp(ev.isFromSource(4098));
                }
                case 3: {
                    this.mIsDragging = false;
                    this.updateDrawable(false);
                }
            }
            return true;
        }

        public boolean isDragging() {
            return this.mIsDragging;
        }

        void onHandleMoved() {
        }

        public void onDetached() {
        }

        @Override
        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            this.setSystemGestureExclusionRects(Collections.singletonList(new Rect(0, 0, w, h)));
        }
    }

    private static class MagnifierMotionAnimator {
        private static final long DURATION = 100L;
        private final Magnifier mMagnifier;
        private final ValueAnimator mAnimator;
        private boolean mMagnifierIsShowing;
        private float mAnimationStartX;
        private float mAnimationStartY;
        private float mAnimationCurrentX;
        private float mAnimationCurrentY;
        private float mLastX;
        private float mLastY;

        private MagnifierMotionAnimator(Magnifier magnifier) {
            this.mMagnifier = magnifier;
            this.mAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mAnimator.setDuration(100L);
            this.mAnimator.setInterpolator(new LinearInterpolator());
            this.mAnimator.addUpdateListener(animation -> {
                this.mAnimationCurrentX = this.mAnimationStartX + (this.mLastX - this.mAnimationStartX) * animation.getAnimatedFraction();
                this.mAnimationCurrentY = this.mAnimationStartY + (this.mLastY - this.mAnimationStartY) * animation.getAnimatedFraction();
                this.mMagnifier.show(this.mAnimationCurrentX, this.mAnimationCurrentY);
            });
        }

        private void show(float x, float y) {
            boolean startNewAnimation;
            boolean bl = startNewAnimation = this.mMagnifierIsShowing && y != this.mLastY;
            if (startNewAnimation) {
                if (this.mAnimator.isRunning()) {
                    this.mAnimator.cancel();
                    this.mAnimationStartX = this.mAnimationCurrentX;
                    this.mAnimationStartY = this.mAnimationCurrentY;
                } else {
                    this.mAnimationStartX = this.mLastX;
                    this.mAnimationStartY = this.mLastY;
                }
                this.mAnimator.start();
            } else if (!this.mAnimator.isRunning()) {
                this.mMagnifier.show(x, y);
            }
            this.mLastX = x;
            this.mLastY = y;
            this.mMagnifierIsShowing = true;
        }

        private void update() {
            this.mMagnifier.update();
        }

        private void dismiss() {
            this.mMagnifier.dismiss();
            this.mAnimator.cancel();
            this.mMagnifierIsShowing = false;
        }
    }

    private class CursorAnchorInfoNotifier
    implements TextViewPositionListener {
        final CursorAnchorInfo.Builder mSelectionInfoBuilder = new CursorAnchorInfo.Builder();
        final int[] mTmpIntOffset = new int[2];
        final Matrix mViewToScreenMatrix = new Matrix();

        private CursorAnchorInfoNotifier() {
        }

        @Override
        public void updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            InputMethodState ims = Editor.this.mInputMethodState;
            if (ims == null || ims.mBatchEditNesting > 0) {
                return;
            }
            InputMethodManager imm = Editor.this.getInputMethodManager();
            if (null == imm) {
                return;
            }
            if (!imm.isActive(Editor.this.mTextView)) {
                return;
            }
            if (!imm.isCursorAnchorInfoEnabled()) {
                return;
            }
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                return;
            }
            CursorAnchorInfo.Builder builder2 = this.mSelectionInfoBuilder;
            builder2.reset();
            int selectionStart = Editor.this.mTextView.getSelectionStart();
            builder2.setSelectionRange(selectionStart, Editor.this.mTextView.getSelectionEnd());
            this.mViewToScreenMatrix.set(Editor.this.mTextView.getMatrix());
            Editor.this.mTextView.getLocationOnScreen(this.mTmpIntOffset);
            this.mViewToScreenMatrix.postTranslate(this.mTmpIntOffset[0], this.mTmpIntOffset[1]);
            builder2.setMatrix(this.mViewToScreenMatrix);
            float viewportToContentHorizontalOffset = Editor.this.mTextView.viewportToContentHorizontalOffset();
            float viewportToContentVerticalOffset = Editor.this.mTextView.viewportToContentVerticalOffset();
            CharSequence text = Editor.this.mTextView.getText();
            if (text instanceof Spannable) {
                boolean hasComposingText;
                Spannable sp = (Spannable)text;
                int composingTextStart = EditableInputConnection.getComposingSpanStart(sp);
                int composingTextEnd = EditableInputConnection.getComposingSpanEnd(sp);
                if (composingTextEnd < composingTextStart) {
                    int temp = composingTextEnd;
                    composingTextEnd = composingTextStart;
                    composingTextStart = temp;
                }
                boolean bl = hasComposingText = 0 <= composingTextStart && composingTextStart < composingTextEnd;
                if (hasComposingText) {
                    CharSequence composingText = text.subSequence(composingTextStart, composingTextEnd);
                    builder2.setComposingText(composingTextStart, composingText);
                    Editor.this.mTextView.populateCharacterBounds(builder2, composingTextStart, composingTextEnd, viewportToContentHorizontalOffset, viewportToContentVerticalOffset);
                }
            }
            if (0 <= selectionStart) {
                int offset2 = selectionStart;
                int line = layout2.getLineForOffset(offset2);
                float insertionMarkerX = layout2.getPrimaryHorizontal(offset2) + viewportToContentHorizontalOffset;
                float insertionMarkerTop = (float)layout2.getLineTop(line) + viewportToContentVerticalOffset;
                float insertionMarkerBaseline = (float)layout2.getLineBaseline(line) + viewportToContentVerticalOffset;
                float insertionMarkerBottom = (float)layout2.getLineBottomWithoutSpacing(line) + viewportToContentVerticalOffset;
                boolean isTopVisible = Editor.this.mTextView.isPositionVisible(insertionMarkerX, insertionMarkerTop);
                boolean isBottomVisible = Editor.this.mTextView.isPositionVisible(insertionMarkerX, insertionMarkerBottom);
                int insertionMarkerFlags = 0;
                if (isTopVisible || isBottomVisible) {
                    insertionMarkerFlags |= 1;
                }
                if (!isTopVisible || !isBottomVisible) {
                    insertionMarkerFlags |= 2;
                }
                if (layout2.isRtlCharAt(offset2)) {
                    insertionMarkerFlags |= 4;
                }
                builder2.setInsertionMarkerLocation(insertionMarkerX, insertionMarkerTop, insertionMarkerBaseline, insertionMarkerBottom, insertionMarkerFlags);
            }
            imm.updateCursorAnchorInfo(Editor.this.mTextView, builder2.build());
        }
    }

    private class TextActionModeCallback
    extends ActionMode.Callback2 {
        private final Path mSelectionPath = new Path();
        private final RectF mSelectionBounds = new RectF();
        private final boolean mHasSelection;
        private final int mHandleHeight;
        private final Map<MenuItem, View.OnClickListener> mAssistClickHandlers = new HashMap<MenuItem, View.OnClickListener>();
        private TextClassification mPrevTextClassification;

        TextActionModeCallback(int mode) {
            boolean bl = this.mHasSelection = mode == 0 || Editor.this.mTextIsSelectable && mode == 2;
            if (this.mHasSelection) {
                SelectionModifierCursorController selectionController = Editor.this.getSelectionController();
                if (selectionController.mStartHandle == null) {
                    Editor.this.loadHandleDrawables(false);
                    selectionController.initHandles();
                    selectionController.hide();
                }
                this.mHandleHeight = Math.max(Editor.this.mSelectHandleLeft.getMinimumHeight(), Editor.this.mSelectHandleRight.getMinimumHeight());
            } else {
                InsertionPointCursorController insertionController = Editor.this.getInsertionController();
                if (insertionController != null) {
                    insertionController.getHandle();
                    this.mHandleHeight = Editor.this.mSelectHandleCenter.getMinimumHeight();
                } else {
                    this.mHandleHeight = 0;
                }
            }
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            this.mAssistClickHandlers.clear();
            mode.setTitle(null);
            mode.setSubtitle(null);
            mode.setTitleOptionalHint(true);
            this.populateMenuWithItems(menu2);
            ActionMode.Callback customCallback = this.getCustomCallback();
            if (customCallback != null && !customCallback.onCreateActionMode(mode, menu2)) {
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), Editor.this.mTextView.getSelectionEnd());
                return false;
            }
            if (Editor.this.mTextView.canProcessText()) {
                Editor.this.mProcessTextIntentActionsHandler.onInitializeMenu(menu2);
            }
            if (this.mHasSelection && !Editor.this.mTextView.hasTransientState()) {
                Editor.this.mTextView.setHasTransientState(true);
            }
            return true;
        }

        private ActionMode.Callback getCustomCallback() {
            return this.mHasSelection ? Editor.this.mCustomSelectionActionModeCallback : Editor.this.mCustomInsertionActionModeCallback;
        }

        private void populateMenuWithItems(Menu menu2) {
            String selected;
            if (Editor.this.mTextView.canCut()) {
                menu2.add(0, 0x1020020, 4, 17039363).setAlphabeticShortcut('x').setShowAsAction(2);
            }
            if (Editor.this.mTextView.canCopy()) {
                menu2.add(0, 0x1020021, 5, 0x1040001).setAlphabeticShortcut('c').setShowAsAction(2);
            }
            if (Editor.this.mTextView.canPaste()) {
                menu2.add(0, 0x1020022, 6, 17039371).setAlphabeticShortcut('v').setShowAsAction(2);
            }
            if (Editor.this.mTextView.canShare()) {
                menu2.add(0, 16908341, 7, 17041385).setShowAsAction(1);
            }
            if (Editor.this.mTextView.canRequestAutofill() && ((selected = Editor.this.mTextView.getSelectedText()) == null || selected.isEmpty())) {
                menu2.add(0, 16908355, 10, 17039386).setShowAsAction(0);
            }
            if (Editor.this.mTextView.canPasteAsPlainText()) {
                menu2.add(0, 16908337, 11, 17039385).setShowAsAction(1);
            }
            this.updateSelectAllItem(menu2);
            this.updateReplaceItem(menu2);
            this.updateAssistMenuItems(menu2);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            this.updateSelectAllItem(menu2);
            this.updateReplaceItem(menu2);
            this.updateAssistMenuItems(menu2);
            ActionMode.Callback customCallback = this.getCustomCallback();
            if (customCallback != null) {
                return customCallback.onPrepareActionMode(mode, menu2);
            }
            return true;
        }

        private void updateSelectAllItem(Menu menu2) {
            boolean selectAllItemExists;
            boolean canSelectAll = Editor.this.mTextView.canSelectAllText();
            boolean bl = selectAllItemExists = menu2.findItem(16908319) != null;
            if (canSelectAll && !selectAllItemExists) {
                menu2.add(0, 16908319, 8, 17039373).setShowAsAction(1);
            } else if (!canSelectAll && selectAllItemExists) {
                menu2.removeItem(16908319);
            }
        }

        private void updateReplaceItem(Menu menu2) {
            boolean replaceItemExists;
            boolean canReplace = Editor.this.mTextView.isSuggestionsEnabled() && Editor.this.shouldOfferToShowSuggestions();
            boolean bl = replaceItemExists = menu2.findItem(16908340) != null;
            if (canReplace && !replaceItemExists) {
                menu2.add(0, 16908340, 9, 17041268).setShowAsAction(1);
            } else if (!canReplace && replaceItemExists) {
                menu2.removeItem(16908340);
            }
        }

        private void updateAssistMenuItems(Menu menu2) {
            MenuItem item;
            TextClassification textClassification = Editor.this.getSelectionActionModeHelper().getTextClassification();
            if (this.mPrevTextClassification == textClassification) {
                return;
            }
            this.clearAssistMenuItems(menu2);
            if (textClassification == null) {
                return;
            }
            if (!this.shouldEnableAssistMenuItems()) {
                return;
            }
            if (!textClassification.getActions().isEmpty()) {
                item = this.addAssistMenuItem(menu2, textClassification.getActions().get(0), 16908353, 0, 2);
                item.setIntent(textClassification.getIntent());
            } else if (this.hasLegacyAssistItem(textClassification)) {
                item = menu2.add(16908353, 16908353, 0, textClassification.getLabel()).setIcon(textClassification.getIcon()).setIntent(textClassification.getIntent());
                item.setShowAsAction(2);
                this.mAssistClickHandlers.put(item, TextClassification.createIntentOnClickListener(TextClassification.createPendingIntent(Editor.this.mTextView.getContext(), textClassification.getIntent(), this.createAssistMenuItemPendingIntentRequestCode())));
            }
            int count = textClassification.getActions().size();
            for (int i = 1; i < count; ++i) {
                this.addAssistMenuItem(menu2, textClassification.getActions().get(i), 0, 50 + i - 1, 0);
            }
            this.mPrevTextClassification = textClassification;
        }

        private MenuItem addAssistMenuItem(Menu menu2, RemoteAction action2, int itemId, int order, int showAsAction) {
            MenuItem item = menu2.add(16908353, itemId, order, action2.getTitle()).setContentDescription(action2.getContentDescription());
            if (action2.shouldShowIcon()) {
                item.setIcon(action2.getIcon().loadDrawable(Editor.this.mTextView.getContext()));
            }
            item.setShowAsAction(showAsAction);
            this.mAssistClickHandlers.put(item, TextClassification.createIntentOnClickListener(action2.getActionIntent()));
            return item;
        }

        private void clearAssistMenuItems(Menu menu2) {
            int i = 0;
            while (i < menu2.size()) {
                MenuItem menuItem = menu2.getItem(i);
                if (menuItem.getGroupId() == 16908353) {
                    menu2.removeItem(menuItem.getItemId());
                    continue;
                }
                ++i;
            }
        }

        private boolean hasLegacyAssistItem(TextClassification classification) {
            return !(classification.getIcon() == null && TextUtils.isEmpty(classification.getLabel()) || classification.getIntent() == null && classification.getOnClickListener() == null);
        }

        private boolean onAssistMenuItemClicked(MenuItem assistMenuItem) {
            Intent intent;
            Preconditions.checkArgument(assistMenuItem.getGroupId() == 16908353);
            TextClassification textClassification = Editor.this.getSelectionActionModeHelper().getTextClassification();
            if (!this.shouldEnableAssistMenuItems() || textClassification == null) {
                return true;
            }
            View.OnClickListener onClickListener = this.mAssistClickHandlers.get(assistMenuItem);
            if (onClickListener == null && (intent = assistMenuItem.getIntent()) != null) {
                onClickListener = TextClassification.createIntentOnClickListener(TextClassification.createPendingIntent(Editor.this.mTextView.getContext(), intent, this.createAssistMenuItemPendingIntentRequestCode()));
            }
            if (onClickListener != null) {
                onClickListener.onClick(Editor.this.mTextView);
                Editor.this.stopTextActionMode();
            }
            return true;
        }

        private int createAssistMenuItemPendingIntentRequestCode() {
            return Editor.this.mTextView.hasSelection() ? Editor.this.mTextView.getText().subSequence(Editor.this.mTextView.getSelectionStart(), Editor.this.mTextView.getSelectionEnd()).hashCode() : 0;
        }

        private boolean shouldEnableAssistMenuItems() {
            return Editor.this.mTextView.isDeviceProvisioned() && TextClassificationManager.getSettings(Editor.this.mTextView.getContext()).isSmartTextShareEnabled();
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            Editor.this.getSelectionActionModeHelper().onSelectionAction(item.getItemId(), item.getTitle().toString());
            if (Editor.this.mProcessTextIntentActionsHandler.performMenuItemAction(item)) {
                return true;
            }
            ActionMode.Callback customCallback = this.getCustomCallback();
            if (customCallback != null && customCallback.onActionItemClicked(mode, item)) {
                return true;
            }
            if (item.getGroupId() == 16908353 && this.onAssistMenuItemClicked(item)) {
                return true;
            }
            return Editor.this.mTextView.onTextContextMenuItem(item.getItemId());
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            Editor.this.getSelectionActionModeHelper().onDestroyActionMode();
            Editor.this.mTextActionMode = null;
            ActionMode.Callback customCallback = this.getCustomCallback();
            if (customCallback != null) {
                customCallback.onDestroyActionMode(mode);
            }
            if (!Editor.this.mPreserveSelection) {
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), Editor.this.mTextView.getSelectionEnd());
            }
            if (Editor.this.mSelectionModifierCursorController != null) {
                Editor.this.mSelectionModifierCursorController.hide();
            }
            this.mAssistClickHandlers.clear();
            Editor.this.mRequestingLinkActionMode = false;
        }

        @Override
        public void onGetContentRect(ActionMode mode, View view, Rect outRect) {
            if (!view.equals(Editor.this.mTextView) || Editor.this.mTextView.getLayout() == null) {
                super.onGetContentRect(mode, view, outRect);
                return;
            }
            if (Editor.this.mTextView.getSelectionStart() != Editor.this.mTextView.getSelectionEnd()) {
                this.mSelectionPath.reset();
                Editor.this.mTextView.getLayout().getSelectionPath(Editor.this.mTextView.getSelectionStart(), Editor.this.mTextView.getSelectionEnd(), this.mSelectionPath);
                this.mSelectionPath.computeBounds(this.mSelectionBounds, true);
                this.mSelectionBounds.bottom += (float)this.mHandleHeight;
            } else {
                Layout layout2 = Editor.this.mTextView.getLayout();
                int line = layout2.getLineForOffset(Editor.this.mTextView.getSelectionStart());
                float primaryHorizontal = Editor.this.clampHorizontalPosition(null, layout2.getPrimaryHorizontal(Editor.this.mTextView.getSelectionStart()));
                this.mSelectionBounds.set(primaryHorizontal, layout2.getLineTop(line), primaryHorizontal, layout2.getLineBottom(line) + this.mHandleHeight);
            }
            int textHorizontalOffset = Editor.this.mTextView.viewportToContentHorizontalOffset();
            int textVerticalOffset = Editor.this.mTextView.viewportToContentVerticalOffset();
            outRect.set((int)Math.floor(this.mSelectionBounds.left + (float)textHorizontalOffset), (int)Math.floor(this.mSelectionBounds.top + (float)textVerticalOffset), (int)Math.ceil(this.mSelectionBounds.right + (float)textHorizontalOffset), (int)Math.ceil(this.mSelectionBounds.bottom + (float)textVerticalOffset));
        }
    }

    private class SuggestionsPopupWindow
    extends PinnedPopupWindow
    implements AdapterView.OnItemClickListener {
        private static final int MAX_NUMBER_SUGGESTIONS = 5;
        private static final String USER_DICTIONARY_EXTRA_WORD = "word";
        private static final String USER_DICTIONARY_EXTRA_LOCALE = "locale";
        private SuggestionInfo[] mSuggestionInfos;
        private int mNumberOfSuggestions;
        private boolean mCursorWasVisibleBeforeSuggestions;
        private boolean mIsShowingUp;
        private SuggestionAdapter mSuggestionsAdapter;
        private TextAppearanceSpan mHighlightSpan;
        private TextView mAddToDictionaryButton;
        private TextView mDeleteButton;
        private ListView mSuggestionListView;
        private final SuggestionSpanInfo mMisspelledSpanInfo;
        private int mContainerMarginWidth;
        private int mContainerMarginTop;
        private LinearLayout mContainerView;
        private Context mContext;

        public SuggestionsPopupWindow() {
            this.mIsShowingUp = false;
            this.mMisspelledSpanInfo = new SuggestionSpanInfo();
            this.mCursorWasVisibleBeforeSuggestions = Editor.this.mTextView.isCursorVisibleFromAttr();
        }

        @Override
        protected void setUp() {
            this.mContext = this.applyDefaultTheme(Editor.this.mTextView.getContext());
            this.mHighlightSpan = new TextAppearanceSpan(this.mContext, ((Editor)Editor.this).mTextView.mTextEditSuggestionHighlightStyle);
        }

        private Context applyDefaultTheme(Context originalContext) {
            TypedArray a = originalContext.obtainStyledAttributes(new int[]{16844176});
            boolean isLightTheme = a.getBoolean(0, true);
            int themeId = isLightTheme ? 16974410 : 16974411;
            a.recycle();
            return new ContextThemeWrapper(originalContext, themeId);
        }

        @Override
        protected void createPopupWindow() {
            this.mPopupWindow = new CustomPopupWindow();
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setBackgroundDrawable(new ColorDrawable(0));
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setClippingEnabled(false);
        }

        @Override
        protected void initContentView() {
            LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            this.mContentView = (ViewGroup)inflater.inflate(((Editor)Editor.this).mTextView.mTextEditSuggestionContainerLayout, null);
            this.mContainerView = (LinearLayout)this.mContentView.findViewById(16909507);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mContainerView.getLayoutParams();
            this.mContainerMarginWidth = lp.leftMargin + lp.rightMargin;
            this.mContainerMarginTop = lp.topMargin;
            this.mClippingLimitLeft = lp.leftMargin;
            this.mClippingLimitRight = lp.rightMargin;
            this.mSuggestionListView = (ListView)this.mContentView.findViewById(16909506);
            this.mSuggestionsAdapter = new SuggestionAdapter();
            this.mSuggestionListView.setAdapter(this.mSuggestionsAdapter);
            this.mSuggestionListView.setOnItemClickListener(this);
            this.mSuggestionInfos = new SuggestionInfo[5];
            for (int i = 0; i < this.mSuggestionInfos.length; ++i) {
                this.mSuggestionInfos[i] = new SuggestionInfo();
            }
            this.mAddToDictionaryButton = (TextView)this.mContentView.findViewById(16908727);
            this.mAddToDictionaryButton.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View v) {
                    SuggestionSpan misspelledSpan = Editor.this.findEquivalentSuggestionSpan(SuggestionsPopupWindow.this.mMisspelledSpanInfo);
                    if (misspelledSpan == null) {
                        return;
                    }
                    Editable editable = (Editable)Editor.this.mTextView.getText();
                    int spanStart = editable.getSpanStart(misspelledSpan);
                    int spanEnd = editable.getSpanEnd(misspelledSpan);
                    if (spanStart < 0 || spanEnd <= spanStart) {
                        return;
                    }
                    String originalText = TextUtils.substring(editable, spanStart, spanEnd);
                    Intent intent = new Intent("com.android.settings.USER_DICTIONARY_INSERT");
                    intent.putExtra(SuggestionsPopupWindow.USER_DICTIONARY_EXTRA_WORD, originalText);
                    intent.putExtra(SuggestionsPopupWindow.USER_DICTIONARY_EXTRA_LOCALE, Editor.this.mTextView.getTextServicesLocale().toString());
                    intent.setFlags(intent.getFlags() | 0x10000000);
                    Editor.this.mTextView.startActivityAsTextOperationUserIfNecessary(intent);
                    editable.removeSpan(((SuggestionsPopupWindow)SuggestionsPopupWindow.this).mMisspelledSpanInfo.mSuggestionSpan);
                    Selection.setSelection(editable, spanEnd);
                    Editor.this.updateSpellCheckSpans(spanStart, spanEnd, false);
                    SuggestionsPopupWindow.this.hideWithCleanUp();
                }
            });
            this.mDeleteButton = (TextView)this.mContentView.findViewById(16908928);
            this.mDeleteButton.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View v) {
                    Editable editable = (Editable)Editor.this.mTextView.getText();
                    int spanUnionStart = editable.getSpanStart(Editor.this.mSuggestionRangeSpan);
                    int spanUnionEnd = editable.getSpanEnd(Editor.this.mSuggestionRangeSpan);
                    if (spanUnionStart >= 0 && spanUnionEnd > spanUnionStart) {
                        if (spanUnionEnd < editable.length() && Character.isSpaceChar(editable.charAt(spanUnionEnd)) && (spanUnionStart == 0 || Character.isSpaceChar(editable.charAt(spanUnionStart - 1)))) {
                            ++spanUnionEnd;
                        }
                        Editor.this.mTextView.deleteText_internal(spanUnionStart, spanUnionEnd);
                    }
                    SuggestionsPopupWindow.this.hideWithCleanUp();
                }
            });
        }

        public boolean isShowingUp() {
            return this.mIsShowingUp;
        }

        public void onParentLostFocus() {
            this.mIsShowingUp = false;
        }

        @Override
        public void show() {
            if (!(Editor.this.mTextView.getText() instanceof Editable)) {
                return;
            }
            if (Editor.this.extractedTextModeWillBeStarted()) {
                return;
            }
            if (this.updateSuggestions()) {
                this.mCursorWasVisibleBeforeSuggestions = Editor.this.mTextView.isCursorVisibleFromAttr();
                Editor.this.mTextView.setCursorVisible(false);
                this.mIsShowingUp = true;
                super.show();
            }
            this.mSuggestionListView.setVisibility(this.mNumberOfSuggestions == 0 ? 8 : 0);
        }

        @Override
        protected void measureContent() {
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            int horizontalMeasure = View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE);
            int verticalMeasure = View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE);
            int width = 0;
            View view = null;
            for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                view = this.mSuggestionsAdapter.getView(i, view, this.mContentView);
                view.getLayoutParams().width = -2;
                view.measure(horizontalMeasure, verticalMeasure);
                width = Math.max(width, view.getMeasuredWidth());
            }
            if (this.mAddToDictionaryButton.getVisibility() != 8) {
                this.mAddToDictionaryButton.measure(horizontalMeasure, verticalMeasure);
                width = Math.max(width, this.mAddToDictionaryButton.getMeasuredWidth());
            }
            this.mDeleteButton.measure(horizontalMeasure, verticalMeasure);
            width = Math.max(width, this.mDeleteButton.getMeasuredWidth());
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(width += this.mContainerView.getPaddingLeft() + this.mContainerView.getPaddingRight() + this.mContainerMarginWidth, 0x40000000), verticalMeasure);
            Drawable popupBackground = this.mPopupWindow.getBackground();
            if (popupBackground != null) {
                if (Editor.this.mTempRect == null) {
                    Editor.this.mTempRect = new Rect();
                }
                popupBackground.getPadding(Editor.this.mTempRect);
                width += ((Editor)Editor.this).mTempRect.left + ((Editor)Editor.this).mTempRect.right;
            }
            this.mPopupWindow.setWidth(width);
        }

        @Override
        protected int getTextOffset() {
            return (Editor.this.mTextView.getSelectionStart() + Editor.this.mTextView.getSelectionStart()) / 2;
        }

        @Override
        protected int getVerticalLocalPosition(int line) {
            Layout layout2 = Editor.this.mTextView.getLayout();
            return layout2.getLineBottomWithoutSpacing(line) - this.mContainerMarginTop;
        }

        @Override
        protected int clipVertically(int positionY) {
            int height = this.mContentView.getMeasuredHeight();
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            return Math.min(positionY, displayMetrics.heightPixels - height);
        }

        private void hideWithCleanUp() {
            for (SuggestionInfo info : this.mSuggestionInfos) {
                info.clear();
            }
            this.mMisspelledSpanInfo.clear();
            this.hide();
        }

        private boolean updateSuggestions() {
            int underlineColor;
            int i;
            Spannable spannable = (Spannable)Editor.this.mTextView.getText();
            this.mNumberOfSuggestions = Editor.this.mSuggestionHelper.getSuggestionInfo(this.mSuggestionInfos, this.mMisspelledSpanInfo);
            if (this.mNumberOfSuggestions == 0 && this.mMisspelledSpanInfo.mSuggestionSpan == null) {
                return false;
            }
            int spanUnionStart = Editor.this.mTextView.getText().length();
            int spanUnionEnd = 0;
            for (i = 0; i < this.mNumberOfSuggestions; ++i) {
                SuggestionSpanInfo spanInfo = this.mSuggestionInfos[i].mSuggestionSpanInfo;
                spanUnionStart = Math.min(spanUnionStart, spanInfo.mSpanStart);
                spanUnionEnd = Math.max(spanUnionEnd, spanInfo.mSpanEnd);
            }
            if (this.mMisspelledSpanInfo.mSuggestionSpan != null) {
                spanUnionStart = Math.min(spanUnionStart, this.mMisspelledSpanInfo.mSpanStart);
                spanUnionEnd = Math.max(spanUnionEnd, this.mMisspelledSpanInfo.mSpanEnd);
            }
            for (i = 0; i < this.mNumberOfSuggestions; ++i) {
                this.highlightTextDifferences(this.mSuggestionInfos[i], spanUnionStart, spanUnionEnd);
            }
            int addToDictionaryButtonVisibility = 8;
            if (this.mMisspelledSpanInfo.mSuggestionSpan != null && this.mMisspelledSpanInfo.mSpanStart >= 0 && this.mMisspelledSpanInfo.mSpanEnd > this.mMisspelledSpanInfo.mSpanStart) {
                addToDictionaryButtonVisibility = 0;
            }
            this.mAddToDictionaryButton.setVisibility(addToDictionaryButtonVisibility);
            if (Editor.this.mSuggestionRangeSpan == null) {
                Editor.this.mSuggestionRangeSpan = new SuggestionRangeSpan();
            }
            if ((underlineColor = this.mNumberOfSuggestions != 0 ? this.mSuggestionInfos[0].mSuggestionSpanInfo.mSuggestionSpan.getUnderlineColor() : this.mMisspelledSpanInfo.mSuggestionSpan.getUnderlineColor()) == 0) {
                Editor.this.mSuggestionRangeSpan.setBackgroundColor(((Editor)Editor.this).mTextView.mHighlightColor);
            } else {
                float BACKGROUND_TRANSPARENCY = 0.4f;
                int newAlpha = (int)((float)Color.alpha(underlineColor) * 0.4f);
                Editor.this.mSuggestionRangeSpan.setBackgroundColor((underlineColor & 0xFFFFFF) + (newAlpha << 24));
            }
            spannable.setSpan(Editor.this.mSuggestionRangeSpan, spanUnionStart, spanUnionEnd, 33);
            this.mSuggestionsAdapter.notifyDataSetChanged();
            return true;
        }

        private void highlightTextDifferences(SuggestionInfo suggestionInfo, int unionStart, int unionEnd) {
            Spannable text = (Spannable)Editor.this.mTextView.getText();
            int spanStart = suggestionInfo.mSuggestionSpanInfo.mSpanStart;
            int spanEnd = suggestionInfo.mSuggestionSpanInfo.mSpanEnd;
            suggestionInfo.mSuggestionStart = spanStart - unionStart;
            suggestionInfo.mSuggestionEnd = suggestionInfo.mSuggestionStart + suggestionInfo.mText.length();
            suggestionInfo.mText.setSpan(this.mHighlightSpan, 0, suggestionInfo.mText.length(), 33);
            String textAsString = text.toString();
            suggestionInfo.mText.insert(0, textAsString.substring(unionStart, spanStart));
            suggestionInfo.mText.append(textAsString.substring(spanEnd, unionEnd));
        }

        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            SuggestionInfo suggestionInfo = this.mSuggestionInfos[position];
            Editor.this.replaceWithSuggestion(suggestionInfo);
            this.hideWithCleanUp();
        }

        private class SuggestionAdapter
        extends BaseAdapter {
            private LayoutInflater mInflater;

            private SuggestionAdapter() {
                this.mInflater = (LayoutInflater)SuggestionsPopupWindow.this.mContext.getSystemService("layout_inflater");
            }

            @Override
            public int getCount() {
                return SuggestionsPopupWindow.this.mNumberOfSuggestions;
            }

            @Override
            public Object getItem(int position) {
                return SuggestionsPopupWindow.this.mSuggestionInfos[position];
            }

            @Override
            public long getItemId(int position) {
                return position;
            }

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                TextView textView = (TextView)convertView;
                if (textView == null) {
                    textView = (TextView)this.mInflater.inflate(((Editor)Editor.this).mTextView.mTextEditSuggestionItemLayout, parent, false);
                }
                SuggestionInfo suggestionInfo = SuggestionsPopupWindow.this.mSuggestionInfos[position];
                textView.setText(suggestionInfo.mText);
                return textView;
            }
        }

        private class CustomPopupWindow
        extends PopupWindow {
            private CustomPopupWindow() {
            }

            @Override
            public void dismiss() {
                if (!this.isShowing()) {
                    return;
                }
                super.dismiss();
                Editor.this.getPositionListener().removeSubscriber(SuggestionsPopupWindow.this);
                ((Spannable)Editor.this.mTextView.getText()).removeSpan(Editor.this.mSuggestionRangeSpan);
                Editor.this.mTextView.setCursorVisible(SuggestionsPopupWindow.this.mCursorWasVisibleBeforeSuggestions);
                if (Editor.this.hasInsertionController() && !Editor.this.extractedTextModeWillBeStarted()) {
                    Editor.this.getInsertionController().show();
                }
            }
        }
    }

    private class SuggestionHelper {
        private final Comparator<SuggestionSpan> mSuggestionSpanComparator = new SuggestionSpanComparator();
        private final HashMap<SuggestionSpan, Integer> mSpansLengths = new HashMap();

        private SuggestionHelper() {
        }

        private SuggestionSpan[] getSortedSuggestionSpans() {
            int pos = Editor.this.mTextView.getSelectionStart();
            Spannable spannable = (Spannable)Editor.this.mTextView.getText();
            SuggestionSpan[] suggestionSpans = spannable.getSpans(pos, pos, SuggestionSpan.class);
            this.mSpansLengths.clear();
            for (SuggestionSpan suggestionSpan : suggestionSpans) {
                int start = spannable.getSpanStart(suggestionSpan);
                int end = spannable.getSpanEnd(suggestionSpan);
                this.mSpansLengths.put(suggestionSpan, end - start);
            }
            Arrays.sort(suggestionSpans, this.mSuggestionSpanComparator);
            this.mSpansLengths.clear();
            return suggestionSpans;
        }

        public int getSuggestionInfo(SuggestionInfo[] suggestionInfos, SuggestionSpanInfo misspelledSpanInfo) {
            Spannable spannable = (Spannable)Editor.this.mTextView.getText();
            SuggestionSpan[] suggestionSpans = this.getSortedSuggestionSpans();
            int nbSpans = suggestionSpans.length;
            if (nbSpans == 0) {
                return 0;
            }
            int numberOfSuggestions = 0;
            for (SuggestionSpan suggestionSpan : suggestionSpans) {
                int spanStart = spannable.getSpanStart(suggestionSpan);
                int spanEnd = spannable.getSpanEnd(suggestionSpan);
                if (misspelledSpanInfo != null && (suggestionSpan.getFlags() & 0xA) != 0) {
                    misspelledSpanInfo.mSuggestionSpan = suggestionSpan;
                    misspelledSpanInfo.mSpanStart = spanStart;
                    misspelledSpanInfo.mSpanEnd = spanEnd;
                }
                String[] suggestions = suggestionSpan.getSuggestions();
                int nbSuggestions = suggestions.length;
                block1: for (int suggestionIndex = 0; suggestionIndex < nbSuggestions; ++suggestionIndex) {
                    String suggestion = suggestions[suggestionIndex];
                    for (int i = 0; i < numberOfSuggestions; ++i) {
                        SuggestionInfo otherSuggestionInfo = suggestionInfos[i];
                        if (!otherSuggestionInfo.mText.toString().equals(suggestion)) continue;
                        int otherSpanStart = otherSuggestionInfo.mSuggestionSpanInfo.mSpanStart;
                        int otherSpanEnd = otherSuggestionInfo.mSuggestionSpanInfo.mSpanEnd;
                        if (spanStart == otherSpanStart && spanEnd == otherSpanEnd) continue block1;
                    }
                    SuggestionInfo suggestionInfo = suggestionInfos[numberOfSuggestions];
                    suggestionInfo.setSpanInfo(suggestionSpan, spanStart, spanEnd);
                    suggestionInfo.mSuggestionIndex = suggestionIndex;
                    suggestionInfo.mSuggestionStart = 0;
                    suggestionInfo.mSuggestionEnd = suggestion.length();
                    suggestionInfo.mText.replace(0, suggestionInfo.mText.length(), suggestion);
                    if (++numberOfSuggestions < suggestionInfos.length) continue;
                    return numberOfSuggestions;
                }
            }
            return numberOfSuggestions;
        }

        private class SuggestionSpanComparator
        implements Comparator<SuggestionSpan> {
            private SuggestionSpanComparator() {
            }

            @Override
            public int compare(SuggestionSpan span1, SuggestionSpan span2) {
                int flag2;
                int flag1 = span1.getFlags();
                if (flag1 != (flag2 = span2.getFlags())) {
                    int easy = this.compareFlag(1, flag1, flag2);
                    if (easy != 0) {
                        return easy;
                    }
                    int misspelled = this.compareFlag(2, flag1, flag2);
                    if (misspelled != 0) {
                        return misspelled;
                    }
                    int grammarError = this.compareFlag(8, flag1, flag2);
                    if (grammarError != 0) {
                        return grammarError;
                    }
                }
                return (Integer)SuggestionHelper.this.mSpansLengths.get(span1) - (Integer)SuggestionHelper.this.mSpansLengths.get(span2);
            }

            private int compareFlag(int flagToCompare, int flags1, int flags2) {
                boolean hasFlag2;
                boolean hasFlag1 = (flags1 & flagToCompare) != 0;
                boolean bl = hasFlag2 = (flags2 & flagToCompare) != 0;
                if (hasFlag1 == hasFlag2) {
                    return 0;
                }
                return hasFlag1 ? -1 : 1;
            }
        }
    }

    private static class SuggestionSpanInfo {
        SuggestionSpan mSuggestionSpan;
        int mSpanStart;
        int mSpanEnd;

        private SuggestionSpanInfo() {
        }

        void clear() {
            this.mSuggestionSpan = null;
        }
    }

    private static class SuggestionInfo {
        int mSuggestionStart;
        int mSuggestionEnd;
        final SuggestionSpanInfo mSuggestionSpanInfo = new SuggestionSpanInfo();
        int mSuggestionIndex;
        final SpannableStringBuilder mText = new SpannableStringBuilder();

        private SuggestionInfo() {
        }

        void clear() {
            this.mSuggestionSpanInfo.clear();
            this.mText.clear();
        }

        void setSpanInfo(SuggestionSpan span, int spanStart, int spanEnd) {
            this.mSuggestionSpanInfo.mSuggestionSpan = span;
            this.mSuggestionSpanInfo.mSpanStart = spanStart;
            this.mSuggestionSpanInfo.mSpanEnd = spanEnd;
        }
    }

    private abstract class PinnedPopupWindow
    implements TextViewPositionListener {
        protected PopupWindow mPopupWindow;
        protected ViewGroup mContentView;
        int mPositionX;
        int mPositionY;
        int mClippingLimitLeft;
        int mClippingLimitRight;

        protected abstract void createPopupWindow();

        protected abstract void initContentView();

        protected abstract int getTextOffset();

        protected abstract int getVerticalLocalPosition(int var1);

        protected abstract int clipVertically(int var1);

        protected void setUp() {
        }

        public PinnedPopupWindow() {
            this.setUp();
            this.createPopupWindow();
            this.mPopupWindow.setWindowLayoutType(1005);
            this.mPopupWindow.setWidth(-2);
            this.mPopupWindow.setHeight(-2);
            this.initContentView();
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mContentView.setLayoutParams(wrapContent);
            this.mPopupWindow.setContentView(this.mContentView);
        }

        public void show() {
            Editor.this.getPositionListener().addSubscriber(this, false);
            this.computeLocalPosition();
            PositionListener positionListener = Editor.this.getPositionListener();
            this.updatePosition(positionListener.getPositionX(), positionListener.getPositionY());
        }

        protected void measureContent() {
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE));
        }

        private void computeLocalPosition() {
            this.measureContent();
            int width = this.mContentView.getMeasuredWidth();
            int offset2 = this.getTextOffset();
            this.mPositionX = (int)(Editor.this.mTextView.getLayout().getPrimaryHorizontal(offset2) - (float)width / 2.0f);
            this.mPositionX += Editor.this.mTextView.viewportToContentHorizontalOffset();
            int line = Editor.this.mTextView.getLayout().getLineForOffset(offset2);
            this.mPositionY = this.getVerticalLocalPosition(line);
            this.mPositionY += Editor.this.mTextView.viewportToContentVerticalOffset();
        }

        private void updatePosition(int parentPositionX, int parentPositionY) {
            int positionX = parentPositionX + this.mPositionX;
            int positionY = parentPositionY + this.mPositionY;
            positionY = this.clipVertically(positionY);
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            int width = this.mContentView.getMeasuredWidth();
            positionX = Math.min(displayMetrics.widthPixels - width + this.mClippingLimitRight, positionX);
            positionX = Math.max(-this.mClippingLimitLeft, positionX);
            if (this.isShowing()) {
                this.mPopupWindow.update(positionX, positionY, -1, -1);
            } else {
                this.mPopupWindow.showAtLocation(Editor.this.mTextView, 0, positionX, positionY);
            }
        }

        public void hide() {
            if (!this.isShowing()) {
                return;
            }
            this.mPopupWindow.dismiss();
            Editor.this.getPositionListener().removeSubscriber(this);
        }

        @Override
        public void updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            if (this.isShowing() && Editor.this.isOffsetVisible(this.getTextOffset())) {
                if (parentScrolled) {
                    this.computeLocalPosition();
                }
                this.updatePosition(parentPositionX, parentPositionY);
            } else {
                this.hide();
            }
        }

        public boolean isShowing() {
            return this.mPopupWindow.isShowing();
        }
    }

    private class PositionListener
    implements ViewTreeObserver.OnPreDrawListener {
        private static final int MAXIMUM_NUMBER_OF_LISTENERS = 7;
        private TextViewPositionListener[] mPositionListeners = new TextViewPositionListener[7];
        private boolean[] mCanMove = new boolean[7];
        private boolean mPositionHasChanged = true;
        private int mPositionX;
        private int mPositionY;
        private int mPositionXOnScreen;
        private int mPositionYOnScreen;
        private int mNumberOfListeners;
        private boolean mScrollHasChanged;
        final int[] mTempCoords = new int[2];

        private PositionListener() {
        }

        public void addSubscriber(TextViewPositionListener positionListener, boolean canMove) {
            if (this.mNumberOfListeners == 0) {
                this.updatePosition();
                ViewTreeObserver vto = Editor.this.mTextView.getViewTreeObserver();
                vto.addOnPreDrawListener(this);
            }
            int emptySlotIndex = -1;
            for (int i = 0; i < 7; ++i) {
                TextViewPositionListener listener2 = this.mPositionListeners[i];
                if (listener2 == positionListener) {
                    return;
                }
                if (emptySlotIndex >= 0 || listener2 != null) continue;
                emptySlotIndex = i;
            }
            this.mPositionListeners[emptySlotIndex] = positionListener;
            this.mCanMove[emptySlotIndex] = canMove;
            ++this.mNumberOfListeners;
        }

        public void removeSubscriber(TextViewPositionListener positionListener) {
            for (int i = 0; i < 7; ++i) {
                if (this.mPositionListeners[i] != positionListener) continue;
                this.mPositionListeners[i] = null;
                --this.mNumberOfListeners;
                break;
            }
            if (this.mNumberOfListeners == 0) {
                ViewTreeObserver vto = Editor.this.mTextView.getViewTreeObserver();
                vto.removeOnPreDrawListener(this);
            }
        }

        public int getPositionX() {
            return this.mPositionX;
        }

        public int getPositionY() {
            return this.mPositionY;
        }

        public int getPositionXOnScreen() {
            return this.mPositionXOnScreen;
        }

        public int getPositionYOnScreen() {
            return this.mPositionYOnScreen;
        }

        @Override
        public boolean onPreDraw() {
            this.updatePosition();
            for (int i = 0; i < 7; ++i) {
                TextViewPositionListener positionListener;
                if (!this.mPositionHasChanged && !this.mScrollHasChanged && !this.mCanMove[i] || (positionListener = this.mPositionListeners[i]) == null) continue;
                positionListener.updatePosition(this.mPositionX, this.mPositionY, this.mPositionHasChanged, this.mScrollHasChanged);
            }
            this.mScrollHasChanged = false;
            return true;
        }

        private void updatePosition() {
            Editor.this.mTextView.getLocationInWindow(this.mTempCoords);
            this.mPositionHasChanged = this.mTempCoords[0] != this.mPositionX || this.mTempCoords[1] != this.mPositionY;
            this.mPositionX = this.mTempCoords[0];
            this.mPositionY = this.mTempCoords[1];
            Editor.this.mTextView.getLocationOnScreen(this.mTempCoords);
            this.mPositionXOnScreen = this.mTempCoords[0];
            this.mPositionYOnScreen = this.mTempCoords[1];
        }

        public void onScrollChanged() {
            this.mScrollHasChanged = true;
        }
    }

    private class EasyEditPopupWindow
    extends PinnedPopupWindow
    implements View.OnClickListener {
        private static final int POPUP_TEXT_LAYOUT = 17367333;
        private TextView mDeleteTextView;
        private EasyEditSpan mEasyEditSpan;
        private EasyEditDeleteListener mOnDeleteListener;

        private EasyEditPopupWindow() {
        }

        @Override
        protected void createPopupWindow() {
            this.mPopupWindow = new PopupWindow(Editor.this.mTextView.getContext(), null, 16843464);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setClippingEnabled(true);
        }

        @Override
        protected void initContentView() {
            LinearLayout linearLayout = new LinearLayout(Editor.this.mTextView.getContext());
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17303737);
            LayoutInflater inflater = (LayoutInflater)Editor.this.mTextView.getContext().getSystemService("layout_inflater");
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mDeleteTextView = (TextView)inflater.inflate(17367333, null);
            this.mDeleteTextView.setLayoutParams(wrapContent);
            this.mDeleteTextView.setText(17040094);
            this.mDeleteTextView.setOnClickListener(this);
            this.mContentView.addView(this.mDeleteTextView);
        }

        public void setEasyEditSpan(EasyEditSpan easyEditSpan) {
            this.mEasyEditSpan = easyEditSpan;
        }

        private void setOnDeleteListener(EasyEditDeleteListener listener2) {
            this.mOnDeleteListener = listener2;
        }

        @Override
        public void onClick(View view) {
            if (view == this.mDeleteTextView && this.mEasyEditSpan != null && this.mEasyEditSpan.isDeleteEnabled() && this.mOnDeleteListener != null) {
                this.mOnDeleteListener.onDeleteClick(this.mEasyEditSpan);
            }
        }

        @Override
        public void hide() {
            if (this.mEasyEditSpan != null) {
                this.mEasyEditSpan.setDeleteEnabled(false);
            }
            this.mOnDeleteListener = null;
            super.hide();
        }

        @Override
        protected int getTextOffset() {
            Editable editable = (Editable)Editor.this.mTextView.getText();
            return editable.getSpanEnd(this.mEasyEditSpan);
        }

        @Override
        protected int getVerticalLocalPosition(int line) {
            Layout layout2 = Editor.this.mTextView.getLayout();
            return layout2.getLineBottomWithoutSpacing(line);
        }

        @Override
        protected int clipVertically(int positionY) {
            return positionY;
        }
    }

    private static interface EasyEditDeleteListener {
        public void onDeleteClick(EasyEditSpan var1);
    }

    private class SpanController
    implements SpanWatcher {
        private static final int DISPLAY_TIMEOUT_MS = 3000;
        private EasyEditPopupWindow mPopupWindow;
        private Runnable mHidePopup;

        private SpanController() {
        }

        private boolean isNonIntermediateSelectionSpan(Spannable text, Object span) {
            return (Selection.SELECTION_START == span || Selection.SELECTION_END == span) && (text.getSpanFlags(span) & 0x200) == 0;
        }

        @Override
        public void onSpanAdded(Spannable text, Object span, int start, int end) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                Editor.this.sendUpdateSelection();
            } else if (span instanceof EasyEditSpan) {
                if (this.mPopupWindow == null) {
                    this.mPopupWindow = new EasyEditPopupWindow();
                    this.mHidePopup = new Runnable(){

                        @Override
                        public void run() {
                            SpanController.this.hide();
                        }
                    };
                }
                if (this.mPopupWindow.mEasyEditSpan != null) {
                    this.mPopupWindow.mEasyEditSpan.setDeleteEnabled(false);
                }
                this.mPopupWindow.setEasyEditSpan((EasyEditSpan)span);
                this.mPopupWindow.setOnDeleteListener(new EasyEditDeleteListener(){

                    @Override
                    public void onDeleteClick(EasyEditSpan span) {
                        Editable editable = (Editable)Editor.this.mTextView.getText();
                        int start = editable.getSpanStart(span);
                        int end = editable.getSpanEnd(span);
                        if (start >= 0 && end >= 0) {
                            SpanController.this.sendEasySpanNotification(1, span);
                            Editor.this.mTextView.deleteText_internal(start, end);
                        }
                        editable.removeSpan(span);
                    }
                });
                if (Editor.this.mTextView.getWindowVisibility() != 0) {
                    return;
                }
                if (Editor.this.mTextView.getLayout() == null) {
                    return;
                }
                if (Editor.this.extractedTextModeWillBeStarted()) {
                    return;
                }
                this.mPopupWindow.show();
                Editor.this.mTextView.removeCallbacks(this.mHidePopup);
                Editor.this.mTextView.postDelayed(this.mHidePopup, 3000L);
            }
        }

        @Override
        public void onSpanRemoved(Spannable text, Object span, int start, int end) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                Editor.this.sendUpdateSelection();
            } else if (this.mPopupWindow != null && span == this.mPopupWindow.mEasyEditSpan) {
                this.hide();
            }
        }

        @Override
        public void onSpanChanged(Spannable text, Object span, int previousStart, int previousEnd, int newStart, int newEnd) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                Editor.this.sendUpdateSelection();
            } else if (this.mPopupWindow != null && span instanceof EasyEditSpan) {
                EasyEditSpan easyEditSpan = (EasyEditSpan)span;
                this.sendEasySpanNotification(2, easyEditSpan);
                text.removeSpan(easyEditSpan);
            }
        }

        public void hide() {
            if (this.mPopupWindow != null) {
                this.mPopupWindow.hide();
                Editor.this.mTextView.removeCallbacks(this.mHidePopup);
            }
        }

        private void sendEasySpanNotification(int textChangedType, EasyEditSpan span) {
            try {
                PendingIntent pendingIntent = span.getPendingIntent();
                if (pendingIntent != null) {
                    Intent intent = new Intent();
                    intent.putExtra("android.text.style.EXTRA_TEXT_CHANGED_TYPE", textChangedType);
                    pendingIntent.send(Editor.this.mTextView.getContext(), 0, intent);
                }
            }
            catch (PendingIntent.CanceledException e) {
                Log.w("Editor", "PendingIntent for notification cannot be sent", e);
            }
        }
    }

    private static class DragLocalState {
        public TextView sourceTextView;
        public int start;
        public int end;

        public DragLocalState(TextView sourceTextView, int start, int end) {
            this.sourceTextView = sourceTextView;
            this.start = start;
            this.end = end;
        }
    }

    private class Blink
    implements Runnable {
        private boolean mCancelled;

        private Blink() {
        }

        @Override
        public void run() {
            if (this.mCancelled) {
                return;
            }
            Editor.this.mTextView.removeCallbacks(this);
            if (Editor.this.shouldBlink()) {
                if (Editor.this.mTextView.getLayout() != null) {
                    Editor.this.mTextView.invalidateCursorPath();
                }
                Editor.this.mTextView.postDelayed(this, 500L);
            }
        }

        void cancel() {
            if (!this.mCancelled) {
                Editor.this.mTextView.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        void uncancel() {
            this.mCancelled = false;
        }
    }

    private static interface TextViewPositionListener {
        public void updatePosition(int var1, int var2, boolean var3, boolean var4);
    }

    private static class TextRenderNode {
        RenderNode renderNode;
        boolean isDirty;
        boolean needsToBeShifted;

        public TextRenderNode(String name) {
            this.renderNode = RenderNode.create(name, null);
            this.isDirty = true;
            this.needsToBeShifted = true;
        }

        boolean needsRecord() {
            return this.isDirty || !this.renderNode.hasDisplayList();
        }
    }

    static @interface TextActionMode {
        public static final int SELECTION = 0;
        public static final int INSERTION = 1;
        public static final int TEXT_LINK = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface MagnifierHandleTrigger {
        public static final int INSERTION = 0;
        public static final int SELECTION_START = 1;
        public static final int SELECTION_END = 2;
    }
}

