/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.os.Handler;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.lang.System_Delegate;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.JulianFields;
import java.util.ArrayList;
import java.util.Date;

@RemoteViews.RemoteView
public class DateTimeView
extends TextView {
    private static final int SHOW_TIME = 0;
    private static final int SHOW_MONTH_DAY_YEAR = 1;
    private long mTimeMillis;
    private LocalDateTime mLocalTime;
    int mLastDisplay = -1;
    java.text.DateFormat mLastFormat;
    private long mUpdateTimeMillis;
    private static final ThreadLocal<ReceiverInfo> sReceiverInfo = new ThreadLocal();
    private String mNowText;
    private boolean mShowRelativeTime;

    public DateTimeView(Context context) {
        this(context, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public DateTimeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DateTimeView, 0, 0);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 0: {
                    boolean relative = a.getBoolean(i, false);
                    this.setShowRelativeTime(relative);
                }
            }
        }
        a.recycle();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ReceiverInfo ri = sReceiverInfo.get();
        if (ri == null) {
            ri = new ReceiverInfo();
            sReceiverInfo.set(ri);
        }
        ri.addView(this);
        if (this.mShowRelativeTime) {
            this.update();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ReceiverInfo ri = sReceiverInfo.get();
        if (ri != null) {
            ri.removeView(this);
        }
    }

    @RemotableViewMethod
    @UnsupportedAppUsage
    public void setTime(long timeMillis) {
        this.mTimeMillis = timeMillis;
        LocalDateTime dateTime = DateTimeView.toLocalDateTime(timeMillis, ZoneId.systemDefault());
        this.mLocalTime = dateTime.withSecond(0);
        this.update();
    }

    @RemotableViewMethod
    public void setShowRelativeTime(boolean showRelativeTime) {
        this.mShowRelativeTime = showRelativeTime;
        this.updateNowText();
        this.update();
    }

    public boolean isShowRelativeTime() {
        return this.mShowRelativeTime;
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int visibility) {
        boolean gotVisible = visibility != 8 && this.getVisibility() == 8;
        super.setVisibility(visibility);
        if (gotVisible) {
            this.update();
        }
    }

    @UnsupportedAppUsage
    void update() {
        java.text.DateFormat format;
        if (this.mLocalTime == null || this.getVisibility() == 8) {
            return;
        }
        if (this.mShowRelativeTime) {
            this.updateRelativeTime();
            return;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localTime = this.mLocalTime;
        LocalDateTime localStartOfDay = LocalDateTime.of(localTime.toLocalDate(), LocalTime.MIDNIGHT);
        LocalDateTime localTomorrowStartOfDay = localStartOfDay.plusDays(1L);
        LocalDateTime localNow = LocalDateTime.now(zoneId).withSecond(0);
        long twelveHoursBefore = DateTimeView.toEpochMillis(localTime.minusHours(12L), zoneId);
        long twelveHoursAfter = DateTimeView.toEpochMillis(localTime.plusHours(12L), zoneId);
        long midnightBefore = DateTimeView.toEpochMillis(localStartOfDay, zoneId);
        long midnightAfter = DateTimeView.toEpochMillis(localTomorrowStartOfDay, zoneId);
        long time = DateTimeView.toEpochMillis(localTime, zoneId);
        long now = DateTimeView.toEpochMillis(localNow, zoneId);
        int display = now >= midnightBefore && now < midnightAfter || now >= twelveHoursBefore && now < twelveHoursAfter ? 0 : 1;
        if (display == this.mLastDisplay && this.mLastFormat != null) {
            format = this.mLastFormat;
        } else {
            switch (display) {
                case 0: {
                    format = this.getTimeFormat();
                    break;
                }
                case 1: {
                    format = java.text.DateFormat.getDateInstance(3);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown display value: " + display);
                }
            }
            this.mLastFormat = format;
        }
        String text = format.format(new Date(time));
        this.setText(text);
        this.mUpdateTimeMillis = display == 0 ? (twelveHoursAfter > midnightAfter ? twelveHoursAfter : midnightAfter) : (this.mTimeMillis < now ? 0L : (twelveHoursBefore < midnightBefore ? twelveHoursBefore : midnightBefore));
    }

    private void updateRelativeTime() {
        long millisIncrease;
        String result;
        int count;
        boolean past;
        long now = System_Delegate.currentTimeMillis();
        long duration = Math.abs(now - this.mTimeMillis);
        boolean bl = past = now >= this.mTimeMillis;
        if (duration < 60000L) {
            this.setText(this.mNowText);
            this.mUpdateTimeMillis = this.mTimeMillis + 60000L + 1L;
            return;
        }
        if (duration < 3600000L) {
            count = (int)(duration / 60000L);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 18153484 : 18153485, count), count);
            millisIncrease = 60000L;
        } else if (duration < 86400000L) {
            count = (int)(duration / 3600000L);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 18153480 : 18153481, count), count);
            millisIncrease = 3600000L;
        } else if (duration < 31449600000L) {
            LocalDateTime localDateTime = this.mLocalTime;
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDateTime localNow = DateTimeView.toLocalDateTime(now, zoneId);
            count = Math.max(Math.abs(DateTimeView.dayDistance(localDateTime, localNow)), 1);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 18153476 : 0x1150005, count), count);
            if (past || count != 1) {
                this.mUpdateTimeMillis = DateTimeView.computeNextMidnight(localNow, zoneId);
                millisIncrease = -1L;
            } else {
                millisIncrease = 86400000L;
            }
        } else {
            count = (int)(duration / 31449600000L);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 0x1150010 : 0x1150011, count), count);
            millisIncrease = 31449600000L;
        }
        if (millisIncrease != -1L) {
            this.mUpdateTimeMillis = past ? this.mTimeMillis + millisIncrease * (long)(count + 1) + 1L : this.mTimeMillis - millisIncrease * (long)count + 1L;
        }
        this.setText(result);
    }

    private static long computeNextMidnight(LocalDateTime time, ZoneId zoneId) {
        LocalDate tomorrow = time.toLocalDate().plusDays(1L);
        LocalDateTime nextMidnight = LocalDateTime.of(tomorrow, LocalTime.MIDNIGHT);
        return DateTimeView.toEpochMillis(nextMidnight, zoneId);
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateNowText();
        this.update();
    }

    private void updateNowText() {
        if (!this.mShowRelativeTime) {
            return;
        }
        this.mNowText = this.getContext().getResources().getString(17040830);
    }

    private static int dayDistance(LocalDateTime start, LocalDateTime end) {
        return (int)(end.getLong(JulianFields.JULIAN_DAY) - start.getLong(JulianFields.JULIAN_DAY));
    }

    private java.text.DateFormat getTimeFormat() {
        return DateFormat.getTimeFormat(this.getContext());
    }

    void clearFormatAndUpdate() {
        this.mLastFormat = null;
        this.update();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.mShowRelativeTime) {
            String result;
            boolean past;
            long now = System_Delegate.currentTimeMillis();
            long duration = Math.abs(now - this.mTimeMillis);
            boolean bl = past = now >= this.mTimeMillis;
            if (duration < 60000L) {
                result = this.mNowText;
            } else if (duration < 3600000L) {
                int count = (int)(duration / 60000L);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153482 : 18153483, count), count);
            } else if (duration < 86400000L) {
                int count = (int)(duration / 3600000L);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153478 : 18153479, count), count);
            } else if (duration < 31449600000L) {
                LocalDateTime localDateTime = this.mLocalTime;
                ZoneId zoneId = ZoneId.systemDefault();
                LocalDateTime localNow = DateTimeView.toLocalDateTime(now, zoneId);
                int count = Math.max(Math.abs(DateTimeView.dayDistance(localDateTime, localNow)), 1);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153474 : 18153475, count), count);
            } else {
                int count = (int)(duration / 31449600000L);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153486 : 18153487, count), count);
            }
            info.setText(result);
        }
    }

    public static void setReceiverHandler(Handler handler) {
        ReceiverInfo ri = sReceiverInfo.get();
        if (ri == null) {
            ri = new ReceiverInfo();
            sReceiverInfo.set(ri);
        }
        ri.setHandler(handler);
    }

    private static LocalDateTime toLocalDateTime(long timeMillis, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(timeMillis);
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    private static long toEpochMillis(LocalDateTime time, ZoneId zoneId) {
        Instant instant = time.toInstant(zoneId.getRules().getOffset(time));
        return instant.toEpochMilli();
    }

    private static class ReceiverInfo {
        private final ArrayList<DateTimeView> mAttachedViews = new ArrayList();
        private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action2 = intent.getAction();
                if ("android.intent.action.TIME_TICK".equals(action2) && System_Delegate.currentTimeMillis() < this.getSoonestUpdateTime()) {
                    return;
                }
                this.updateAll();
            }
        };
        private final ContentObserver mObserver = new ContentObserver(new Handler()){

            @Override
            public void onChange(boolean selfChange) {
                this.updateAll();
            }
        };
        private Handler mHandler = new Handler();

        private ReceiverInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addView(DateTimeView v) {
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                boolean register = this.mAttachedViews.isEmpty();
                this.mAttachedViews.add(v);
                if (register) {
                    this.register(ReceiverInfo.getApplicationContextIfAvailable(v.getContext()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeView(DateTimeView v) {
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                boolean removed = this.mAttachedViews.remove(v);
                if (removed && this.mAttachedViews.isEmpty()) {
                    this.unregister(ReceiverInfo.getApplicationContextIfAvailable(v.getContext()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateAll() {
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                int count = this.mAttachedViews.size();
                for (int i = 0; i < count; ++i) {
                    DateTimeView view = this.mAttachedViews.get(i);
                    view.post(() -> view.clearFormatAndUpdate());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getSoonestUpdateTime() {
            long result = Long.MAX_VALUE;
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                int count = this.mAttachedViews.size();
                for (int i = 0; i < count; ++i) {
                    long time = this.mAttachedViews.get(i).mUpdateTimeMillis;
                    if (time >= result) continue;
                    result = time;
                }
            }
            return result;
        }

        static Context getApplicationContextIfAvailable(Context context) {
            Context ac = context.getApplicationContext();
            return ac != null ? ac : ActivityThread.currentApplication().getApplicationContext();
        }

        void register(Context context) {
            IntentFilter filter2 = new IntentFilter();
            filter2.addAction("android.intent.action.TIME_TICK");
            filter2.addAction("android.intent.action.TIME_SET");
            filter2.addAction("android.intent.action.CONFIGURATION_CHANGED");
            filter2.addAction("android.intent.action.TIMEZONE_CHANGED");
            context.registerReceiver(this.mReceiver, filter2, null, this.mHandler);
        }

        void unregister(Context context) {
            context.unregisterReceiver(this.mReceiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setHandler(Handler handler) {
            this.mHandler = handler;
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                if (!this.mAttachedViews.isEmpty()) {
                    this.unregister(this.mAttachedViews.get(0).getContext());
                    this.register(this.mAttachedViews.get(0).getContext());
                }
            }
        }
    }
}

