/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.NonNull;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class TranslationResponseValue
implements Parcelable {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_ERROR = 1;
    public static final String EXTRA_DEFINITIONS = "android.view.translation.extra.DEFINITIONS";
    private final int mStatusCode;
    private final CharSequence mText;
    private final Bundle mExtras;
    private final CharSequence mTransliteration;
    public static final Parcelable.Creator<TranslationResponseValue> CREATOR = new Parcelable.Creator<TranslationResponseValue>(){

        public TranslationResponseValue[] newArray(int size) {
            return new TranslationResponseValue[size];
        }

        @Override
        public TranslationResponseValue createFromParcel(Parcel in) {
            return new TranslationResponseValue(in);
        }
    };

    public static TranslationResponseValue forError() {
        return new TranslationResponseValue(1, null, Bundle.EMPTY, null);
    }

    private static CharSequence defaultText() {
        return null;
    }

    private static Bundle defaultExtras() {
        return Bundle.EMPTY;
    }

    private boolean extrasEquals(Bundle other) {
        return Objects.equals(this.mExtras, other) || this.mExtras.isEmpty() && other.isEmpty();
    }

    private static CharSequence defaultTransliteration() {
        return null;
    }

    public static String statusToString(int value2) {
        switch (value2) {
            case 0: {
                return "STATUS_SUCCESS";
            }
            case 1: {
                return "STATUS_ERROR";
            }
        }
        return Integer.toHexString(value2);
    }

    TranslationResponseValue(int statusCode, CharSequence text, Bundle extras, CharSequence transliteration) {
        this.mStatusCode = statusCode;
        if (this.mStatusCode != 0 && this.mStatusCode != 1) {
            throw new IllegalArgumentException("statusCode was " + this.mStatusCode + " but must be one of: STATUS_SUCCESS(" + 0 + "), STATUS_ERROR(" + 1 + ")");
        }
        this.mText = text;
        this.mExtras = extras;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mExtras);
        this.mTransliteration = transliteration;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public CharSequence getTransliteration() {
        return this.mTransliteration;
    }

    public String toString() {
        return "TranslationResponseValue { statusCode = " + TranslationResponseValue.statusToString(this.mStatusCode) + ", text = " + this.mText + ", extras = " + this.mExtras + ", transliteration = " + this.mTransliteration + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslationResponseValue that = (TranslationResponseValue)o;
        return this.mStatusCode == that.mStatusCode && Objects.equals(this.mText, that.mText) && this.extrasEquals(that.mExtras) && Objects.equals(this.mTransliteration, that.mTransliteration);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mStatusCode;
        _hash = 31 * _hash + Objects.hashCode(this.mText);
        _hash = 31 * _hash + Objects.hashCode(this.mExtras);
        _hash = 31 * _hash + Objects.hashCode(this.mTransliteration);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mText != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mTransliteration != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mStatusCode);
        if (this.mText != null) {
            dest.writeCharSequence(this.mText);
        }
        dest.writeBundle(this.mExtras);
        if (this.mTransliteration != null) {
            dest.writeCharSequence(this.mTransliteration);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TranslationResponseValue(Parcel in) {
        byte flg = in.readByte();
        int statusCode = in.readInt();
        CharSequence text = (flg & 2) == 0 ? null : in.readCharSequence();
        Bundle extras = in.readBundle();
        CharSequence transliteration = (flg & 8) == 0 ? null : in.readCharSequence();
        this.mStatusCode = statusCode;
        if (this.mStatusCode != 0 && this.mStatusCode != 1) {
            throw new IllegalArgumentException("statusCode was " + this.mStatusCode + " but must be one of: STATUS_SUCCESS(" + 0 + "), STATUS_ERROR(" + 1 + ")");
        }
        this.mText = text;
        this.mExtras = extras;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mExtras);
        this.mTransliteration = transliteration;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        private int mStatusCode;
        private CharSequence mText;
        private Bundle mExtras;
        private CharSequence mTransliteration;
        private long mBuilderFieldsSet = 0L;

        public Builder(int statusCode) {
            this.mStatusCode = statusCode;
            if (this.mStatusCode != 0 && this.mStatusCode != 1) {
                throw new IllegalArgumentException("statusCode was " + this.mStatusCode + " but must be one of: STATUS_SUCCESS(" + 0 + "), STATUS_ERROR(" + 1 + ")");
            }
        }

        public Builder setText(CharSequence value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mText = value2;
            return this;
        }

        public Builder setExtras(Bundle value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mExtras = value2;
            return this;
        }

        public Builder setTransliteration(CharSequence value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mTransliteration = value2;
            return this;
        }

        public TranslationResponseValue build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mText = TranslationResponseValue.defaultText();
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mExtras = TranslationResponseValue.defaultExtras();
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mTransliteration = TranslationResponseValue.defaultTransliteration();
            }
            TranslationResponseValue o = new TranslationResponseValue(this.mStatusCode, this.mText, this.mExtras, this.mTransliteration);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x10L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }
    }
}

