/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.LocaleList;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.util.ArrayMap;
import android.view.textclassifier.ConversationActions;
import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifierEvent;
import android.view.textclassifier.TextLanguage;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface TextClassifier {
    public static final String LOG_TAG = "androidtc";
    public static final int LOCAL = 0;
    public static final int SYSTEM = 1;
    public static final int DEFAULT_SYSTEM = 2;
    public static final String TYPE_UNKNOWN = "";
    public static final String TYPE_OTHER = "other";
    public static final String TYPE_EMAIL = "email";
    public static final String TYPE_PHONE = "phone";
    public static final String TYPE_ADDRESS = "address";
    public static final String TYPE_URL = "url";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_DATE_TIME = "datetime";
    public static final String TYPE_FLIGHT_NUMBER = "flight";
    public static final String TYPE_DICTIONARY = "dictionary";
    public static final String HINT_TEXT_IS_EDITABLE = "android.text_is_editable";
    public static final String HINT_TEXT_IS_NOT_EDITABLE = "android.text_is_not_editable";
    public static final String WIDGET_TYPE_TEXTVIEW = "textview";
    public static final String WIDGET_TYPE_EDITTEXT = "edittext";
    public static final String WIDGET_TYPE_UNSELECTABLE_TEXTVIEW = "nosel-textview";
    public static final String WIDGET_TYPE_WEBVIEW = "webview";
    public static final String WIDGET_TYPE_EDIT_WEBVIEW = "edit-webview";
    public static final String WIDGET_TYPE_CUSTOM_TEXTVIEW = "customview";
    public static final String WIDGET_TYPE_CUSTOM_EDITTEXT = "customedit";
    public static final String WIDGET_TYPE_CUSTOM_UNSELECTABLE_TEXTVIEW = "nosel-customview";
    public static final String WIDGET_TYPE_NOTIFICATION = "notification";
    public static final String WIDGET_TYPE_CLIPBOARD = "clipboard";
    public static final String WIDGET_TYPE_UNKNOWN = "unknown";
    public static final TextClassifier NO_OP = new TextClassifier(){

        public String toString() {
            return "TextClassifier.NO_OP";
        }
    };
    public static final String EXTRA_FROM_TEXT_CLASSIFIER = "android.view.textclassifier.extra.FROM_TEXT_CLASSIFIER";

    public static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "Local";
            }
            case 1: {
                return "System";
            }
            case 2: {
                return "Default system";
            }
        }
        return "Unknown";
    }

    default public TextSelection suggestSelection(TextSelection.Request request) {
        Objects.requireNonNull(request);
        Utils.checkMainThread();
        return new TextSelection.Builder(request.getStartIndex(), request.getEndIndex()).build();
    }

    default public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, LocaleList defaultLocales) {
        TextSelection.Request request = new TextSelection.Request.Builder(text, selectionStartIndex, selectionEndIndex).setDefaultLocales(defaultLocales).build();
        return this.suggestSelection(request);
    }

    default public TextClassification classifyText(TextClassification.Request request) {
        Objects.requireNonNull(request);
        Utils.checkMainThread();
        return TextClassification.EMPTY;
    }

    default public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales) {
        TextClassification.Request request = new TextClassification.Request.Builder(text, startIndex, endIndex).setDefaultLocales(defaultLocales).build();
        return this.classifyText(request);
    }

    default public TextLinks generateLinks(TextLinks.Request request) {
        Objects.requireNonNull(request);
        Utils.checkMainThread();
        return new TextLinks.Builder(request.getText().toString()).build();
    }

    default public int getMaxGenerateLinksTextLength() {
        return Integer.MAX_VALUE;
    }

    default public TextLanguage detectLanguage(TextLanguage.Request request) {
        Objects.requireNonNull(request);
        Utils.checkMainThread();
        return TextLanguage.EMPTY;
    }

    default public ConversationActions suggestConversationActions(ConversationActions.Request request) {
        Objects.requireNonNull(request);
        Utils.checkMainThread();
        return new ConversationActions(Collections.emptyList(), null);
    }

    default public void onSelectionEvent(SelectionEvent event) {
    }

    default public void onTextClassifierEvent(TextClassifierEvent event) {
    }

    default public void destroy() {
    }

    default public boolean isDestroyed() {
        return false;
    }

    default public void dump(IndentingPrintWriter printWriter) {
    }

    public static class Utils {
        @GuardedBy(value={"WORD_ITERATOR"})
        private static final BreakIterator WORD_ITERATOR = BreakIterator.getWordInstance();

        static void checkArgument(CharSequence text, int startIndex, int endIndex) {
            Preconditions.checkArgument(text != null);
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex <= text.length());
            Preconditions.checkArgument(endIndex > startIndex);
        }

        static boolean checkTextLength(CharSequence text, int maxLength) {
            int textLength = text.length();
            return textLength >= 0 && textLength <= maxLength;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getSubString(String text, int start, int end, int minimumLength) {
            Preconditions.checkArgument(start >= 0);
            Preconditions.checkArgument(end <= text.length());
            Preconditions.checkArgument(start <= end);
            if (text.length() < minimumLength) {
                return text;
            }
            int length = end - start;
            if (length >= minimumLength) {
                return text.substring(start, end);
            }
            int offset2 = (minimumLength - length) / 2;
            int iterStart = Math.max(0, Math.min(start - offset2, text.length() - minimumLength));
            int iterEnd = Math.min(text.length(), iterStart + minimumLength);
            BreakIterator breakIterator = WORD_ITERATOR;
            synchronized (breakIterator) {
                WORD_ITERATOR.setText(text);
                iterStart = WORD_ITERATOR.isBoundary(iterStart) ? iterStart : Math.max(0, WORD_ITERATOR.preceding(iterStart));
                iterEnd = WORD_ITERATOR.isBoundary(iterEnd) ? iterEnd : Math.max(iterEnd, WORD_ITERATOR.following(iterEnd));
                WORD_ITERATOR.setText(TextClassifier.TYPE_UNKNOWN);
                return text.substring(iterStart, iterEnd);
            }
        }

        public static TextLinks generateLegacyLinks(TextLinks.Request request) {
            String string2 = request.getText().toString();
            TextLinks.Builder links = new TextLinks.Builder(string2);
            Collection<String> entities = request.getEntityConfig().resolveEntityListModifications(Collections.emptyList());
            if (entities.contains(TextClassifier.TYPE_URL)) {
                Utils.addLinks(links, string2, TextClassifier.TYPE_URL);
            }
            if (entities.contains(TextClassifier.TYPE_PHONE)) {
                Utils.addLinks(links, string2, TextClassifier.TYPE_PHONE);
            }
            if (entities.contains(TextClassifier.TYPE_EMAIL)) {
                Utils.addLinks(links, string2, TextClassifier.TYPE_EMAIL);
            }
            return links.build();
        }

        private static void addLinks(TextLinks.Builder links, String string2, String entityType) {
            SpannableString spannable = new SpannableString(string2);
            if (Linkify.addLinks(spannable, Utils.linkMask(entityType))) {
                URLSpan[] spans;
                for (URLSpan urlSpan : spans = spannable.getSpans(0, spannable.length(), URLSpan.class)) {
                    links.addLink(spannable.getSpanStart(urlSpan), spannable.getSpanEnd(urlSpan), Utils.entityScores(entityType), urlSpan);
                }
            }
        }

        private static int linkMask(String entityType) {
            switch (entityType) {
                case "url": {
                    return 1;
                }
                case "phone": {
                    return 4;
                }
                case "email": {
                    return 2;
                }
            }
            return 0;
        }

        private static Map<String, Float> entityScores(String entityType) {
            ArrayMap<String, Float> scores = new ArrayMap<String, Float>();
            scores.put(entityType, Float.valueOf(1.0f));
            return scores;
        }

        static void checkMainThread() {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                Log.w(TextClassifier.LOG_TAG, "TextClassifier called on main thread");
            }
        }
    }

    public static class EntityConfig
    implements Parcelable {
        private final List<String> mIncludedTypes;
        private final List<String> mExcludedTypes;
        private final List<String> mHints;
        private final boolean mIncludeTypesFromTextClassifier;
        public static final Parcelable.Creator<EntityConfig> CREATOR = new Parcelable.Creator<EntityConfig>(){

            @Override
            public EntityConfig createFromParcel(Parcel in) {
                return new EntityConfig(in);
            }

            public EntityConfig[] newArray(int size) {
                return new EntityConfig[size];
            }
        };

        private EntityConfig(List<String> includedEntityTypes, List<String> excludedEntityTypes, List<String> hints, boolean includeTypesFromTextClassifier) {
            this.mIncludedTypes = Objects.requireNonNull(includedEntityTypes);
            this.mExcludedTypes = Objects.requireNonNull(excludedEntityTypes);
            this.mHints = Objects.requireNonNull(hints);
            this.mIncludeTypesFromTextClassifier = includeTypesFromTextClassifier;
        }

        private EntityConfig(Parcel in) {
            this.mIncludedTypes = new ArrayList<String>();
            in.readStringList(this.mIncludedTypes);
            this.mExcludedTypes = new ArrayList<String>();
            in.readStringList(this.mExcludedTypes);
            ArrayList<String> tmpHints = new ArrayList<String>();
            in.readStringList(tmpHints);
            this.mHints = Collections.unmodifiableList(tmpHints);
            this.mIncludeTypesFromTextClassifier = in.readByte() != 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeStringList(this.mIncludedTypes);
            parcel.writeStringList(this.mExcludedTypes);
            parcel.writeStringList(this.mHints);
            parcel.writeByte((byte)(this.mIncludeTypesFromTextClassifier ? 1 : 0));
        }

        @Deprecated
        public static EntityConfig createWithHints(Collection<String> hints) {
            return new Builder().includeTypesFromTextClassifier(true).setHints(hints).build();
        }

        @Deprecated
        public static EntityConfig create(Collection<String> hints, Collection<String> includedEntityTypes, Collection<String> excludedEntityTypes) {
            return new Builder().setIncludedTypes(includedEntityTypes).setExcludedTypes(excludedEntityTypes).setHints(hints).includeTypesFromTextClassifier(true).build();
        }

        @Deprecated
        public static EntityConfig createWithExplicitEntityList(Collection<String> entityTypes) {
            return new Builder().setIncludedTypes(entityTypes).includeTypesFromTextClassifier(false).build();
        }

        public Collection<String> resolveEntityListModifications(Collection<String> entityTypes) {
            HashSet<String> finalSet = new HashSet<String>();
            if (this.mIncludeTypesFromTextClassifier) {
                finalSet.addAll(entityTypes);
            }
            finalSet.addAll(this.mIncludedTypes);
            finalSet.removeAll(this.mExcludedTypes);
            return finalSet;
        }

        public Collection<String> getHints() {
            return this.mHints;
        }

        public boolean shouldIncludeTypesFromTextClassifier() {
            return this.mIncludeTypesFromTextClassifier;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public static class Builder {
            private Collection<String> mIncludedTypes;
            private Collection<String> mExcludedTypes;
            private Collection<String> mHints;
            private boolean mIncludeTypesFromTextClassifier = true;

            public Builder setIncludedTypes(Collection<String> includedTypes) {
                this.mIncludedTypes = includedTypes;
                return this;
            }

            public Builder setExcludedTypes(Collection<String> excludedTypes) {
                this.mExcludedTypes = excludedTypes;
                return this;
            }

            public Builder includeTypesFromTextClassifier(boolean includeTypesFromTextClassifier) {
                this.mIncludeTypesFromTextClassifier = includeTypesFromTextClassifier;
                return this;
            }

            public Builder setHints(Collection<String> hints) {
                this.mHints = hints;
                return this;
            }

            public EntityConfig build() {
                return new EntityConfig(this.mIncludedTypes == null ? Collections.emptyList() : new ArrayList<String>(this.mIncludedTypes), this.mExcludedTypes == null ? Collections.emptyList() : new ArrayList<String>(this.mExcludedTypes), this.mHints == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(this.mHints)), this.mIncludeTypesFromTextClassifier);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WidgetType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Hints {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EntityType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextClassifierType {
    }
}

