/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Size;
import android.util.Slog;
import android.view.SurfaceControlViewHost;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InlineSuggestionInfo;
import android.widget.inline.InlineContentView;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Parcelling;
import com.android.internal.view.inline.IInlineContentCallback;
import com.android.internal.view.inline.IInlineContentProvider;
import com.android.internal.view.inline.InlineTooltipUi;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class InlineSuggestion
implements Parcelable {
    private static final String TAG = "InlineSuggestion";
    private final InlineSuggestionInfo mInfo;
    private final IInlineContentProvider mContentProvider;
    private InlineContentCallbackImpl mInlineContentCallback;
    private InlineTooltipUi mInlineTooltipUi;
    static Parcelling<InlineContentCallbackImpl> sParcellingForInlineContentCallback = Parcelling.Cache.get(InlineContentCallbackImplParceling.class);
    static Parcelling<InlineTooltipUi> sParcellingForInlineTooltipUi;
    public static final Parcelable.Creator<InlineSuggestion> CREATOR;

    public static InlineSuggestion newInlineSuggestion(InlineSuggestionInfo info) {
        return new InlineSuggestion(info, null, null, null);
    }

    public InlineSuggestion(InlineSuggestionInfo info, IInlineContentProvider contentProvider) {
        this(info, contentProvider, null, null);
    }

    public void inflate(Context context, Size size, Executor callbackExecutor, Consumer<InlineContentView> callback2) {
        Size minSize = this.mInfo.getInlinePresentationSpec().getMinSize();
        Size maxSize = this.mInfo.getInlinePresentationSpec().getMaxSize();
        if (!InlineSuggestion.isValid(size.getWidth(), minSize.getWidth(), maxSize.getWidth()) || !InlineSuggestion.isValid(size.getHeight(), minSize.getHeight(), maxSize.getHeight())) {
            throw new IllegalArgumentException("size is neither between min:" + minSize + " and max:" + maxSize + ", nor wrap_content");
        }
        InlineSuggestion toolTip = this.mInfo.getTooltip();
        if (toolTip != null) {
            if (this.mInlineTooltipUi == null) {
                this.mInlineTooltipUi = new InlineTooltipUi(context);
            }
        } else {
            this.mInlineTooltipUi = null;
        }
        this.mInlineContentCallback = this.getInlineContentCallback(context, callbackExecutor, callback2, this.mInlineTooltipUi);
        if (this.mContentProvider == null) {
            callbackExecutor.execute(() -> callback2.accept(null));
            this.mInlineTooltipUi = null;
            return;
        }
        try {
            this.mContentProvider.provideContent(size.getWidth(), size.getHeight(), new InlineContentCallbackWrapper(this.mInlineContentCallback));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Error creating suggestion content surface: " + e);
            callbackExecutor.execute(() -> callback2.accept(null));
        }
        if (toolTip == null) {
            return;
        }
        Size tooltipSize = new Size(-2, -2);
        this.mInfo.getTooltip().inflate(context, tooltipSize, callbackExecutor, view -> Handler.getMain().post(() -> this.mInlineTooltipUi.setTooltipView((InlineContentView)view)));
    }

    private static boolean isValid(int actual, int min, int max) {
        if (actual == -2) {
            return true;
        }
        return actual >= min && actual <= max;
    }

    private synchronized InlineContentCallbackImpl getInlineContentCallback(Context context, Executor callbackExecutor, Consumer<InlineContentView> callback2, InlineTooltipUi inlineTooltipUi) {
        if (this.mInlineContentCallback != null) {
            throw new IllegalStateException("Already called #inflate()");
        }
        return new InlineContentCallbackImpl(context, this.mContentProvider, callbackExecutor, callback2, inlineTooltipUi);
    }

    public InlineSuggestion(InlineSuggestionInfo info, IInlineContentProvider contentProvider, InlineContentCallbackImpl inlineContentCallback, InlineTooltipUi inlineTooltipUi) {
        this.mInfo = info;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mInfo);
        this.mContentProvider = contentProvider;
        this.mInlineContentCallback = inlineContentCallback;
        this.mInlineTooltipUi = inlineTooltipUi;
    }

    public InlineSuggestionInfo getInfo() {
        return this.mInfo;
    }

    public IInlineContentProvider getContentProvider() {
        return this.mContentProvider;
    }

    public InlineContentCallbackImpl getInlineContentCallback() {
        return this.mInlineContentCallback;
    }

    public InlineTooltipUi getInlineTooltipUi() {
        return this.mInlineTooltipUi;
    }

    public String toString() {
        return "InlineSuggestion { info = " + this.mInfo + ", contentProvider = " + this.mContentProvider + ", inlineContentCallback = " + this.mInlineContentCallback + ", inlineTooltipUi = " + this.mInlineTooltipUi + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineSuggestion that = (InlineSuggestion)o;
        return Objects.equals(this.mInfo, that.mInfo) && Objects.equals(this.mContentProvider, that.mContentProvider) && Objects.equals(this.mInlineContentCallback, that.mInlineContentCallback) && Objects.equals(this.mInlineTooltipUi, that.mInlineTooltipUi);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mInfo);
        _hash = 31 * _hash + Objects.hashCode(this.mContentProvider);
        _hash = 31 * _hash + Objects.hashCode(this.mInlineContentCallback);
        _hash = 31 * _hash + Objects.hashCode(this.mInlineTooltipUi);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mContentProvider != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mInlineContentCallback != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mInlineTooltipUi != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeTypedObject(this.mInfo, flags);
        if (this.mContentProvider != null) {
            dest.writeStrongInterface(this.mContentProvider);
        }
        sParcellingForInlineContentCallback.parcel(this.mInlineContentCallback, dest, flags);
        sParcellingForInlineTooltipUi.parcel(this.mInlineTooltipUi, dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    InlineSuggestion(Parcel in) {
        byte flg = in.readByte();
        InlineSuggestionInfo info = in.readTypedObject(InlineSuggestionInfo.CREATOR);
        IInlineContentProvider contentProvider = (flg & 2) == 0 ? null : IInlineContentProvider.Stub.asInterface(in.readStrongBinder());
        InlineContentCallbackImpl inlineContentCallback = sParcellingForInlineContentCallback.unparcel(in);
        InlineTooltipUi inlineTooltipUi = sParcellingForInlineTooltipUi.unparcel(in);
        this.mInfo = info;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mInfo);
        this.mContentProvider = contentProvider;
        this.mInlineContentCallback = inlineContentCallback;
        this.mInlineTooltipUi = inlineTooltipUi;
    }

    @Deprecated
    private void __metadata() {
    }

    static {
        if (sParcellingForInlineContentCallback == null) {
            sParcellingForInlineContentCallback = Parcelling.Cache.put(new InlineContentCallbackImplParceling());
        }
        if ((sParcellingForInlineTooltipUi = Parcelling.Cache.get(InlineTooltipUiParceling.class)) == null) {
            sParcellingForInlineTooltipUi = Parcelling.Cache.put(new InlineTooltipUiParceling());
        }
        CREATOR = new Parcelable.Creator<InlineSuggestion>(){

            public InlineSuggestion[] newArray(int size) {
                return new InlineSuggestion[size];
            }

            @Override
            public InlineSuggestion createFromParcel(Parcel in) {
                return new InlineSuggestion(in);
            }
        };
    }

    private static class InlineTooltipUiParceling
    implements Parcelling<InlineTooltipUi> {
        private InlineTooltipUiParceling() {
        }

        @Override
        public void parcel(InlineTooltipUi item, Parcel dest, int parcelFlags) {
        }

        @Override
        public InlineTooltipUi unparcel(Parcel source) {
            return null;
        }
    }

    private static class InlineContentCallbackImplParceling
    implements Parcelling<InlineContentCallbackImpl> {
        private InlineContentCallbackImplParceling() {
        }

        @Override
        public void parcel(InlineContentCallbackImpl item, Parcel dest, int parcelFlags) {
        }

        @Override
        public InlineContentCallbackImpl unparcel(Parcel source) {
            return null;
        }
    }

    private static class InlineContentCallbackImpl {
        private final Handler mMainHandler = new Handler(Looper.getMainLooper());
        private final Context mContext;
        private final IInlineContentProvider mInlineContentProvider;
        private final Executor mCallbackExecutor;
        private final Consumer<InlineContentView> mCallback;
        private boolean mFirstContentReceived = false;
        private InlineContentView mView;
        private SurfaceControlViewHost.SurfacePackage mSurfacePackage;
        private Consumer<SurfaceControlViewHost.SurfacePackage> mSurfacePackageConsumer;
        private InlineTooltipUi mInlineTooltipUi;

        InlineContentCallbackImpl(Context context, IInlineContentProvider inlineContentProvider, Executor callbackExecutor, Consumer<InlineContentView> callback2, InlineTooltipUi inlineTooltipUi) {
            this.mContext = context;
            this.mInlineContentProvider = inlineContentProvider;
            this.mCallbackExecutor = callbackExecutor;
            this.mCallback = callback2;
            this.mInlineTooltipUi = inlineTooltipUi;
        }

        public void onContent(SurfaceControlViewHost.SurfacePackage content2, int width, int height) {
            this.mMainHandler.post(() -> this.handleOnContent(content2, width, height));
        }

        private void handleOnContent(SurfaceControlViewHost.SurfacePackage content2, int width, int height) {
            if (!this.mFirstContentReceived) {
                this.handleOnFirstContentReceived(content2, width, height);
                this.mFirstContentReceived = true;
            } else {
                this.handleOnSurfacePackage(content2);
            }
        }

        private void handleOnFirstContentReceived(SurfaceControlViewHost.SurfacePackage content2, int width, int height) {
            this.mSurfacePackage = content2;
            if (this.mSurfacePackage == null) {
                this.mCallbackExecutor.execute(() -> this.mCallback.accept(null));
            } else {
                this.mView = new InlineContentView(this.mContext);
                if (this.mInlineTooltipUi != null) {
                    this.mView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                        @Override
                        public void onLayoutChange(View v, int left, int top, int right2, int bottom2, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                            if (mInlineTooltipUi != null) {
                                mInlineTooltipUi.update(mView);
                            }
                        }
                    });
                }
                this.mView.setLayoutParams(new ViewGroup.LayoutParams(width, height));
                this.mView.setChildSurfacePackageUpdater(this.getSurfacePackageUpdater());
                this.mCallbackExecutor.execute(() -> this.mCallback.accept(this.mView));
            }
        }

        private void handleOnSurfacePackage(SurfaceControlViewHost.SurfacePackage surfacePackage) {
            if (surfacePackage == null) {
                return;
            }
            if (this.mSurfacePackage != null || this.mSurfacePackageConsumer == null) {
                surfacePackage.release();
                try {
                    this.mInlineContentProvider.onSurfacePackageReleased();
                }
                catch (RemoteException e) {
                    Slog.w(InlineSuggestion.TAG, "Error calling onSurfacePackageReleased(): " + e);
                }
                return;
            }
            this.mSurfacePackage = surfacePackage;
            if (this.mSurfacePackage == null) {
                return;
            }
            if (this.mSurfacePackageConsumer != null) {
                this.mSurfacePackageConsumer.accept(this.mSurfacePackage);
                this.mSurfacePackageConsumer = null;
            }
        }

        private void handleOnSurfacePackageReleased() {
            if (this.mSurfacePackage != null) {
                try {
                    this.mInlineContentProvider.onSurfacePackageReleased();
                }
                catch (RemoteException e) {
                    Slog.w(InlineSuggestion.TAG, "Error calling onSurfacePackageReleased(): " + e);
                }
                this.mSurfacePackage = null;
            }
            this.mSurfacePackageConsumer = null;
        }

        private void handleGetSurfacePackage(Consumer<SurfaceControlViewHost.SurfacePackage> consumer) {
            if (this.mSurfacePackage != null) {
                consumer.accept(this.mSurfacePackage);
            } else {
                this.mSurfacePackageConsumer = consumer;
                try {
                    this.mInlineContentProvider.requestSurfacePackage();
                }
                catch (RemoteException e) {
                    Slog.w(InlineSuggestion.TAG, "Error calling getSurfacePackage(): " + e);
                    consumer.accept(null);
                    this.mSurfacePackageConsumer = null;
                }
            }
        }

        private InlineContentView.SurfacePackageUpdater getSurfacePackageUpdater() {
            return new InlineContentView.SurfacePackageUpdater(){

                @Override
                public void onSurfacePackageReleased() {
                    mMainHandler.post(() -> this.handleOnSurfacePackageReleased());
                }

                @Override
                public void getSurfacePackage(Consumer<SurfaceControlViewHost.SurfacePackage> consumer) {
                    mMainHandler.post(() -> this.handleGetSurfacePackage(consumer));
                }
            };
        }

        public void onClick() {
            this.mMainHandler.post(() -> {
                if (this.mView != null && this.mView.hasOnClickListeners()) {
                    this.mView.callOnClick();
                }
            });
        }

        public void onLongClick() {
            this.mMainHandler.post(() -> {
                if (this.mView != null && this.mView.hasOnLongClickListeners()) {
                    this.mView.performLongClick();
                }
            });
        }
    }

    private static class InlineContentCallbackWrapper
    extends IInlineContentCallback.Stub {
        private final WeakReference<InlineContentCallbackImpl> mCallbackImpl;

        InlineContentCallbackWrapper(InlineContentCallbackImpl callbackImpl) {
            this.mCallbackImpl = new WeakReference<InlineContentCallbackImpl>(callbackImpl);
        }

        @Override
        public void onContent(SurfaceControlViewHost.SurfacePackage content2, int width, int height) {
            InlineContentCallbackImpl callbackImpl = (InlineContentCallbackImpl)this.mCallbackImpl.get();
            if (callbackImpl != null) {
                callbackImpl.onContent(content2, width, height);
            }
        }

        @Override
        public void onClick() {
            InlineContentCallbackImpl callbackImpl = (InlineContentCallbackImpl)this.mCallbackImpl.get();
            if (callbackImpl != null) {
                callbackImpl.onClick();
            }
        }

        @Override
        public void onLongClick() {
            InlineContentCallbackImpl callbackImpl = (InlineContentCallbackImpl)this.mCallbackImpl.get();
            if (callbackImpl != null) {
                callbackImpl.onLongClick();
            }
        }
    }
}

