/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.contentcapture.DataRemovalRequest;
import android.view.contentcapture.DataShareRequest;
import android.view.contentcapture.IContentCaptureOptionsCallback;
import android.view.contentcapture.IDataShareWriteAdapter;
import com.android.internal.os.IResultReceiver;

public interface IContentCaptureManager
extends IInterface {
    public static final String DESCRIPTOR = "android.view.contentcapture.IContentCaptureManager";

    public void startSession(IBinder var1, IBinder var2, ComponentName var3, int var4, int var5, IResultReceiver var6) throws RemoteException;

    public void finishSession(int var1) throws RemoteException;

    public void getServiceComponentName(IResultReceiver var1) throws RemoteException;

    public void removeData(DataRemovalRequest var1) throws RemoteException;

    public void shareData(DataShareRequest var1, IDataShareWriteAdapter var2) throws RemoteException;

    public void isContentCaptureFeatureEnabled(IResultReceiver var1) throws RemoteException;

    public void getServiceSettingsActivity(IResultReceiver var1) throws RemoteException;

    public void getContentCaptureConditions(String var1, IResultReceiver var2) throws RemoteException;

    public void resetTemporaryService(int var1) throws RemoteException;

    public void setTemporaryService(int var1, String var2, int var3) throws RemoteException;

    public void setDefaultServiceEnabled(int var1, boolean var2) throws RemoteException;

    public void registerContentCaptureOptionsCallback(String var1, IContentCaptureOptionsCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContentCaptureManager {
        static final int TRANSACTION_startSession = 1;
        static final int TRANSACTION_finishSession = 2;
        static final int TRANSACTION_getServiceComponentName = 3;
        static final int TRANSACTION_removeData = 4;
        static final int TRANSACTION_shareData = 5;
        static final int TRANSACTION_isContentCaptureFeatureEnabled = 6;
        static final int TRANSACTION_getServiceSettingsActivity = 7;
        static final int TRANSACTION_getContentCaptureConditions = 8;
        static final int TRANSACTION_resetTemporaryService = 9;
        static final int TRANSACTION_setTemporaryService = 10;
        static final int TRANSACTION_setDefaultServiceEnabled = 11;
        static final int TRANSACTION_registerContentCaptureOptionsCallback = 12;

        public Stub() {
            this.attachInterface(this, IContentCaptureManager.DESCRIPTOR);
        }

        public static IContentCaptureManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IContentCaptureManager.DESCRIPTOR);
            if (iin != null && iin instanceof IContentCaptureManager) {
                return (IContentCaptureManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startSession";
                }
                case 2: {
                    return "finishSession";
                }
                case 3: {
                    return "getServiceComponentName";
                }
                case 4: {
                    return "removeData";
                }
                case 5: {
                    return "shareData";
                }
                case 6: {
                    return "isContentCaptureFeatureEnabled";
                }
                case 7: {
                    return "getServiceSettingsActivity";
                }
                case 8: {
                    return "getContentCaptureConditions";
                }
                case 9: {
                    return "resetTemporaryService";
                }
                case 10: {
                    return "setTemporaryService";
                }
                case 11: {
                    return "setDefaultServiceEnabled";
                }
                case 12: {
                    return "registerContentCaptureOptionsCallback";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IContentCaptureManager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    ComponentName _arg2 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    IResultReceiver _arg5 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    this.startSession(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.finishSession(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    this.getServiceComponentName(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    DataRemovalRequest _arg0 = 0 != data.readInt() ? DataRemovalRequest.CREATOR.createFromParcel(data) : null;
                    this.removeData(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    DataShareRequest _arg0 = 0 != data.readInt() ? DataShareRequest.CREATOR.createFromParcel(data) : null;
                    IDataShareWriteAdapter _arg1 = IDataShareWriteAdapter.Stub.asInterface(data.readStrongBinder());
                    this.shareData(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    this.isContentCaptureFeatureEnabled(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    this.getServiceSettingsActivity(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IResultReceiver _arg1 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    this.getContentCaptureConditions(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.resetTemporaryService(_arg0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.setTemporaryService(_arg0, _arg1, _arg2);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setDefaultServiceEnabled(_arg0, _arg1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IContentCaptureOptionsCallback _arg1 = IContentCaptureOptionsCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerContentCaptureOptionsCallback(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IContentCaptureManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IContentCaptureManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IContentCaptureManager {
            private IBinder mRemote;
            public static IContentCaptureManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IContentCaptureManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSession(IBinder activityToken, IBinder shareableActivityToken, ComponentName componentName, int sessionId, int flags, IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeStrongBinder(shareableActivityToken);
                    if (componentName != null) {
                        _data.writeInt(1);
                        componentName.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(sessionId);
                    _data.writeInt(flags);
                    _data.writeStrongBinder(result != null ? result.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startSession(activityToken, shareableActivityToken, componentName, sessionId, flags, result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishSession(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().finishSession(sessionId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getServiceComponentName(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeStrongBinder(result != null ? result.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getServiceComponentName(result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeData(DataRemovalRequest request) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeData(request);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shareData(DataShareRequest request, IDataShareWriteAdapter adapter) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(adapter != null ? adapter.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().shareData(request, adapter);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isContentCaptureFeatureEnabled(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeStrongBinder(result != null ? result.asBinder() : null);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().isContentCaptureFeatureEnabled(result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getServiceSettingsActivity(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeStrongBinder(result != null ? result.asBinder() : null);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getServiceSettingsActivity(result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getContentCaptureConditions(String packageName, IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(result != null ? result.asBinder() : null);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getContentCaptureConditions(packageName, result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetTemporaryService(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().resetTemporaryService(userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTemporaryService(int userId, String serviceName, int duration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(serviceName);
                    _data.writeInt(duration);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTemporaryService(userId, serviceName, duration);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultServiceEnabled(int userId, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDefaultServiceEnabled(userId, enabled);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerContentCaptureOptionsCallback(String packageName, IContentCaptureOptionsCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerContentCaptureOptionsCallback(packageName, callback2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContentCaptureManager {
        @Override
        public void startSession(IBinder activityToken, IBinder shareableActivityToken, ComponentName componentName, int sessionId, int flags, IResultReceiver result) throws RemoteException {
        }

        @Override
        public void finishSession(int sessionId) throws RemoteException {
        }

        @Override
        public void getServiceComponentName(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void removeData(DataRemovalRequest request) throws RemoteException {
        }

        @Override
        public void shareData(DataShareRequest request, IDataShareWriteAdapter adapter) throws RemoteException {
        }

        @Override
        public void isContentCaptureFeatureEnabled(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void getServiceSettingsActivity(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void getContentCaptureConditions(String packageName, IResultReceiver result) throws RemoteException {
        }

        @Override
        public void resetTemporaryService(int userId) throws RemoteException {
        }

        @Override
        public void setTemporaryService(int userId, String serviceName, int duration) throws RemoteException {
        }

        @Override
        public void setDefaultServiceEnabled(int userId, boolean enabled) throws RemoteException {
        }

        @Override
        public void registerContentCaptureOptionsCallback(String packageName, IContentCaptureOptionsCallback callback2) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

