/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.app.ActivityThread;
import android.content.LocusId;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.IntArray;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class DataRemovalRequest
implements Parcelable {
    public static final int FLAG_IS_PREFIX = 1;
    private final String mPackageName;
    private final boolean mForEverything;
    private ArrayList<LocusIdRequest> mLocusIdRequests;
    public static final Parcelable.Creator<DataRemovalRequest> CREATOR = new Parcelable.Creator<DataRemovalRequest>(){

        @Override
        public DataRemovalRequest createFromParcel(Parcel parcel) {
            return new DataRemovalRequest(parcel);
        }

        public DataRemovalRequest[] newArray(int size) {
            return new DataRemovalRequest[size];
        }
    };

    private DataRemovalRequest(Builder builder2) {
        this.mPackageName = ActivityThread.currentActivityThread().getApplication().getPackageName();
        this.mForEverything = builder2.mForEverything;
        if (builder2.mLocusIds != null) {
            int size = builder2.mLocusIds.size();
            this.mLocusIdRequests = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.mLocusIdRequests.add(new LocusIdRequest((LocusId)builder2.mLocusIds.get(i), builder2.mFlags.get(i)));
            }
        }
    }

    private DataRemovalRequest(Parcel parcel) {
        this.mPackageName = parcel.readString();
        this.mForEverything = parcel.readBoolean();
        if (!this.mForEverything) {
            int size = parcel.readInt();
            this.mLocusIdRequests = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.mLocusIdRequests.add(new LocusIdRequest((LocusId)parcel.readValue(null), parcel.readInt()));
            }
        }
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public boolean isForEverything() {
        return this.mForEverything;
    }

    public List<LocusIdRequest> getLocusIdRequests() {
        return this.mLocusIdRequests;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mPackageName);
        parcel.writeBoolean(this.mForEverything);
        if (!this.mForEverything) {
            int size = this.mLocusIdRequests.size();
            parcel.writeInt(size);
            for (int i = 0; i < size; ++i) {
                LocusIdRequest request = this.mLocusIdRequests.get(i);
                parcel.writeValue(request.getLocusId());
                parcel.writeInt(request.getFlags());
            }
        }
    }

    public class LocusIdRequest {
        private final LocusId mLocusId;
        private final int mFlags;

        private LocusIdRequest(LocusId locusId, int flags) {
            this.mLocusId = locusId;
            this.mFlags = flags;
        }

        public LocusId getLocusId() {
            return this.mLocusId;
        }

        public int getFlags() {
            return this.mFlags;
        }
    }

    public static class Builder {
        private boolean mForEverything;
        private ArrayList<LocusId> mLocusIds;
        private IntArray mFlags;
        private boolean mDestroyed;

        public Builder forEverything() {
            this.throwIfDestroyed();
            Preconditions.checkState(this.mLocusIds == null, "Already added LocusIds");
            this.mForEverything = true;
            return this;
        }

        public Builder addLocusId(LocusId locusId, int flags) {
            this.throwIfDestroyed();
            Preconditions.checkState(!this.mForEverything, "Already is for everything");
            Preconditions.checkNotNull(locusId);
            if (this.mLocusIds == null) {
                this.mLocusIds = new ArrayList();
                this.mFlags = new IntArray();
            }
            this.mLocusIds.add(locusId);
            this.mFlags.add(flags);
            return this;
        }

        public DataRemovalRequest build() {
            this.throwIfDestroyed();
            Preconditions.checkState(this.mForEverything || this.mLocusIds != null, "must call either #forEverything() or add one #addLocusId()");
            this.mDestroyed = true;
            return new DataRemovalRequest(this);
        }

        private void throwIfDestroyed() {
            Preconditions.checkState(!this.mDestroyed, "Already destroyed!");
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Flags {
    }
}

