/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.content.ClipData;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.KeyEvent;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutofillWindowPresenter;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;
import java.util.List;

public interface IAutoFillManagerClient
extends IInterface {
    public void setState(int var1) throws RemoteException;

    public void autofill(int var1, List<AutofillId> var2, List<AutofillValue> var3, boolean var4) throws RemoteException;

    public void autofillContent(int var1, AutofillId var2, ClipData var3) throws RemoteException;

    public void authenticate(int var1, int var2, IntentSender var3, Intent var4, boolean var5) throws RemoteException;

    public void setTrackedViews(int var1, AutofillId[] var2, boolean var3, boolean var4, AutofillId[] var5, AutofillId var6) throws RemoteException;

    public void requestShowFillUi(int var1, AutofillId var2, int var3, int var4, Rect var5, IAutofillWindowPresenter var6) throws RemoteException;

    public void requestHideFillUi(int var1, AutofillId var2) throws RemoteException;

    public void notifyNoFillUi(int var1, AutofillId var2, int var3) throws RemoteException;

    public void notifyFillUiShown(int var1, AutofillId var2) throws RemoteException;

    public void notifyFillUiHidden(int var1, AutofillId var2) throws RemoteException;

    public void dispatchUnhandledKey(int var1, AutofillId var2, KeyEvent var3) throws RemoteException;

    public void startIntentSender(IntentSender var1, Intent var2) throws RemoteException;

    public void setSaveUiState(int var1, boolean var2) throws RemoteException;

    public void setSessionFinished(int var1, List<AutofillId> var2) throws RemoteException;

    public void getAugmentedAutofillClient(IResultReceiver var1) throws RemoteException;

    public void notifyDisableAutofill(long var1, ComponentName var3) throws RemoteException;

    public void requestShowSoftInput(AutofillId var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAutoFillManagerClient {
        public static final String DESCRIPTOR = "android.view.autofill.IAutoFillManagerClient";
        static final int TRANSACTION_setState = 1;
        static final int TRANSACTION_autofill = 2;
        static final int TRANSACTION_autofillContent = 3;
        static final int TRANSACTION_authenticate = 4;
        static final int TRANSACTION_setTrackedViews = 5;
        static final int TRANSACTION_requestShowFillUi = 6;
        static final int TRANSACTION_requestHideFillUi = 7;
        static final int TRANSACTION_notifyNoFillUi = 8;
        static final int TRANSACTION_notifyFillUiShown = 9;
        static final int TRANSACTION_notifyFillUiHidden = 10;
        static final int TRANSACTION_dispatchUnhandledKey = 11;
        static final int TRANSACTION_startIntentSender = 12;
        static final int TRANSACTION_setSaveUiState = 13;
        static final int TRANSACTION_setSessionFinished = 14;
        static final int TRANSACTION_getAugmentedAutofillClient = 15;
        static final int TRANSACTION_notifyDisableAutofill = 16;
        static final int TRANSACTION_requestShowSoftInput = 17;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAutoFillManagerClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAutoFillManagerClient) {
                return (IAutoFillManagerClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setState";
                }
                case 2: {
                    return "autofill";
                }
                case 3: {
                    return "autofillContent";
                }
                case 4: {
                    return "authenticate";
                }
                case 5: {
                    return "setTrackedViews";
                }
                case 6: {
                    return "requestShowFillUi";
                }
                case 7: {
                    return "requestHideFillUi";
                }
                case 8: {
                    return "notifyNoFillUi";
                }
                case 9: {
                    return "notifyFillUiShown";
                }
                case 10: {
                    return "notifyFillUiHidden";
                }
                case 11: {
                    return "dispatchUnhandledKey";
                }
                case 12: {
                    return "startIntentSender";
                }
                case 13: {
                    return "setSaveUiState";
                }
                case 14: {
                    return "setSessionFinished";
                }
                case 15: {
                    return "getAugmentedAutofillClient";
                }
                case 16: {
                    return "notifyDisableAutofill";
                }
                case 17: {
                    return "requestShowSoftInput";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setState(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ArrayList<AutofillId> _arg1 = data.createTypedArrayList(AutofillId.CREATOR);
                    ArrayList<AutofillValue> _arg2 = data.createTypedArrayList(AutofillValue.CREATOR);
                    boolean _arg3 = 0 != data.readInt();
                    this.autofill(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = 0 != data.readInt() ? AutofillId.CREATOR.createFromParcel(data) : null;
                    ClipData _arg2 = 0 != data.readInt() ? ClipData.CREATOR.createFromParcel(data) : null;
                    this.autofillContent(_arg0, _arg1, _arg2);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IntentSender _arg2 = 0 != data.readInt() ? IntentSender.CREATOR.createFromParcel(data) : null;
                    Intent _arg3 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    boolean _arg4 = 0 != data.readInt();
                    this.authenticate(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AutofillId[] _arg1 = data.createTypedArray(AutofillId.CREATOR);
                    boolean _arg2 = 0 != data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    AutofillId[] _arg4 = data.createTypedArray(AutofillId.CREATOR);
                    AutofillId _arg5 = 0 != data.readInt() ? AutofillId.CREATOR.createFromParcel(data) : null;
                    this.setTrackedViews(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = 0 != data.readInt() ? AutofillId.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    Rect _arg4 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    IAutofillWindowPresenter _arg5 = IAutofillWindowPresenter.Stub.asInterface(data.readStrongBinder());
                    this.requestShowFillUi(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = 0 != data.readInt() ? AutofillId.CREATOR.createFromParcel(data) : null;
                    this.requestHideFillUi(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = 0 != data.readInt() ? AutofillId.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.notifyNoFillUi(_arg0, _arg1, _arg2);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = 0 != data.readInt() ? AutofillId.CREATOR.createFromParcel(data) : null;
                    this.notifyFillUiShown(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = 0 != data.readInt() ? AutofillId.CREATOR.createFromParcel(data) : null;
                    this.notifyFillUiHidden(_arg0, _arg1);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = 0 != data.readInt() ? AutofillId.CREATOR.createFromParcel(data) : null;
                    KeyEvent _arg2 = 0 != data.readInt() ? KeyEvent.CREATOR.createFromParcel(data) : null;
                    this.dispatchUnhandledKey(_arg0, _arg1, _arg2);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    IntentSender _arg0 = 0 != data.readInt() ? IntentSender.CREATOR.createFromParcel(data) : null;
                    Intent _arg1 = 0 != data.readInt() ? Intent.CREATOR.createFromParcel(data) : null;
                    this.startIntentSender(_arg0, _arg1);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setSaveUiState(_arg0, _arg1);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ArrayList<AutofillId> _arg1 = data.createTypedArrayList(AutofillId.CREATOR);
                    this.setSessionFinished(_arg0, _arg1);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    this.getAugmentedAutofillClient(_arg0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    ComponentName _arg1 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    this.notifyDisableAutofill(_arg0, _arg1);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    AutofillId _arg0 = 0 != data.readInt() ? AutofillId.CREATOR.createFromParcel(data) : null;
                    this.requestShowSoftInput(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IAutoFillManagerClient impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IAutoFillManagerClient getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IAutoFillManagerClient {
            private IBinder mRemote;
            public static IAutoFillManagerClient sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setState(int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setState(flags);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values2, boolean hideHighlight) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedList(ids);
                    _data.writeTypedList(values2);
                    _data.writeInt(hideHighlight ? 1 : 0);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().autofill(sessionId, ids, values2, hideHighlight);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void autofillContent(int sessionId, AutofillId id2, ClipData content2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    if (id2 != null) {
                        _data.writeInt(1);
                        id2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (content2 != null) {
                        _data.writeInt(1);
                        content2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().autofillContent(sessionId, id2, content2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent, boolean authenticateInline) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(authenticationId);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (fillInIntent != null) {
                        _data.writeInt(1);
                        fillInIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(authenticateInline ? 1 : 0);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().authenticate(sessionId, authenticationId, intent, fillInIntent, authenticateInline);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTrackedViews(int sessionId, AutofillId[] savableIds, boolean saveOnAllViewsInvisible, boolean saveOnFinish, AutofillId[] fillableIds, AutofillId saveTriggerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedArray(savableIds, 0);
                    _data.writeInt(saveOnAllViewsInvisible ? 1 : 0);
                    _data.writeInt(saveOnFinish ? 1 : 0);
                    _data.writeTypedArray(fillableIds, 0);
                    if (saveTriggerId != null) {
                        _data.writeInt(1);
                        saveTriggerId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTrackedViews(sessionId, savableIds, saveOnAllViewsInvisible, saveOnFinish, fillableIds, saveTriggerId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    if (id2 != null) {
                        _data.writeInt(1);
                        id2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(width);
                    _data.writeInt(height);
                    if (anchorBounds != null) {
                        _data.writeInt(1);
                        anchorBounds.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(presenter != null ? presenter.asBinder() : null);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestShowFillUi(sessionId, id2, width, height, anchorBounds, presenter);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestHideFillUi(int sessionId, AutofillId id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    if (id2 != null) {
                        _data.writeInt(1);
                        id2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestHideFillUi(sessionId, id2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyNoFillUi(int sessionId, AutofillId id2, int sessionFinishedState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    if (id2 != null) {
                        _data.writeInt(1);
                        id2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(sessionFinishedState);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyNoFillUi(sessionId, id2, sessionFinishedState);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyFillUiShown(int sessionId, AutofillId id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    if (id2 != null) {
                        _data.writeInt(1);
                        id2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyFillUiShown(sessionId, id2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyFillUiHidden(int sessionId, AutofillId id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    if (id2 != null) {
                        _data.writeInt(1);
                        id2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyFillUiHidden(sessionId, id2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchUnhandledKey(int sessionId, AutofillId id2, KeyEvent keyEvent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    if (id2 != null) {
                        _data.writeInt(1);
                        id2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (keyEvent != null) {
                        _data.writeInt(1);
                        keyEvent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchUnhandledKey(sessionId, id2, keyEvent);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startIntentSender(IntentSender intentSender, Intent intent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intentSender != null) {
                        _data.writeInt(1);
                        intentSender.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startIntentSender(intentSender, intent);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSaveUiState(int sessionId, boolean shown) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(shown ? 1 : 0);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSaveUiState(sessionId, shown);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionFinished(int newState2, List<AutofillId> autofillableIds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(newState2);
                    _data.writeTypedList(autofillableIds);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSessionFinished(newState2, autofillableIds);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAugmentedAutofillClient(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(result != null ? result.asBinder() : null);
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getAugmentedAutofillClient(result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDisableAutofill(long disableDuration, ComponentName componentName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(disableDuration);
                    if (componentName != null) {
                        _data.writeInt(1);
                        componentName.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyDisableAutofill(disableDuration, componentName);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestShowSoftInput(AutofillId id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (id2 != null) {
                        _data.writeInt(1);
                        id2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestShowSoftInput(id2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAutoFillManagerClient {
        @Override
        public void setState(int flags) throws RemoteException {
        }

        @Override
        public void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values2, boolean hideHighlight) throws RemoteException {
        }

        @Override
        public void autofillContent(int sessionId, AutofillId id2, ClipData content2) throws RemoteException {
        }

        @Override
        public void authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent, boolean authenticateInline) throws RemoteException {
        }

        @Override
        public void setTrackedViews(int sessionId, AutofillId[] savableIds, boolean saveOnAllViewsInvisible, boolean saveOnFinish, AutofillId[] fillableIds, AutofillId saveTriggerId) throws RemoteException {
        }

        @Override
        public void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) throws RemoteException {
        }

        @Override
        public void requestHideFillUi(int sessionId, AutofillId id2) throws RemoteException {
        }

        @Override
        public void notifyNoFillUi(int sessionId, AutofillId id2, int sessionFinishedState) throws RemoteException {
        }

        @Override
        public void notifyFillUiShown(int sessionId, AutofillId id2) throws RemoteException {
        }

        @Override
        public void notifyFillUiHidden(int sessionId, AutofillId id2) throws RemoteException {
        }

        @Override
        public void dispatchUnhandledKey(int sessionId, AutofillId id2, KeyEvent keyEvent) throws RemoteException {
        }

        @Override
        public void startIntentSender(IntentSender intentSender, Intent intent) throws RemoteException {
        }

        @Override
        public void setSaveUiState(int sessionId, boolean shown) throws RemoteException {
        }

        @Override
        public void setSessionFinished(int newState2, List<AutofillId> autofillableIds) throws RemoteException {
        }

        @Override
        public void getAugmentedAutofillClient(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void notifyDisableAutofill(long disableDuration, ComponentName componentName) throws RemoteException {
        }

        @Override
        public void requestShowSoftInput(AutofillId id2) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

