/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.annotation.SystemApi;
import android.app.assist.AssistStructure;
import android.content.AutofillOptions;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ResolveInfo;
import android.graphics.Rect;
import android.metrics.LogMaker;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import android.service.autofill.FillEventHistory;
import android.service.autofill.UserData;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Choreographer;
import android.view.ContentInfo;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.view.autofill.IAugmentedAutofillManagerClient;
import android.view.autofill.IAutoFillManager;
import android.view.autofill.IAutoFillManagerClient;
import android.view.autofill.IAutofillWindowPresenter;
import android.view.autofill.ParcelableMap;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.IResultReceiver;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.SyncResultReceiver;
import com.android.layoutlib.bridge.libcore.util.Cleaner;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public class AutofillManager {
    private static final String TAG = "AutofillManager";
    public static final String EXTRA_ASSIST_STRUCTURE = "android.view.autofill.extra.ASSIST_STRUCTURE";
    public static final String EXTRA_AUTHENTICATION_RESULT = "android.view.autofill.extra.AUTHENTICATION_RESULT";
    public static final String EXTRA_AUTHENTICATION_RESULT_EPHEMERAL_DATASET = "android.view.autofill.extra.AUTHENTICATION_RESULT_EPHEMERAL_DATASET";
    public static final String EXTRA_CLIENT_STATE = "android.view.autofill.extra.CLIENT_STATE";
    public static final String EXTRA_INLINE_SUGGESTIONS_REQUEST = "android.view.autofill.extra.INLINE_SUGGESTIONS_REQUEST";
    public static final String EXTRA_RESTORE_SESSION_TOKEN = "android.view.autofill.extra.RESTORE_SESSION_TOKEN";
    public static final String EXTRA_RESTORE_CROSS_ACTIVITY = "android.view.autofill.extra.RESTORE_CROSS_ACTIVITY";
    public static final String EXTRA_AUGMENTED_AUTOFILL_CLIENT = "android.view.autofill.extra.AUGMENTED_AUTOFILL_CLIENT";
    private static final String SESSION_ID_TAG = "android:sessionId";
    private static final String STATE_TAG = "android:state";
    private static final String LAST_AUTOFILLED_DATA_TAG = "android:lastAutoFilledData";
    public static final int ACTION_START_SESSION = 1;
    public static final int ACTION_VIEW_ENTERED = 2;
    public static final int ACTION_VIEW_EXITED = 3;
    public static final int ACTION_VALUE_CHANGED = 4;
    public static final int ACTION_RESPONSE_EXPIRED = 5;
    public static final int NO_LOGGING = 0;
    public static final int FLAG_ADD_CLIENT_ENABLED = 1;
    public static final int FLAG_ADD_CLIENT_DEBUG = 2;
    public static final int FLAG_ADD_CLIENT_VERBOSE = 4;
    public static final int FLAG_ADD_CLIENT_ENABLED_FOR_AUGMENTED_AUTOFILL_ONLY = 8;
    public static final int RECEIVER_FLAG_SESSION_FOR_AUGMENTED_AUTOFILL_ONLY = 1;
    public static final int DEFAULT_LOGGING_LEVEL = _Original_Build.IS_DEBUGGABLE ? 2 : 0;
    public static final int DEFAULT_MAX_PARTITIONS_SIZE = 10;
    private static final int AUTHENTICATION_ID_DATASET_ID_MASK = 65535;
    private static final int AUTHENTICATION_ID_DATASET_ID_SHIFT = 16;
    public static final int AUTHENTICATION_ID_DATASET_ID_UNDEFINED = 65535;
    public static final int PENDING_UI_OPERATION_CANCEL = 1;
    public static final int PENDING_UI_OPERATION_RESTORE = 2;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_ACTIVE = 1;
    public static final int STATE_FINISHED = 2;
    public static final int STATE_SHOWING_SAVE_UI = 3;
    public static final int STATE_DISABLED_BY_SERVICE = 4;
    public static final int STATE_UNKNOWN_COMPAT_MODE = 5;
    public static final int STATE_UNKNOWN_FAILED = 6;
    public static final int FC_SERVICE_TIMEOUT = 5000;
    private static final int SYNC_CALLS_TIMEOUT_MS = 5000;
    public static final int MAX_TEMP_AUGMENTED_SERVICE_DURATION_MS = 120000;
    public static final int FLAG_SMART_SUGGESTION_OFF = 0;
    public static final int FLAG_SMART_SUGGESTION_SYSTEM = 1;
    public static final String DEVICE_CONFIG_AUTOFILL_SMART_SUGGESTION_SUPPORTED_MODES = "smart_suggestion_supported_modes";
    public static final String DEVICE_CONFIG_AUGMENTED_SERVICE_IDLE_UNBIND_TIMEOUT = "augmented_service_idle_unbind_timeout";
    public static final String DEVICE_CONFIG_AUGMENTED_SERVICE_REQUEST_TIMEOUT = "augmented_service_request_timeout";
    public static final int RESULT_OK = 0;
    public static final int RESULT_CODE_NOT_SERVICE = -1;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    public static final int NO_SESSION = Integer.MAX_VALUE;
    private final IAutoFillManager mService;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private IAutoFillManagerClient mServiceClient;
    @GuardedBy(value={"mLock"})
    private Cleaner mServiceClientCleaner;
    @GuardedBy(value={"mLock"})
    private IAugmentedAutofillManagerClient mAugmentedAutofillServiceClient;
    @GuardedBy(value={"mLock"})
    private AutofillCallback mCallback;
    private final Context mContext;
    @GuardedBy(value={"mLock"})
    private int mSessionId = Integer.MAX_VALUE;
    @GuardedBy(value={"mLock"})
    private int mState = 0;
    @GuardedBy(value={"mLock"})
    private boolean mEnabled;
    @GuardedBy(value={"mLock"})
    private ParcelableMap mLastAutofilledData;
    @GuardedBy(value={"mLock"})
    private TrackedViews mTrackedViews;
    @GuardedBy(value={"mLock"})
    private ArraySet<AutofillId> mFillableIds;
    private AutofillId mIdShownFillUi;
    @GuardedBy(value={"mLock"})
    private ArraySet<AutofillId> mEnteredIds;
    @GuardedBy(value={"mLock"})
    private Set<AutofillId> mEnteredForAugmentedAutofillIds;
    @GuardedBy(value={"mLock"})
    private AutofillId mSaveTriggerId;
    @GuardedBy(value={"mLock"})
    private boolean mOnInvisibleCalled;
    @GuardedBy(value={"mLock"})
    private boolean mSaveOnFinish;
    @GuardedBy(value={"mLock"})
    private CompatibilityBridge mCompatibilityBridge;
    private final AutofillOptions mOptions;
    @GuardedBy(value={"mLock"})
    private boolean mForAugmentedAutofillOnly;
    @GuardedBy(value={"mLock"})
    private boolean mEnabledForAugmentedAutofillOnly;
    public static final int SET_STATE_FLAG_ENABLED = 1;
    public static final int SET_STATE_FLAG_RESET_SESSION = 2;
    public static final int SET_STATE_FLAG_RESET_CLIENT = 4;
    public static final int SET_STATE_FLAG_DEBUG = 8;
    public static final int SET_STATE_FLAG_VERBOSE = 16;
    public static final int SET_STATE_FLAG_FOR_AUTOFILL_ONLY = 32;

    public static int makeAuthenticationId(int requestId, int datasetId) {
        return requestId << 16 | datasetId & 0xFFFF;
    }

    public static int getRequestIdFromAuthenticationId(int authRequestId) {
        return authRequestId >> 16;
    }

    public static int getDatasetIdFromAuthenticationId(int authRequestId) {
        return authRequestId & 0xFFFF;
    }

    public AutofillManager(Context context, IAutoFillManager service) {
        this.mContext = Preconditions.checkNotNull(context, "context cannot be null");
        this.mService = service;
        this.mOptions = context.getAutofillOptions();
        if (this.mOptions != null) {
            Helper.sDebug = (this.mOptions.loggingLevel & 2) != 0;
            Helper.sVerbose = (this.mOptions.loggingLevel & 4) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCompatibilityMode() {
        Object object = this.mLock;
        synchronized (object) {
            if (Helper.sDebug) {
                Slog.d(TAG, "creating CompatibilityBridge for " + this.mContext);
            }
            this.mCompatibilityBridge = new CompatibilityBridge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(Bundle savedInstanceState) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLastAutofilledData = (ParcelableMap)savedInstanceState.getParcelable(LAST_AUTOFILLED_DATA_TAG);
            if (this.isActiveLocked()) {
                Log.w(TAG, "New session was started before onCreate()");
                return;
            }
            this.mSessionId = savedInstanceState.getInt(SESSION_ID_TAG, Integer.MAX_VALUE);
            this.mState = savedInstanceState.getInt(STATE_TAG, 0);
            if (this.mSessionId != Integer.MAX_VALUE) {
                boolean clientAdded = this.tryAddServiceClientIfNeededLocked();
                AutofillClient client = this.getClient();
                if (client != null) {
                    SyncResultReceiver receiver = new SyncResultReceiver(5000);
                    try {
                        boolean sessionWasRestored = false;
                        if (clientAdded) {
                            this.mService.restoreSession(this.mSessionId, client.autofillClientGetActivityToken(), this.mServiceClient.asBinder(), receiver);
                            sessionWasRestored = receiver.getIntResult() == 1;
                        } else {
                            Log.w(TAG, "No service client for session " + this.mSessionId);
                        }
                        if (!sessionWasRestored) {
                            Log.w(TAG, "Session " + this.mSessionId + " could not be restored");
                            this.mSessionId = Integer.MAX_VALUE;
                            this.mState = 0;
                        } else {
                            if (Helper.sDebug) {
                                Log.d(TAG, "session " + this.mSessionId + " was restored");
                            }
                            client.autofillClientResetableStateAvailable();
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Could not figure out if there was an autofill session", e);
                    }
                    catch (SyncResultReceiver.TimeoutException e) {
                        Log.e(TAG, "Fail to get session restore status: " + e);
                    }
                }
            }
        }
    }

    public void onVisibleForAutofill() {
        Choreographer.getInstance().postCallback(4, () -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mEnabled && this.isActiveLocked() && this.mTrackedViews != null) {
                    this.mTrackedViews.onVisibleForAutofillChangedLocked();
                }
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInvisibleForAutofill(boolean isExpiredResponse) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnInvisibleCalled = true;
            if (isExpiredResponse) {
                this.updateSessionLocked(null, null, null, 5, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSaveInstanceState(Bundle outState) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId != Integer.MAX_VALUE) {
                outState.putInt(SESSION_ID_TAG, this.mSessionId);
            }
            if (this.mState != 0) {
                outState.putInt(STATE_TAG, this.mState);
            }
            if (this.mLastAutofilledData != null) {
                outState.putParcelable(LAST_AUTOFILLED_DATA_TAG, this.mLastAutofilledData);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    public boolean isCompatibilityModeEnabledLocked() {
        return this.mCompatibilityBridge != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        if (!this.hasAutofillFeature()) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDisabledByServiceLocked()) {
                return false;
            }
            boolean clientAdded = this.tryAddServiceClientIfNeededLocked();
            boolean bl = clientAdded ? this.mEnabled : false;
            return bl;
        }
    }

    public FillEventHistory getFillEventHistory() {
        try {
            SyncResultReceiver receiver = new SyncResultReceiver(5000);
            this.mService.getFillEventHistory(receiver);
            return (FillEventHistory)receiver.getParcelableResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            Log.e(TAG, "Fail to get fill event history: " + e);
            return null;
        }
    }

    public void requestAutofill(View view) {
        int flags = 1;
        if (!view.isFocused()) {
            flags |= 0x10;
        }
        this.notifyViewEntered(view, flags);
    }

    void requestAutofillFromNewSession(View view) {
        this.cancel();
        this.notifyViewEntered(view);
    }

    public void requestAutofill(View view, int virtualId, Rect absBounds) {
        int flags = 1;
        if (!view.isFocused()) {
            flags |= 0x10;
        }
        this.notifyViewEntered(view, virtualId, absBounds, flags);
    }

    public void notifyViewEntered(View view) {
        this.notifyViewEntered(view, 0);
    }

    @GuardedBy(value={"mLock"})
    private boolean shouldIgnoreViewEnteredLocked(AutofillId id2, int flags) {
        if (this.isDisabledByServiceLocked()) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring notifyViewEntered(flags=" + flags + ", view=" + id2 + ") on state " + this.getStateAsStringLocked() + " because disabled by svc");
            }
            return true;
        }
        if (this.isFinishedLocked() && (flags & 1) == 0 && this.mEnteredIds != null && this.mEnteredIds.contains(id2)) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring notifyViewEntered(flags=" + flags + ", view=" + id2 + ") on state " + this.getStateAsStringLocked() + " because view was already entered: " + this.mEnteredIds);
            }
            return true;
        }
        return false;
    }

    private boolean isClientVisibleForAutofillLocked() {
        AutofillClient client = this.getClient();
        return client != null && client.autofillClientIsVisibleForAutofill();
    }

    private boolean isClientDisablingEnterExitEvent() {
        AutofillClient client = this.getClient();
        return client != null && client.isDisablingEnterExitEventForAutofill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewEntered(View view, int flags) {
        AutofillCallback callback2;
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            callback2 = this.notifyViewEnteredLocked(view, flags);
        }
        if (callback2 != null) {
            this.mCallback.onAutofillEvent(view, 3);
        }
    }

    @GuardedBy(value={"mLock"})
    private AutofillCallback notifyViewEnteredLocked(View view, int flags) {
        AutofillId id2 = view.getAutofillId();
        if (this.shouldIgnoreViewEnteredLocked(id2, flags)) {
            return null;
        }
        AutofillCallback callback2 = null;
        boolean clientAdded = this.tryAddServiceClientIfNeededLocked();
        if (!clientAdded) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring notifyViewEntered(" + id2 + "): no service client");
            }
            return callback2;
        }
        if (!this.mEnabled && !this.mEnabledForAugmentedAutofillOnly) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring notifyViewEntered(" + id2 + "): disabled");
            }
            if (this.mCallback != null) {
                callback2 = this.mCallback;
            }
        } else if (!this.isClientDisablingEnterExitEvent()) {
            AutofillValue value2 = view.getAutofillValue();
            if (view instanceof TextView && ((TextView)view).isAnyPasswordInputType()) {
                flags |= 4;
            }
            if (!this.isActiveLocked()) {
                this.startSessionLocked(id2, null, value2, flags);
            } else {
                if (this.mForAugmentedAutofillOnly && (flags & 1) != 0) {
                    if (Helper.sDebug) {
                        Log.d(TAG, "notifyViewEntered(" + id2 + "): resetting mForAugmentedAutofillOnly on manual request");
                    }
                    this.mForAugmentedAutofillOnly = false;
                }
                this.updateSessionLocked(id2, null, value2, 2, flags);
            }
            this.addEnteredIdLocked(id2);
        }
        return callback2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyViewExited(View view) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.notifyViewExitedLocked(view);
        }
    }

    @GuardedBy(value={"mLock"})
    void notifyViewExitedLocked(View view) {
        boolean clientAdded = this.tryAddServiceClientIfNeededLocked();
        if (clientAdded && (this.mEnabled || this.mEnabledForAugmentedAutofillOnly) && this.isActiveLocked() && !this.isClientDisablingEnterExitEvent()) {
            AutofillId id2 = view.getAutofillId();
            this.updateSessionLocked(id2, null, null, 3, 0);
        }
    }

    public void notifyViewVisibilityChanged(View view, boolean isVisible) {
        this.notifyViewVisibilityChangedInternal(view, 0, isVisible, false);
    }

    public void notifyViewVisibilityChanged(View view, int virtualId, boolean isVisible) {
        this.notifyViewVisibilityChangedInternal(view, virtualId, isVisible, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewVisibilityChangedInternal(View view, int virtualId, boolean isVisible, boolean virtual) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mForAugmentedAutofillOnly) {
                if (Helper.sVerbose) {
                    Log.v(TAG, "notifyViewVisibilityChanged(): ignoring on augmented only mode");
                }
                return;
            }
            if (this.mEnabled && this.isActiveLocked()) {
                AutofillId id2;
                AutofillId autofillId = id2 = virtual ? AutofillManager.getAutofillId(view, virtualId) : view.getAutofillId();
                if (Helper.sVerbose) {
                    Log.v(TAG, "visibility changed for " + id2 + ": " + isVisible);
                }
                if (!isVisible && this.mFillableIds != null && this.mFillableIds.contains(id2)) {
                    if (Helper.sDebug) {
                        Log.d(TAG, "Hidding UI when view " + id2 + " became invisible");
                    }
                    this.requestHideFillUi(id2, view);
                }
                if (this.mTrackedViews != null) {
                    this.mTrackedViews.notifyViewVisibilityChangedLocked(id2, isVisible);
                } else if (Helper.sVerbose) {
                    Log.v(TAG, "Ignoring visibility change on " + id2 + ": no tracked views");
                }
            } else if (!virtual && isVisible) {
                this.startAutofillIfNeededLocked(view);
            }
        }
    }

    public void notifyViewEntered(View view, int virtualId, Rect absBounds) {
        this.notifyViewEntered(view, virtualId, absBounds, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewEntered(View view, int virtualId, Rect bounds2, int flags) {
        AutofillCallback callback2;
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            callback2 = this.notifyViewEnteredLocked(view, virtualId, bounds2, flags);
        }
        if (callback2 != null) {
            callback2.onAutofillEvent(view, virtualId, 3);
        }
    }

    @GuardedBy(value={"mLock"})
    private AutofillCallback notifyViewEnteredLocked(View view, int virtualId, Rect bounds2, int flags) {
        AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
        AutofillCallback callback2 = null;
        if (this.shouldIgnoreViewEnteredLocked(id2, flags)) {
            return callback2;
        }
        boolean clientAdded = this.tryAddServiceClientIfNeededLocked();
        if (!clientAdded) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring notifyViewEntered(" + id2 + "): no service client");
            }
            return callback2;
        }
        if (!this.mEnabled && !this.mEnabledForAugmentedAutofillOnly) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring notifyViewEntered(" + id2 + "): disabled");
            }
            if (this.mCallback != null) {
                callback2 = this.mCallback;
            }
        } else if (!this.isClientDisablingEnterExitEvent()) {
            if (view instanceof TextView && ((TextView)view).isAnyPasswordInputType()) {
                flags |= 4;
            }
            if (!this.isActiveLocked()) {
                this.startSessionLocked(id2, bounds2, null, flags);
            } else {
                if (this.mForAugmentedAutofillOnly && (flags & 1) != 0) {
                    if (Helper.sDebug) {
                        Log.d(TAG, "notifyViewEntered(" + id2 + "): resetting mForAugmentedAutofillOnly on manual request");
                    }
                    this.mForAugmentedAutofillOnly = false;
                }
                this.updateSessionLocked(id2, bounds2, null, 2, flags);
            }
            this.addEnteredIdLocked(id2);
        }
        return callback2;
    }

    @GuardedBy(value={"mLock"})
    private void addEnteredIdLocked(AutofillId id2) {
        if (this.mEnteredIds == null) {
            this.mEnteredIds = new ArraySet(1);
        }
        id2.resetSessionId();
        this.mEnteredIds.add(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyViewExited(View view, int virtualId) {
        if (Helper.sVerbose) {
            Log.v(TAG, "notifyViewExited(" + view.getAutofillId() + ", " + virtualId);
        }
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.notifyViewExitedLocked(view, virtualId);
        }
    }

    @GuardedBy(value={"mLock"})
    private void notifyViewExitedLocked(View view, int virtualId) {
        boolean clientAdded = this.tryAddServiceClientIfNeededLocked();
        if (clientAdded && (this.mEnabled || this.mEnabledForAugmentedAutofillOnly) && this.isActiveLocked() && !this.isClientDisablingEnterExitEvent()) {
            AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
            this.updateSessionLocked(id2, null, null, 3, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyValueChanged(View view) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        AutofillId id2 = null;
        boolean valueWasRead = false;
        AutofillValue value2 = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastAutofilledData == null) {
                view.setAutofilled(false, false);
            } else {
                id2 = view.getAutofillId();
                if (this.mLastAutofilledData.containsKey(id2)) {
                    boolean hideHighlight;
                    value2 = view.getAutofillValue();
                    valueWasRead = true;
                    boolean bl = hideHighlight = this.mLastAutofilledData.keySet().size() == 1;
                    if (Objects.equals(this.mLastAutofilledData.get(id2), value2)) {
                        view.setAutofilled(true, hideHighlight);
                    } else {
                        view.setAutofilled(false, false);
                        this.mLastAutofilledData.remove(id2);
                    }
                } else {
                    view.setAutofilled(false, false);
                }
            }
            if (!this.mEnabled || !this.isActiveLocked()) {
                if (!this.startAutofillIfNeededLocked(view) && Helper.sVerbose) {
                    Log.v(TAG, "notifyValueChanged(" + view.getAutofillId() + "): ignoring on state " + this.getStateAsStringLocked());
                }
                return;
            }
            if (id2 == null) {
                id2 = view.getAutofillId();
            }
            if (!valueWasRead) {
                value2 = view.getAutofillValue();
            }
            this.updateSessionLocked(id2, null, value2, 4, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyValueChanged(View view, int virtualId, AutofillValue value2) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled || !this.isActiveLocked()) {
                if (Helper.sVerbose) {
                    Log.v(TAG, "notifyValueChanged(" + view.getAutofillId() + ":" + virtualId + "): ignoring on state " + this.getStateAsStringLocked());
                }
                return;
            }
            AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
            this.updateSessionLocked(id2, null, value2, 4, 0);
        }
    }

    public void notifyViewClicked(View view) {
        this.notifyViewClicked(view.getAutofillId());
    }

    public void notifyViewClicked(View view, int virtualId) {
        this.notifyViewClicked(AutofillManager.getAutofillId(view, virtualId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewClicked(AutofillId id2) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sVerbose) {
            Log.v(TAG, "notifyViewClicked(): id=" + id2 + ", trigger=" + this.mSaveTriggerId);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled || !this.isActiveLocked()) {
                return;
            }
            if (this.mSaveTriggerId != null && this.mSaveTriggerId.equals(id2)) {
                if (Helper.sDebug) {
                    Log.d(TAG, "triggering commit by click of " + id2);
                }
                this.commitLocked();
                this.mMetricsLogger.write(this.newLog(1229));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityFinishing() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSaveOnFinish) {
                if (Helper.sDebug) {
                    Log.d(TAG, "onActivityFinishing(): calling commitLocked()");
                }
                this.commitLocked();
            } else {
                if (Helper.sDebug) {
                    Log.d(TAG, "onActivityFinishing(): calling cancelLocked()");
                }
                this.cancelLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sVerbose) {
            Log.v(TAG, "commit() called by app");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.commitLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private void commitLocked() {
        if (!this.mEnabled && !this.isActiveLocked()) {
            return;
        }
        this.finishSessionLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (Helper.sVerbose) {
            Log.v(TAG, "cancel() called by app or augmented autofill service");
        }
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.cancelLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private void cancelLocked() {
        if (!this.mEnabled && !this.isActiveLocked()) {
            return;
        }
        this.cancelSessionLocked();
    }

    public void disableOwnedAutofillServices() {
        this.disableAutofillServices();
    }

    public void disableAutofillServices() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        try {
            this.mService.disableOwnedAutofillServices(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasEnabledAutofillServices() {
        if (this.mService == null) {
            return false;
        }
        SyncResultReceiver receiver = new SyncResultReceiver(5000);
        try {
            this.mService.isServiceEnabled(this.mContext.getUserId(), this.mContext.getPackageName(), receiver);
            return receiver.getIntResult() == 1;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get enabled autofill services status.");
        }
    }

    public ComponentName getAutofillServiceComponentName() {
        if (this.mService == null) {
            return null;
        }
        SyncResultReceiver receiver = new SyncResultReceiver(5000);
        try {
            this.mService.getAutofillServiceComponentName(receiver);
            return (ComponentName)receiver.getParcelableResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get autofill services component name.");
        }
    }

    public String getUserDataId() {
        try {
            SyncResultReceiver receiver = new SyncResultReceiver(5000);
            this.mService.getUserDataId(receiver);
            return receiver.getStringResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get user data id for field classification.");
        }
    }

    public UserData getUserData() {
        try {
            SyncResultReceiver receiver = new SyncResultReceiver(5000);
            this.mService.getUserData(receiver);
            return (UserData)receiver.getParcelableResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get user data for field classification.");
        }
    }

    public void setUserData(UserData userData) {
        try {
            this.mService.setUserData(userData);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isFieldClassificationEnabled() {
        SyncResultReceiver receiver = new SyncResultReceiver(5000);
        try {
            this.mService.isFieldClassificationEnabled(receiver);
            return receiver.getIntResult() == 1;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get field classification enabled status.");
        }
    }

    public String getDefaultFieldClassificationAlgorithm() {
        SyncResultReceiver receiver = new SyncResultReceiver(5000);
        try {
            this.mService.getDefaultFieldClassificationAlgorithm(receiver);
            return receiver.getStringResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get default field classification algorithm.");
        }
    }

    public List<String> getAvailableFieldClassificationAlgorithms() {
        SyncResultReceiver receiver = new SyncResultReceiver(5000);
        try {
            this.mService.getAvailableFieldClassificationAlgorithms(receiver);
            String[] algorithms = receiver.getStringArrayResult();
            return algorithms != null ? Arrays.asList(algorithms) : Collections.emptyList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get available field classification algorithms.");
        }
    }

    public boolean isAutofillSupported() {
        if (this.mService == null) {
            return false;
        }
        SyncResultReceiver receiver = new SyncResultReceiver(5000);
        try {
            this.mService.isServiceSupported(this.mContext.getUserId(), receiver);
            return receiver.getIntResult() == 1;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get autofill supported status.");
        }
    }

    private AutofillClient getClient() {
        AutofillClient client = this.mContext.getAutofillClient();
        if (client == null && Helper.sVerbose) {
            Log.v(TAG, "No AutofillClient for " + this.mContext.getPackageName() + " on context " + this.mContext);
        }
        return client;
    }

    public boolean isAutofillUiShowing() {
        AutofillClient client = this.mContext.getAutofillClient();
        return client != null && client.autofillClientIsFillUiShowing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAuthenticationResult(int authenticationId, Intent data, View focusView) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sDebug) {
            Log.d(TAG, "onAuthenticationResult(): id= " + authenticationId + ", data=" + data);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isActiveLocked()) {
                return;
            }
            if (!this.mOnInvisibleCalled && focusView != null && focusView.canNotifyAutofillEnterExitEvent()) {
                this.notifyViewExitedLocked(focusView);
                this.notifyViewEnteredLocked(focusView, 0);
            }
            if (data == null) {
                return;
            }
            Object result = data.getParcelableExtra(EXTRA_AUTHENTICATION_RESULT);
            Bundle responseData = new Bundle();
            responseData.putParcelable(EXTRA_AUTHENTICATION_RESULT, (Parcelable)result);
            Bundle newClientState = data.getBundleExtra(EXTRA_CLIENT_STATE);
            if (newClientState != null) {
                responseData.putBundle(EXTRA_CLIENT_STATE, newClientState);
            }
            if (data.getExtras().containsKey(EXTRA_AUTHENTICATION_RESULT_EPHEMERAL_DATASET)) {
                responseData.putBoolean(EXTRA_AUTHENTICATION_RESULT_EPHEMERAL_DATASET, data.getBooleanExtra(EXTRA_AUTHENTICATION_RESULT_EPHEMERAL_DATASET, false));
            }
            try {
                this.mService.setAuthenticationResult(responseData, this.mSessionId, authenticationId, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error delivering authentication result", e);
            }
        }
    }

    public AutofillId getNextAutofillId() {
        AutofillClient client = this.getClient();
        if (client == null) {
            return null;
        }
        AutofillId id2 = client.autofillClientGetNextAutofillId();
        if (id2 == null && Helper.sDebug) {
            Log.d(TAG, "getNextAutofillId(): client " + client + " returned null");
        }
        return id2;
    }

    private static AutofillId getAutofillId(View parent, int virtualId) {
        return new AutofillId(parent.getAutofillViewId(), virtualId);
    }

    @GuardedBy(value={"mLock"})
    private void startSessionLocked(AutofillId id2, Rect bounds2, AutofillValue value2, int flags) {
        if (this.mEnteredForAugmentedAutofillIds != null && this.mEnteredForAugmentedAutofillIds.contains(id2) || this.mEnabledForAugmentedAutofillOnly) {
            if (Helper.sVerbose) {
                Log.v(TAG, "Starting session for augmented autofill on " + id2);
            }
            flags |= 8;
        }
        if (Helper.sVerbose) {
            Log.v(TAG, "startSessionLocked(): id=" + id2 + ", bounds=" + bounds2 + ", value=" + value2 + ", flags=" + flags + ", state=" + this.getStateAsStringLocked() + ", compatMode=" + this.isCompatibilityModeEnabledLocked() + ", augmentedOnly=" + this.mForAugmentedAutofillOnly + ", enabledAugmentedOnly=" + this.mEnabledForAugmentedAutofillOnly + ", enteredIds=" + this.mEnteredIds);
        }
        if (this.mForAugmentedAutofillOnly && !this.mEnabledForAugmentedAutofillOnly && (flags & 1) != 0) {
            if (Helper.sVerbose) {
                Log.v(TAG, "resetting mForAugmentedAutofillOnly on manual autofill request");
            }
            this.mForAugmentedAutofillOnly = false;
        }
        if (this.mState != 0 && !this.isFinishedLocked() && (flags & 1) == 0) {
            if (Helper.sVerbose) {
                Log.v(TAG, "not automatically starting session for " + id2 + " on state " + this.getStateAsStringLocked() + " and flags " + flags);
            }
            return;
        }
        try {
            int extraFlags;
            AutofillClient client = this.getClient();
            if (client == null) {
                return;
            }
            SyncResultReceiver receiver = new SyncResultReceiver(5000);
            ComponentName clientActivity = client.autofillClientGetComponentName();
            if (!this.mEnabledForAugmentedAutofillOnly && this.mOptions != null && this.mOptions.isAutofillDisabledLocked(clientActivity)) {
                if (this.mOptions.isAugmentedAutofillEnabled(this.mContext)) {
                    if (Helper.sDebug) {
                        Log.d(TAG, "startSession(" + clientActivity + "): disabled by service but allowlisted for augmented autofill");
                        flags |= 8;
                    }
                } else {
                    if (Helper.sDebug) {
                        Log.d(TAG, "startSession(" + clientActivity + "): ignored because disabled by service and not allowlisted for augmented autofill");
                    }
                    this.setSessionFinished(4, null);
                    client.autofillClientResetableStateAvailable();
                    return;
                }
            }
            this.mService.startSession(client.autofillClientGetActivityToken(), this.mServiceClient.asBinder(), id2, bounds2, value2, this.mContext.getUserId(), this.mCallback != null, flags, clientActivity, this.isCompatibilityModeEnabledLocked(), receiver);
            this.mSessionId = receiver.getIntResult();
            if (this.mSessionId != Integer.MAX_VALUE) {
                this.mState = 1;
            }
            if (((extraFlags = receiver.getOptionalExtraIntResult(0)) & 1) != 0) {
                if (Helper.sDebug) {
                    Log.d(TAG, "startSession(" + clientActivity + "): for augmented only");
                }
                this.mForAugmentedAutofillOnly = true;
            }
            client.autofillClientResetableStateAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            Log.w(TAG, "Exception getting result from SyncResultReceiver: " + e);
        }
    }

    @GuardedBy(value={"mLock"})
    private void finishSessionLocked() {
        if (Helper.sVerbose) {
            Log.v(TAG, "finishSessionLocked(): " + this.getStateAsStringLocked());
        }
        if (!this.isActiveLocked()) {
            return;
        }
        try {
            this.mService.finishSession(this.mSessionId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.resetSessionLocked(true);
    }

    @GuardedBy(value={"mLock"})
    private void cancelSessionLocked() {
        if (Helper.sVerbose) {
            Log.v(TAG, "cancelSessionLocked(): " + this.getStateAsStringLocked());
        }
        if (!this.isActiveLocked()) {
            return;
        }
        try {
            this.mService.cancelSession(this.mSessionId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.resetSessionLocked(true);
    }

    @GuardedBy(value={"mLock"})
    private void resetSessionLocked(boolean resetEnteredIds) {
        this.mSessionId = Integer.MAX_VALUE;
        this.mState = 0;
        this.mTrackedViews = null;
        this.mFillableIds = null;
        this.mSaveTriggerId = null;
        this.mIdShownFillUi = null;
        if (resetEnteredIds) {
            this.mEnteredIds = null;
        }
    }

    @GuardedBy(value={"mLock"})
    private void updateSessionLocked(AutofillId id2, Rect bounds2, AutofillValue value2, int action2, int flags) {
        if (Helper.sVerbose) {
            Log.v(TAG, "updateSessionLocked(): id=" + id2 + ", bounds=" + bounds2 + ", value=" + value2 + ", action=" + action2 + ", flags=" + flags);
        }
        try {
            this.mService.updateSession(this.mSessionId, id2, bounds2, value2, action2, flags, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean tryAddServiceClientIfNeededLocked() {
        AutofillClient client = this.getClient();
        if (client == null) {
            return false;
        }
        if (this.mService == null) {
            Log.w(TAG, "Autofill service is null!");
            return false;
        }
        if (this.mServiceClient == null) {
            this.mServiceClient = new AutofillManagerClient(this);
            try {
                int userId = this.mContext.getUserId();
                SyncResultReceiver receiver = new SyncResultReceiver(5000);
                this.mService.addClient(this.mServiceClient, client.autofillClientGetComponentName(), userId, receiver);
                int flags = 0;
                try {
                    flags = receiver.getIntResult();
                }
                catch (SyncResultReceiver.TimeoutException e) {
                    Log.w(TAG, "Failed to initialize autofill: " + e);
                    this.mService.removeClient(this.mServiceClient, userId);
                    this.mServiceClient = null;
                    return false;
                }
                this.mEnabled = (flags & 1) != 0;
                Helper.sDebug = (flags & 2) != 0;
                Helper.sVerbose = (flags & 4) != 0;
                boolean bl = this.mEnabledForAugmentedAutofillOnly = (flags & 8) != 0;
                if (Helper.sVerbose) {
                    Log.v(TAG, "receiver results: flags=" + flags + " enabled=" + this.mEnabled + ", enabledForAugmentedOnly: " + this.mEnabledForAugmentedAutofillOnly);
                }
                IAutoFillManager service = this.mService;
                IAutoFillManagerClient serviceClient = this.mServiceClient;
                this.mServiceClientCleaner = Cleaner.create(this, () -> {
                    try {
                        service.removeClient(serviceClient, userId);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                });
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    @GuardedBy(value={"mLock"})
    private boolean startAutofillIfNeededLocked(View view) {
        if (this.mState == 0 && this.mSessionId == Integer.MAX_VALUE && view instanceof EditText && !TextUtils.isEmpty(((EditText)view).getText()) && !view.isFocused() && view.isImportantForAutofill() && view.isLaidOut() && view.isVisibleToUser()) {
            boolean clientAdded = this.tryAddServiceClientIfNeededLocked();
            if (Helper.sVerbose) {
                Log.v(TAG, "startAutofillIfNeededLocked(): enabled=" + this.mEnabled + " mServiceClient=" + this.mServiceClient);
            }
            if (clientAdded && this.mEnabled && !this.isClientDisablingEnterExitEvent()) {
                AutofillId id2 = view.getAutofillId();
                AutofillValue value2 = view.getAutofillValue();
                this.startSessionLocked(id2, null, null, 0);
                this.updateSessionLocked(id2, null, value2, 4, 0);
                this.addEnteredIdLocked(id2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(AutofillCallback callback2) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback2 == null) {
                return;
            }
            boolean hadCallback = this.mCallback != null;
            this.mCallback = callback2;
            if (!hadCallback) {
                try {
                    this.mService.setHasCallback(this.mSessionId, this.mContext.getUserId(), true);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(AutofillCallback callback2) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback2 == null || this.mCallback == null || callback2 != this.mCallback) {
                return;
            }
            this.mCallback = null;
            try {
                this.mService.setHasCallback(this.mSessionId, this.mContext.getUserId(), false);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    public void setAugmentedAutofillWhitelist(Set<String> packages, Set<ComponentName> activities) {
        int resultCode;
        if (!this.hasAutofillFeature()) {
            return;
        }
        SyncResultReceiver resultReceiver = new SyncResultReceiver(5000);
        try {
            this.mService.setAugmentedAutofillWhitelist(Helper.toList(packages), Helper.toList(activities), resultReceiver);
            resultCode = resultReceiver.getIntResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            Log.e(TAG, "Fail to get the result of set AugmentedAutofill whitelist. " + e);
            return;
        }
        switch (resultCode) {
            case 0: {
                return;
            }
            case -1: {
                throw new SecurityException("caller is not user's Augmented Autofill Service");
            }
        }
        Log.wtf(TAG, "setAugmentedAutofillWhitelist(): received invalid result: " + resultCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyViewEnteredForAugmentedAutofill(View view) {
        AutofillId id2 = view.getAutofillId();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnteredForAugmentedAutofillIds == null) {
                this.mEnteredForAugmentedAutofillIds = new ArraySet<AutofillId>(1);
            }
            this.mEnteredForAugmentedAutofillIds.add(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
        View anchor = this.findView(id2);
        if (anchor == null) {
            return;
        }
        AutofillCallback callback2 = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (this.mSessionId == sessionId && (client = this.getClient()) != null && client.autofillClientRequestShowFillUi(anchor, width, height, anchorBounds, presenter)) {
                callback2 = this.mCallback;
                this.mIdShownFillUi = id2;
            }
        }
        if (callback2 != null) {
            if (id2.isVirtualInt()) {
                callback2.onAutofillEvent(anchor, id2.getVirtualChildIntId(), 1);
            } else {
                callback2.onAutofillEvent(anchor, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent, boolean authenticateInline) {
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (sessionId == this.mSessionId && (client = this.getClient()) != null) {
                this.mOnInvisibleCalled = false;
                client.autofillClientAuthenticate(authenticationId, intent, fillInIntent, authenticateInline);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchUnhandledKey(int sessionId, AutofillId id2, KeyEvent keyEvent) {
        View anchor = this.findView(id2);
        if (anchor == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (this.mSessionId == sessionId && (client = this.getClient()) != null) {
                client.autofillClientDispatchUnhandledKey(anchor, keyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int flags) {
        if (Helper.sVerbose) {
            Log.v(TAG, "setState(" + flags + ": " + DebugUtils.flagsToString(AutofillManager.class, "SET_STATE_FLAG_", flags) + ")");
        }
        Object object = this.mLock;
        synchronized (object) {
            if ((flags & 0x20) != 0) {
                this.mForAugmentedAutofillOnly = true;
                return;
            }
            boolean bl = this.mEnabled = (flags & 1) != 0;
            if (!this.mEnabled || (flags & 2) != 0) {
                this.resetSessionLocked(true);
            }
            if ((flags & 4) != 0) {
                this.mServiceClient = null;
                this.mAugmentedAutofillServiceClient = null;
                if (this.mServiceClientCleaner != null) {
                    this.mServiceClientCleaner.clean();
                    this.mServiceClientCleaner = null;
                }
                this.notifyReenableAutofill();
            }
        }
        Helper.sDebug = (flags & 8) != 0;
        Helper.sVerbose = (flags & 0x10) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAutofilledIfValuesIs(View view, AutofillValue targetValue, boolean hideHighlight) {
        AutofillValue currentValue = view.getAutofillValue();
        if (Objects.equals(currentValue, targetValue)) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mLastAutofilledData == null) {
                    this.mLastAutofilledData = new ParcelableMap(1);
                }
                this.mLastAutofilledData.put(view.getAutofillId(), targetValue);
            }
            view.setAutofilled(true, hideHighlight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values2, boolean hideHighlight) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            if (sessionId != this.mSessionId) {
                return;
            }
            AutofillClient client = this.getClient();
            if (client == null) {
                return;
            }
            int itemCount = ids.size();
            int numApplied = 0;
            ArrayMap<View, SparseArray<AutofillValue>> virtualValues = null;
            View[] views = client.autofillClientFindViewsByAutofillIdTraversal(Helper.toArray(ids));
            ArrayList<AutofillId> failedIds = null;
            for (i = 0; i < itemCount; ++i) {
                AutofillId id2 = ids.get(i);
                AutofillValue value2 = values2.get(i);
                View view = views[i];
                if (view == null) {
                    Log.d(TAG, "autofill(): no View with id " + id2);
                    if (failedIds == null) {
                        failedIds = new ArrayList<AutofillId>();
                    }
                    failedIds.add(id2);
                    continue;
                }
                if (id2.isVirtualInt()) {
                    SparseArray<AutofillValue> valuesByParent;
                    if (virtualValues == null) {
                        virtualValues = new ArrayMap<View, SparseArray<AutofillValue>>(1);
                    }
                    if ((valuesByParent = (SparseArray<AutofillValue>)virtualValues.get(view)) == null) {
                        valuesByParent = new SparseArray<AutofillValue>(5);
                        virtualValues.put(view, valuesByParent);
                    }
                    valuesByParent.put(id2.getVirtualChildIntId(), value2);
                    continue;
                }
                if (this.mLastAutofilledData == null) {
                    this.mLastAutofilledData = new ParcelableMap(itemCount - i);
                }
                this.mLastAutofilledData.put(id2, value2);
                view.autofill(value2);
                this.setAutofilledIfValuesIs(view, value2, hideHighlight);
                ++numApplied;
            }
            if (failedIds != null) {
                if (Helper.sVerbose) {
                    Log.v(TAG, "autofill(): total failed views: " + failedIds);
                }
                try {
                    this.mService.setAutofillFailure(this.mSessionId, failedIds, this.mContext.getUserId());
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            if (virtualValues != null) {
                for (i = 0; i < virtualValues.size(); ++i) {
                    View parent = (View)virtualValues.keyAt(i);
                    SparseArray childrenValues = (SparseArray)virtualValues.valueAt(i);
                    parent.autofill(childrenValues);
                    numApplied += childrenValues.size();
                }
            }
            this.mMetricsLogger.write(this.newLog(913).addTaggedData(914, itemCount).addTaggedData(915, numApplied));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autofillContent(int sessionId, AutofillId id2, ClipData clip) {
        Object object = this.mLock;
        synchronized (object) {
            if (sessionId != this.mSessionId) {
                return;
            }
            AutofillClient client = this.getClient();
            if (client == null) {
                return;
            }
            View view = client.autofillClientFindViewByAutofillIdTraversal(id2);
            if (view == null) {
                Log.d(TAG, "autofillContent(): no view with id " + id2);
                this.reportAutofillContentFailure(id2);
                return;
            }
            ContentInfo payload = new ContentInfo.Builder(clip, 4).build();
            ContentInfo result = view.performReceiveContent(payload);
            if (result != null) {
                Log.w(TAG, "autofillContent(): receiver could not insert content: id=" + id2 + ", view=" + view + ", clip=" + clip);
                this.reportAutofillContentFailure(id2);
                return;
            }
            this.mMetricsLogger.write(this.newLog(913).addTaggedData(914, 1).addTaggedData(915, 1));
        }
    }

    private void reportAutofillContentFailure(AutofillId id2) {
        try {
            this.mService.setAutofillFailure(this.mSessionId, Collections.singletonList(id2), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private LogMaker newLog(int category) {
        AutofillClient client;
        LogMaker log = new LogMaker(category).addTaggedData(1456, this.mSessionId);
        if (this.isCompatibilityModeEnabledLocked()) {
            log.addTaggedData(1414, 1);
        }
        if ((client = this.getClient()) == null) {
            log.setPackageName(this.mContext.getPackageName());
        } else {
            ComponentName sanitizedComponentName = new ComponentName(client.autofillClientGetComponentName().getPackageName(), "");
            log.setComponentName(sanitizedComponentName);
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTrackedViews(int sessionId, AutofillId[] trackedIds, boolean saveOnAllViewsInvisible, boolean saveOnFinish, AutofillId[] fillableIds, AutofillId saveTriggerId) {
        if (saveTriggerId != null) {
            saveTriggerId.resetSessionId();
        }
        Object object = this.mLock;
        synchronized (object) {
            if (Helper.sVerbose) {
                Log.v(TAG, "setTrackedViews(): sessionId=" + sessionId + ", trackedIds=" + Arrays.toString(trackedIds) + ", saveOnAllViewsInvisible=" + saveOnAllViewsInvisible + ", saveOnFinish=" + saveOnFinish + ", fillableIds=" + Arrays.toString(fillableIds) + ", saveTrigerId=" + saveTriggerId + ", mFillableIds=" + this.mFillableIds + ", mEnabled=" + this.mEnabled + ", mSessionId=" + this.mSessionId);
            }
            if (this.mEnabled && this.mSessionId == sessionId) {
                this.mTrackedViews = saveOnAllViewsInvisible ? new TrackedViews(trackedIds) : null;
                this.mSaveOnFinish = saveOnFinish;
                if (fillableIds != null) {
                    if (this.mFillableIds == null) {
                        this.mFillableIds = new ArraySet(fillableIds.length);
                    }
                    for (AutofillId id2 : fillableIds) {
                        id2.resetSessionId();
                        this.mFillableIds.add(id2);
                    }
                }
                if (this.mSaveTriggerId != null && !this.mSaveTriggerId.equals(saveTriggerId)) {
                    this.setNotifyOnClickLocked(this.mSaveTriggerId, false);
                }
                if (saveTriggerId != null && !saveTriggerId.equals(this.mSaveTriggerId)) {
                    this.mSaveTriggerId = saveTriggerId;
                    this.setNotifyOnClickLocked(this.mSaveTriggerId, true);
                }
            }
        }
    }

    private void setNotifyOnClickLocked(AutofillId id2, boolean notify) {
        View view = this.findView(id2);
        if (view == null) {
            Log.w(TAG, "setNotifyOnClick(): invalid id: " + id2);
            return;
        }
        view.setNotifyAutofillManagerOnClick(notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSaveUiState(int sessionId, boolean shown) {
        if (Helper.sDebug) {
            Log.d(TAG, "setSaveUiState(" + sessionId + "): " + shown);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId != Integer.MAX_VALUE) {
                Log.w(TAG, "setSaveUiState(" + sessionId + ", " + shown + ") called on existing session " + this.mSessionId + "; cancelling it");
                this.cancelSessionLocked();
            }
            if (shown) {
                this.mSessionId = sessionId;
                this.mState = 3;
            } else {
                this.mSessionId = Integer.MAX_VALUE;
                this.mState = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionFinished(int newState2, List<AutofillId> autofillableIds) {
        if (autofillableIds != null) {
            for (int i = 0; i < autofillableIds.size(); ++i) {
                autofillableIds.get(i).resetSessionId();
            }
        }
        Object object = this.mLock;
        synchronized (object) {
            if (Helper.sVerbose) {
                Log.v(TAG, "setSessionFinished(): from " + this.getStateAsStringLocked() + " to " + AutofillManager.getStateAsString(newState2) + "; autofillableIds=" + autofillableIds);
            }
            if (autofillableIds != null) {
                this.mEnteredIds = new ArraySet<AutofillId>(autofillableIds);
            }
            if (newState2 == 5 || newState2 == 6) {
                this.resetSessionLocked(true);
                this.mState = 0;
            } else {
                this.resetSessionLocked(false);
                this.mState = newState2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAugmentedAutofillClient(IResultReceiver result) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAugmentedAutofillServiceClient == null) {
                this.mAugmentedAutofillServiceClient = new AugmentedAutofillManagerClient(this);
            }
            Bundle resultData = new Bundle();
            resultData.putBinder(EXTRA_AUGMENTED_AUTOFILL_CLIENT, this.mAugmentedAutofillServiceClient.asBinder());
            try {
                result.send(0, resultData);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Could not send AugmentedAutofillClient back: " + e);
            }
        }
    }

    private void requestShowSoftInput(AutofillId id2) {
        AutofillClient client;
        if (Helper.sVerbose) {
            Log.v(TAG, "requestShowSoftInput(" + id2 + ")");
        }
        if ((client = this.getClient()) == null) {
            return;
        }
        View view = client.autofillClientFindViewByAutofillIdTraversal(id2);
        if (view == null) {
            if (Helper.sVerbose) {
                Log.v(TAG, "View is not found");
            }
            return;
        }
        Handler handler = view.getHandler();
        if (handler == null) {
            if (Helper.sVerbose) {
                Log.v(TAG, "Ignoring requestShowSoftInput due to no handler in view");
            }
            return;
        }
        if (handler.getLooper() != Looper.myLooper()) {
            if (Helper.sVerbose) {
                Log.v(TAG, "Scheduling showSoftInput() on the view UI thread");
            }
            handler.post(() -> AutofillManager.requestShowSoftInputInViewThread(view));
        } else {
            AutofillManager.requestShowSoftInputInViewThread(view);
        }
    }

    private static void requestShowSoftInputInViewThread(View view) {
        if (!view.isFocused()) {
            Log.w(TAG, "Ignoring requestShowSoftInput() due to non-focused view");
            return;
        }
        InputMethodManager inputMethodManager = view.getContext().getSystemService(InputMethodManager.class);
        boolean ret = inputMethodManager.showSoftInput(view, 0);
        if (Helper.sVerbose) {
            Log.v(TAG, " InputMethodManager.showSoftInput returns " + ret);
        }
    }

    public void requestHideFillUi() {
        this.requestHideFillUi(this.mIdShownFillUi, true);
    }

    private void requestHideFillUi(AutofillId id2, boolean force) {
        View anchor;
        View view = anchor = id2 == null ? null : this.findView(id2);
        if (Helper.sVerbose) {
            Log.v(TAG, "requestHideFillUi(" + id2 + "): anchor = " + anchor);
        }
        if (anchor == null) {
            AutofillClient client;
            if (force && (client = this.getClient()) != null) {
                client.autofillClientRequestHideFillUi();
            }
            return;
        }
        this.requestHideFillUi(id2, anchor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestHideFillUi(AutofillId id2, View anchor) {
        AutofillCallback callback2 = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client = this.getClient();
            if (client != null && client.autofillClientRequestHideFillUi()) {
                this.mIdShownFillUi = null;
                callback2 = this.mCallback;
            }
        }
        if (callback2 != null) {
            if (id2.isVirtualInt()) {
                callback2.onAutofillEvent(anchor, id2.getVirtualChildIntId(), 2);
            } else {
                callback2.onAutofillEvent(anchor, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDisableAutofill(long disableDuration, ComponentName componentName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOptions == null) {
                return;
            }
            long expiration = SystemClock.elapsedRealtime() + disableDuration;
            if (expiration < 0L) {
                expiration = Long.MAX_VALUE;
            }
            if (componentName != null) {
                if (this.mOptions.disabledActivities == null) {
                    this.mOptions.disabledActivities = new ArrayMap();
                }
                this.mOptions.disabledActivities.put(componentName.flattenToString(), expiration);
            } else {
                this.mOptions.appDisabledExpiration = expiration;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyReenableAutofill() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOptions == null) {
                return;
            }
            this.mOptions.appDisabledExpiration = 0L;
            this.mOptions.disabledActivities = null;
        }
    }

    private void notifyNoFillUi(int sessionId, AutofillId id2, int sessionFinishedState) {
        View anchor;
        if (Helper.sVerbose) {
            Log.v(TAG, "notifyNoFillUi(): sessionFinishedState=" + sessionFinishedState);
        }
        if ((anchor = this.findView(id2)) == null) {
            return;
        }
        this.notifyCallback(sessionId, id2, 3);
        if (sessionFinishedState != 0) {
            this.setSessionFinished(sessionFinishedState, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCallback(int sessionId, AutofillId id2, int event) {
        View anchor;
        if (Helper.sVerbose) {
            Log.v(TAG, "notifyCallback(): sessionId=" + sessionId + ", autofillId=" + id2 + ", event=" + event);
        }
        if ((anchor = this.findView(id2)) == null) {
            return;
        }
        AutofillCallback callback2 = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId == sessionId && this.getClient() != null) {
                callback2 = this.mCallback;
            }
        }
        if (callback2 != null) {
            if (id2.isVirtualInt()) {
                callback2.onAutofillEvent(anchor, id2.getVirtualChildIntId(), event);
            } else {
                callback2.onAutofillEvent(anchor, event);
            }
        }
    }

    private View findView(AutofillId autofillId) {
        AutofillClient client = this.getClient();
        if (client != null) {
            return client.autofillClientFindViewByAutofillIdTraversal(autofillId);
        }
        return null;
    }

    public boolean hasAutofillFeature() {
        return this.mService != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPendingSaveUi(int operation, IBinder token) {
        if (Helper.sVerbose) {
            Log.v(TAG, "onPendingSaveUi(" + operation + "): " + token);
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mService.onPendingSaveUi(operation, token);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in onPendingSaveUi: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String outerPrefix, PrintWriter pw) {
        pw.print(outerPrefix);
        pw.println("AutofillManager:");
        String pfx = outerPrefix + "  ";
        pw.print(pfx);
        pw.print("sessionId: ");
        pw.println(this.mSessionId);
        pw.print(pfx);
        pw.print("state: ");
        pw.println(this.getStateAsStringLocked());
        pw.print(pfx);
        pw.print("context: ");
        pw.println(this.mContext);
        pw.print(pfx);
        pw.print("service client: ");
        pw.println(this.mServiceClient);
        AutofillClient client = this.getClient();
        if (client != null) {
            pw.print(pfx);
            pw.print("client: ");
            pw.print(client);
            pw.print(" (");
            pw.print(client.autofillClientGetActivityToken());
            pw.println(')');
        }
        pw.print(pfx);
        pw.print("enabled: ");
        pw.println(this.mEnabled);
        pw.print(pfx);
        pw.print("enabledAugmentedOnly: ");
        pw.println(this.mForAugmentedAutofillOnly);
        pw.print(pfx);
        pw.print("hasService: ");
        pw.println(this.mService != null);
        pw.print(pfx);
        pw.print("hasCallback: ");
        pw.println(this.mCallback != null);
        pw.print(pfx);
        pw.print("onInvisibleCalled ");
        pw.println(this.mOnInvisibleCalled);
        pw.print(pfx);
        pw.print("last autofilled data: ");
        pw.println(this.mLastAutofilledData);
        pw.print(pfx);
        pw.print("id of last fill UI shown: ");
        pw.println(this.mIdShownFillUi);
        pw.print(pfx);
        pw.print("tracked views: ");
        if (this.mTrackedViews == null) {
            pw.println("null");
        } else {
            String pfx2 = pfx + "  ";
            pw.println();
            pw.print(pfx2);
            pw.print("visible:");
            pw.println(this.mTrackedViews.mVisibleTrackedIds);
            pw.print(pfx2);
            pw.print("invisible:");
            pw.println(this.mTrackedViews.mInvisibleTrackedIds);
        }
        pw.print(pfx);
        pw.print("fillable ids: ");
        pw.println(this.mFillableIds);
        pw.print(pfx);
        pw.print("entered ids: ");
        pw.println(this.mEnteredIds);
        if (this.mEnteredForAugmentedAutofillIds != null) {
            pw.print(pfx);
            pw.print("entered ids for augmented autofill: ");
            pw.println(this.mEnteredForAugmentedAutofillIds);
        }
        if (this.mForAugmentedAutofillOnly) {
            pw.print(pfx);
            pw.println("For Augmented Autofill Only");
        }
        pw.print(pfx);
        pw.print("save trigger id: ");
        pw.println(this.mSaveTriggerId);
        pw.print(pfx);
        pw.print("save on finish(): ");
        pw.println(this.mSaveOnFinish);
        if (this.mOptions != null) {
            pw.print(pfx);
            pw.print("options: ");
            this.mOptions.dumpShort(pw);
            pw.println();
        }
        pw.print(pfx);
        pw.print("compat mode enabled: ");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCompatibilityBridge != null) {
                String pfx2 = pfx + "  ";
                pw.println("true");
                pw.print(pfx2);
                pw.print("windowId: ");
                pw.println(this.mCompatibilityBridge.mFocusedWindowId);
                pw.print(pfx2);
                pw.print("nodeId: ");
                pw.println(this.mCompatibilityBridge.mFocusedNodeId);
                pw.print(pfx2);
                pw.print("virtualId: ");
                pw.println(AccessibilityNodeInfo.getVirtualDescendantId(this.mCompatibilityBridge.mFocusedNodeId));
                pw.print(pfx2);
                pw.print("focusedBounds: ");
                pw.println(this.mCompatibilityBridge.mFocusedBounds);
            } else {
                pw.println("false");
            }
        }
        pw.print(pfx);
        pw.print("debug: ");
        pw.print(Helper.sDebug);
        pw.print(" verbose: ");
        pw.println(Helper.sVerbose);
    }

    @GuardedBy(value={"mLock"})
    private String getStateAsStringLocked() {
        return AutofillManager.getStateAsString(this.mState);
    }

    private static String getStateAsString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "FINISHED";
            }
            case 3: {
                return "SHOWING_SAVE_UI";
            }
            case 4: {
                return "DISABLED_BY_SERVICE";
            }
            case 5: {
                return "UNKNOWN_COMPAT_MODE";
            }
            case 6: {
                return "UNKNOWN_FAILED";
            }
        }
        return "INVALID:" + state;
    }

    public static String getSmartSuggestionModeToString(int flags) {
        switch (flags) {
            case 0: {
                return "OFF";
            }
            case 1: {
                return "SYSTEM";
            }
        }
        return "INVALID:" + flags;
    }

    @GuardedBy(value={"mLock"})
    private boolean isActiveLocked() {
        return this.mState == 1;
    }

    @GuardedBy(value={"mLock"})
    private boolean isDisabledByServiceLocked() {
        return this.mState == 4;
    }

    @GuardedBy(value={"mLock"})
    private boolean isFinishedLocked() {
        return this.mState == 2;
    }

    private void post(Runnable runnable) {
        AutofillClient client = this.getClient();
        if (client == null) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring post() because client is null");
            }
            return;
        }
        client.autofillClientRunOnUiThread(runnable);
    }

    private static class AugmentedAutofillManagerClient
    extends IAugmentedAutofillManagerClient.Stub {
        private final WeakReference<AutofillManager> mAfm;

        private AugmentedAutofillManagerClient(AutofillManager autofillManager) {
            this.mAfm = new WeakReference<AutofillManager>(autofillManager);
        }

        @Override
        public AssistStructure.ViewNodeParcelable getViewNodeParcelable(AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm == null) {
                return null;
            }
            View view = this.getView(afm, id2);
            if (view == null) {
                Log.w(AutofillManager.TAG, "getViewNodeParcelable(" + id2 + "): could not find view");
                return null;
            }
            ViewRootImpl root = view.getViewRootImpl();
            if (root != null && (root.getWindowFlags() & 0x2000) == 0) {
                AssistStructure.ViewNodeBuilder viewStructure = new AssistStructure.ViewNodeBuilder();
                viewStructure.setAutofillId(view.getAutofillId());
                view.onProvideAutofillStructure(viewStructure, 0);
                AssistStructure.ViewNode viewNode = viewStructure.getViewNode();
                if (viewNode != null && id2.equals(viewNode.getAutofillId())) {
                    return new AssistStructure.ViewNodeParcelable(viewNode);
                }
            }
            return null;
        }

        @Override
        public Rect getViewCoordinates(AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm == null) {
                return null;
            }
            View view = this.getView(afm, id2);
            if (view == null) {
                return null;
            }
            Rect windowVisibleDisplayFrame = new Rect();
            view.getWindowVisibleDisplayFrame(windowVisibleDisplayFrame);
            int[] location = new int[2];
            view.getLocationOnScreen(location);
            Rect rect = new Rect(location[0], location[1] - windowVisibleDisplayFrame.top, location[0] + view.getWidth(), location[1] - windowVisibleDisplayFrame.top + view.getHeight());
            if (Helper.sVerbose) {
                Log.v(AutofillManager.TAG, "Coordinates for " + id2 + ": " + rect);
            }
            return rect;
        }

        @Override
        public void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values2, boolean hideHighlight) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.autofill(sessionId, ids, values2, hideHighlight));
            }
        }

        @Override
        public void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestShowFillUi(sessionId, id2, width, height, anchorBounds, presenter));
            }
        }

        @Override
        public void requestHideFillUi(int sessionId, AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestHideFillUi(id2, false));
            }
        }

        @Override
        public boolean requestAutofill(int sessionId, AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm == null || afm.mSessionId != sessionId) {
                if (Helper.sDebug) {
                    Slog.d(AutofillManager.TAG, "Autofill not available or sessionId doesn't match");
                }
                return false;
            }
            View view = this.getView(afm, id2);
            if (view == null || !view.isFocused()) {
                if (Helper.sDebug) {
                    Slog.d(AutofillManager.TAG, "View not available or is not on focus");
                }
                return false;
            }
            if (Helper.sVerbose) {
                Log.v(AutofillManager.TAG, "requestAutofill() by AugmentedAutofillService.");
            }
            afm.post(() -> afm.requestAutofillFromNewSession(view));
            return true;
        }

        private View getView(AutofillManager afm, AutofillId id2) {
            AutofillClient client = afm.getClient();
            if (client == null) {
                Log.w(AutofillManager.TAG, "getView(" + id2 + "): no autofill client");
                return null;
            }
            View view = client.autofillClientFindViewByAutofillIdTraversal(id2);
            if (view == null) {
                Log.w(AutofillManager.TAG, "getView(" + id2 + "): could not find view");
            }
            return view;
        }
    }

    private static class AutofillManagerClient
    extends IAutoFillManagerClient.Stub {
        private final WeakReference<AutofillManager> mAfm;

        private AutofillManagerClient(AutofillManager autofillManager) {
            this.mAfm = new WeakReference<AutofillManager>(autofillManager);
        }

        @Override
        public void setState(int flags) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setState(flags));
            }
        }

        @Override
        public void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values2, boolean hideHighlight) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.autofill(sessionId, ids, values2, hideHighlight));
            }
        }

        @Override
        public void autofillContent(int sessionId, AutofillId id2, ClipData content2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.autofillContent(sessionId, id2, content2));
            }
        }

        @Override
        public void authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent, boolean authenticateInline) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.authenticate(sessionId, authenticationId, intent, fillInIntent, authenticateInline));
            }
        }

        @Override
        public void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestShowFillUi(sessionId, id2, width, height, anchorBounds, presenter));
            }
        }

        @Override
        public void requestHideFillUi(int sessionId, AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestHideFillUi(id2, false));
            }
        }

        @Override
        public void notifyNoFillUi(int sessionId, AutofillId id2, int sessionFinishedState) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.notifyNoFillUi(sessionId, id2, sessionFinishedState));
            }
        }

        @Override
        public void notifyFillUiShown(int sessionId, AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.notifyCallback(sessionId, id2, 1));
            }
        }

        @Override
        public void notifyFillUiHidden(int sessionId, AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.notifyCallback(sessionId, id2, 2));
            }
        }

        @Override
        public void notifyDisableAutofill(long disableDuration, ComponentName componentName) throws RemoteException {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.notifyDisableAutofill(disableDuration, componentName));
            }
        }

        @Override
        public void dispatchUnhandledKey(int sessionId, AutofillId id2, KeyEvent fullScreen) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.dispatchUnhandledKey(sessionId, id2, fullScreen));
            }
        }

        @Override
        public void startIntentSender(IntentSender intentSender, Intent intent) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> {
                    try {
                        afm.mContext.startIntentSender(intentSender, intent, 0, 0, 0);
                    }
                    catch (IntentSender.SendIntentException e) {
                        Log.e(AutofillManager.TAG, "startIntentSender() failed for intent:" + intentSender, e);
                    }
                });
            }
        }

        @Override
        public void setTrackedViews(int sessionId, AutofillId[] ids, boolean saveOnAllViewsInvisible, boolean saveOnFinish, AutofillId[] fillableIds, AutofillId saveTriggerId) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setTrackedViews(sessionId, ids, saveOnAllViewsInvisible, saveOnFinish, fillableIds, saveTriggerId));
            }
        }

        @Override
        public void setSaveUiState(int sessionId, boolean shown) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setSaveUiState(sessionId, shown));
            }
        }

        @Override
        public void setSessionFinished(int newState2, List<AutofillId> autofillableIds) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setSessionFinished(newState2, autofillableIds));
            }
        }

        @Override
        public void getAugmentedAutofillClient(IResultReceiver result) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.getAugmentedAutofillClient(result));
            }
        }

        @Override
        public void requestShowSoftInput(AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestShowSoftInput(id2));
            }
        }
    }

    public static abstract class AutofillCallback {
        public static final int EVENT_INPUT_SHOWN = 1;
        public static final int EVENT_INPUT_HIDDEN = 2;
        public static final int EVENT_INPUT_UNAVAILABLE = 3;

        public void onAutofillEvent(View view, int event) {
        }

        public void onAutofillEvent(View view, int virtualId, int event) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AutofillEventType {
        }
    }

    private class TrackedViews {
        private ArraySet<AutofillId> mVisibleTrackedIds;
        private ArraySet<AutofillId> mInvisibleTrackedIds;

        private <T> boolean isInSet(ArraySet<T> set, T value2) {
            return set != null && set.contains(value2);
        }

        private <T> ArraySet<T> addToSet(ArraySet<T> set, T valueToAdd) {
            if (set == null) {
                set = new ArraySet(1);
            }
            set.add(valueToAdd);
            return set;
        }

        private <T> ArraySet<T> removeFromSet(ArraySet<T> set, T valueToRemove) {
            if (set == null) {
                return null;
            }
            set.remove(valueToRemove);
            if (set.isEmpty()) {
                return null;
            }
            return set;
        }

        TrackedViews(AutofillId[] trackedIds) {
            AutofillClient client = AutofillManager.this.getClient();
            if (!ArrayUtils.isEmpty(trackedIds) && client != null) {
                boolean[] isVisible;
                if (client.autofillClientIsVisibleForAutofill()) {
                    if (Helper.sVerbose) {
                        Log.v(AutofillManager.TAG, "client is visible, check tracked ids");
                    }
                    isVisible = client.autofillClientGetViewVisibility(trackedIds);
                } else {
                    isVisible = new boolean[trackedIds.length];
                }
                int numIds = trackedIds.length;
                for (int i = 0; i < numIds; ++i) {
                    AutofillId id2 = trackedIds[i];
                    id2.resetSessionId();
                    if (isVisible[i]) {
                        this.mVisibleTrackedIds = this.addToSet(this.mVisibleTrackedIds, id2);
                        continue;
                    }
                    this.mInvisibleTrackedIds = this.addToSet(this.mInvisibleTrackedIds, id2);
                }
            }
            if (Helper.sVerbose) {
                Log.v(AutofillManager.TAG, "TrackedViews(trackedIds=" + Arrays.toString(trackedIds) + "):  mVisibleTrackedIds=" + this.mVisibleTrackedIds + " mInvisibleTrackedIds=" + this.mInvisibleTrackedIds);
            }
            if (this.mVisibleTrackedIds == null) {
                AutofillManager.this.finishSessionLocked();
            }
        }

        @GuardedBy(value={"mLock"})
        void notifyViewVisibilityChangedLocked(AutofillId id2, boolean isVisible) {
            if (Helper.sDebug) {
                Log.d(AutofillManager.TAG, "notifyViewVisibilityChangedLocked(): id=" + id2 + " isVisible=" + isVisible);
            }
            if (AutofillManager.this.isClientVisibleForAutofillLocked()) {
                if (isVisible) {
                    if (this.isInSet(this.mInvisibleTrackedIds, id2)) {
                        this.mInvisibleTrackedIds = this.removeFromSet(this.mInvisibleTrackedIds, id2);
                        this.mVisibleTrackedIds = this.addToSet(this.mVisibleTrackedIds, id2);
                    }
                } else if (this.isInSet(this.mVisibleTrackedIds, id2)) {
                    this.mVisibleTrackedIds = this.removeFromSet(this.mVisibleTrackedIds, id2);
                    this.mInvisibleTrackedIds = this.addToSet(this.mInvisibleTrackedIds, id2);
                }
            }
            if (this.mVisibleTrackedIds == null) {
                if (Helper.sVerbose) {
                    Log.v(AutofillManager.TAG, "No more visible ids. Invisibile = " + this.mInvisibleTrackedIds);
                }
                AutofillManager.this.finishSessionLocked();
            }
        }

        @GuardedBy(value={"mLock"})
        void onVisibleForAutofillChangedLocked() {
            AutofillClient client = AutofillManager.this.getClient();
            ArraySet<AutofillId> updatedVisibleTrackedIds = null;
            ArraySet<AutofillId> updatedInvisibleTrackedIds = null;
            if (client != null) {
                AutofillId id2;
                int i;
                boolean[] isVisible;
                if (Helper.sVerbose) {
                    Log.v(AutofillManager.TAG, "onVisibleForAutofillChangedLocked(): inv= " + this.mInvisibleTrackedIds + " vis=" + this.mVisibleTrackedIds);
                }
                if (this.mInvisibleTrackedIds != null) {
                    ArrayList<AutofillId> orderedInvisibleIds = new ArrayList<AutofillId>(this.mInvisibleTrackedIds);
                    isVisible = client.autofillClientGetViewVisibility(Helper.toArray(orderedInvisibleIds));
                    int numInvisibleTrackedIds = orderedInvisibleIds.size();
                    for (i = 0; i < numInvisibleTrackedIds; ++i) {
                        id2 = orderedInvisibleIds.get(i);
                        if (isVisible[i]) {
                            updatedVisibleTrackedIds = this.addToSet(updatedVisibleTrackedIds, id2);
                            if (!Helper.sDebug) continue;
                            Log.d(AutofillManager.TAG, "onVisibleForAutofill() " + id2 + " became visible");
                            continue;
                        }
                        updatedInvisibleTrackedIds = this.addToSet(updatedInvisibleTrackedIds, id2);
                    }
                }
                if (this.mVisibleTrackedIds != null) {
                    ArrayList<AutofillId> orderedVisibleIds = new ArrayList<AutofillId>(this.mVisibleTrackedIds);
                    isVisible = client.autofillClientGetViewVisibility(Helper.toArray(orderedVisibleIds));
                    int numVisibleTrackedIds = orderedVisibleIds.size();
                    for (i = 0; i < numVisibleTrackedIds; ++i) {
                        id2 = orderedVisibleIds.get(i);
                        if (isVisible[i]) {
                            updatedVisibleTrackedIds = this.addToSet(updatedVisibleTrackedIds, id2);
                            continue;
                        }
                        updatedInvisibleTrackedIds = this.addToSet(updatedInvisibleTrackedIds, id2);
                        if (!Helper.sDebug) continue;
                        Log.d(AutofillManager.TAG, "onVisibleForAutofill() " + id2 + " became invisible");
                    }
                }
                this.mInvisibleTrackedIds = updatedInvisibleTrackedIds;
                this.mVisibleTrackedIds = updatedVisibleTrackedIds;
            }
            if (this.mVisibleTrackedIds == null) {
                if (Helper.sVerbose) {
                    Log.v(AutofillManager.TAG, "onVisibleForAutofillChangedLocked(): no more visible ids");
                }
                AutofillManager.this.finishSessionLocked();
            }
        }
    }

    private class CompatibilityBridge
    implements AccessibilityManager.AccessibilityPolicy {
        @GuardedBy(value={"mLock"})
        private final Rect mFocusedBounds = new Rect();
        @GuardedBy(value={"mLock"})
        private final Rect mTempBounds = new Rect();
        @GuardedBy(value={"mLock"})
        private int mFocusedWindowId = -1;
        @GuardedBy(value={"mLock"})
        private long mFocusedNodeId = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
        @GuardedBy(value={"mLock"})
        AccessibilityServiceInfo mCompatServiceInfo;

        CompatibilityBridge() {
            AccessibilityManager am = AccessibilityManager.getInstance(AutofillManager.this.mContext);
            am.setAccessibilityPolicy(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AccessibilityServiceInfo getCompatServiceInfo() {
            Object object = AutofillManager.this.mLock;
            synchronized (object) {
                if (this.mCompatServiceInfo != null) {
                    return this.mCompatServiceInfo;
                }
                Intent intent = new Intent();
                intent.setComponent(new ComponentName("android", "com.android.server.autofill.AutofillCompatAccessibilityService"));
                ResolveInfo resolveInfo = AutofillManager.this.mContext.getPackageManager().resolveService(intent, 0x100080);
                try {
                    this.mCompatServiceInfo = new AccessibilityServiceInfo(resolveInfo, AutofillManager.this.mContext);
                }
                catch (IOException | XmlPullParserException e) {
                    Log.e(AutofillManager.TAG, "Cannot find compat autofill service:" + intent);
                    throw new IllegalStateException("Cannot find compat autofill service");
                }
                return this.mCompatServiceInfo;
            }
        }

        @Override
        public boolean isEnabled(boolean accessibilityEnabled) {
            return true;
        }

        @Override
        public int getRelevantEventTypes(int relevantEventTypes) {
            return relevantEventTypes | 8 | 0x10 | 1 | 0x800;
        }

        @Override
        public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(List<AccessibilityServiceInfo> installedServices) {
            if (installedServices == null) {
                installedServices = new ArrayList<AccessibilityServiceInfo>();
            }
            installedServices.add(this.getCompatServiceInfo());
            return installedServices;
        }

        @Override
        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags, List<AccessibilityServiceInfo> enabledService) {
            if (enabledService == null) {
                enabledService = new ArrayList<AccessibilityServiceInfo>();
            }
            enabledService.add(this.getCompatServiceInfo());
            return enabledService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessibilityEvent onAccessibilityEvent(AccessibilityEvent event, boolean accessibilityEnabled, int relevantEventTypes) {
            int type = event.getEventType();
            if (Helper.sVerbose) {
                Log.v(AutofillManager.TAG, "onAccessibilityEvent(" + AccessibilityEvent.eventTypeToString(type) + "): virtualId=" + AccessibilityNodeInfo.getVirtualDescendantId(event.getSourceNodeId()) + ", client=" + AutofillManager.this.getClient());
            }
            switch (type) {
                case 8: {
                    Object object = AutofillManager.this.mLock;
                    synchronized (object) {
                        long nodeId;
                        int windowId;
                        if (this.mFocusedWindowId == event.getWindowId() && this.mFocusedNodeId == event.getSourceNodeId()) {
                            return event;
                        }
                        if (this.mFocusedWindowId != -1 && this.mFocusedNodeId != AccessibilityNodeInfo.UNDEFINED_NODE_ID) {
                            this.notifyViewExited(this.mFocusedWindowId, this.mFocusedNodeId);
                            this.mFocusedWindowId = -1;
                            this.mFocusedNodeId = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
                            this.mFocusedBounds.set(0, 0, 0, 0);
                        }
                        if (this.notifyViewEntered(windowId = event.getWindowId(), nodeId = event.getSourceNodeId(), this.mFocusedBounds)) {
                            this.mFocusedWindowId = windowId;
                            this.mFocusedNodeId = nodeId;
                        }
                        break;
                    }
                }
                case 16: {
                    Object object = AutofillManager.this.mLock;
                    synchronized (object) {
                        if (this.mFocusedWindowId == event.getWindowId() && this.mFocusedNodeId == event.getSourceNodeId()) {
                            this.notifyValueChanged(event.getWindowId(), event.getSourceNodeId());
                        }
                        break;
                    }
                }
                case 1: {
                    Object object = AutofillManager.this.mLock;
                    synchronized (object) {
                        this.notifyViewClicked(event.getWindowId(), event.getSourceNodeId());
                        break;
                    }
                }
                case 2048: {
                    AutofillClient client = AutofillManager.this.getClient();
                    if (client == null) break;
                    Object object = AutofillManager.this.mLock;
                    synchronized (object) {
                        if (client.autofillClientIsFillUiShowing()) {
                            this.notifyViewEntered(this.mFocusedWindowId, this.mFocusedNodeId, this.mFocusedBounds);
                        }
                        this.updateTrackedViewsLocked();
                        break;
                    }
                }
            }
            return accessibilityEnabled ? event : null;
        }

        private boolean notifyViewEntered(int windowId, long nodeId, Rect focusedBounds) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return false;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return false;
            }
            AccessibilityNodeInfo node = this.findVirtualNodeByAccessibilityId(view, virtualId);
            if (node == null) {
                return false;
            }
            if (!node.isEditable()) {
                return false;
            }
            Rect newBounds = this.mTempBounds;
            node.getBoundsInScreen(newBounds);
            if (newBounds.equals(focusedBounds)) {
                return false;
            }
            focusedBounds.set(newBounds);
            AutofillManager.this.notifyViewEntered(view, virtualId, newBounds);
            return true;
        }

        private void notifyViewExited(int windowId, long nodeId) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return;
            }
            AutofillManager.this.notifyViewExited(view, virtualId);
        }

        private void notifyValueChanged(int windowId, long nodeId) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return;
            }
            AccessibilityNodeInfo node = this.findVirtualNodeByAccessibilityId(view, virtualId);
            if (node == null) {
                return;
            }
            AutofillManager.this.notifyValueChanged(view, virtualId, AutofillValue.forText(node.getText()));
        }

        private void notifyViewClicked(int windowId, long nodeId) {
            int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(nodeId);
            if (!this.isVirtualNode(virtualId)) {
                return;
            }
            View view = this.findViewByAccessibilityId(windowId, nodeId);
            if (view == null) {
                return;
            }
            AccessibilityNodeInfo node = this.findVirtualNodeByAccessibilityId(view, virtualId);
            if (node == null) {
                return;
            }
            AutofillManager.this.notifyViewClicked(view, virtualId);
        }

        @GuardedBy(value={"mLock"})
        private void updateTrackedViewsLocked() {
            if (AutofillManager.this.mTrackedViews != null) {
                AutofillManager.this.mTrackedViews.onVisibleForAutofillChangedLocked();
            }
        }

        private View findViewByAccessibilityId(int windowId, long nodeId) {
            AutofillClient client = AutofillManager.this.getClient();
            if (client == null) {
                return null;
            }
            int viewId = AccessibilityNodeInfo.getAccessibilityViewId(nodeId);
            return client.autofillClientFindViewByAccessibilityIdTraversal(viewId, windowId);
        }

        private AccessibilityNodeInfo findVirtualNodeByAccessibilityId(View view, int virtualId) {
            AccessibilityNodeProvider provider2 = view.getAccessibilityNodeProvider();
            if (provider2 == null) {
                return null;
            }
            return provider2.createAccessibilityNodeInfo(virtualId);
        }

        private boolean isVirtualNode(int nodeId) {
            return nodeId != -1 && nodeId != Integer.MAX_VALUE;
        }
    }

    public static interface AutofillClient {
        public void autofillClientAuthenticate(int var1, IntentSender var2, Intent var3, boolean var4);

        public void autofillClientResetableStateAvailable();

        public boolean autofillClientRequestShowFillUi(View var1, int var2, int var3, Rect var4, IAutofillWindowPresenter var5);

        public void autofillClientDispatchUnhandledKey(View var1, KeyEvent var2);

        public boolean autofillClientRequestHideFillUi();

        public boolean autofillClientIsFillUiShowing();

        public boolean[] autofillClientGetViewVisibility(AutofillId[] var1);

        public boolean autofillClientIsVisibleForAutofill();

        public boolean isDisablingEnterExitEventForAutofill();

        public View[] autofillClientFindViewsByAutofillIdTraversal(AutofillId[] var1);

        public View autofillClientFindViewByAutofillIdTraversal(AutofillId var1);

        public View autofillClientFindViewByAccessibilityIdTraversal(int var1, int var2);

        public void autofillClientRunOnUiThread(Runnable var1);

        public ComponentName autofillClientGetComponentName();

        public IBinder autofillClientGetActivityToken();

        public boolean autofillClientIsCompatibilityModeEnabled();

        public AutofillId autofillClientGetNextAutofillId();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SmartSuggestionMode {
    }
}

