/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWindowMagnificationConnectionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.view.accessibility.IWindowMagnificationConnectionCallback";

    public void onWindowMagnifierBoundsChanged(int var1, Rect var2) throws RemoteException;

    public void onChangeMagnificationMode(int var1, int var2) throws RemoteException;

    public void onSourceBoundsChanged(int var1, Rect var2) throws RemoteException;

    public void onPerformScaleAction(int var1, float var2) throws RemoteException;

    public void onAccessibilityActionPerformed(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowMagnificationConnectionCallback {
        static final int TRANSACTION_onWindowMagnifierBoundsChanged = 1;
        static final int TRANSACTION_onChangeMagnificationMode = 2;
        static final int TRANSACTION_onSourceBoundsChanged = 3;
        static final int TRANSACTION_onPerformScaleAction = 4;
        static final int TRANSACTION_onAccessibilityActionPerformed = 5;

        public Stub() {
            this.attachInterface(this, IWindowMagnificationConnectionCallback.DESCRIPTOR);
        }

        public static IWindowMagnificationConnectionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWindowMagnificationConnectionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IWindowMagnificationConnectionCallback) {
                return (IWindowMagnificationConnectionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onWindowMagnifierBoundsChanged";
                }
                case 2: {
                    return "onChangeMagnificationMode";
                }
                case 3: {
                    return "onSourceBoundsChanged";
                }
                case 4: {
                    return "onPerformScaleAction";
                }
                case 5: {
                    return "onAccessibilityActionPerformed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWindowMagnificationConnectionCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Rect _arg1 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    this.onWindowMagnifierBoundsChanged(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onChangeMagnificationMode(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Rect _arg1 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    this.onSourceBoundsChanged(_arg0, _arg1);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    this.onPerformScaleAction(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onAccessibilityActionPerformed(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IWindowMagnificationConnectionCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IWindowMagnificationConnectionCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IWindowMagnificationConnectionCallback {
            private IBinder mRemote;
            public static IWindowMagnificationConnectionCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWindowMagnificationConnectionCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWindowMagnifierBoundsChanged(int displayId, Rect bounds2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    if (bounds2 != null) {
                        _data.writeInt(1);
                        bounds2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onWindowMagnifierBoundsChanged(displayId, bounds2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChangeMagnificationMode(int displayId, int magnificationMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(magnificationMode);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onChangeMagnificationMode(displayId, magnificationMode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSourceBoundsChanged(int displayId, Rect sourceBounds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    if (sourceBounds != null) {
                        _data.writeInt(1);
                        sourceBounds.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSourceBoundsChanged(displayId, sourceBounds);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPerformScaleAction(int displayId, float scale) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(scale);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onPerformScaleAction(displayId, scale);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAccessibilityActionPerformed(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnectionCallback.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAccessibilityActionPerformed(displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindowMagnificationConnectionCallback {
        @Override
        public void onWindowMagnifierBoundsChanged(int displayId, Rect bounds2) throws RemoteException {
        }

        @Override
        public void onChangeMagnificationMode(int displayId, int magnificationMode) throws RemoteException {
        }

        @Override
        public void onSourceBoundsChanged(int displayId, Rect sourceBounds) throws RemoteException {
        }

        @Override
        public void onPerformScaleAction(int displayId, float scale) throws RemoteException {
        }

        @Override
        public void onAccessibilityActionPerformed(int displayId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

