/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AccessibilityClickableSpan;
import android.text.style.AccessibilityReplacementSpan;
import android.text.style.AccessibilityURLSpan;
import android.text.style.ClickableSpan;
import android.text.style.ReplacementSpan;
import android.text.style.URLSpan;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.LongArray;
import android.util.Pools;
import android.util.Size;
import android.view.View;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityWindowInfo;
import com.android.internal.util.BitUtils;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class AccessibilityNodeInfo
implements Parcelable {
    private static final String TAG = "AccessibilityNodeInfo";
    private static final boolean DEBUG = Log.isLoggable("AccessibilityNodeInfo", 3) && _Original_Build.IS_DEBUGGABLE;
    public static final int UNDEFINED_CONNECTION_ID = -1;
    public static final int UNDEFINED_SELECTION_INDEX = -1;
    public static final int UNDEFINED_ITEM_ID = Integer.MAX_VALUE;
    public static final int ROOT_ITEM_ID = 0x7FFFFFFE;
    public static final int LEASHED_ITEM_ID = 0x7FFFFFFD;
    public static final long UNDEFINED_NODE_ID = AccessibilityNodeInfo.makeNodeId(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final long ROOT_NODE_ID = AccessibilityNodeInfo.makeNodeId(0x7FFFFFFE, -1);
    public static final long LEASHED_NODE_ID = AccessibilityNodeInfo.makeNodeId(0x7FFFFFFD, -1);
    public static final int FLAG_PREFETCH_PREDECESSORS = 1;
    public static final int FLAG_PREFETCH_SIBLINGS = 2;
    public static final int FLAG_PREFETCH_DESCENDANTS = 4;
    public static final int FLAG_PREFETCH_MASK = 7;
    public static final int FLAG_INCLUDE_NOT_IMPORTANT_VIEWS = 8;
    public static final int FLAG_REPORT_VIEW_IDS = 16;
    public static final int ACTION_FOCUS = 1;
    public static final int ACTION_CLEAR_FOCUS = 2;
    public static final int ACTION_SELECT = 4;
    public static final int ACTION_CLEAR_SELECTION = 8;
    public static final int ACTION_CLICK = 16;
    public static final int ACTION_LONG_CLICK = 32;
    public static final int ACTION_ACCESSIBILITY_FOCUS = 64;
    public static final int ACTION_CLEAR_ACCESSIBILITY_FOCUS = 128;
    public static final int ACTION_NEXT_AT_MOVEMENT_GRANULARITY = 256;
    public static final int ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = 512;
    public static final int ACTION_NEXT_HTML_ELEMENT = 1024;
    public static final int ACTION_PREVIOUS_HTML_ELEMENT = 2048;
    public static final int ACTION_SCROLL_FORWARD = 4096;
    public static final int ACTION_SCROLL_BACKWARD = 8192;
    public static final int ACTION_COPY = 16384;
    public static final int ACTION_PASTE = 32768;
    public static final int ACTION_CUT = 65536;
    public static final int ACTION_SET_SELECTION = 131072;
    public static final int ACTION_EXPAND = 262144;
    public static final int ACTION_COLLAPSE = 524288;
    public static final int ACTION_DISMISS = 0x100000;
    public static final int ACTION_SET_TEXT = 0x200000;
    public static final int LAST_LEGACY_STANDARD_ACTION = 0x200000;
    private static final int ACTION_TYPE_MASK = -16777216;
    public static final String ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT = "ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT";
    public static final String ACTION_ARGUMENT_HTML_ELEMENT_STRING = "ACTION_ARGUMENT_HTML_ELEMENT_STRING";
    public static final String ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN = "ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN";
    public static final String ACTION_ARGUMENT_SELECTION_START_INT = "ACTION_ARGUMENT_SELECTION_START_INT";
    public static final String ACTION_ARGUMENT_SELECTION_END_INT = "ACTION_ARGUMENT_SELECTION_END_INT";
    public static final String ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE = "ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE";
    public static final String ACTION_ARGUMENT_ROW_INT = "android.view.accessibility.action.ARGUMENT_ROW_INT";
    public static final String ACTION_ARGUMENT_COLUMN_INT = "android.view.accessibility.action.ARGUMENT_COLUMN_INT";
    public static final String ACTION_ARGUMENT_PROGRESS_VALUE = "android.view.accessibility.action.ARGUMENT_PROGRESS_VALUE";
    public static final String ACTION_ARGUMENT_MOVE_WINDOW_X = "ACTION_ARGUMENT_MOVE_WINDOW_X";
    public static final String ACTION_ARGUMENT_MOVE_WINDOW_Y = "ACTION_ARGUMENT_MOVE_WINDOW_Y";
    public static final String ACTION_ARGUMENT_ACCESSIBLE_CLICKABLE_SPAN = "android.view.accessibility.action.ACTION_ARGUMENT_ACCESSIBLE_CLICKABLE_SPAN";
    public static final String ACTION_ARGUMENT_PRESS_AND_HOLD_DURATION_MILLIS_INT = "android.view.accessibility.action.ARGUMENT_PRESS_AND_HOLD_DURATION_MILLIS_INT";
    public static final int FOCUS_INPUT = 1;
    public static final int FOCUS_ACCESSIBILITY = 2;
    public static final int MOVEMENT_GRANULARITY_CHARACTER = 1;
    public static final int MOVEMENT_GRANULARITY_WORD = 2;
    public static final int MOVEMENT_GRANULARITY_LINE = 4;
    public static final int MOVEMENT_GRANULARITY_PARAGRAPH = 8;
    public static final int MOVEMENT_GRANULARITY_PAGE = 16;
    public static final String EXTRA_DATA_TEXT_CHARACTER_LOCATION_KEY = "android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY";
    public static final String EXTRA_DATA_TEXT_CHARACTER_LOCATION_ARG_START_INDEX = "android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_START_INDEX";
    public static final String EXTRA_DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH = "android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH";
    public static final int EXTRA_DATA_TEXT_CHARACTER_LOCATION_ARG_MAX_LENGTH = 20000;
    public static final String EXTRA_DATA_RENDERING_INFO_KEY = "android.view.accessibility.extra.DATA_RENDERING_INFO_KEY";
    public static final String EXTRA_DATA_REQUESTED_KEY = "android.view.accessibility.AccessibilityNodeInfo.extra_data_requested";
    private static final int BOOLEAN_PROPERTY_CHECKABLE = 1;
    private static final int BOOLEAN_PROPERTY_CHECKED = 2;
    private static final int BOOLEAN_PROPERTY_FOCUSABLE = 4;
    private static final int BOOLEAN_PROPERTY_FOCUSED = 8;
    private static final int BOOLEAN_PROPERTY_SELECTED = 16;
    private static final int BOOLEAN_PROPERTY_CLICKABLE = 32;
    private static final int BOOLEAN_PROPERTY_LONG_CLICKABLE = 64;
    private static final int BOOLEAN_PROPERTY_ENABLED = 128;
    private static final int BOOLEAN_PROPERTY_PASSWORD = 256;
    private static final int BOOLEAN_PROPERTY_SCROLLABLE = 512;
    private static final int BOOLEAN_PROPERTY_ACCESSIBILITY_FOCUSED = 1024;
    private static final int BOOLEAN_PROPERTY_VISIBLE_TO_USER = 2048;
    private static final int BOOLEAN_PROPERTY_EDITABLE = 4096;
    private static final int BOOLEAN_PROPERTY_OPENS_POPUP = 8192;
    private static final int BOOLEAN_PROPERTY_DISMISSABLE = 16384;
    private static final int BOOLEAN_PROPERTY_MULTI_LINE = 32768;
    private static final int BOOLEAN_PROPERTY_CONTENT_INVALID = 65536;
    private static final int BOOLEAN_PROPERTY_CONTEXT_CLICKABLE = 131072;
    private static final int BOOLEAN_PROPERTY_IMPORTANCE = 262144;
    private static final int BOOLEAN_PROPERTY_SCREEN_READER_FOCUSABLE = 524288;
    private static final int BOOLEAN_PROPERTY_IS_SHOWING_HINT = 0x100000;
    private static final int BOOLEAN_PROPERTY_IS_HEADING = 0x200000;
    private static final int BOOLEAN_PROPERTY_IS_TEXT_ENTRY_KEY = 0x400000;
    private static final long VIRTUAL_DESCENDANT_ID_MASK = -4294967296L;
    private static final int VIRTUAL_DESCENDANT_ID_SHIFT = 32;
    private static AtomicInteger sNumInstancesInUse;
    private static final int MAX_POOL_SIZE = 50;
    private static final Pools.SynchronizedPool<AccessibilityNodeInfo> sPool;
    private static final AccessibilityNodeInfo DEFAULT;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private boolean mSealed;
    private int mWindowId = -1;
    @UnsupportedAppUsage
    private long mSourceNodeId = UNDEFINED_NODE_ID;
    private long mParentNodeId = UNDEFINED_NODE_ID;
    private long mLabelForId = UNDEFINED_NODE_ID;
    private long mLabeledById = UNDEFINED_NODE_ID;
    private long mTraversalBefore = UNDEFINED_NODE_ID;
    private long mTraversalAfter = UNDEFINED_NODE_ID;
    private int mBooleanProperties;
    private final Rect mBoundsInParent = new Rect();
    private final Rect mBoundsInScreen = new Rect();
    private int mDrawingOrderInParent;
    private CharSequence mPackageName;
    private CharSequence mClassName;
    private CharSequence mOriginalText;
    private CharSequence mText;
    private CharSequence mHintText;
    private CharSequence mError;
    private CharSequence mPaneTitle;
    private CharSequence mStateDescription;
    private CharSequence mContentDescription;
    private CharSequence mTooltipText;
    private String mViewIdResourceName;
    private ArrayList<String> mExtraDataKeys;
    @UnsupportedAppUsage
    private LongArray mChildNodeIds;
    private ArrayList<AccessibilityAction> mActions;
    private int mMaxTextLength = -1;
    private int mMovementGranularities;
    private int mTextSelectionStart = -1;
    private int mTextSelectionEnd = -1;
    private int mInputType = 0;
    private int mLiveRegion = 0;
    private Bundle mExtras;
    private int mConnectionId = -1;
    private RangeInfo mRangeInfo;
    private CollectionInfo mCollectionInfo;
    private CollectionItemInfo mCollectionItemInfo;
    private TouchDelegateInfo mTouchDelegateInfo;
    private ExtraRenderingInfo mExtraRenderingInfo;
    private IBinder mLeashedChild;
    private IBinder mLeashedParent;
    private long mLeashedParentNodeId = UNDEFINED_NODE_ID;
    public static final Parcelable.Creator<AccessibilityNodeInfo> CREATOR;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int getAccessibilityViewId(long accessibilityNodeId) {
        return (int)accessibilityNodeId;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int getVirtualDescendantId(long accessibilityNodeId) {
        return (int)((accessibilityNodeId & 0xFFFFFFFF00000000L) >> 32);
    }

    public static long makeNodeId(int accessibilityViewId, int virtualDescendantId) {
        return (long)virtualDescendantId << 32 | (long)accessibilityViewId;
    }

    public AccessibilityNodeInfo() {
    }

    public AccessibilityNodeInfo(View source) {
        this.setSource(source);
    }

    public AccessibilityNodeInfo(View root, int virtualDescendantId) {
        this.setSource(root, virtualDescendantId);
    }

    public AccessibilityNodeInfo(AccessibilityNodeInfo info) {
        this.init(info, false);
    }

    public void setSource(View source) {
        this.setSource(source, -1);
    }

    public void setSource(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        this.mWindowId = root != null ? root.getAccessibilityWindowId() : Integer.MAX_VALUE;
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mSourceNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public AccessibilityNodeInfo findFocus(int focus) {
        this.enforceSealed();
        this.enforceValidFocusType(focus);
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, this.mWindowId, this.mSourceNodeId, focus);
    }

    public AccessibilityNodeInfo focusSearch(int direction) {
        this.enforceSealed();
        this.enforceValidFocusDirection(direction);
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().focusSearch(this.mConnectionId, this.mWindowId, this.mSourceNodeId, direction);
    }

    public int getWindowId() {
        return this.mWindowId;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean refresh(Bundle arguments, boolean bypassCache) {
        this.enforceSealed();
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        AccessibilityNodeInfo refreshedInfo = client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mSourceNodeId, bypassCache, 0, arguments);
        if (refreshedInfo == null) {
            return false;
        }
        this.enforceSealed();
        this.init(refreshedInfo, true);
        refreshedInfo.recycle();
        return true;
    }

    public boolean refresh() {
        return this.refresh(null, true);
    }

    public boolean refreshWithExtraData(String extraDataKey, Bundle args) {
        if (args.getInt(EXTRA_DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH, -1) > 20000) {
            args.putInt(EXTRA_DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH, 20000);
        }
        args.putString(EXTRA_DATA_REQUESTED_KEY, extraDataKey);
        return this.refresh(args, true);
    }

    public LongArray getChildNodeIds() {
        return this.mChildNodeIds;
    }

    public long getChildId(int index) {
        if (this.mChildNodeIds == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.mChildNodeIds.get(index);
    }

    public int getChildCount() {
        return this.mChildNodeIds == null ? 0 : this.mChildNodeIds.size();
    }

    public AccessibilityNodeInfo getChild(int index) {
        this.enforceSealed();
        if (this.mChildNodeIds == null) {
            return null;
        }
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return null;
        }
        long childId = this.mChildNodeIds.get(index);
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        if (this.mLeashedChild != null && childId == LEASHED_NODE_ID) {
            return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mLeashedChild, ROOT_NODE_ID, false, 4, null);
        }
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, childId, false, 4, null);
    }

    public void addChild(View child) {
        this.addChildInternal(child, -1, true);
    }

    public void addChild(IBinder token) {
        this.enforceNotSealed();
        if (token == null) {
            return;
        }
        if (this.mChildNodeIds == null) {
            this.mChildNodeIds = new LongArray();
        }
        this.mLeashedChild = token;
        if (this.mChildNodeIds.indexOf(LEASHED_NODE_ID) >= 0) {
            return;
        }
        this.mChildNodeIds.add(LEASHED_NODE_ID);
    }

    public void addChildUnchecked(View child) {
        this.addChildInternal(child, -1, false);
    }

    public boolean removeChild(View child) {
        return this.removeChild(child, -1);
    }

    public boolean removeChild(IBinder token) {
        this.enforceNotSealed();
        if (this.mChildNodeIds == null || this.mLeashedChild == null) {
            return false;
        }
        if (!this.mLeashedChild.equals(token)) {
            return false;
        }
        int index = this.mChildNodeIds.indexOf(LEASHED_NODE_ID);
        this.mLeashedChild = null;
        if (index < 0) {
            return false;
        }
        this.mChildNodeIds.remove(index);
        return true;
    }

    public void addChild(View root, int virtualDescendantId) {
        this.addChildInternal(root, virtualDescendantId, true);
    }

    private void addChildInternal(View root, int virtualDescendantId, boolean checked) {
        int rootAccessibilityViewId;
        long childNodeId;
        this.enforceNotSealed();
        if (this.mChildNodeIds == null) {
            this.mChildNodeIds = new LongArray();
        }
        if ((childNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE, virtualDescendantId)) == this.mSourceNodeId) {
            Log.e(TAG, "Rejecting attempt to make a View its own child");
            return;
        }
        if (checked && this.mChildNodeIds.indexOf(childNodeId) >= 0) {
            return;
        }
        this.mChildNodeIds.add(childNodeId);
    }

    public boolean removeChild(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        LongArray childIds = this.mChildNodeIds;
        if (childIds == null) {
            return false;
        }
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        long childNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
        int index = childIds.indexOf(childNodeId);
        if (index < 0) {
            return false;
        }
        childIds.remove(index);
        return true;
    }

    public List<AccessibilityAction> getActionList() {
        return CollectionUtils.emptyIfNull(this.mActions);
    }

    @Deprecated
    public int getActions() {
        int returnValue = 0;
        if (this.mActions == null) {
            return returnValue;
        }
        int actionSize = this.mActions.size();
        for (int i = 0; i < actionSize; ++i) {
            int actionId = this.mActions.get(i).getId();
            if (actionId > 0x200000) continue;
            returnValue |= actionId;
        }
        return returnValue;
    }

    public void addAction(AccessibilityAction action2) {
        this.enforceNotSealed();
        this.addActionUnchecked(action2);
    }

    private void addActionUnchecked(AccessibilityAction action2) {
        if (action2 == null) {
            return;
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.remove(action2);
        this.mActions.add(action2);
    }

    @Deprecated
    public void addAction(int action2) {
        this.enforceNotSealed();
        if ((action2 & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Action is not a combination of the standard actions: " + action2);
        }
        this.addStandardActions(action2);
    }

    @Deprecated
    public void removeAction(int action2) {
        this.enforceNotSealed();
        this.removeAction(AccessibilityNodeInfo.getActionSingleton(action2));
    }

    public boolean removeAction(AccessibilityAction action2) {
        this.enforceNotSealed();
        if (this.mActions == null || action2 == null) {
            return false;
        }
        return this.mActions.remove(action2);
    }

    public void removeAllActions() {
        if (this.mActions != null) {
            this.mActions.clear();
        }
    }

    public AccessibilityNodeInfo getTraversalBefore() {
        this.enforceSealed();
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mTraversalBefore);
    }

    public void setTraversalBefore(View view) {
        this.setTraversalBefore(view, -1);
    }

    public void setTraversalBefore(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mTraversalBefore = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public AccessibilityNodeInfo getTraversalAfter() {
        this.enforceSealed();
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mTraversalAfter);
    }

    public void setTraversalAfter(View view) {
        this.setTraversalAfter(view, -1);
    }

    public void setTraversalAfter(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mTraversalAfter = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public List<String> getAvailableExtraData() {
        if (this.mExtraDataKeys != null) {
            return Collections.unmodifiableList(this.mExtraDataKeys);
        }
        return Collections.EMPTY_LIST;
    }

    public void setAvailableExtraData(List<String> extraDataKeys) {
        this.enforceNotSealed();
        this.mExtraDataKeys = new ArrayList<String>(extraDataKeys);
    }

    public void setMaxTextLength(int max) {
        this.enforceNotSealed();
        this.mMaxTextLength = max;
    }

    public int getMaxTextLength() {
        return this.mMaxTextLength;
    }

    public void setMovementGranularities(int granularities) {
        this.enforceNotSealed();
        this.mMovementGranularities = granularities;
    }

    public int getMovementGranularities() {
        return this.mMovementGranularities;
    }

    public boolean performAction(int action2) {
        this.enforceSealed();
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        Bundle arguments = null;
        if (this.mExtras != null) {
            arguments = this.mExtras;
        }
        return client.performAccessibilityAction(this.mConnectionId, this.mWindowId, this.mSourceNodeId, action2, arguments);
    }

    public boolean performAction(int action2, Bundle arguments) {
        this.enforceSealed();
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.performAccessibilityAction(this.mConnectionId, this.mWindowId, this.mSourceNodeId, action2, arguments);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String text) {
        this.enforceSealed();
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return Collections.emptyList();
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfosByText(this.mConnectionId, this.mWindowId, this.mSourceNodeId, text);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewId(String viewId) {
        this.enforceSealed();
        if (viewId == null) {
            Log.e(TAG, "returns empty list due to null viewId.");
            return Collections.emptyList();
        }
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return Collections.emptyList();
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfosByViewId(this.mConnectionId, this.mWindowId, this.mSourceNodeId, viewId);
    }

    public AccessibilityWindowInfo getWindow() {
        this.enforceSealed();
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.getWindow(this.mConnectionId, this.mWindowId);
    }

    public AccessibilityNodeInfo getParent() {
        this.enforceSealed();
        if (this.mLeashedParent != null && this.mLeashedParentNodeId != UNDEFINED_NODE_ID) {
            return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mLeashedParent, this.mLeashedParentNodeId);
        }
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mParentNodeId);
    }

    public long getParentNodeId() {
        return this.mParentNodeId;
    }

    public void setParent(View parent) {
        this.setParent(parent, -1);
    }

    public void setParent(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mParentNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    @Deprecated
    public void getBoundsInParent(Rect outBounds) {
        outBounds.set(this.mBoundsInParent.left, this.mBoundsInParent.top, this.mBoundsInParent.right, this.mBoundsInParent.bottom);
    }

    @Deprecated
    public void setBoundsInParent(Rect bounds2) {
        this.enforceNotSealed();
        this.mBoundsInParent.set(bounds2.left, bounds2.top, bounds2.right, bounds2.bottom);
    }

    public void getBoundsInScreen(Rect outBounds) {
        outBounds.set(this.mBoundsInScreen.left, this.mBoundsInScreen.top, this.mBoundsInScreen.right, this.mBoundsInScreen.bottom);
    }

    public Rect getBoundsInScreen() {
        return this.mBoundsInScreen;
    }

    public void setBoundsInScreen(Rect bounds2) {
        this.enforceNotSealed();
        this.mBoundsInScreen.set(bounds2.left, bounds2.top, bounds2.right, bounds2.bottom);
    }

    public boolean isCheckable() {
        return this.getBooleanProperty(1);
    }

    public void setCheckable(boolean checkable) {
        this.setBooleanProperty(1, checkable);
    }

    public boolean isChecked() {
        return this.getBooleanProperty(2);
    }

    public void setChecked(boolean checked) {
        this.setBooleanProperty(2, checked);
    }

    public boolean isFocusable() {
        return this.getBooleanProperty(4);
    }

    public void setFocusable(boolean focusable) {
        this.setBooleanProperty(4, focusable);
    }

    public boolean isFocused() {
        return this.getBooleanProperty(8);
    }

    public void setFocused(boolean focused) {
        this.setBooleanProperty(8, focused);
    }

    public boolean isVisibleToUser() {
        return this.getBooleanProperty(2048);
    }

    public void setVisibleToUser(boolean visibleToUser) {
        this.setBooleanProperty(2048, visibleToUser);
    }

    public boolean isAccessibilityFocused() {
        return this.getBooleanProperty(1024);
    }

    public void setAccessibilityFocused(boolean focused) {
        this.setBooleanProperty(1024, focused);
    }

    public boolean isSelected() {
        return this.getBooleanProperty(16);
    }

    public void setSelected(boolean selected) {
        this.setBooleanProperty(16, selected);
    }

    public boolean isClickable() {
        return this.getBooleanProperty(32);
    }

    public void setClickable(boolean clickable) {
        this.setBooleanProperty(32, clickable);
    }

    public boolean isLongClickable() {
        return this.getBooleanProperty(64);
    }

    public void setLongClickable(boolean longClickable) {
        this.setBooleanProperty(64, longClickable);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty(128);
    }

    public void setEnabled(boolean enabled) {
        this.setBooleanProperty(128, enabled);
    }

    public boolean isPassword() {
        return this.getBooleanProperty(256);
    }

    public void setPassword(boolean password) {
        this.setBooleanProperty(256, password);
    }

    public boolean isScrollable() {
        return this.getBooleanProperty(512);
    }

    public void setScrollable(boolean scrollable) {
        this.setBooleanProperty(512, scrollable);
    }

    public boolean isEditable() {
        return this.getBooleanProperty(4096);
    }

    public void setEditable(boolean editable) {
        this.setBooleanProperty(4096, editable);
    }

    public void setPaneTitle(CharSequence paneTitle) {
        this.enforceNotSealed();
        this.mPaneTitle = paneTitle == null ? null : paneTitle.subSequence(0, paneTitle.length());
    }

    public CharSequence getPaneTitle() {
        return this.mPaneTitle;
    }

    public int getDrawingOrder() {
        return this.mDrawingOrderInParent;
    }

    public void setDrawingOrder(int drawingOrderInParent) {
        this.enforceNotSealed();
        this.mDrawingOrderInParent = drawingOrderInParent;
    }

    public CollectionInfo getCollectionInfo() {
        return this.mCollectionInfo;
    }

    public void setCollectionInfo(CollectionInfo collectionInfo) {
        this.enforceNotSealed();
        this.mCollectionInfo = collectionInfo;
    }

    public CollectionItemInfo getCollectionItemInfo() {
        return this.mCollectionItemInfo;
    }

    public void setCollectionItemInfo(CollectionItemInfo collectionItemInfo) {
        this.enforceNotSealed();
        this.mCollectionItemInfo = collectionItemInfo;
    }

    public RangeInfo getRangeInfo() {
        return this.mRangeInfo;
    }

    public void setRangeInfo(RangeInfo rangeInfo) {
        this.enforceNotSealed();
        this.mRangeInfo = rangeInfo;
    }

    public ExtraRenderingInfo getExtraRenderingInfo() {
        return this.mExtraRenderingInfo;
    }

    public void setExtraRenderingInfo(ExtraRenderingInfo extraRenderingInfo) {
        this.enforceNotSealed();
        this.mExtraRenderingInfo = extraRenderingInfo;
    }

    public boolean isContentInvalid() {
        return this.getBooleanProperty(65536);
    }

    public void setContentInvalid(boolean contentInvalid) {
        this.setBooleanProperty(65536, contentInvalid);
    }

    public boolean isContextClickable() {
        return this.getBooleanProperty(131072);
    }

    public void setContextClickable(boolean contextClickable) {
        this.setBooleanProperty(131072, contextClickable);
    }

    public int getLiveRegion() {
        return this.mLiveRegion;
    }

    public void setLiveRegion(int mode) {
        this.enforceNotSealed();
        this.mLiveRegion = mode;
    }

    public boolean isMultiLine() {
        return this.getBooleanProperty(32768);
    }

    public void setMultiLine(boolean multiLine) {
        this.setBooleanProperty(32768, multiLine);
    }

    public boolean canOpenPopup() {
        return this.getBooleanProperty(8192);
    }

    public void setCanOpenPopup(boolean opensPopup) {
        this.enforceNotSealed();
        this.setBooleanProperty(8192, opensPopup);
    }

    public boolean isDismissable() {
        return this.getBooleanProperty(16384);
    }

    public void setDismissable(boolean dismissable) {
        this.setBooleanProperty(16384, dismissable);
    }

    public boolean isImportantForAccessibility() {
        return this.getBooleanProperty(262144);
    }

    public void setImportantForAccessibility(boolean important) {
        this.setBooleanProperty(262144, important);
    }

    public boolean isScreenReaderFocusable() {
        return this.getBooleanProperty(524288);
    }

    public void setScreenReaderFocusable(boolean screenReaderFocusable) {
        this.setBooleanProperty(524288, screenReaderFocusable);
    }

    public boolean isShowingHintText() {
        return this.getBooleanProperty(0x100000);
    }

    public void setShowingHintText(boolean showingHintText) {
        this.setBooleanProperty(0x100000, showingHintText);
    }

    public boolean isHeading() {
        if (this.getBooleanProperty(0x200000)) {
            return true;
        }
        CollectionItemInfo itemInfo = this.getCollectionItemInfo();
        return itemInfo != null && itemInfo.mHeading;
    }

    public void setHeading(boolean isHeading) {
        this.setBooleanProperty(0x200000, isHeading);
    }

    public boolean isTextEntryKey() {
        return this.getBooleanProperty(0x400000);
    }

    public void setTextEntryKey(boolean isTextEntryKey) {
        this.setBooleanProperty(0x400000, isTextEntryKey);
    }

    public CharSequence getPackageName() {
        return this.mPackageName;
    }

    public void setPackageName(CharSequence packageName) {
        this.enforceNotSealed();
        this.mPackageName = packageName;
    }

    public CharSequence getClassName() {
        return this.mClassName;
    }

    public void setClassName(CharSequence className2) {
        this.enforceNotSealed();
        this.mClassName = className2;
    }

    public CharSequence getText() {
        if (this.mText instanceof Spanned) {
            Spanned spanned = (Spanned)this.mText;
            AccessibilityClickableSpan[] clickableSpans = spanned.getSpans(0, this.mText.length(), AccessibilityClickableSpan.class);
            for (int i = 0; i < clickableSpans.length; ++i) {
                clickableSpans[i].copyConnectionDataFrom(this);
            }
            AccessibilityURLSpan[] urlSpans = spanned.getSpans(0, this.mText.length(), AccessibilityURLSpan.class);
            for (int i = 0; i < urlSpans.length; ++i) {
                urlSpans[i].copyConnectionDataFrom(this);
            }
        }
        return this.mText;
    }

    public CharSequence getOriginalText() {
        return this.mOriginalText;
    }

    public void setText(CharSequence text) {
        this.enforceNotSealed();
        this.mOriginalText = text;
        if (text instanceof Spanned) {
            CharSequence tmpText = text;
            tmpText = this.replaceClickableSpan(tmpText);
            this.mText = tmpText = this.replaceReplacementSpan(tmpText);
            return;
        }
        this.mText = text == null ? null : text.subSequence(0, text.length());
    }

    private CharSequence replaceClickableSpan(CharSequence text) {
        ClickableSpan span;
        ClickableSpan[] clickableSpans = ((Spanned)text).getSpans(0, text.length(), ClickableSpan.class);
        SpannableStringBuilder spannable = new SpannableStringBuilder(text);
        if (clickableSpans.length == 0) {
            return text;
        }
        for (int i = 0; i < clickableSpans.length && !((span = clickableSpans[i]) instanceof AccessibilityClickableSpan) && !(span instanceof AccessibilityURLSpan); ++i) {
            int spanToReplaceStart = spannable.getSpanStart(span);
            int spanToReplaceEnd = spannable.getSpanEnd(span);
            int spanToReplaceFlags = spannable.getSpanFlags(span);
            spannable.removeSpan(span);
            ClickableSpan replacementSpan = span instanceof URLSpan ? new AccessibilityURLSpan((URLSpan)span) : new AccessibilityClickableSpan(span.getId());
            spannable.setSpan(replacementSpan, spanToReplaceStart, spanToReplaceEnd, spanToReplaceFlags);
        }
        return spannable;
    }

    private CharSequence replaceReplacementSpan(CharSequence text) {
        ReplacementSpan[] replacementSpans = ((Spanned)text).getSpans(0, text.length(), ReplacementSpan.class);
        SpannableStringBuilder spannable = new SpannableStringBuilder(text);
        if (replacementSpans.length == 0) {
            return text;
        }
        for (int i = 0; i < replacementSpans.length; ++i) {
            ReplacementSpan span = replacementSpans[i];
            CharSequence replacementText = span.getContentDescription();
            if (span instanceof AccessibilityReplacementSpan) break;
            if (replacementText == null) continue;
            int spanToReplaceStart = spannable.getSpanStart(span);
            int spanToReplaceEnd = spannable.getSpanEnd(span);
            int spanToReplaceFlags = spannable.getSpanFlags(span);
            spannable.removeSpan(span);
            AccessibilityReplacementSpan replacementSpan = new AccessibilityReplacementSpan(replacementText);
            spannable.setSpan(replacementSpan, spanToReplaceStart, spanToReplaceEnd, spanToReplaceFlags);
        }
        return spannable;
    }

    public CharSequence getHintText() {
        return this.mHintText;
    }

    public void setHintText(CharSequence hintText) {
        this.enforceNotSealed();
        this.mHintText = hintText == null ? null : hintText.subSequence(0, hintText.length());
    }

    public void setError(CharSequence error) {
        this.enforceNotSealed();
        this.mError = error == null ? null : error.subSequence(0, error.length());
    }

    public CharSequence getError() {
        return this.mError;
    }

    public CharSequence getStateDescription() {
        return this.mStateDescription;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public void setStateDescription(CharSequence stateDescription) {
        this.enforceNotSealed();
        this.mStateDescription = stateDescription == null ? null : stateDescription.subSequence(0, stateDescription.length());
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.enforceNotSealed();
        this.mContentDescription = contentDescription == null ? null : contentDescription.subSequence(0, contentDescription.length());
    }

    public CharSequence getTooltipText() {
        return this.mTooltipText;
    }

    public void setTooltipText(CharSequence tooltipText) {
        this.enforceNotSealed();
        this.mTooltipText = tooltipText == null ? null : tooltipText.subSequence(0, tooltipText.length());
    }

    public void setLabelFor(View labeled) {
        this.setLabelFor(labeled, -1);
    }

    public void setLabelFor(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mLabelForId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public AccessibilityNodeInfo getLabelFor() {
        this.enforceSealed();
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabelForId);
    }

    public void setLabeledBy(View label) {
        this.setLabeledBy(label, -1);
    }

    public void setLabeledBy(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mLabeledById = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public AccessibilityNodeInfo getLabeledBy() {
        this.enforceSealed();
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabeledById);
    }

    public void setViewIdResourceName(String viewIdResName) {
        this.enforceNotSealed();
        this.mViewIdResourceName = viewIdResName;
    }

    public String getViewIdResourceName() {
        return this.mViewIdResourceName;
    }

    public int getTextSelectionStart() {
        return this.mTextSelectionStart;
    }

    public int getTextSelectionEnd() {
        return this.mTextSelectionEnd;
    }

    public void setTextSelection(int start, int end) {
        this.enforceNotSealed();
        this.mTextSelectionStart = start;
        this.mTextSelectionEnd = end;
    }

    public int getInputType() {
        return this.mInputType;
    }

    public void setInputType(int inputType) {
        this.enforceNotSealed();
        this.mInputType = inputType;
    }

    public Bundle getExtras() {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        return this.mExtras;
    }

    public boolean hasExtras() {
        return this.mExtras != null;
    }

    public TouchDelegateInfo getTouchDelegateInfo() {
        if (this.mTouchDelegateInfo != null) {
            this.mTouchDelegateInfo.setConnectionId(this.mConnectionId);
            this.mTouchDelegateInfo.setWindowId(this.mWindowId);
        }
        return this.mTouchDelegateInfo;
    }

    public void setTouchDelegateInfo(TouchDelegateInfo delegatedInfo) {
        this.enforceNotSealed();
        this.mTouchDelegateInfo = delegatedInfo;
    }

    private boolean getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) != 0;
    }

    private void setBooleanProperty(int property, boolean value2) {
        this.enforceNotSealed();
        this.mBooleanProperties = value2 ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    public void setConnectionId(int connectionId) {
        this.enforceNotSealed();
        this.mConnectionId = connectionId;
    }

    public int getConnectionId() {
        return this.mConnectionId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void setSourceNodeId(long sourceId, int windowId) {
        this.enforceNotSealed();
        this.mSourceNodeId = sourceId;
        this.mWindowId = windowId;
    }

    @UnsupportedAppUsage
    public long getSourceNodeId() {
        return this.mSourceNodeId;
    }

    public void setLeashedParent(IBinder token, int viewId) {
        this.enforceNotSealed();
        this.mLeashedParent = token;
        this.mLeashedParentNodeId = AccessibilityNodeInfo.makeNodeId(viewId, -1);
    }

    public IBinder getLeashedParent() {
        return this.mLeashedParent;
    }

    public long getLeashedParentNodeId() {
        return this.mLeashedParentNodeId;
    }

    @UnsupportedAppUsage
    public void setSealed(boolean sealed) {
        this.mSealed = sealed;
    }

    @UnsupportedAppUsage
    public boolean isSealed() {
        return this.mSealed;
    }

    protected void enforceSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a not sealed instance.");
        }
    }

    private void enforceValidFocusDirection(int direction) {
        switch (direction) {
            case 1: 
            case 2: 
            case 17: 
            case 33: 
            case 66: 
            case 130: {
                return;
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    private void enforceValidFocusType(int focusType) {
        switch (focusType) {
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Unknown focus type: " + focusType);
    }

    protected void enforceNotSealed() {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a sealed instance.");
        }
    }

    public static AccessibilityNodeInfo obtain(View source) {
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
        info.setSource(source);
        return info;
    }

    public static AccessibilityNodeInfo obtain(View root, int virtualDescendantId) {
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
        info.setSource(root, virtualDescendantId);
        return info;
    }

    public static AccessibilityNodeInfo obtain() {
        AccessibilityNodeInfo info = sPool.acquire();
        if (sNumInstancesInUse != null) {
            sNumInstancesInUse.incrementAndGet();
        }
        return info != null ? info : new AccessibilityNodeInfo();
    }

    public static AccessibilityNodeInfo obtain(AccessibilityNodeInfo info) {
        AccessibilityNodeInfo infoClone = AccessibilityNodeInfo.obtain();
        infoClone.init(info, true);
        return infoClone;
    }

    public void recycle() {
        this.clear();
        sPool.release(this);
        if (sNumInstancesInUse != null) {
            sNumInstancesInUse.decrementAndGet();
        }
    }

    public static void setNumInstancesInUseCounter(AtomicInteger counter) {
        sNumInstancesInUse = counter;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        this.writeToParcelNoRecycle(parcel, flags);
        this.recycle();
    }

    public void writeToParcelNoRecycle(Parcel parcel, int flags) {
        long nonDefaultFields = 0L;
        int fieldIndex = 0;
        if (this.isSealed() != DEFAULT.isSealed()) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mSourceNodeId != AccessibilityNodeInfo.DEFAULT.mSourceNodeId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mWindowId != AccessibilityNodeInfo.DEFAULT.mWindowId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mParentNodeId != AccessibilityNodeInfo.DEFAULT.mParentNodeId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLabelForId != AccessibilityNodeInfo.DEFAULT.mLabelForId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLabeledById != AccessibilityNodeInfo.DEFAULT.mLabeledById) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mTraversalBefore != AccessibilityNodeInfo.DEFAULT.mTraversalBefore) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mTraversalAfter != AccessibilityNodeInfo.DEFAULT.mTraversalAfter) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mConnectionId != AccessibilityNodeInfo.DEFAULT.mConnectionId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!LongArray.elementsEqual(this.mChildNodeIds, AccessibilityNodeInfo.DEFAULT.mChildNodeIds)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mBoundsInParent, AccessibilityNodeInfo.DEFAULT.mBoundsInParent)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mBoundsInScreen, AccessibilityNodeInfo.DEFAULT.mBoundsInScreen)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mActions, AccessibilityNodeInfo.DEFAULT.mActions)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mMaxTextLength != AccessibilityNodeInfo.DEFAULT.mMaxTextLength) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mMovementGranularities != AccessibilityNodeInfo.DEFAULT.mMovementGranularities) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mBooleanProperties != AccessibilityNodeInfo.DEFAULT.mBooleanProperties) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mPackageName, AccessibilityNodeInfo.DEFAULT.mPackageName)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mClassName, AccessibilityNodeInfo.DEFAULT.mClassName)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mText, AccessibilityNodeInfo.DEFAULT.mText)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mHintText, AccessibilityNodeInfo.DEFAULT.mHintText)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mError, AccessibilityNodeInfo.DEFAULT.mError)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mStateDescription, AccessibilityNodeInfo.DEFAULT.mStateDescription)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mContentDescription, AccessibilityNodeInfo.DEFAULT.mContentDescription)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mPaneTitle, AccessibilityNodeInfo.DEFAULT.mPaneTitle)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mTooltipText, AccessibilityNodeInfo.DEFAULT.mTooltipText)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mViewIdResourceName, AccessibilityNodeInfo.DEFAULT.mViewIdResourceName)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mTextSelectionStart != AccessibilityNodeInfo.DEFAULT.mTextSelectionStart) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mTextSelectionEnd != AccessibilityNodeInfo.DEFAULT.mTextSelectionEnd) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mInputType != AccessibilityNodeInfo.DEFAULT.mInputType) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLiveRegion != AccessibilityNodeInfo.DEFAULT.mLiveRegion) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mDrawingOrderInParent != AccessibilityNodeInfo.DEFAULT.mDrawingOrderInParent) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mExtraDataKeys, AccessibilityNodeInfo.DEFAULT.mExtraDataKeys)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mExtras, AccessibilityNodeInfo.DEFAULT.mExtras)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mRangeInfo, AccessibilityNodeInfo.DEFAULT.mRangeInfo)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mCollectionInfo, AccessibilityNodeInfo.DEFAULT.mCollectionInfo)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mCollectionItemInfo, AccessibilityNodeInfo.DEFAULT.mCollectionItemInfo)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mTouchDelegateInfo, AccessibilityNodeInfo.DEFAULT.mTouchDelegateInfo)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mExtraRenderingInfo, AccessibilityNodeInfo.DEFAULT.mExtraRenderingInfo)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLeashedChild != AccessibilityNodeInfo.DEFAULT.mLeashedChild) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLeashedParent != AccessibilityNodeInfo.DEFAULT.mLeashedParent) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLeashedParentNodeId != AccessibilityNodeInfo.DEFAULT.mLeashedParentNodeId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        int totalFields = fieldIndex;
        parcel.writeLong(nonDefaultFields);
        fieldIndex = 0;
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.isSealed() ? 1 : 0);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mSourceNodeId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mWindowId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mParentNodeId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mLabelForId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mLabeledById);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mTraversalBefore);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mTraversalAfter);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mConnectionId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            LongArray childIds = this.mChildNodeIds;
            if (childIds == null) {
                parcel.writeInt(0);
            } else {
                int childIdsSize = childIds.size();
                parcel.writeInt(childIdsSize);
                for (int i = 0; i < childIdsSize; ++i) {
                    parcel.writeLong(childIds.get(i));
                }
            }
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mBoundsInParent.top);
            parcel.writeInt(this.mBoundsInParent.bottom);
            parcel.writeInt(this.mBoundsInParent.left);
            parcel.writeInt(this.mBoundsInParent.right);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mBoundsInScreen.top);
            parcel.writeInt(this.mBoundsInScreen.bottom);
            parcel.writeInt(this.mBoundsInScreen.left);
            parcel.writeInt(this.mBoundsInScreen.right);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            if (this.mActions != null && !this.mActions.isEmpty()) {
                AccessibilityAction action2;
                int i;
                int actionCount = this.mActions.size();
                int nonStandardActionCount = 0;
                long defaultStandardActions = 0L;
                for (i = 0; i < actionCount; ++i) {
                    action2 = this.mActions.get(i);
                    if (AccessibilityNodeInfo.isDefaultStandardAction(action2)) {
                        defaultStandardActions |= action2.mSerializationFlag;
                        continue;
                    }
                    ++nonStandardActionCount;
                }
                parcel.writeLong(defaultStandardActions);
                parcel.writeInt(nonStandardActionCount);
                for (i = 0; i < actionCount; ++i) {
                    action2 = this.mActions.get(i);
                    if (AccessibilityNodeInfo.isDefaultStandardAction(action2)) continue;
                    action2.writeToParcel(parcel, flags);
                }
            } else {
                parcel.writeLong(0L);
                parcel.writeInt(0);
            }
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mMaxTextLength);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mMovementGranularities);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mBooleanProperties);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mPackageName);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mClassName);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mText);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mHintText);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mError);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mStateDescription);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mContentDescription);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mPaneTitle);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mTooltipText);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeString(this.mViewIdResourceName);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mTextSelectionStart);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mTextSelectionEnd);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mInputType);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mLiveRegion);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mDrawingOrderInParent);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeStringList(this.mExtraDataKeys);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeBundle(this.mExtras);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mRangeInfo.getType());
            parcel.writeFloat(this.mRangeInfo.getMin());
            parcel.writeFloat(this.mRangeInfo.getMax());
            parcel.writeFloat(this.mRangeInfo.getCurrent());
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mCollectionInfo.getRowCount());
            parcel.writeInt(this.mCollectionInfo.getColumnCount());
            parcel.writeInt(this.mCollectionInfo.isHierarchical() ? 1 : 0);
            parcel.writeInt(this.mCollectionInfo.getSelectionMode());
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mCollectionItemInfo.getRowIndex());
            parcel.writeInt(this.mCollectionItemInfo.getRowSpan());
            parcel.writeInt(this.mCollectionItemInfo.getColumnIndex());
            parcel.writeInt(this.mCollectionItemInfo.getColumnSpan());
            parcel.writeInt(this.mCollectionItemInfo.isHeading() ? 1 : 0);
            parcel.writeInt(this.mCollectionItemInfo.isSelected() ? 1 : 0);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTouchDelegateInfo.writeToParcel(parcel, flags);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeValue(this.mExtraRenderingInfo.getLayoutSize());
            parcel.writeFloat(this.mExtraRenderingInfo.getTextSizeInPx());
            parcel.writeInt(this.mExtraRenderingInfo.getTextSizeUnit());
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeStrongBinder(this.mLeashedChild);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeStrongBinder(this.mLeashedParent);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mLeashedParentNodeId);
        }
        if (DEBUG && totalFields != --fieldIndex) {
            throw new IllegalStateException("Number of fields mismatch: " + totalFields + " vs " + fieldIndex);
        }
    }

    private void init(AccessibilityNodeInfo other, boolean usePoolingInfos) {
        LongArray otherChildNodeIds;
        ArrayList<AccessibilityAction> otherActions;
        this.mSealed = other.mSealed;
        this.mSourceNodeId = other.mSourceNodeId;
        this.mParentNodeId = other.mParentNodeId;
        this.mLabelForId = other.mLabelForId;
        this.mLabeledById = other.mLabeledById;
        this.mTraversalBefore = other.mTraversalBefore;
        this.mTraversalAfter = other.mTraversalAfter;
        this.mWindowId = other.mWindowId;
        this.mConnectionId = other.mConnectionId;
        this.mBoundsInParent.set(other.mBoundsInParent);
        this.mBoundsInScreen.set(other.mBoundsInScreen);
        this.mPackageName = other.mPackageName;
        this.mClassName = other.mClassName;
        this.mText = other.mText;
        this.mOriginalText = other.mOriginalText;
        this.mHintText = other.mHintText;
        this.mError = other.mError;
        this.mStateDescription = other.mStateDescription;
        this.mContentDescription = other.mContentDescription;
        this.mPaneTitle = other.mPaneTitle;
        this.mTooltipText = other.mTooltipText;
        this.mViewIdResourceName = other.mViewIdResourceName;
        if (this.mActions != null) {
            this.mActions.clear();
        }
        if ((otherActions = other.mActions) != null && otherActions.size() > 0) {
            if (this.mActions == null) {
                this.mActions = new ArrayList<AccessibilityAction>(otherActions);
            } else {
                this.mActions.addAll(other.mActions);
            }
        }
        this.mBooleanProperties = other.mBooleanProperties;
        this.mMaxTextLength = other.mMaxTextLength;
        this.mMovementGranularities = other.mMovementGranularities;
        if (this.mChildNodeIds != null) {
            this.mChildNodeIds.clear();
        }
        if ((otherChildNodeIds = other.mChildNodeIds) != null && otherChildNodeIds.size() > 0) {
            if (this.mChildNodeIds == null) {
                this.mChildNodeIds = otherChildNodeIds.clone();
            } else {
                this.mChildNodeIds.addAll(otherChildNodeIds);
            }
        }
        this.mTextSelectionStart = other.mTextSelectionStart;
        this.mTextSelectionEnd = other.mTextSelectionEnd;
        this.mInputType = other.mInputType;
        this.mLiveRegion = other.mLiveRegion;
        this.mDrawingOrderInParent = other.mDrawingOrderInParent;
        this.mExtraDataKeys = other.mExtraDataKeys;
        Bundle bundle = this.mExtras = other.mExtras != null ? new Bundle(other.mExtras) : null;
        if (usePoolingInfos) {
            this.initPoolingInfos(other);
        } else {
            this.initCopyInfos(other);
        }
        TouchDelegateInfo otherInfo = other.mTouchDelegateInfo;
        this.mTouchDelegateInfo = otherInfo != null ? new TouchDelegateInfo(otherInfo.mTargetMap, true) : null;
        this.mLeashedChild = other.mLeashedChild;
        this.mLeashedParent = other.mLeashedParent;
        this.mLeashedParentNodeId = other.mLeashedParentNodeId;
    }

    private void initPoolingInfos(AccessibilityNodeInfo other) {
        if (this.mRangeInfo != null) {
            this.mRangeInfo.recycle();
        }
        RangeInfo rangeInfo = this.mRangeInfo = other.mRangeInfo != null ? RangeInfo.obtain(other.mRangeInfo) : null;
        if (this.mCollectionInfo != null) {
            this.mCollectionInfo.recycle();
        }
        CollectionInfo collectionInfo = this.mCollectionInfo = other.mCollectionInfo != null ? CollectionInfo.obtain(other.mCollectionInfo) : null;
        if (this.mCollectionItemInfo != null) {
            this.mCollectionItemInfo.recycle();
        }
        CollectionItemInfo collectionItemInfo = this.mCollectionItemInfo = other.mCollectionItemInfo != null ? CollectionItemInfo.obtain(other.mCollectionItemInfo) : null;
        if (this.mExtraRenderingInfo != null) {
            this.mExtraRenderingInfo.recycle();
        }
        this.mExtraRenderingInfo = other.mExtraRenderingInfo != null ? ExtraRenderingInfo.obtain(other.mExtraRenderingInfo) : null;
    }

    private void initCopyInfos(AccessibilityNodeInfo other) {
        RangeInfo ri = other.mRangeInfo;
        this.mRangeInfo = ri == null ? null : new RangeInfo(ri.mType, ri.mMin, ri.mMax, ri.mCurrent);
        CollectionInfo ci = other.mCollectionInfo;
        this.mCollectionInfo = ci == null ? null : new CollectionInfo(ci.mRowCount, ci.mColumnCount, ci.mHierarchical, ci.mSelectionMode);
        CollectionItemInfo cii = other.mCollectionItemInfo;
        this.mCollectionItemInfo = cii == null ? null : new CollectionItemInfo(cii.mRowIndex, cii.mRowSpan, cii.mColumnIndex, cii.mColumnSpan, cii.mHeading, cii.mSelected);
        ExtraRenderingInfo ti = other.mExtraRenderingInfo;
        this.mExtraRenderingInfo = ti == null ? null : new ExtraRenderingInfo(ti);
    }

    private void initFromParcel(Parcel parcel) {
        boolean sealed;
        long nonDefaultFields = parcel.readLong();
        int fieldIndex = 0;
        boolean bl = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? parcel.readInt() == 1 : (sealed = AccessibilityNodeInfo.DEFAULT.mSealed);
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mSourceNodeId = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mWindowId = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mParentNodeId = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLabelForId = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLabeledById = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTraversalBefore = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTraversalAfter = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mConnectionId = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            int childrenSize = parcel.readInt();
            if (childrenSize <= 0) {
                this.mChildNodeIds = null;
            } else {
                this.mChildNodeIds = new LongArray(childrenSize);
                for (int i = 0; i < childrenSize; ++i) {
                    long childId = parcel.readLong();
                    this.mChildNodeIds.add(childId);
                }
            }
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mBoundsInParent.top = parcel.readInt();
            this.mBoundsInParent.bottom = parcel.readInt();
            this.mBoundsInParent.left = parcel.readInt();
            this.mBoundsInParent.right = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mBoundsInScreen.top = parcel.readInt();
            this.mBoundsInScreen.bottom = parcel.readInt();
            this.mBoundsInScreen.left = parcel.readInt();
            this.mBoundsInScreen.right = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            long standardActions = parcel.readLong();
            this.addStandardActions(standardActions);
            int nonStandardActionCount = parcel.readInt();
            for (int i = 0; i < nonStandardActionCount; ++i) {
                AccessibilityAction action2 = AccessibilityAction.CREATOR.createFromParcel(parcel);
                this.addActionUnchecked(action2);
            }
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mMaxTextLength = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mMovementGranularities = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mBooleanProperties = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mPackageName = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mClassName = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mText = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mHintText = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mError = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mStateDescription = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mContentDescription = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mPaneTitle = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTooltipText = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mViewIdResourceName = parcel.readString();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTextSelectionStart = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTextSelectionEnd = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mInputType = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLiveRegion = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mDrawingOrderInParent = parcel.readInt();
        }
        this.mExtraDataKeys = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? parcel.createStringArrayList() : null;
        Bundle bundle = this.mExtras = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? parcel.readBundle() : null;
        if (this.mRangeInfo != null) {
            this.mRangeInfo.recycle();
        }
        RangeInfo rangeInfo = this.mRangeInfo = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? RangeInfo.obtain(parcel.readInt(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat()) : null;
        if (this.mCollectionInfo != null) {
            this.mCollectionInfo.recycle();
        }
        CollectionInfo collectionInfo = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? CollectionInfo.obtain(parcel.readInt(), parcel.readInt(), parcel.readInt() == 1, parcel.readInt()) : (this.mCollectionInfo = null);
        if (this.mCollectionItemInfo != null) {
            this.mCollectionItemInfo.recycle();
        }
        CollectionItemInfo collectionItemInfo = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? CollectionItemInfo.obtain(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt() == 1, parcel.readInt() == 1) : (this.mCollectionItemInfo = null);
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTouchDelegateInfo = TouchDelegateInfo.CREATOR.createFromParcel(parcel);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            if (this.mExtraRenderingInfo != null) {
                this.mExtraRenderingInfo.recycle();
            }
            this.mExtraRenderingInfo = ExtraRenderingInfo.obtain();
            this.mExtraRenderingInfo.mLayoutSize = (Size)parcel.readValue(null);
            this.mExtraRenderingInfo.mTextSizeInPx = parcel.readFloat();
            this.mExtraRenderingInfo.mTextSizeUnit = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLeashedChild = parcel.readStrongBinder();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLeashedParent = parcel.readStrongBinder();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLeashedParentNodeId = parcel.readLong();
        }
        this.mSealed = sealed;
    }

    private void clear() {
        this.init(DEFAULT, true);
    }

    private static boolean isDefaultStandardAction(AccessibilityAction action2) {
        return action2.mSerializationFlag != -1L && TextUtils.isEmpty(action2.getLabel());
    }

    private static AccessibilityAction getActionSingleton(int actionId) {
        int actions2 = AccessibilityAction.sStandardActions.size();
        for (int i = 0; i < actions2; ++i) {
            AccessibilityAction currentAction = AccessibilityAction.sStandardActions.valueAt(i);
            if (actionId != currentAction.getId()) continue;
            return currentAction;
        }
        return null;
    }

    private static AccessibilityAction getActionSingletonBySerializationFlag(long flag) {
        int actions2 = AccessibilityAction.sStandardActions.size();
        for (int i = 0; i < actions2; ++i) {
            AccessibilityAction currentAction = AccessibilityAction.sStandardActions.valueAt(i);
            if (flag != currentAction.mSerializationFlag) continue;
            return currentAction;
        }
        return null;
    }

    private void addStandardActions(long serializationIdMask) {
        long id2;
        for (long remainingIds = serializationIdMask; remainingIds > 0L; remainingIds &= id2 ^ 0xFFFFFFFFFFFFFFFFL) {
            id2 = 1L << Long.numberOfTrailingZeros(remainingIds);
            AccessibilityAction action2 = AccessibilityNodeInfo.getActionSingletonBySerializationFlag(id2);
            this.addAction(action2);
        }
    }

    private static String getActionSymbolicName(int action2) {
        switch (action2) {
            case 1: {
                return "ACTION_FOCUS";
            }
            case 2: {
                return "ACTION_CLEAR_FOCUS";
            }
            case 4: {
                return "ACTION_SELECT";
            }
            case 8: {
                return "ACTION_CLEAR_SELECTION";
            }
            case 16: {
                return "ACTION_CLICK";
            }
            case 32: {
                return "ACTION_LONG_CLICK";
            }
            case 64: {
                return "ACTION_ACCESSIBILITY_FOCUS";
            }
            case 128: {
                return "ACTION_CLEAR_ACCESSIBILITY_FOCUS";
            }
            case 256: {
                return "ACTION_NEXT_AT_MOVEMENT_GRANULARITY";
            }
            case 512: {
                return "ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY";
            }
            case 1024: {
                return "ACTION_NEXT_HTML_ELEMENT";
            }
            case 2048: {
                return "ACTION_PREVIOUS_HTML_ELEMENT";
            }
            case 4096: {
                return "ACTION_SCROLL_FORWARD";
            }
            case 8192: {
                return "ACTION_SCROLL_BACKWARD";
            }
            case 65536: {
                return "ACTION_CUT";
            }
            case 16384: {
                return "ACTION_COPY";
            }
            case 32768: {
                return "ACTION_PASTE";
            }
            case 131072: {
                return "ACTION_SET_SELECTION";
            }
            case 262144: {
                return "ACTION_EXPAND";
            }
            case 524288: {
                return "ACTION_COLLAPSE";
            }
            case 0x100000: {
                return "ACTION_DISMISS";
            }
            case 0x200000: {
                return "ACTION_SET_TEXT";
            }
            case 16908342: {
                return "ACTION_SHOW_ON_SCREEN";
            }
            case 16908343: {
                return "ACTION_SCROLL_TO_POSITION";
            }
            case 16908344: {
                return "ACTION_SCROLL_UP";
            }
            case 16908345: {
                return "ACTION_SCROLL_LEFT";
            }
            case 16908346: {
                return "ACTION_SCROLL_DOWN";
            }
            case 16908347: {
                return "ACTION_SCROLL_RIGHT";
            }
            case 16908359: {
                return "ACTION_PAGE_DOWN";
            }
            case 16908358: {
                return "ACTION_PAGE_UP";
            }
            case 16908360: {
                return "ACTION_PAGE_LEFT";
            }
            case 16908361: {
                return "ACTION_PAGE_RIGHT";
            }
            case 16908349: {
                return "ACTION_SET_PROGRESS";
            }
            case 16908348: {
                return "ACTION_CONTEXT_CLICK";
            }
            case 16908356: {
                return "ACTION_SHOW_TOOLTIP";
            }
            case 16908357: {
                return "ACTION_HIDE_TOOLTIP";
            }
            case 16908362: {
                return "ACTION_PRESS_AND_HOLD";
            }
            case 16908372: {
                return "ACTION_IME_ENTER";
            }
        }
        return "ACTION_UNKNOWN";
    }

    private static String getMovementGranularitySymbolicName(int granularity) {
        switch (granularity) {
            case 1: {
                return "MOVEMENT_GRANULARITY_CHARACTER";
            }
            case 2: {
                return "MOVEMENT_GRANULARITY_WORD";
            }
            case 4: {
                return "MOVEMENT_GRANULARITY_LINE";
            }
            case 8: {
                return "MOVEMENT_GRANULARITY_PARAGRAPH";
            }
            case 16: {
                return "MOVEMENT_GRANULARITY_PAGE";
            }
        }
        throw new IllegalArgumentException("Unknown movement granularity: " + granularity);
    }

    private static boolean canPerformRequestOverConnection(int connectionId, int windowId, long accessibilityNodeId) {
        return windowId != -1 && AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId) != Integer.MAX_VALUE && connectionId != -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AccessibilityNodeInfo other = (AccessibilityNodeInfo)object;
        if (this.mSourceNodeId != other.mSourceNodeId) {
            return false;
        }
        return this.mWindowId == other.mWindowId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + AccessibilityNodeInfo.getAccessibilityViewId(this.mSourceNodeId);
        result = 31 * result + AccessibilityNodeInfo.getVirtualDescendantId(this.mSourceNodeId);
        result = 31 * result + this.mWindowId;
        return result;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(super.toString());
        if (DEBUG) {
            builder2.append("; sourceNodeId: 0x").append(Long.toHexString(this.mSourceNodeId));
            builder2.append("; windowId: 0x").append(Long.toHexString(this.mWindowId));
            builder2.append("; accessibilityViewId: 0x").append(Long.toHexString(AccessibilityNodeInfo.getAccessibilityViewId(this.mSourceNodeId)));
            builder2.append("; virtualDescendantId: 0x").append(Long.toHexString(AccessibilityNodeInfo.getVirtualDescendantId(this.mSourceNodeId)));
            builder2.append("; mParentNodeId: 0x").append(Long.toHexString(this.mParentNodeId));
            builder2.append("; traversalBefore: 0x").append(Long.toHexString(this.mTraversalBefore));
            builder2.append("; traversalAfter: 0x").append(Long.toHexString(this.mTraversalAfter));
            int granularities = this.mMovementGranularities;
            builder2.append("; MovementGranularities: [");
            while (granularities != 0) {
                int granularity = 1 << Integer.numberOfTrailingZeros(granularities);
                builder2.append(AccessibilityNodeInfo.getMovementGranularitySymbolicName(granularity));
                if ((granularities &= ~granularity) == 0) continue;
                builder2.append(", ");
            }
            builder2.append("]");
            builder2.append("; childAccessibilityIds: [");
            LongArray childIds = this.mChildNodeIds;
            if (childIds != null) {
                int count = childIds.size();
                for (int i = 0; i < count; ++i) {
                    builder2.append("0x").append(Long.toHexString(childIds.get(i)));
                    if (i >= count - 1) continue;
                    builder2.append(", ");
                }
            }
            builder2.append("]");
        }
        builder2.append("; boundsInParent: ").append(this.mBoundsInParent);
        builder2.append("; boundsInScreen: ").append(this.mBoundsInScreen);
        builder2.append("; packageName: ").append(this.mPackageName);
        builder2.append("; className: ").append(this.mClassName);
        builder2.append("; text: ").append(this.mText);
        builder2.append("; error: ").append(this.mError);
        builder2.append("; maxTextLength: ").append(this.mMaxTextLength);
        builder2.append("; stateDescription: ").append(this.mStateDescription);
        builder2.append("; contentDescription: ").append(this.mContentDescription);
        builder2.append("; tooltipText: ").append(this.mTooltipText);
        builder2.append("; viewIdResName: ").append(this.mViewIdResourceName);
        builder2.append("; checkable: ").append(this.isCheckable());
        builder2.append("; checked: ").append(this.isChecked());
        builder2.append("; focusable: ").append(this.isFocusable());
        builder2.append("; focused: ").append(this.isFocused());
        builder2.append("; selected: ").append(this.isSelected());
        builder2.append("; clickable: ").append(this.isClickable());
        builder2.append("; longClickable: ").append(this.isLongClickable());
        builder2.append("; contextClickable: ").append(this.isContextClickable());
        builder2.append("; enabled: ").append(this.isEnabled());
        builder2.append("; password: ").append(this.isPassword());
        builder2.append("; scrollable: ").append(this.isScrollable());
        builder2.append("; importantForAccessibility: ").append(this.isImportantForAccessibility());
        builder2.append("; visible: ").append(this.isVisibleToUser());
        builder2.append("; actions: ").append(this.mActions);
        return builder2.toString();
    }

    private static AccessibilityNodeInfo getNodeForAccessibilityId(int connectionId, int windowId, long accessibilityId) {
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(connectionId, windowId, accessibilityId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(connectionId, windowId, accessibilityId, false, 7, null);
    }

    private static AccessibilityNodeInfo getNodeForAccessibilityId(int connectionId, IBinder leashToken, long accessibilityId) {
        if (leashToken == null || AccessibilityNodeInfo.getAccessibilityViewId(accessibilityId) == Integer.MAX_VALUE || connectionId == -1) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(connectionId, leashToken, accessibilityId, false, 7, null);
    }

    public static String idToString(long accessibilityId) {
        int accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityId);
        int virtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityId);
        return virtualDescendantId == -1 ? AccessibilityNodeInfo.idItemToString(accessibilityViewId) : AccessibilityNodeInfo.idItemToString(accessibilityViewId) + ":" + AccessibilityNodeInfo.idItemToString(virtualDescendantId);
    }

    private static String idItemToString(int item) {
        switch (item) {
            case 0x7FFFFFFE: {
                return "ROOT";
            }
            case 0x7FFFFFFF: {
                return "UNDEFINED";
            }
            case -1: {
                return "HOST";
            }
        }
        return "" + item;
    }

    static {
        sPool = new Pools.SynchronizedPool(50);
        DEFAULT = new AccessibilityNodeInfo();
        CREATOR = new Parcelable.Creator<AccessibilityNodeInfo>(){

            @Override
            public AccessibilityNodeInfo createFromParcel(Parcel parcel) {
                AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
                info.initFromParcel(parcel);
                return info;
            }

            public AccessibilityNodeInfo[] newArray(int size) {
                return new AccessibilityNodeInfo[size];
            }
        };
    }

    public static class ExtraRenderingInfo {
        private static final int UNDEFINED_VALUE = -1;
        private static final int MAX_POOL_SIZE = 20;
        private static final Pools.SynchronizedPool<ExtraRenderingInfo> sPool = new Pools.SynchronizedPool(20);
        private Size mLayoutSize;
        private float mTextSizeInPx = -1.0f;
        private int mTextSizeUnit = -1;

        public static ExtraRenderingInfo obtain() {
            ExtraRenderingInfo info = sPool.acquire();
            if (info == null) {
                return new ExtraRenderingInfo(null);
            }
            return info;
        }

        private static ExtraRenderingInfo obtain(ExtraRenderingInfo other) {
            ExtraRenderingInfo extraRenderingInfo = ExtraRenderingInfo.obtain();
            extraRenderingInfo.mLayoutSize = other.mLayoutSize;
            extraRenderingInfo.mTextSizeInPx = other.mTextSizeInPx;
            extraRenderingInfo.mTextSizeUnit = other.mTextSizeUnit;
            return extraRenderingInfo;
        }

        private ExtraRenderingInfo(ExtraRenderingInfo other) {
            if (other != null) {
                this.mLayoutSize = other.mLayoutSize;
                this.mTextSizeInPx = other.mTextSizeInPx;
                this.mTextSizeUnit = other.mTextSizeUnit;
            }
        }

        public Size getLayoutSize() {
            return this.mLayoutSize;
        }

        public void setLayoutSize(int width, int height) {
            this.mLayoutSize = new Size(width, height);
        }

        public float getTextSizeInPx() {
            return this.mTextSizeInPx;
        }

        public void setTextSizeInPx(float textSizeInPx) {
            this.mTextSizeInPx = textSizeInPx;
        }

        public int getTextSizeUnit() {
            return this.mTextSizeUnit;
        }

        public void setTextSizeUnit(int textSizeUnit) {
            this.mTextSizeUnit = textSizeUnit;
        }

        void recycle() {
            this.clear();
            sPool.release(this);
        }

        private void clear() {
            this.mLayoutSize = null;
            this.mTextSizeInPx = -1.0f;
            this.mTextSizeUnit = -1;
        }
    }

    public static class TouchDelegateInfo
    implements Parcelable {
        private ArrayMap<Region, Long> mTargetMap;
        private int mConnectionId;
        private int mWindowId;
        public static final Parcelable.Creator<TouchDelegateInfo> CREATOR = new Parcelable.Creator<TouchDelegateInfo>(){

            @Override
            public TouchDelegateInfo createFromParcel(Parcel parcel) {
                int size = parcel.readInt();
                if (size == 0) {
                    return null;
                }
                ArrayMap<Region, Long> targetMap = new ArrayMap<Region, Long>(size);
                for (int i = 0; i < size; ++i) {
                    Region region = Region.CREATOR.createFromParcel(parcel);
                    long accessibilityId = parcel.readLong();
                    targetMap.put(region, accessibilityId);
                }
                TouchDelegateInfo touchDelegateInfo = new TouchDelegateInfo(targetMap, false);
                return touchDelegateInfo;
            }

            public TouchDelegateInfo[] newArray(int size) {
                return new TouchDelegateInfo[size];
            }
        };

        public TouchDelegateInfo(Map<Region, View> targetMap) {
            Preconditions.checkArgument(!targetMap.isEmpty() && !targetMap.containsKey(null) && !targetMap.containsValue(null));
            this.mTargetMap = new ArrayMap(targetMap.size());
            for (Region region : targetMap.keySet()) {
                View view = targetMap.get(region);
                this.mTargetMap.put(region, Long.valueOf(view.getAccessibilityViewId()));
            }
        }

        TouchDelegateInfo(ArrayMap<Region, Long> targetMap, boolean doCopy) {
            Preconditions.checkArgument(!targetMap.isEmpty() && !targetMap.containsKey(null) && !targetMap.containsValue(null));
            if (doCopy) {
                this.mTargetMap = new ArrayMap(targetMap.size());
                this.mTargetMap.putAll(targetMap);
            } else {
                this.mTargetMap = targetMap;
            }
        }

        private void setConnectionId(int connectionId) {
            this.mConnectionId = connectionId;
        }

        private void setWindowId(int windowId) {
            this.mWindowId = windowId;
        }

        public int getRegionCount() {
            return this.mTargetMap.size();
        }

        public Region getRegionAt(int index) {
            return this.mTargetMap.keyAt(index);
        }

        public AccessibilityNodeInfo getTargetForRegion(Region region) {
            return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mTargetMap.get(region));
        }

        public long getAccessibilityIdForRegion(Region region) {
            return this.mTargetMap.get(region);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mTargetMap.size());
            for (int i = 0; i < this.mTargetMap.size(); ++i) {
                Region region = this.mTargetMap.keyAt(i);
                Long accessibilityId = this.mTargetMap.valueAt(i);
                region.writeToParcel(dest, flags);
                dest.writeLong(accessibilityId);
            }
        }
    }

    public static class CollectionItemInfo {
        private static final int MAX_POOL_SIZE = 20;
        private static final Pools.SynchronizedPool<CollectionItemInfo> sPool = new Pools.SynchronizedPool(20);
        private boolean mHeading;
        private int mColumnIndex;
        private int mRowIndex;
        private int mColumnSpan;
        private int mRowSpan;
        private boolean mSelected;

        public static CollectionItemInfo obtain(CollectionItemInfo other) {
            return CollectionItemInfo.obtain(other.mRowIndex, other.mRowSpan, other.mColumnIndex, other.mColumnSpan, other.mHeading, other.mSelected);
        }

        public static CollectionItemInfo obtain(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading) {
            return CollectionItemInfo.obtain(rowIndex, rowSpan, columnIndex, columnSpan, heading, false);
        }

        public static CollectionItemInfo obtain(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            CollectionItemInfo info = sPool.acquire();
            if (info == null) {
                return new CollectionItemInfo(rowIndex, rowSpan, columnIndex, columnSpan, heading, selected);
            }
            info.mRowIndex = rowIndex;
            info.mRowSpan = rowSpan;
            info.mColumnIndex = columnIndex;
            info.mColumnSpan = columnSpan;
            info.mHeading = heading;
            info.mSelected = selected;
            return info;
        }

        public CollectionItemInfo(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading) {
            this(rowIndex, rowSpan, columnIndex, columnSpan, heading, false);
        }

        public CollectionItemInfo(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            this.mRowIndex = rowIndex;
            this.mRowSpan = rowSpan;
            this.mColumnIndex = columnIndex;
            this.mColumnSpan = columnSpan;
            this.mHeading = heading;
            this.mSelected = selected;
        }

        public int getColumnIndex() {
            return this.mColumnIndex;
        }

        public int getRowIndex() {
            return this.mRowIndex;
        }

        public int getColumnSpan() {
            return this.mColumnSpan;
        }

        public int getRowSpan() {
            return this.mRowSpan;
        }

        public boolean isHeading() {
            return this.mHeading;
        }

        public boolean isSelected() {
            return this.mSelected;
        }

        void recycle() {
            this.clear();
            sPool.release(this);
        }

        private void clear() {
            this.mColumnIndex = 0;
            this.mColumnSpan = 0;
            this.mRowIndex = 0;
            this.mRowSpan = 0;
            this.mHeading = false;
            this.mSelected = false;
        }
    }

    public static class CollectionInfo {
        public static final int SELECTION_MODE_NONE = 0;
        public static final int SELECTION_MODE_SINGLE = 1;
        public static final int SELECTION_MODE_MULTIPLE = 2;
        private static final int MAX_POOL_SIZE = 20;
        private static final Pools.SynchronizedPool<CollectionInfo> sPool = new Pools.SynchronizedPool(20);
        private int mRowCount;
        private int mColumnCount;
        private boolean mHierarchical;
        private int mSelectionMode;

        public static CollectionInfo obtain(CollectionInfo other) {
            return CollectionInfo.obtain(other.mRowCount, other.mColumnCount, other.mHierarchical, other.mSelectionMode);
        }

        public static CollectionInfo obtain(int rowCount, int columnCount, boolean hierarchical) {
            return CollectionInfo.obtain(rowCount, columnCount, hierarchical, 0);
        }

        public static CollectionInfo obtain(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            CollectionInfo info = sPool.acquire();
            if (info == null) {
                return new CollectionInfo(rowCount, columnCount, hierarchical, selectionMode);
            }
            info.mRowCount = rowCount;
            info.mColumnCount = columnCount;
            info.mHierarchical = hierarchical;
            info.mSelectionMode = selectionMode;
            return info;
        }

        public CollectionInfo(int rowCount, int columnCount, boolean hierarchical) {
            this(rowCount, columnCount, hierarchical, 0);
        }

        public CollectionInfo(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            this.mRowCount = rowCount;
            this.mColumnCount = columnCount;
            this.mHierarchical = hierarchical;
            this.mSelectionMode = selectionMode;
        }

        public int getRowCount() {
            return this.mRowCount;
        }

        public int getColumnCount() {
            return this.mColumnCount;
        }

        public boolean isHierarchical() {
            return this.mHierarchical;
        }

        public int getSelectionMode() {
            return this.mSelectionMode;
        }

        void recycle() {
            this.clear();
            sPool.release(this);
        }

        private void clear() {
            this.mRowCount = 0;
            this.mColumnCount = 0;
            this.mHierarchical = false;
            this.mSelectionMode = 0;
        }
    }

    public static class RangeInfo {
        private static final int MAX_POOL_SIZE = 10;
        public static final int RANGE_TYPE_INT = 0;
        public static final int RANGE_TYPE_FLOAT = 1;
        public static final int RANGE_TYPE_PERCENT = 2;
        private static final Pools.SynchronizedPool<RangeInfo> sPool = new Pools.SynchronizedPool(10);
        private int mType;
        private float mMin;
        private float mMax;
        private float mCurrent;

        public static RangeInfo obtain(RangeInfo other) {
            return RangeInfo.obtain(other.mType, other.mMin, other.mMax, other.mCurrent);
        }

        public static RangeInfo obtain(int type, float min, float max, float current) {
            RangeInfo info = sPool.acquire();
            if (info == null) {
                return new RangeInfo(type, min, max, current);
            }
            info.mType = type;
            info.mMin = min;
            info.mMax = max;
            info.mCurrent = current;
            return info;
        }

        public RangeInfo(int type, float min, float max, float current) {
            this.mType = type;
            this.mMin = min;
            this.mMax = max;
            this.mCurrent = current;
        }

        public int getType() {
            return this.mType;
        }

        public float getMin() {
            return this.mMin;
        }

        public float getMax() {
            return this.mMax;
        }

        public float getCurrent() {
            return this.mCurrent;
        }

        void recycle() {
            this.clear();
            sPool.release(this);
        }

        private void clear() {
            this.mType = 0;
            this.mMin = 0.0f;
            this.mMax = 0.0f;
            this.mCurrent = 0.0f;
        }
    }

    public static class AccessibilityAction
    implements Parcelable {
        public static final ArraySet<AccessibilityAction> sStandardActions = new ArraySet();
        public static final AccessibilityAction ACTION_FOCUS = new AccessibilityAction(1);
        public static final AccessibilityAction ACTION_CLEAR_FOCUS = new AccessibilityAction(2);
        public static final AccessibilityAction ACTION_SELECT = new AccessibilityAction(4);
        public static final AccessibilityAction ACTION_CLEAR_SELECTION = new AccessibilityAction(8);
        public static final AccessibilityAction ACTION_CLICK = new AccessibilityAction(16);
        public static final AccessibilityAction ACTION_LONG_CLICK = new AccessibilityAction(32);
        public static final AccessibilityAction ACTION_ACCESSIBILITY_FOCUS = new AccessibilityAction(64);
        public static final AccessibilityAction ACTION_CLEAR_ACCESSIBILITY_FOCUS = new AccessibilityAction(128);
        public static final AccessibilityAction ACTION_NEXT_AT_MOVEMENT_GRANULARITY = new AccessibilityAction(256);
        public static final AccessibilityAction ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = new AccessibilityAction(512);
        public static final AccessibilityAction ACTION_NEXT_HTML_ELEMENT = new AccessibilityAction(1024);
        public static final AccessibilityAction ACTION_PREVIOUS_HTML_ELEMENT = new AccessibilityAction(2048);
        public static final AccessibilityAction ACTION_SCROLL_FORWARD = new AccessibilityAction(4096);
        public static final AccessibilityAction ACTION_SCROLL_BACKWARD = new AccessibilityAction(8192);
        public static final AccessibilityAction ACTION_COPY = new AccessibilityAction(16384);
        public static final AccessibilityAction ACTION_PASTE = new AccessibilityAction(32768);
        public static final AccessibilityAction ACTION_CUT = new AccessibilityAction(65536);
        public static final AccessibilityAction ACTION_SET_SELECTION = new AccessibilityAction(131072);
        public static final AccessibilityAction ACTION_EXPAND = new AccessibilityAction(262144);
        public static final AccessibilityAction ACTION_COLLAPSE = new AccessibilityAction(524288);
        public static final AccessibilityAction ACTION_DISMISS = new AccessibilityAction(0x100000);
        public static final AccessibilityAction ACTION_SET_TEXT = new AccessibilityAction(0x200000);
        public static final AccessibilityAction ACTION_SHOW_ON_SCREEN = new AccessibilityAction(16908342);
        public static final AccessibilityAction ACTION_SCROLL_TO_POSITION = new AccessibilityAction(16908343);
        public static final AccessibilityAction ACTION_SCROLL_UP = new AccessibilityAction(16908344);
        public static final AccessibilityAction ACTION_SCROLL_LEFT = new AccessibilityAction(16908345);
        public static final AccessibilityAction ACTION_SCROLL_DOWN = new AccessibilityAction(16908346);
        public static final AccessibilityAction ACTION_SCROLL_RIGHT = new AccessibilityAction(16908347);
        public static final AccessibilityAction ACTION_PAGE_UP = new AccessibilityAction(16908358);
        public static final AccessibilityAction ACTION_PAGE_DOWN = new AccessibilityAction(16908359);
        public static final AccessibilityAction ACTION_PAGE_LEFT = new AccessibilityAction(16908360);
        public static final AccessibilityAction ACTION_PAGE_RIGHT = new AccessibilityAction(16908361);
        public static final AccessibilityAction ACTION_CONTEXT_CLICK = new AccessibilityAction(16908348);
        public static final AccessibilityAction ACTION_SET_PROGRESS = new AccessibilityAction(16908349);
        public static final AccessibilityAction ACTION_MOVE_WINDOW = new AccessibilityAction(16908354);
        public static final AccessibilityAction ACTION_SHOW_TOOLTIP = new AccessibilityAction(16908356);
        public static final AccessibilityAction ACTION_HIDE_TOOLTIP = new AccessibilityAction(16908357);
        public static final AccessibilityAction ACTION_PRESS_AND_HOLD = new AccessibilityAction(16908362);
        public static final AccessibilityAction ACTION_IME_ENTER = new AccessibilityAction(16908372);
        private final int mActionId;
        private final CharSequence mLabel;
        public long mSerializationFlag = -1L;
        public static final Parcelable.Creator<AccessibilityAction> CREATOR = new Parcelable.Creator<AccessibilityAction>(){

            @Override
            public AccessibilityAction createFromParcel(Parcel in) {
                return new AccessibilityAction(in);
            }

            public AccessibilityAction[] newArray(int size) {
                return new AccessibilityAction[size];
            }
        };

        public AccessibilityAction(int actionId, CharSequence label) {
            this.mActionId = actionId;
            this.mLabel = label;
        }

        private AccessibilityAction(int standardActionId) {
            this(standardActionId, null);
            this.mSerializationFlag = BitUtils.bitAt(sStandardActions.size());
            sStandardActions.add(this);
        }

        public int getId() {
            return this.mActionId;
        }

        public CharSequence getLabel() {
            return this.mLabel;
        }

        public int hashCode() {
            return this.mActionId;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            return this.mActionId == ((AccessibilityAction)other).mActionId;
        }

        public String toString() {
            return "AccessibilityAction: " + AccessibilityNodeInfo.getActionSymbolicName(this.mActionId) + " - " + this.mLabel;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mActionId);
            out.writeCharSequence(this.mLabel);
        }

        private AccessibilityAction(Parcel in) {
            this.mActionId = in.readInt();
            this.mLabel = in.readCharSequence();
        }
    }
}

