/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ResourcesManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.CrossWindowBlurListeners;
import android.view.Display;
import android.view.InsetsState;
import android.view.KeyboardShortcutGroup;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowMetrics;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class _Original_WindowManagerImpl
implements WindowManager {
    @UnsupportedAppUsage
    private final WindowManagerGlobal mGlobal = WindowManagerGlobal.getInstance();
    @VisibleForTesting
    public final Context mContext;
    private final Window mParentWindow;
    private IBinder mDefaultToken;
    private final IBinder mWindowContextToken;

    public _Original_WindowManagerImpl(Context context) {
        this(context, null, null);
    }

    private _Original_WindowManagerImpl(Context context, Window parentWindow, IBinder windowContextToken) {
        this.mContext = context;
        this.mParentWindow = parentWindow;
        this.mWindowContextToken = windowContextToken;
    }

    public _Original_WindowManagerImpl createLocalWindowManager(Window parentWindow) {
        return new _Original_WindowManagerImpl(this.mContext, parentWindow, this.mWindowContextToken);
    }

    public _Original_WindowManagerImpl createPresentationWindowManager(Context displayContext) {
        return new _Original_WindowManagerImpl(displayContext, this.mParentWindow, this.mWindowContextToken);
    }

    public static WindowManager createWindowContextWindowManager(Context context) {
        IBinder clientToken = context.getWindowContextToken();
        return new _Original_WindowManagerImpl(context, null, clientToken);
    }

    public void setDefaultToken(IBinder token) {
        this.mDefaultToken = token;
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams params) {
        this.applyTokens(params);
        this.mGlobal.addView(view, params, this.mContext.getDisplayNoVerify(), this.mParentWindow, this.mContext.getUserId());
    }

    @Override
    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        this.applyTokens(params);
        this.mGlobal.updateViewLayout(view, params);
    }

    private void applyTokens(ViewGroup.LayoutParams params) {
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        if (this.mDefaultToken != null && this.mParentWindow == null && wparams.token == null) {
            wparams.token = this.mDefaultToken;
        }
        wparams.mWindowContextToken = this.mWindowContextToken;
    }

    @Override
    public void removeView(View view) {
        this.mGlobal.removeView(view, false);
    }

    @Override
    public void removeViewImmediate(View view) {
        this.mGlobal.removeView(view, true);
    }

    @Override
    public void requestAppKeyboardShortcuts(final WindowManager.KeyboardShortcutsReceiver receiver, int deviceId) {
        IResultReceiver.Stub resultReceiver = new IResultReceiver.Stub(){

            @Override
            public void send(int resultCode, Bundle resultData) throws RemoteException {
                ArrayList<KeyboardShortcutGroup> result = resultData.getParcelableArrayList("shortcuts_array");
                receiver.onKeyboardShortcutsReceived(result);
            }
        };
        try {
            WindowManagerGlobal.getWindowManagerService().requestAppKeyboardShortcuts(resultReceiver, deviceId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public Display getDefaultDisplay() {
        return this.mContext.getDisplayNoVerify();
    }

    @Override
    public Region getCurrentImeTouchRegion() {
        try {
            return WindowManagerGlobal.getWindowManagerService().getCurrentImeTouchRegion();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) {
        try {
            WindowManagerGlobal.getWindowManagerService().setShouldShowWithInsecureKeyguard(displayId, shouldShow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setShouldShowSystemDecors(int displayId, boolean shouldShow) {
        try {
            WindowManagerGlobal.getWindowManagerService().setShouldShowSystemDecors(displayId, shouldShow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public boolean shouldShowSystemDecors(int displayId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().shouldShowSystemDecors(displayId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public void setDisplayImePolicy(int displayId, @WindowManager.DisplayImePolicy int imePolicy) {
        try {
            WindowManagerGlobal.getWindowManagerService().setDisplayImePolicy(displayId, imePolicy);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    @WindowManager.DisplayImePolicy
    public int getDisplayImePolicy(int displayId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().getDisplayImePolicy(displayId);
        }
        catch (RemoteException remoteException) {
            return 1;
        }
    }

    @Override
    public WindowMetrics getCurrentWindowMetrics() {
        Context context = this.mParentWindow != null ? this.mParentWindow.getContext() : this.mContext;
        Rect bounds2 = _Original_WindowManagerImpl.getCurrentBounds(context);
        return new WindowMetrics(bounds2, this.computeWindowInsets(bounds2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rect getCurrentBounds(Context context) {
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        synchronized (resourcesManager) {
            return context.getResources().getConfiguration().windowConfiguration.getBounds();
        }
    }

    @Override
    public WindowMetrics getMaximumWindowMetrics() {
        Context context = this.mParentWindow != null ? this.mParentWindow.getContext() : this.mContext;
        Rect maxBounds = _Original_WindowManagerImpl.getMaximumBounds(context);
        return new WindowMetrics(maxBounds, this.computeWindowInsets(maxBounds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rect getMaximumBounds(Context context) {
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        synchronized (resourcesManager) {
            return context.getResources().getConfiguration().windowConfiguration.getMaxBounds();
        }
    }

    private WindowInsets computeWindowInsets(Rect bounds2) {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.flags = 65792;
        Context context = this.mParentWindow != null ? this.mParentWindow.getContext() : this.mContext;
        params.token = Context.getToken(context);
        params.systemUiVisibility = 1536;
        params.setFitInsetsTypes(0);
        params.setFitInsetsSides(0);
        return this.getWindowInsetsFromServer(params, bounds2);
    }

    private WindowInsets getWindowInsetsFromServer(WindowManager.LayoutParams attrs, Rect bounds2) {
        try {
            InsetsState insetsState = new InsetsState();
            boolean alwaysConsumeSystemBars = WindowManagerGlobal.getWindowManagerService().getWindowInsets(attrs, this.mContext.getDisplayId(), insetsState);
            Configuration config = this.mContext.getResources().getConfiguration();
            boolean isScreenRound = config.isScreenRound();
            int windowingMode = config.windowConfiguration.getWindowingMode();
            return insetsState.calculateInsets(bounds2, null, isScreenRound, alwaysConsumeSystemBars, 48, attrs.flags, 0, attrs.type, windowingMode, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void holdLock(IBinder token, int durationMs) {
        try {
            WindowManagerGlobal.getWindowManagerService().holdLock(token, durationMs);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isCrossWindowBlurEnabled() {
        return CrossWindowBlurListeners.getInstance().isCrossWindowBlurEnabled();
    }

    @Override
    public void addCrossWindowBlurEnabledListener(Consumer<Boolean> listener2) {
        this.addCrossWindowBlurEnabledListener(this.mContext.getMainExecutor(), listener2);
    }

    @Override
    public void addCrossWindowBlurEnabledListener(Executor executor, Consumer<Boolean> listener2) {
        CrossWindowBlurListeners.getInstance().addListener(executor, listener2);
    }

    @Override
    public void removeCrossWindowBlurEnabledListener(Consumer<Boolean> listener2) {
        CrossWindowBlurListeners.getInstance().removeListener(listener2);
    }

    @Override
    public boolean isTaskSnapshotSupported() {
        try {
            return WindowManagerGlobal.getWindowManagerService().isTaskSnapshotSupported();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }
}

