/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ResourcesManager;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import android.view.InsetsState;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowMetrics;
import android.widget.FrameLayout;
import com.android.layoutlib.bridge.Bridge;

public class WindowManagerImpl
implements WindowManager {
    private final Context mContext;
    private final DisplayMetrics mMetrics;
    private final Display mDisplay;
    private ViewGroup mBaseRootView;
    private ViewGroup mCurrentRootView;

    public WindowManagerImpl(Context context, DisplayMetrics metrics) {
        this.mContext = context;
        this.mMetrics = metrics;
        DisplayInfo info = new DisplayInfo();
        info.logicalHeight = this.mMetrics.heightPixels;
        info.logicalWidth = this.mMetrics.widthPixels;
        info.supportedModes = new Display.Mode[]{new Display.Mode(0, this.mMetrics.widthPixels, this.mMetrics.heightPixels, 60.0f)};
        info.logicalDensityDpi = this.mMetrics.densityDpi;
        this.mDisplay = new Display(null, 0, info, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    public WindowManagerImpl createLocalWindowManager(Window parentWindow) {
        return this;
    }

    public WindowManagerImpl createPresentationWindowManager(Context displayContext) {
        Bridge.getLog().fidelityWarning("unsupported", "The preview does not fully support multiple windows.", null, null, null);
        return this;
    }

    public void setDefaultToken(IBinder token) {
    }

    @Override
    public Display getDefaultDisplay() {
        return this.mDisplay;
    }

    @Override
    public void addView(View arg0, ViewGroup.LayoutParams arg1) {
        if (this.mBaseRootView == null) {
            return;
        }
        if (this.mCurrentRootView == null) {
            FrameLayout layout2 = new FrameLayout(this.mContext){

                @Override
                public boolean dispatchTouchEvent(MotionEvent ev) {
                    View baseRootParent = (View)((Object)WindowManagerImpl.this.mBaseRootView.getParent());
                    if (baseRootParent != null) {
                        ev.offsetLocation(-baseRootParent.getX(), -baseRootParent.getY());
                    }
                    return super.dispatchTouchEvent(ev);
                }

                @Override
                protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
                    int baseSize;
                    ViewGroup.LayoutParams lp = child.getLayoutParams();
                    int parentWidth = View.MeasureSpec.getSize(parentWidthMeasureSpec);
                    int parentHeight = View.MeasureSpec.getSize(parentHeightMeasureSpec);
                    int childWidthMeasureSpec = 0;
                    int childHeightMeasureSpec = ViewRootImpl.getRootMeasureSpec(parentHeight, lp.height);
                    if (lp.width == -2 && (baseSize = this.mContext.getResources().getDimensionPixelSize(17105092)) != 0 && baseSize < parentWidth) {
                        childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(baseSize, lp.width);
                    }
                    if (childWidthMeasureSpec == 0) {
                        childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(parentWidth, lp.width);
                    }
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
            };
            layout2.setOnTouchListener((v, event) -> {
                event.offsetLocation(-arg0.getX(), -arg0.getY());
                return arg0.dispatchTouchEvent(event);
            });
            this.mBaseRootView.addView((View)layout2, new FrameLayout.LayoutParams(-1, -1));
            this.mCurrentRootView = layout2;
        }
        FrameLayout.LayoutParams frameLayoutParams = new FrameLayout.LayoutParams(arg1);
        if (arg1 instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams params = (WindowManager.LayoutParams)arg1;
            frameLayoutParams.gravity = params.gravity;
            if ((params.flags & 2) != 0) {
                this.mCurrentRootView.setBackgroundColor(Color.argb(params.dimAmount, 0.0f, 0.0f, 0.0f));
            }
        }
        this.mCurrentRootView.addView(arg0, frameLayoutParams);
    }

    @Override
    public void removeView(View arg0) {
        if (this.mCurrentRootView != null) {
            this.mCurrentRootView.removeView(arg0);
            if (this.mBaseRootView != null && this.mCurrentRootView.getChildCount() == 0) {
                this.mBaseRootView.removeView(this.mCurrentRootView);
                this.mCurrentRootView = null;
            }
        }
    }

    @Override
    public void updateViewLayout(View arg0, ViewGroup.LayoutParams arg1) {
    }

    @Override
    public void removeViewImmediate(View arg0) {
        this.removeView(arg0);
    }

    @Override
    public void requestAppKeyboardShortcuts(WindowManager.KeyboardShortcutsReceiver receiver, int deviceId) {
    }

    @Override
    public Region getCurrentImeTouchRegion() {
        return null;
    }

    @Override
    public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) {
    }

    @Override
    public void setShouldShowSystemDecors(int displayId, boolean shouldShow) {
    }

    @Override
    public void setDisplayImePolicy(int displayId, int imePolicy) {
    }

    @Override
    public WindowMetrics getCurrentWindowMetrics() {
        Rect bound = WindowManagerImpl.getCurrentBounds(this.mContext);
        return new WindowMetrics(bound, this.computeWindowInsets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rect getCurrentBounds(Context context) {
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        synchronized (resourcesManager) {
            return context.getResources().getConfiguration().windowConfiguration.getBounds();
        }
    }

    @Override
    public WindowMetrics getMaximumWindowMetrics() {
        return new WindowMetrics(this.getMaximumBounds(), this.computeWindowInsets());
    }

    private Rect getMaximumBounds() {
        Point displaySize = new Point();
        this.mDisplay.getRealSize(displaySize);
        return new Rect(0, 0, displaySize.x, displaySize.y);
    }

    private WindowInsets computeWindowInsets() {
        try {
            InsetsState insetsState = new InsetsState();
            boolean alwaysConsumeSystemBars = WindowManagerGlobal.getWindowManagerService().getWindowInsets(new WindowManager.LayoutParams(), this.mContext.getDisplayId(), insetsState);
            Configuration config = this.mContext.getResources().getConfiguration();
            boolean isScreenRound = config.isScreenRound();
            int windowingMode = config.windowConfiguration.getWindowingMode();
            return insetsState.calculateInsets(WindowManagerImpl.getCurrentBounds(this.mContext), null, isScreenRound, alwaysConsumeSystemBars, 48, 0, 0, 2, windowingMode, null);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void setBaseRootView(ViewGroup baseRootView) {
        ViewGroup composableRoot = this.findComposableRoot(baseRootView);
        this.mBaseRootView = composableRoot != null ? composableRoot : baseRootView;
    }

    private ViewGroup findComposableRoot(ViewGroup baseRootView) {
        if (baseRootView.getClass().getName().endsWith("ComposeViewAdapter")) {
            return baseRootView;
        }
        for (int i = 0; i < baseRootView.getChildCount(); ++i) {
            ViewGroup composableRoot;
            View child = baseRootView.getChildAt(i);
            if (!(child instanceof ViewGroup) || (composableRoot = this.findComposableRoot((ViewGroup)child)) == null) continue;
            return composableRoot;
        }
        return null;
    }

    public ViewGroup getCurrentRootView() {
        return this.mCurrentRootView;
    }
}

