/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.Display;
import android.view.IWindow;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import android.view.WindowlessWindowManager;
import android.view.accessibility.IAccessibilityEmbeddedConnection;
import java.util.Objects;

public class SurfaceControlViewHost {
    private final ViewRootImpl mViewRoot;
    private WindowlessWindowManager mWm;
    private SurfaceControl mSurfaceControl;
    private IAccessibilityEmbeddedConnection mAccessibilityEmbeddedConnection;

    public SurfaceControlViewHost(Context c, Display d, WindowlessWindowManager wwm) {
        this(c, d, wwm, false);
    }

    public SurfaceControlViewHost(Context c, Display d, WindowlessWindowManager wwm, boolean useSfChoreographer) {
        this.mWm = wwm;
        this.mViewRoot = new ViewRootImpl(c, d, this.mWm, useSfChoreographer);
        this.mAccessibilityEmbeddedConnection = this.mViewRoot.getAccessibilityEmbeddedConnection();
    }

    public SurfaceControlViewHost(Context context, Display display, IBinder hostToken) {
        this.mSurfaceControl = new SurfaceControl.Builder().setContainerLayer().setName("SurfaceControlViewHost").setCallsite("SurfaceControlViewHost").build();
        this.mWm = new WindowlessWindowManager(context.getResources().getConfiguration(), this.mSurfaceControl, hostToken);
        this.mViewRoot = new ViewRootImpl(context, display, this.mWm);
        this.mAccessibilityEmbeddedConnection = this.mViewRoot.getAccessibilityEmbeddedConnection();
    }

    protected void finalize() throws Throwable {
        this.mViewRoot.die(false);
    }

    public SurfacePackage getSurfacePackage() {
        if (this.mSurfaceControl != null && this.mAccessibilityEmbeddedConnection != null) {
            return new SurfacePackage(this.mSurfaceControl, this.mAccessibilityEmbeddedConnection, this.mViewRoot.getInputToken());
        }
        return null;
    }

    public void setView(View view, int width, int height) {
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(width, height, 2, 0, -2);
        this.setView(view, lp);
    }

    public void setView(View view, WindowManager.LayoutParams attrs) {
        Objects.requireNonNull(view);
        attrs.flags |= 0x1000000;
        view.setLayoutParams(attrs);
        this.mViewRoot.setView(view, attrs, null);
    }

    public View getView() {
        return this.mViewRoot.getView();
    }

    public IWindow getWindowToken() {
        return this.mViewRoot.mWindow;
    }

    public WindowlessWindowManager getWindowlessWM() {
        return this.mWm;
    }

    public void relayout(WindowManager.LayoutParams attrs) {
        this.mViewRoot.setLayoutParams(attrs, false);
        this.mViewRoot.setReportNextDraw();
        this.mWm.setCompletionCallback(this.mViewRoot.mWindow.asBinder(), t -> t.apply());
    }

    public void relayout(int width, int height) {
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(width, height, 2, 0, -2);
        this.relayout(lp);
    }

    public void release() {
        this.mViewRoot.die(true);
    }

    public static class SurfacePackage
    implements Parcelable {
        private SurfaceControl mSurfaceControl;
        private final IAccessibilityEmbeddedConnection mAccessibilityEmbeddedConnection;
        private final IBinder mInputToken;
        public static final Parcelable.Creator<SurfacePackage> CREATOR = new Parcelable.Creator<SurfacePackage>(){

            @Override
            public SurfacePackage createFromParcel(Parcel in) {
                return new SurfacePackage(in);
            }

            public SurfacePackage[] newArray(int size) {
                return new SurfacePackage[size];
            }
        };

        SurfacePackage(SurfaceControl sc, IAccessibilityEmbeddedConnection connection, IBinder inputToken) {
            this.mSurfaceControl = sc;
            this.mAccessibilityEmbeddedConnection = connection;
            this.mInputToken = inputToken;
        }

        public SurfacePackage(SurfacePackage other) {
            SurfaceControl otherSurfaceControl = other.mSurfaceControl;
            if (otherSurfaceControl != null && otherSurfaceControl.isValid()) {
                this.mSurfaceControl = new SurfaceControl();
                this.mSurfaceControl.copyFrom(otherSurfaceControl, "SurfacePackage");
            }
            this.mAccessibilityEmbeddedConnection = other.mAccessibilityEmbeddedConnection;
            this.mInputToken = other.mInputToken;
        }

        private SurfacePackage(Parcel in) {
            this.mSurfaceControl = new SurfaceControl();
            this.mSurfaceControl.readFromParcel(in);
            this.mAccessibilityEmbeddedConnection = IAccessibilityEmbeddedConnection.Stub.asInterface(in.readStrongBinder());
            this.mInputToken = in.readStrongBinder();
        }

        public SurfaceControl getSurfaceControl() {
            return this.mSurfaceControl;
        }

        public IAccessibilityEmbeddedConnection getAccessibilityEmbeddedConnection() {
            return this.mAccessibilityEmbeddedConnection;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            this.mSurfaceControl.writeToParcel(out, flags);
            out.writeStrongBinder(this.mAccessibilityEmbeddedConnection.asBinder());
            out.writeStrongBinder(this.mInputToken);
        }

        public void release() {
            if (this.mSurfaceControl != null) {
                this.mSurfaceControl.release();
            }
            this.mSurfaceControl = null;
        }

        public IBinder getInputToken() {
            return this.mInputToken;
        }
    }
}

