/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import com.android.tools.layoutlib.create.OverrideMethod;

public abstract class SurfaceControlFpsListener {
    private long mNativeListener = SurfaceControlFpsListener.nativeCreate(this);

    protected void destroy() {
        if (this.mNativeListener == 0L) {
            return;
        }
        this.unregister();
        SurfaceControlFpsListener.nativeDestroy(this.mNativeListener);
        this.mNativeListener = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    public abstract void onFpsReported(float var1);

    public void register(int taskId) {
        if (this.mNativeListener == 0L) {
            return;
        }
        SurfaceControlFpsListener.nativeRegister(this.mNativeListener, taskId);
    }

    public void unregister() {
        if (this.mNativeListener == 0L) {
            return;
        }
        SurfaceControlFpsListener.nativeUnregister(this.mNativeListener);
    }

    private static void dispatchOnFpsReported(SurfaceControlFpsListener listener2, float fps) {
        listener2.onFpsReported(fps);
    }

    private static long nativeCreate(SurfaceControlFpsListener surfaceControlFpsListener) {
        return OverrideMethod.invokeL("android.view.SurfaceControlFpsListener#nativeCreate(Landroid/view/SurfaceControlFpsListener;)J", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControlFpsListener#nativeDestroy(J)V", true, null);
    }

    private static void nativeRegister(long l, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControlFpsListener#nativeRegister(JI)V", true, null);
    }

    private static void nativeUnregister(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControlFpsListener#nativeUnregister(J)V", true, null);
    }
}

