/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.CancellationSignal;
import android.util.IndentingPrintWriter;
import android.view.ScrollCaptureCallback;
import android.view.ScrollCaptureTarget;
import android.view.View;
import android.view.ViewParent;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ScrollCaptureSearchResults {
    private final Executor mExecutor;
    private final List<ScrollCaptureTarget> mTargets;
    private final CancellationSignal mCancel;
    private Runnable mOnCompleteListener;
    private int mCompleted;
    private boolean mComplete = true;
    private static final int AFTER = 1;
    private static final int BEFORE = -1;
    private static final int EQUAL = 0;
    static final Comparator<ScrollCaptureTarget> PRIORITY_ORDER = (a, b) -> {
        int scrollAreaB;
        boolean hintIncludeB;
        if (a == null && b == null) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? 1 : -1;
        }
        boolean emptyScrollBoundsA = ScrollCaptureSearchResults.nullOrEmpty(a.getScrollBounds());
        boolean emptyScrollBoundsB = ScrollCaptureSearchResults.nullOrEmpty(b.getScrollBounds());
        if (emptyScrollBoundsA || emptyScrollBoundsB) {
            if (emptyScrollBoundsA && emptyScrollBoundsB) {
                return 0;
            }
            if (emptyScrollBoundsA) {
                return 1;
            }
            return -1;
        }
        View viewA = a.getContainingView();
        View viewB = b.getContainingView();
        boolean hintIncludeA = ScrollCaptureSearchResults.hasIncludeHint(viewA);
        if (hintIncludeA != (hintIncludeB = ScrollCaptureSearchResults.hasIncludeHint(viewB))) {
            return hintIncludeA ? -1 : 1;
        }
        if (ScrollCaptureSearchResults.isDescendant(viewA, viewB)) {
            return -1;
        }
        if (ScrollCaptureSearchResults.isDescendant(viewB, viewA)) {
            return 1;
        }
        int scrollAreaA = ScrollCaptureSearchResults.area(a.getScrollBounds());
        return scrollAreaA >= (scrollAreaB = ScrollCaptureSearchResults.area(b.getScrollBounds())) ? -1 : 1;
    };

    public ScrollCaptureSearchResults(Executor executor) {
        this.mExecutor = executor;
        this.mTargets = new ArrayList<ScrollCaptureTarget>();
        this.mCancel = new CancellationSignal();
    }

    public void addTarget(ScrollCaptureTarget target) {
        Objects.requireNonNull(target);
        this.mTargets.add(target);
        this.mComplete = false;
        ScrollCaptureCallback callback2 = target.getCallback();
        SearchRequest consumer = new SearchRequest(target);
        this.mExecutor.execute(() -> callback2.onScrollCaptureSearch(this.mCancel, consumer));
    }

    public boolean isComplete() {
        return this.mComplete;
    }

    public void setOnCompleteListener(Runnable onComplete) {
        if (this.mComplete) {
            onComplete.run();
        } else {
            this.mOnCompleteListener = onComplete;
        }
    }

    public boolean isEmpty() {
        return this.mTargets.isEmpty();
    }

    public void finish() {
        if (!this.mComplete) {
            this.mCancel.cancel();
            this.signalComplete();
        }
    }

    private void signalComplete() {
        this.mComplete = true;
        this.mTargets.sort(PRIORITY_ORDER);
        if (this.mOnCompleteListener != null) {
            this.mOnCompleteListener.run();
            this.mOnCompleteListener = null;
        }
    }

    @VisibleForTesting
    public List<ScrollCaptureTarget> getTargets() {
        return new ArrayList<ScrollCaptureTarget>(this.mTargets);
    }

    public ScrollCaptureTarget getTopResult() {
        ScrollCaptureTarget target = this.mTargets.isEmpty() ? null : this.mTargets.get(0);
        return target != null && target.getScrollBounds() != null ? target : null;
    }

    private static int area(Rect r) {
        return r.width() * r.height();
    }

    private static boolean nullOrEmpty(Rect r) {
        return r == null || r.isEmpty();
    }

    private static boolean hasIncludeHint(View view) {
        return (view.getScrollCaptureHint() & 2) != 0;
    }

    private static boolean isDescendant(View view, View otherView) {
        ViewParent otherParent;
        if (view == otherView) {
            return false;
        }
        for (otherParent = otherView.getParent(); otherParent != view && otherParent != null; otherParent = otherParent.getParent()) {
        }
        return otherParent == view;
    }

    void dump(IndentingPrintWriter writer) {
        writer.println("results:");
        writer.increaseIndent();
        writer.println("complete: " + this.isComplete());
        writer.println("cancelled: " + this.mCancel.isCanceled());
        writer.println("targets:");
        writer.increaseIndent();
        if (this.isEmpty()) {
            writer.println("None");
        } else {
            for (int i = 0; i < this.mTargets.size(); ++i) {
                writer.println("[" + i + "]");
                writer.increaseIndent();
                this.mTargets.get(i).dump(writer);
                writer.decreaseIndent();
            }
            writer.decreaseIndent();
        }
        writer.decreaseIndent();
    }

    private class SearchRequest
    implements Consumer<Rect> {
        private ScrollCaptureTarget mTarget;

        SearchRequest(ScrollCaptureTarget target) {
            this.mTarget = target;
        }

        @Override
        public void accept(Rect scrollBounds) {
            if (this.mTarget == null || ScrollCaptureSearchResults.this.mCancel.isCanceled()) {
                return;
            }
            ScrollCaptureSearchResults.this.mExecutor.execute(() -> this.consume(scrollBounds));
        }

        private void consume(Rect scrollBounds) {
            if (this.mTarget == null || ScrollCaptureSearchResults.this.mCancel.isCanceled()) {
                return;
            }
            if (!ScrollCaptureSearchResults.nullOrEmpty(scrollBounds)) {
                this.mTarget.setScrollBounds(scrollBounds);
                this.mTarget.updatePositionInWindow();
            }
            ScrollCaptureSearchResults.this.mCompleted++;
            this.mTarget = null;
            if (ScrollCaptureSearchResults.this.mCompleted == ScrollCaptureSearchResults.this.mTargets.size()) {
                ScrollCaptureSearchResults.this.signalComplete();
            }
        }
    }
}

