/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.IScrollCaptureConnection;
import com.android.internal.util.AnnotationValidations;
import java.util.ArrayList;

public class ScrollCaptureResponse
implements Parcelable {
    private String mDescription = "";
    private IScrollCaptureConnection mConnection = null;
    private Rect mWindowBounds = null;
    private Rect mBoundsInWindow = null;
    private String mWindowTitle = null;
    private ArrayList<String> mMessages = new ArrayList();
    public static final Parcelable.Creator<ScrollCaptureResponse> CREATOR = new Parcelable.Creator<ScrollCaptureResponse>(){

        public ScrollCaptureResponse[] newArray(int size) {
            return new ScrollCaptureResponse[size];
        }

        @Override
        public ScrollCaptureResponse createFromParcel(Parcel in) {
            return new ScrollCaptureResponse(in);
        }
    };

    public boolean isConnected() {
        return this.mConnection != null && this.mConnection.asBinder().isBinderAlive();
    }

    public void close() {
        if (this.mConnection != null) {
            try {
                this.mConnection.close();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mConnection = null;
        }
    }

    ScrollCaptureResponse(String description, IScrollCaptureConnection connection, Rect windowBounds, Rect boundsInWindow, String windowTitle, ArrayList<String> messages) {
        this.mDescription = description;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mDescription);
        this.mConnection = connection;
        this.mWindowBounds = windowBounds;
        this.mBoundsInWindow = boundsInWindow;
        this.mWindowTitle = windowTitle;
        this.mMessages = messages;
        AnnotationValidations.validate(NonNull.class, null, this.mMessages);
    }

    public String getDescription() {
        return this.mDescription;
    }

    public IScrollCaptureConnection getConnection() {
        return this.mConnection;
    }

    public Rect getWindowBounds() {
        return this.mWindowBounds;
    }

    public Rect getBoundsInWindow() {
        return this.mBoundsInWindow;
    }

    public String getWindowTitle() {
        return this.mWindowTitle;
    }

    public ArrayList<String> getMessages() {
        return this.mMessages;
    }

    public String toString() {
        return "ScrollCaptureResponse { description = " + this.mDescription + ", connection = " + this.mConnection + ", windowBounds = " + this.mWindowBounds + ", boundsInWindow = " + this.mBoundsInWindow + ", windowTitle = " + this.mWindowTitle + ", messages = " + this.mMessages + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mConnection != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mWindowBounds != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mBoundsInWindow != null) {
            flg = (byte)(flg | 8);
        }
        if (this.mWindowTitle != null) {
            flg = (byte)(flg | 0x10);
        }
        dest.writeByte(flg);
        dest.writeString(this.mDescription);
        if (this.mConnection != null) {
            dest.writeStrongInterface(this.mConnection);
        }
        if (this.mWindowBounds != null) {
            dest.writeTypedObject(this.mWindowBounds, flags);
        }
        if (this.mBoundsInWindow != null) {
            dest.writeTypedObject(this.mBoundsInWindow, flags);
        }
        if (this.mWindowTitle != null) {
            dest.writeString(this.mWindowTitle);
        }
        dest.writeStringList(this.mMessages);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected ScrollCaptureResponse(Parcel in) {
        byte flg = in.readByte();
        String description = in.readString();
        IScrollCaptureConnection connection = (flg & 2) == 0 ? null : IScrollCaptureConnection.Stub.asInterface(in.readStrongBinder());
        Rect windowBounds = (flg & 4) == 0 ? null : in.readTypedObject(Rect.CREATOR);
        Rect boundsInWindow = (flg & 8) == 0 ? null : in.readTypedObject(Rect.CREATOR);
        String windowTitle = (flg & 0x10) == 0 ? null : in.readString();
        ArrayList<String> messages = new ArrayList<String>();
        in.readStringList(messages);
        this.mDescription = description;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mDescription);
        this.mConnection = connection;
        this.mWindowBounds = windowBounds;
        this.mBoundsInWindow = boundsInWindow;
        this.mWindowTitle = windowTitle;
        this.mMessages = messages;
        AnnotationValidations.validate(NonNull.class, null, this.mMessages);
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        private String mDescription;
        private IScrollCaptureConnection mConnection;
        private Rect mWindowBounds;
        private Rect mBoundsInWindow;
        private String mWindowTitle;
        private ArrayList<String> mMessages;
        private long mBuilderFieldsSet = 0L;

        public Builder setDescription(String value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mDescription = value2;
            return this;
        }

        public Builder setConnection(IScrollCaptureConnection value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mConnection = value2;
            return this;
        }

        public Builder setWindowBounds(Rect value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mWindowBounds = value2;
            return this;
        }

        public Builder setBoundsInWindow(Rect value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mBoundsInWindow = value2;
            return this;
        }

        public Builder setWindowTitle(String value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mWindowTitle = value2;
            return this;
        }

        public Builder setMessages(ArrayList<String> value2) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mMessages = value2;
            return this;
        }

        public Builder addMessage(String value2) {
            if (this.mMessages == null) {
                this.setMessages(new ArrayList<String>());
            }
            this.mMessages.add(value2);
            return this;
        }

        public ScrollCaptureResponse build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mDescription = "";
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mConnection = null;
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mWindowBounds = null;
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mBoundsInWindow = null;
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mWindowTitle = null;
            }
            if ((this.mBuilderFieldsSet & 0x20L) == 0L) {
                this.mMessages = new ArrayList();
            }
            ScrollCaptureResponse o = new ScrollCaptureResponse(this.mDescription, this.mConnection, this.mWindowBounds, this.mBoundsInWindow, this.mWindowTitle, this.mMessages);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x40L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

