/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.CancellationSignal;
import android.os.ICancellationSignal;
import android.os.RemoteException;
import android.os.Trace;
import android.util.CloseGuard;
import android.util.Log;
import android.view.IScrollCaptureCallbacks;
import android.view.IScrollCaptureConnection;
import android.view.ScrollCaptureCallback;
import android.view.ScrollCaptureSession;
import android.view.ScrollCaptureTarget;
import android.view.Surface;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ScrollCaptureConnection
extends IScrollCaptureConnection.Stub {
    private static final String TAG = "ScrollCaptureConnection";
    private final Object mLock = new Object();
    private final Rect mScrollBounds;
    private final Point mPositionInWindow;
    private final Executor mUiThread;
    private final CloseGuard mCloseGuard = new CloseGuard();
    private ScrollCaptureCallback mLocal;
    private IScrollCaptureCallbacks mRemote;
    private ScrollCaptureSession mSession;
    private CancellationSignal mCancellation;
    private volatile boolean mActive;

    public ScrollCaptureConnection(Executor uiThread, ScrollCaptureTarget selectedTarget) {
        this.mUiThread = Objects.requireNonNull(uiThread, "<uiThread> must non-null");
        Objects.requireNonNull(selectedTarget, "<selectedTarget> must non-null");
        this.mScrollBounds = Objects.requireNonNull(Rect.copyOrNull(selectedTarget.getScrollBounds()), "target.getScrollBounds() must be non-null to construct a client");
        this.mLocal = selectedTarget.getCallback();
        this.mPositionInWindow = new Point(selectedTarget.getPositionInWindow());
    }

    @Override
    public ICancellationSignal startCapture(Surface surface2, IScrollCaptureCallbacks remote) throws RemoteException {
        this.mCloseGuard.open("close");
        if (!surface2.isValid()) {
            throw new RemoteException((Throwable)new IllegalArgumentException("surface must be valid"));
        }
        this.mRemote = Objects.requireNonNull(remote, "<callbacks> must non-null");
        ICancellationSignal cancellation = CancellationSignal.createTransport();
        this.mCancellation = CancellationSignal.fromTransport(cancellation);
        this.mSession = new ScrollCaptureSession(surface2, this.mScrollBounds, this.mPositionInWindow);
        Runnable listener2 = SafeCallback.create(this.mCancellation, this.mUiThread, this::onStartCaptureCompleted);
        this.mUiThread.execute(() -> this.mLocal.onScrollCaptureStart(this.mSession, this.mCancellation, listener2));
        return cancellation;
    }

    private void onStartCaptureCompleted() {
        this.mActive = true;
        try {
            this.mRemote.onCaptureStarted();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Shutting down due to error: ", e);
            this.close();
        }
    }

    @Override
    public ICancellationSignal requestImage(Rect requestRect) throws RemoteException {
        Trace.beginSection("requestImage");
        this.checkActive();
        ICancellationSignal cancellation = CancellationSignal.createTransport();
        this.mCancellation = CancellationSignal.fromTransport(cancellation);
        Consumer<Rect> listener2 = SafeCallback.create(this.mCancellation, this.mUiThread, this::onImageRequestCompleted);
        this.mUiThread.execute(() -> this.mLocal.onScrollCaptureImageRequest(this.mSession, this.mCancellation, new Rect(requestRect), listener2));
        Trace.endSection();
        return cancellation;
    }

    void onImageRequestCompleted(Rect capturedArea) {
        try {
            this.mRemote.onImageRequestCompleted(0, capturedArea);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Shutting down due to error: ", e);
            this.close();
        }
    }

    @Override
    public ICancellationSignal endCapture() throws RemoteException {
        this.checkActive();
        ICancellationSignal cancellation = CancellationSignal.createTransport();
        this.mCancellation = CancellationSignal.fromTransport(cancellation);
        Runnable listener2 = SafeCallback.create(this.mCancellation, this.mUiThread, this::onEndCaptureCompleted);
        this.mUiThread.execute(() -> this.mLocal.onScrollCaptureEnd(listener2));
        return cancellation;
    }

    private void onEndCaptureCompleted() {
        this.mActive = false;
        try {
            if (this.mRemote != null) {
                this.mRemote.onCaptureEnded();
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "Caught exception confirming capture end!", e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.mActive) {
            if (this.mCancellation != null) {
                Log.w(TAG, "close(): cancelling pending operation.");
                this.mCancellation.cancel();
                this.mCancellation = null;
            }
            Log.w(TAG, "close(): capture session still active! Ending now.");
            ScrollCaptureCallback callback2 = this.mLocal;
            this.mUiThread.execute(() -> callback2.onScrollCaptureEnd(() -> {}));
            this.mActive = false;
        }
        this.mActive = false;
        this.mSession = null;
        this.mRemote = null;
        this.mLocal = null;
        this.mCloseGuard.close();
        Reference.reachabilityFence(this);
    }

    @VisibleForTesting
    public boolean isActive() {
        return this.mActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkActive() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mActive) {
                throw new RemoteException((Throwable)new IllegalStateException("Not started!"));
            }
        }
    }

    public String toString() {
        return "ScrollCaptureConnection{active=" + this.mActive + ", session=" + this.mSession + ", remote=" + this.mRemote + ", local=" + this.mLocal + "}";
    }

    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static class ConsumerCallback<T>
    extends SafeCallback<Consumer<T>>
    implements Consumer<T> {
        ConsumerCallback(CancellationSignal signal, Executor executor, Consumer<T> target) {
            super(signal, executor, target);
        }

        @Override
        public void accept(T value2) {
            this.maybeAccept(target -> target.accept(value2));
        }
    }

    private static class RunnableCallback
    extends SafeCallback<Runnable>
    implements Runnable {
        RunnableCallback(CancellationSignal signal, Executor executor, Runnable target) {
            super(signal, executor, target);
        }

        @Override
        public void run() {
            this.maybeAccept(Runnable::run);
        }
    }

    private static class SafeCallback<T> {
        private final CancellationSignal mSignal;
        private final WeakReference<T> mTargetRef;
        private final Executor mExecutor;
        private boolean mExecuted;

        protected SafeCallback(CancellationSignal signal, Executor executor, T target) {
            this.mSignal = signal;
            this.mTargetRef = new WeakReference<T>(target);
            this.mExecutor = executor;
        }

        protected void maybeAccept(Consumer<T> targetConsumer) {
            if (this.mExecuted) {
                return;
            }
            this.mExecuted = true;
            if (this.mSignal.isCanceled()) {
                return;
            }
            Object target = this.mTargetRef.get();
            if (target == null) {
                return;
            }
            this.mExecutor.execute(() -> targetConsumer.accept(target));
        }

        static Runnable create(CancellationSignal signal, Executor executor, Runnable target) {
            return new RunnableCallback(signal, executor, target);
        }

        static <T> Consumer<T> create(CancellationSignal signal, Executor executor, Consumer<T> target) {
            return new ConsumerCallback<T>(signal, executor, target);
        }
    }
}

