/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import java.util.HashSet;
import java.util.Set;

@RemoteViews.RemoteView
public class NotificationTopLineView
extends ViewGroup {
    private final OverflowAdjuster mOverflowAdjuster = new OverflowAdjuster();
    private final int mGravityY;
    private final int mChildMinWidth;
    private final int mChildHideWidth;
    private View mAppName;
    private View mTitle;
    private View mHeaderText;
    private View mHeaderTextDivider;
    private View mSecondaryHeaderText;
    private View mSecondaryHeaderTextDivider;
    private View.OnClickListener mFeedbackListener;
    private HeaderTouchListener mTouchListener = new HeaderTouchListener();
    private View mFeedbackIcon;
    private int mHeaderTextMarginEnd;
    private Set<View> mViewsToDisappear = new HashSet<View>();
    private int mMaxAscent;
    private int mMaxDescent;

    public NotificationTopLineView(Context context) {
        this(context, null);
    }

    public NotificationTopLineView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NotificationTopLineView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public NotificationTopLineView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Resources res = this.getResources();
        this.mChildMinWidth = res.getDimensionPixelSize(17105399);
        this.mChildHideWidth = res.getDimensionPixelSize(17105398);
        int[] attrIds = new int[]{16842927};
        TypedArray ta = context.obtainStyledAttributes(attrs, attrIds, defStyleAttr, defStyleRes);
        int gravity = ta.getInt(0, 0);
        ta.recycle();
        this.mGravityY = (gravity & 0x50) == 80 ? 80 : ((gravity & 0x30) == 48 ? 48 : 16);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mAppName = this.findViewById(16908763);
        this.mTitle = this.findViewById(16908310);
        this.mHeaderText = this.findViewById(16909043);
        this.mHeaderTextDivider = this.findViewById(16909044);
        this.mSecondaryHeaderText = this.findViewById(16909045);
        this.mSecondaryHeaderTextDivider = this.findViewById(16909046);
        this.mFeedbackIcon = this.findViewById(16908967);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int givenWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int givenHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        boolean wrapHeight2 = View.MeasureSpec.getMode(heightMeasureSpec) == Integer.MIN_VALUE;
        int wrapContentWidthSpec = View.MeasureSpec.makeMeasureSpec(givenWidth, Integer.MIN_VALUE);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(givenHeight, Integer.MIN_VALUE);
        int totalWidth = this.getPaddingStart();
        int maxChildHeight = -1;
        this.mMaxAscent = -1;
        this.mMaxDescent = -1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidthSpec = NotificationTopLineView.getChildMeasureSpec(wrapContentWidthSpec, lp.leftMargin + lp.rightMargin, lp.width);
            int childHeightSpec = NotificationTopLineView.getChildMeasureSpec(heightSpec, lp.topMargin + lp.bottomMargin, lp.height);
            child.measure(childWidthSpec, childHeightSpec);
            totalWidth += lp.leftMargin + lp.rightMargin + child.getMeasuredWidth();
            int childBaseline = child.getBaseline();
            int childHeight = child.getMeasuredHeight();
            if (childBaseline != -1) {
                this.mMaxAscent = Math.max(this.mMaxAscent, childBaseline);
                this.mMaxDescent = Math.max(this.mMaxDescent, childHeight - childBaseline);
            }
            maxChildHeight = Math.max(maxChildHeight, childHeight);
        }
        this.mViewsToDisappear.clear();
        int endMargin = Math.max(this.mHeaderTextMarginEnd, this.getPaddingEnd());
        if (totalWidth > givenWidth - endMargin) {
            int overFlow = totalWidth - givenWidth + endMargin;
            this.mOverflowAdjuster.resetForOverflow(overFlow, heightSpec).adjust(this.mAppName, null, this.mChildMinWidth).adjust(this.mHeaderText, this.mHeaderTextDivider, this.mChildMinWidth).adjust(this.mSecondaryHeaderText, this.mSecondaryHeaderTextDivider, 0).adjust(this.mTitle, null, this.mChildMinWidth).adjust(this.mHeaderText, this.mHeaderTextDivider, 0).adjust(this.mTitle, null, 0).finish();
        }
        this.setMeasuredDimension(givenWidth, wrapHeight2 ? maxChildHeight : givenHeight);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        boolean isRtl = this.getLayoutDirection() == 1;
        int width = this.getWidth();
        int start = this.getPaddingStart();
        int childCount = this.getChildCount();
        int ownHeight = b - t;
        int childSpace = ownHeight - this.mPaddingTop - this.mPaddingBottom;
        int baselineY = this.mPaddingTop + (childSpace - (this.mMaxAscent + this.mMaxDescent)) / 2 + this.mMaxAscent;
        for (int i = 0; i < childCount; ++i) {
            int childTop;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childHeight = child.getMeasuredHeight();
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childBaseline = child.getBaseline();
            switch (this.mGravityY) {
                case 48: {
                    childTop = this.mPaddingTop + params.topMargin;
                    if (childBaseline == -1) break;
                    childTop += this.mMaxAscent - childBaseline;
                    break;
                }
                case 16: {
                    if (childBaseline != -1) {
                        if (childSpace - childHeight > 0) {
                            childTop = baselineY - childBaseline;
                            break;
                        }
                        childTop = this.mPaddingTop + (childSpace - childHeight) / 2;
                        break;
                    }
                    childTop = this.mPaddingTop + (childSpace - childHeight) / 2 + params.topMargin - params.bottomMargin;
                    break;
                }
                case 80: {
                    int childBottom = ownHeight - this.mPaddingBottom;
                    childTop = childBottom - childHeight - params.bottomMargin;
                    if (childBaseline == -1) break;
                    int descent = childHeight - childBaseline;
                    childTop -= this.mMaxDescent - descent;
                    break;
                }
                default: {
                    childTop = this.mPaddingTop;
                }
            }
            if (this.mViewsToDisappear.contains(child)) {
                child.layout(start, childTop, start, childTop + childHeight);
                continue;
            }
            int end = (start += params.getMarginStart()) + child.getMeasuredWidth();
            int layoutLeft = isRtl ? width - end : start;
            int layoutRight = isRtl ? width - start : end;
            start = end + params.getMarginEnd();
            child.layout(layoutLeft, childTop, layoutRight, childTop + childHeight);
        }
        this.updateTouchListener();
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    private void updateTouchListener() {
        if (this.mFeedbackListener == null) {
            this.setOnTouchListener(null);
            return;
        }
        this.setOnTouchListener(this.mTouchListener);
        this.mTouchListener.bindTouchRects();
    }

    public void setFeedbackOnClickListener(View.OnClickListener l) {
        this.mFeedbackListener = l;
        this.mFeedbackIcon.setOnClickListener(this.mFeedbackListener);
        this.updateTouchListener();
    }

    public void setHeaderTextMarginEnd(int headerTextMarginEnd) {
        if (this.mHeaderTextMarginEnd != headerTextMarginEnd) {
            this.mHeaderTextMarginEnd = headerTextMarginEnd;
            this.requestLayout();
        }
    }

    public int getHeaderTextMarginEnd() {
        return this.mHeaderTextMarginEnd;
    }

    public void setPaddingStart(int paddingStart) {
        this.setPaddingRelative(paddingStart, this.getPaddingTop(), this.getPaddingEnd(), this.getPaddingBottom());
    }

    private View getFirstChildNotGone() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            return child;
        }
        return this;
    }

    @Override
    public boolean hasOverlappingRendering() {
        return false;
    }

    public boolean isInTouchRect(float x, float y) {
        if (this.mFeedbackListener == null) {
            return false;
        }
        return this.mTouchListener.isInside(x, y);
    }

    public boolean onTouchUp(float upX, float upY, float downX, float downY) {
        if (this.mFeedbackListener == null) {
            return false;
        }
        return this.mTouchListener.onTouchUp(upX, upY, downX, downY);
    }

    private class OverflowAdjuster {
        private int mOverflow;
        private int mHeightSpec;
        private View mRegrowView;

        private OverflowAdjuster() {
        }

        OverflowAdjuster resetForOverflow(int overflow, int heightSpec) {
            this.mOverflow = overflow;
            this.mHeightSpec = heightSpec;
            this.mRegrowView = null;
            return this;
        }

        OverflowAdjuster adjust(View targetView, View targetDivider, int minimumWidth) {
            if (this.mOverflow <= 0 || targetView == null || targetView.getVisibility() == 8) {
                return this;
            }
            int oldWidth = targetView.getMeasuredWidth();
            if (oldWidth <= minimumWidth) {
                return this;
            }
            int newSize = Math.max(minimumWidth, oldWidth - this.mOverflow);
            if (minimumWidth == 0 && newSize < NotificationTopLineView.this.mChildHideWidth && this.mRegrowView != null && this.mRegrowView != targetView) {
                newSize = 0;
            }
            int childWidthSpec = View.MeasureSpec.makeMeasureSpec(newSize, Integer.MIN_VALUE);
            targetView.measure(childWidthSpec, this.mHeightSpec);
            this.mOverflow -= oldWidth - newSize;
            if (newSize == 0) {
                NotificationTopLineView.this.mViewsToDisappear.add(targetView);
                this.mOverflow -= this.getHorizontalMargins(targetView);
                if (targetDivider != null && targetDivider.getVisibility() != 8) {
                    NotificationTopLineView.this.mViewsToDisappear.add(targetDivider);
                    int oldDividerWidth = targetDivider.getMeasuredWidth();
                    int dividerWidthSpec = View.MeasureSpec.makeMeasureSpec(0, Integer.MIN_VALUE);
                    targetDivider.measure(dividerWidthSpec, this.mHeightSpec);
                    this.mOverflow -= oldDividerWidth + this.getHorizontalMargins(targetDivider);
                }
            }
            if (this.mOverflow < 0 && this.mRegrowView != null) {
                int regrowCurrentSize = this.mRegrowView.getMeasuredWidth();
                int maxSize = regrowCurrentSize - this.mOverflow;
                int regrowWidthSpec = View.MeasureSpec.makeMeasureSpec(maxSize, Integer.MIN_VALUE);
                this.mRegrowView.measure(regrowWidthSpec, this.mHeightSpec);
                this.finish();
                return this;
            }
            if (newSize != 0) {
                this.mRegrowView = targetView;
            }
            return this;
        }

        void finish() {
            this.resetForOverflow(0, 0);
        }

        private int getHorizontalMargins(View view) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            return params.getMarginStart() + params.getMarginEnd();
        }
    }

    private class HeaderTouchListener
    implements View.OnTouchListener {
        private Rect mFeedbackRect;
        private int mTouchSlop;
        private boolean mTrackGesture;
        private float mDownX;
        private float mDownY;

        HeaderTouchListener() {
        }

        public void bindTouchRects() {
            this.mFeedbackRect = this.getRectAroundView(NotificationTopLineView.this.mFeedbackIcon);
            this.mTouchSlop = ViewConfiguration.get(NotificationTopLineView.this.getContext()).getScaledTouchSlop();
        }

        private Rect getRectAroundView(View view) {
            float size = 48.0f * NotificationTopLineView.this.getResources().getDisplayMetrics().density;
            float width = Math.max(size, (float)view.getWidth());
            float height = Math.max(size, (float)view.getHeight());
            Rect r = new Rect();
            if (view.getVisibility() == 8) {
                view = NotificationTopLineView.this.getFirstChildNotGone();
                r.left = (int)((float)view.getLeft() - width / 2.0f);
            } else {
                r.left = (int)((float)(view.getLeft() + view.getRight()) / 2.0f - width / 2.0f);
            }
            r.top = (int)((float)(view.getTop() + view.getBottom()) / 2.0f - height / 2.0f);
            r.bottom = (int)((float)r.top + height);
            r.right = (int)((float)r.left + width);
            return r;
        }

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            float x = event.getX();
            float y = event.getY();
            switch (event.getActionMasked() & 0xFF) {
                case 0: {
                    this.mTrackGesture = false;
                    if (!this.isInside(x, y)) break;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mTrackGesture = true;
                    return true;
                }
                case 2: {
                    if (!this.mTrackGesture || !(Math.abs(this.mDownX - x) > (float)this.mTouchSlop) && !(Math.abs(this.mDownY - y) > (float)this.mTouchSlop)) break;
                    this.mTrackGesture = false;
                    break;
                }
                case 1: {
                    if (!this.mTrackGesture || !this.onTouchUp(x, y, this.mDownX, this.mDownY)) break;
                    return true;
                }
            }
            return this.mTrackGesture;
        }

        private boolean onTouchUp(float upX, float upY, float downX, float downY) {
            if (NotificationTopLineView.this.mFeedbackIcon.isVisibleToUser() && (this.mFeedbackRect.contains((int)upX, (int)upY) || this.mFeedbackRect.contains((int)downX, (int)downY))) {
                NotificationTopLineView.this.mFeedbackIcon.performClick();
                return true;
            }
            return false;
        }

        private boolean isInside(float x, float y) {
            return this.mFeedbackRect.contains((int)x, (int)y);
        }
    }
}

