/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.LongSparseArray;
import android.util.Pools;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

public class InputQueue {
    private final LongSparseArray<ActiveInputEvent> mActiveEventArray = new LongSparseArray(20);
    private final Pools.Pool<ActiveInputEvent> mActiveInputEventPool = new Pools.SimplePool<ActiveInputEvent>(20);
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private long mPtr = InputQueue.nativeInit(new WeakReference<InputQueue>(this), Looper.myQueue());

    private static long nativeInit(WeakReference<InputQueue> weakReference, MessageQueue messageQueue) {
        return OverrideMethod.invokeL("android.view.InputQueue#nativeInit(Ljava/lang/ref/WeakReference;Landroid/os/MessageQueue;)J", true, null);
    }

    private static long nativeSendKeyEvent(long l, KeyEvent keyEvent, boolean bl) {
        return OverrideMethod.invokeL("android.view.InputQueue#nativeSendKeyEvent(JLandroid/view/KeyEvent;Z)J", true, null);
    }

    private static long nativeSendMotionEvent(long l, MotionEvent motionEvent) {
        return OverrideMethod.invokeL("android.view.InputQueue#nativeSendMotionEvent(JLandroid/view/MotionEvent;)J", true, null);
    }

    private static void nativeDispose(long l) {
        OverrideMethod.invokeV("android.view.InputQueue#nativeDispose(J)V", true, null);
    }

    public InputQueue() {
        this.mCloseGuard.open("dispose");
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mPtr != 0L) {
            InputQueue.nativeDispose(this.mPtr);
            this.mPtr = 0L;
        }
    }

    public long getNativePtr() {
        return this.mPtr;
    }

    public void sendInputEvent(InputEvent e, Object token, boolean predispatch, FinishedInputEventCallback callback2) {
        ActiveInputEvent event = this.obtainActiveInputEvent(token, callback2);
        long id2 = e instanceof KeyEvent ? InputQueue.nativeSendKeyEvent(this.mPtr, (KeyEvent)e, predispatch) : InputQueue.nativeSendMotionEvent(this.mPtr, (MotionEvent)e);
        this.mActiveEventArray.put(id2, event);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void finishInputEvent(long id2, boolean handled) {
        int index = this.mActiveEventArray.indexOfKey(id2);
        if (index >= 0) {
            ActiveInputEvent e = this.mActiveEventArray.valueAt(index);
            this.mActiveEventArray.removeAt(index);
            e.mCallback.onFinishedInputEvent(e.mToken, handled);
            this.recycleActiveInputEvent(e);
        }
    }

    private ActiveInputEvent obtainActiveInputEvent(Object token, FinishedInputEventCallback callback2) {
        ActiveInputEvent e = this.mActiveInputEventPool.acquire();
        if (e == null) {
            e = new ActiveInputEvent();
        }
        e.mToken = token;
        e.mCallback = callback2;
        return e;
    }

    private void recycleActiveInputEvent(ActiveInputEvent e) {
        e.recycle();
        this.mActiveInputEventPool.release(e);
    }

    public static interface FinishedInputEventCallback {
        public void onFinishedInputEvent(Object var1, boolean var2);
    }

    public static interface Callback {
        public void onInputQueueCreated(InputQueue var1);

        public void onInputQueueDestroyed(InputQueue var1);
    }

    private class ActiveInputEvent {
        public Object mToken;
        public FinishedInputEventCallback mCallback;

        private ActiveInputEvent() {
        }

        public void recycle() {
            this.mToken = null;
            this.mCallback = null;
        }
    }
}

