/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.proto.ProtoOutputStream;
import android.view.InputEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import java.util.Objects;

public class ImeFocusController {
    private static final boolean DEBUG = false;
    private static final String TAG = "ImeFocusController";
    private final ViewRootImpl mViewRootImpl;
    private boolean mHasImeFocus = false;
    private View mServedView;
    private View mNextServedView;
    private InputMethodManagerDelegate mDelegate;

    ImeFocusController(ViewRootImpl viewRootImpl) {
        this.mViewRootImpl = viewRootImpl;
    }

    private InputMethodManagerDelegate getImmDelegate() {
        InputMethodManagerDelegate delegate = this.mDelegate;
        if (delegate != null) {
            return delegate;
        }
        this.mDelegate = delegate = this.mViewRootImpl.mContext.getSystemService(InputMethodManager.class).getDelegate();
        return delegate;
    }

    void onMovedToDisplay() {
        this.mDelegate = null;
    }

    void onTraversal(boolean hasWindowFocus, WindowManager.LayoutParams windowAttribute) {
        boolean hasImeFocus = this.updateImeFocusable(windowAttribute, false);
        if (!hasWindowFocus || ImeFocusController.isInLocalFocusMode(windowAttribute)) {
            return;
        }
        if (hasImeFocus == this.mHasImeFocus) {
            return;
        }
        this.mHasImeFocus = hasImeFocus;
        if (this.mHasImeFocus) {
            this.onPreWindowFocus(true, windowAttribute);
            this.onPostWindowFocus(this.mViewRootImpl.mView.findFocus(), true, windowAttribute);
        }
    }

    void onPreWindowFocus(boolean hasWindowFocus, WindowManager.LayoutParams windowAttribute) {
        if (!this.mHasImeFocus || ImeFocusController.isInLocalFocusMode(windowAttribute)) {
            return;
        }
        if (hasWindowFocus) {
            this.getImmDelegate().setCurrentRootView(this.mViewRootImpl);
        }
    }

    boolean updateImeFocusable(WindowManager.LayoutParams windowAttribute, boolean force) {
        boolean hasImeFocus = WindowManager.LayoutParams.mayUseInputMethod(windowAttribute.flags);
        if (force) {
            this.mHasImeFocus = hasImeFocus;
        }
        return hasImeFocus;
    }

    void onPostWindowFocus(View focusedView, boolean hasWindowFocus, WindowManager.LayoutParams windowAttribute) {
        boolean nextFocusIsServedView;
        if (!hasWindowFocus || !this.mHasImeFocus || ImeFocusController.isInLocalFocusMode(windowAttribute)) {
            return;
        }
        View viewForWindowFocus = focusedView != null ? focusedView : this.mViewRootImpl.mView;
        boolean forceFocus = false;
        InputMethodManagerDelegate immDelegate = this.getImmDelegate();
        if (immDelegate.isRestartOnNextWindowFocus(true)) {
            forceFocus = true;
        }
        this.onViewFocusChanged(viewForWindowFocus, true);
        boolean bl = nextFocusIsServedView = this.mServedView == viewForWindowFocus;
        if (nextFocusIsServedView && !immDelegate.hasActiveConnection(viewForWindowFocus)) {
            forceFocus = true;
        }
        immDelegate.startInputAsyncOnWindowFocusGain(viewForWindowFocus, windowAttribute.softInputMode, windowAttribute.flags, forceFocus);
    }

    public boolean checkFocus(boolean forceNewFocus, boolean startInput) {
        InputMethodManagerDelegate immDelegate = this.getImmDelegate();
        if (!immDelegate.isCurrentRootView(this.mViewRootImpl) || this.mServedView == this.mNextServedView && !forceNewFocus) {
            return false;
        }
        if (this.mNextServedView == null) {
            immDelegate.finishInput();
            immDelegate.closeCurrentIme();
            return false;
        }
        this.mServedView = this.mNextServedView;
        immDelegate.finishComposingText();
        if (startInput) {
            immDelegate.startInput(5, null, 0, 0, 0);
        }
        return true;
    }

    void onViewFocusChanged(View view, boolean hasFocus) {
        if (view == null || view.isTemporarilyDetached()) {
            return;
        }
        if (!this.getImmDelegate().isCurrentRootView(view.getViewRootImpl())) {
            return;
        }
        if (!view.hasImeFocus() || !view.hasWindowFocus()) {
            return;
        }
        if (hasFocus) {
            this.mNextServedView = view;
        }
        this.mViewRootImpl.dispatchCheckFocus();
    }

    void onViewDetachedFromWindow(View view) {
        if (!this.getImmDelegate().isCurrentRootView(view.getViewRootImpl())) {
            return;
        }
        if (this.mServedView == view) {
            this.mNextServedView = null;
            this.mViewRootImpl.dispatchCheckFocus();
        }
    }

    void onWindowDismissed() {
        InputMethodManagerDelegate immDelegate = this.getImmDelegate();
        if (!immDelegate.isCurrentRootView(this.mViewRootImpl)) {
            return;
        }
        if (this.mServedView != null) {
            immDelegate.finishInput();
        }
        immDelegate.setCurrentRootView(null);
        this.mHasImeFocus = false;
    }

    public void onInteractiveChanged(boolean interactive) {
        InputMethodManagerDelegate immDelegate = this.getImmDelegate();
        if (!immDelegate.isCurrentRootView(this.mViewRootImpl)) {
            return;
        }
        if (interactive) {
            View focusedView;
            this.onViewFocusChanged(focusedView, (focusedView = this.mViewRootImpl.mView.findFocus()) != null);
        } else {
            this.mDelegate.finishInputAndReportToIme();
        }
    }

    private static boolean isInLocalFocusMode(WindowManager.LayoutParams windowAttribute) {
        return (windowAttribute.flags & 0x10000000) != 0;
    }

    int onProcessImeInputStage(Object token, InputEvent event, WindowManager.LayoutParams windowAttribute, InputMethodManager.FinishedInputEventCallback callback2) {
        if (!this.mHasImeFocus || ImeFocusController.isInLocalFocusMode(windowAttribute)) {
            return 0;
        }
        InputMethodManager imm = this.mViewRootImpl.mContext.getSystemService(InputMethodManager.class);
        if (imm == null) {
            return 0;
        }
        return imm.dispatchInputEvent(event, token, callback2, this.mViewRootImpl.mHandler);
    }

    public View getServedView() {
        return this.mServedView;
    }

    public View getNextServedView() {
        return this.mNextServedView;
    }

    public void setServedView(View view) {
        this.mServedView = view;
    }

    public void setNextServedView(View view) {
        this.mNextServedView = view;
    }

    boolean hasImeFocus() {
        return this.mHasImeFocus;
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10800000001L, this.mHasImeFocus);
        proto.write(1138166333442L, Objects.toString(this.mServedView));
        proto.write(1138166333443L, Objects.toString(this.mNextServedView));
        proto.end(token);
    }

    public static interface InputMethodManagerDelegate {
        public boolean startInput(int var1, View var2, int var3, int var4, int var5);

        public void startInputAsyncOnWindowFocusGain(View var1, int var2, int var3, boolean var4);

        public void finishInput();

        public void finishInputAndReportToIme();

        public void closeCurrentIme();

        public void finishComposingText();

        public void setCurrentRootView(ViewRootImpl var1);

        public boolean isCurrentRootView(ViewRootImpl var1);

        public boolean isRestartOnNextWindowFocus(boolean var1);

        public boolean hasActiveConnection(View var1);
    }
}

