/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.util.MergedConfiguration;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.InputChannel;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.window.ClientWindowFrames;
import java.util.ArrayList;
import java.util.List;

public interface IWindowSession
extends IInterface {
    public int addToDisplay(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, InsetsState var5, InputChannel var6, InsetsState var7, InsetsSourceControl[] var8) throws RemoteException;

    public int addToDisplayAsUser(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, int var5, InsetsState var6, InputChannel var7, InsetsState var8, InsetsSourceControl[] var9) throws RemoteException;

    public int addToDisplayWithoutInputChannel(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, InsetsState var5) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:58:1:58:25")
    public void remove(IWindow var1) throws RemoteException;

    public int relayout(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, int var5, int var6, long var7, ClientWindowFrames var9, MergedConfiguration var10, SurfaceControl var11, InsetsState var12, InsetsSourceControl[] var13, Point var14) throws RemoteException;

    public void prepareToReplaceWindows(IBinder var1, boolean var2) throws RemoteException;

    public boolean outOfMemory(IWindow var1) throws RemoteException;

    public void setInsets(IWindow var1, int var2, Rect var3, Rect var4, Region var5) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:145:1:145:25")
    public void finishDrawing(IWindow var1, SurfaceControl.Transaction var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:148:1:148:25")
    public void setInTouchMode(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:150:1:150:25")
    public boolean getInTouchMode() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:153:1:153:25")
    public boolean performHapticFeedback(int var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:172:1:172:69")
    public IBinder performDrag(IWindow var1, int var2, SurfaceControl var3, int var4, float var5, float var6, float var7, float var8, ClipData var9) throws RemoteException;

    public void reportDropResult(IWindow var1, boolean var2) throws RemoteException;

    public void cancelDragAndDrop(IBinder var1, boolean var2) throws RemoteException;

    public void dragRecipientEntered(IWindow var1) throws RemoteException;

    public void dragRecipientExited(IWindow var1) throws RemoteException;

    public void setWallpaperPosition(IBinder var1, float var2, float var3, float var4, float var5) throws RemoteException;

    public void setWallpaperZoomOut(IBinder var1, float var2) throws RemoteException;

    public void setShouldZoomOutWallpaper(IBinder var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:221:1:221:25")
    public void wallpaperOffsetsComplete(IBinder var1) throws RemoteException;

    public void setWallpaperDisplayOffset(IBinder var1, int var2, int var3) throws RemoteException;

    public Bundle sendWallpaperCommand(IBinder var1, String var2, int var3, int var4, int var5, Bundle var6, boolean var7) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:232:1:232:25")
    public void wallpaperCommandComplete(IBinder var1, Bundle var2) throws RemoteException;

    public void onRectangleOnScreenRequested(IBinder var1, Rect var2) throws RemoteException;

    public IWindowId getWindowId(IBinder var1) throws RemoteException;

    public void pokeDrawLock(IBinder var1) throws RemoteException;

    public boolean startMovingTask(IWindow var1, float var2, float var3) throws RemoteException;

    public void finishMovingTask(IWindow var1) throws RemoteException;

    public void updatePointerIcon(IWindow var1) throws RemoteException;

    public void updateDisplayContentLocation(IWindow var1, int var2, int var3, int var4) throws RemoteException;

    public void updateTapExcludeRegion(IWindow var1, Region var2) throws RemoteException;

    public void insetsModified(IWindow var1, InsetsState var2) throws RemoteException;

    public void reportSystemGestureExclusionChanged(IWindow var1, List<Rect> var2) throws RemoteException;

    public void grantInputChannel(int var1, SurfaceControl var2, IWindow var3, IBinder var4, int var5, int var6, int var7, InputChannel var8) throws RemoteException;

    public void updateInputChannel(IBinder var1, int var2, SurfaceControl var3, int var4, int var5, Region var6) throws RemoteException;

    public void grantEmbeddedWindowFocus(IWindow var1, IBinder var2, boolean var3) throws RemoteException;

    public void generateDisplayHash(IWindow var1, Rect var2, String var3, RemoteCallback var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowSession {
        public static final String DESCRIPTOR = "android.view.IWindowSession";
        static final int TRANSACTION_addToDisplay = 1;
        static final int TRANSACTION_addToDisplayAsUser = 2;
        static final int TRANSACTION_addToDisplayWithoutInputChannel = 3;
        static final int TRANSACTION_remove = 4;
        static final int TRANSACTION_relayout = 5;
        static final int TRANSACTION_prepareToReplaceWindows = 6;
        static final int TRANSACTION_outOfMemory = 7;
        static final int TRANSACTION_setInsets = 8;
        static final int TRANSACTION_finishDrawing = 9;
        static final int TRANSACTION_setInTouchMode = 10;
        static final int TRANSACTION_getInTouchMode = 11;
        static final int TRANSACTION_performHapticFeedback = 12;
        static final int TRANSACTION_performDrag = 13;
        static final int TRANSACTION_reportDropResult = 14;
        static final int TRANSACTION_cancelDragAndDrop = 15;
        static final int TRANSACTION_dragRecipientEntered = 16;
        static final int TRANSACTION_dragRecipientExited = 17;
        static final int TRANSACTION_setWallpaperPosition = 18;
        static final int TRANSACTION_setWallpaperZoomOut = 19;
        static final int TRANSACTION_setShouldZoomOutWallpaper = 20;
        static final int TRANSACTION_wallpaperOffsetsComplete = 21;
        static final int TRANSACTION_setWallpaperDisplayOffset = 22;
        static final int TRANSACTION_sendWallpaperCommand = 23;
        static final int TRANSACTION_wallpaperCommandComplete = 24;
        static final int TRANSACTION_onRectangleOnScreenRequested = 25;
        static final int TRANSACTION_getWindowId = 26;
        static final int TRANSACTION_pokeDrawLock = 27;
        static final int TRANSACTION_startMovingTask = 28;
        static final int TRANSACTION_finishMovingTask = 29;
        static final int TRANSACTION_updatePointerIcon = 30;
        static final int TRANSACTION_updateDisplayContentLocation = 31;
        static final int TRANSACTION_updateTapExcludeRegion = 32;
        static final int TRANSACTION_insetsModified = 33;
        static final int TRANSACTION_reportSystemGestureExclusionChanged = 34;
        static final int TRANSACTION_grantInputChannel = 35;
        static final int TRANSACTION_updateInputChannel = 36;
        static final int TRANSACTION_grantEmbeddedWindowFocus = 37;
        static final int TRANSACTION_generateDisplayHash = 38;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWindowSession) {
                return (IWindowSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addToDisplay";
                }
                case 2: {
                    return "addToDisplayAsUser";
                }
                case 3: {
                    return "addToDisplayWithoutInputChannel";
                }
                case 4: {
                    return "remove";
                }
                case 5: {
                    return "relayout";
                }
                case 6: {
                    return "prepareToReplaceWindows";
                }
                case 7: {
                    return "outOfMemory";
                }
                case 8: {
                    return "setInsets";
                }
                case 9: {
                    return "finishDrawing";
                }
                case 10: {
                    return "setInTouchMode";
                }
                case 11: {
                    return "getInTouchMode";
                }
                case 12: {
                    return "performHapticFeedback";
                }
                case 13: {
                    return "performDrag";
                }
                case 14: {
                    return "reportDropResult";
                }
                case 15: {
                    return "cancelDragAndDrop";
                }
                case 16: {
                    return "dragRecipientEntered";
                }
                case 17: {
                    return "dragRecipientExited";
                }
                case 18: {
                    return "setWallpaperPosition";
                }
                case 19: {
                    return "setWallpaperZoomOut";
                }
                case 20: {
                    return "setShouldZoomOutWallpaper";
                }
                case 21: {
                    return "wallpaperOffsetsComplete";
                }
                case 22: {
                    return "setWallpaperDisplayOffset";
                }
                case 23: {
                    return "sendWallpaperCommand";
                }
                case 24: {
                    return "wallpaperCommandComplete";
                }
                case 25: {
                    return "onRectangleOnScreenRequested";
                }
                case 26: {
                    return "getWindowId";
                }
                case 27: {
                    return "pokeDrawLock";
                }
                case 28: {
                    return "startMovingTask";
                }
                case 29: {
                    return "finishMovingTask";
                }
                case 30: {
                    return "updatePointerIcon";
                }
                case 31: {
                    return "updateDisplayContentLocation";
                }
                case 32: {
                    return "updateTapExcludeRegion";
                }
                case 33: {
                    return "insetsModified";
                }
                case 34: {
                    return "reportSystemGestureExclusionChanged";
                }
                case 35: {
                    return "grantInputChannel";
                }
                case 36: {
                    return "updateInputChannel";
                }
                case 37: {
                    return "grantEmbeddedWindowFocus";
                }
                case 38: {
                    return "generateDisplayHash";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = 0 != data.readInt() ? WindowManager.LayoutParams.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    InsetsState _arg4 = 0 != data.readInt() ? InsetsState.CREATOR.createFromParcel(data) : null;
                    InputChannel _arg5 = new InputChannel();
                    InsetsState _arg6 = new InsetsState();
                    int _arg7_length = data.readInt();
                    Parcelable[] _arg7 = _arg7_length < 0 ? null : new InsetsSourceControl[_arg7_length];
                    int _result = this.addToDisplay(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, (InsetsSourceControl[])_arg7);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg5 != null) {
                        reply.writeInt(1);
                        _arg5.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    if (_arg6 != null) {
                        reply.writeInt(1);
                        _arg6.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    reply.writeTypedArray(_arg7, 1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = 0 != data.readInt() ? WindowManager.LayoutParams.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    InsetsState _arg5 = 0 != data.readInt() ? InsetsState.CREATOR.createFromParcel(data) : null;
                    InputChannel _arg6 = new InputChannel();
                    InsetsState _arg7 = new InsetsState();
                    int _arg8_length = data.readInt();
                    Parcelable[] _arg8 = _arg8_length < 0 ? null : new InsetsSourceControl[_arg8_length];
                    int _result = this.addToDisplayAsUser(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, (InsetsSourceControl[])_arg8);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg6 != null) {
                        reply.writeInt(1);
                        _arg6.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    if (_arg7 != null) {
                        reply.writeInt(1);
                        _arg7.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    reply.writeTypedArray(_arg8, 1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = 0 != data.readInt() ? WindowManager.LayoutParams.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    InsetsState _arg4 = new InsetsState();
                    int _result = this.addToDisplayWithoutInputChannel(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg4 != null) {
                        reply.writeInt(1);
                        _arg4.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    this.remove(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = 0 != data.readInt() ? WindowManager.LayoutParams.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    long _arg6 = data.readLong();
                    ClientWindowFrames _arg7 = new ClientWindowFrames();
                    MergedConfiguration _arg8 = new MergedConfiguration();
                    SurfaceControl _arg9 = new SurfaceControl();
                    InsetsState _arg10 = new InsetsState();
                    int _arg11_length = data.readInt();
                    Parcelable[] _arg11 = _arg11_length < 0 ? null : new InsetsSourceControl[_arg11_length];
                    Point _arg12 = new Point();
                    int _result = this.relayout(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10, (InsetsSourceControl[])_arg11, _arg12);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    if (_arg7 != null) {
                        reply.writeInt(1);
                        _arg7.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    if (_arg8 != null) {
                        reply.writeInt(1);
                        _arg8.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    if (_arg9 != null) {
                        reply.writeInt(1);
                        _arg9.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    if (_arg10 != null) {
                        reply.writeInt(1);
                        _arg10.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    reply.writeTypedArray(_arg11, 1);
                    if (_arg12 != null) {
                        reply.writeInt(1);
                        _arg12.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.prepareToReplaceWindows(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.outOfMemory(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    Rect _arg2 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    Rect _arg3 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    Region _arg4 = 0 != data.readInt() ? Region.CREATOR.createFromParcel(data) : null;
                    this.setInsets(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    SurfaceControl.Transaction _arg1 = 0 != data.readInt() ? SurfaceControl.Transaction.CREATOR.createFromParcel(data) : null;
                    this.finishDrawing(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setInTouchMode(_arg0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.getInTouchMode();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.performHapticFeedback(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    SurfaceControl _arg2 = 0 != data.readInt() ? SurfaceControl.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    float _arg4 = data.readFloat();
                    float _arg5 = data.readFloat();
                    float _arg6 = data.readFloat();
                    float _arg7 = data.readFloat();
                    ClipData _arg8 = 0 != data.readInt() ? ClipData.CREATOR.createFromParcel(data) : null;
                    IBinder _result = this.performDrag(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = 0 != data.readInt();
                    this.reportDropResult(_arg0, _arg1);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.cancelDragAndDrop(_arg0, _arg1);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    this.dragRecipientEntered(_arg0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    this.dragRecipientExited(_arg0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    float _arg3 = data.readFloat();
                    float _arg4 = data.readFloat();
                    this.setWallpaperPosition(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    float _arg1 = data.readFloat();
                    this.setWallpaperZoomOut(_arg0, _arg1);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.setShouldZoomOutWallpaper(_arg0, _arg1);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.wallpaperOffsetsComplete(_arg0);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.setWallpaperDisplayOffset(_arg0, _arg1, _arg2);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    Bundle _arg5 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    boolean _arg6 = 0 != data.readInt();
                    Bundle _result = this.sendWallpaperCommand(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.wallpaperCommandComplete(_arg0, _arg1);
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    Rect _arg1 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    this.onRectangleOnScreenRequested(_arg0, _arg1);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    IWindowId _result = this.getWindowId(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.pokeDrawLock(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    boolean _result = this.startMovingTask(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    this.finishMovingTask(_arg0);
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    this.updatePointerIcon(_arg0);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.updateDisplayContentLocation(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    Region _arg1 = 0 != data.readInt() ? Region.CREATOR.createFromParcel(data) : null;
                    this.updateTapExcludeRegion(_arg0, _arg1);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    InsetsState _arg1 = 0 != data.readInt() ? InsetsState.CREATOR.createFromParcel(data) : null;
                    this.insetsModified(_arg0, _arg1);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    ArrayList<Rect> _arg1 = data.createTypedArrayList(Rect.CREATOR);
                    this.reportSystemGestureExclusionChanged(_arg0, _arg1);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    SurfaceControl _arg1 = 0 != data.readInt() ? SurfaceControl.CREATOR.createFromParcel(data) : null;
                    IWindow _arg2 = IWindow.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg3 = data.readStrongBinder();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    InputChannel _arg7 = new InputChannel();
                    this.grantInputChannel(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    if (_arg7 != null) {
                        reply.writeInt(1);
                        _arg7.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    SurfaceControl _arg2 = 0 != data.readInt() ? SurfaceControl.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    Region _arg5 = 0 != data.readInt() ? Region.CREATOR.createFromParcel(data) : null;
                    this.updateInputChannel(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    boolean _arg2 = 0 != data.readInt();
                    this.grantEmbeddedWindowFocus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    Rect _arg1 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    RemoteCallback _arg3 = 0 != data.readInt() ? RemoteCallback.CREATOR.createFromParcel(data) : null;
                    this.generateDisplayHash(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IWindowSession impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IWindowSession getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IWindowSession {
            private IBinder mRemote;
            public static IWindowSession sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addToDisplay(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, InsetsState requestedVisibility, InputChannel outInputChannel, InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    if (attrs != null) {
                        _data.writeInt(1);
                        attrs.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(viewVisibility);
                    _data.writeInt(layerStackId);
                    if (requestedVisibility != null) {
                        _data.writeInt(1);
                        requestedVisibility.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (activeControls == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(activeControls.length);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().addToDisplay(window, attrs, viewVisibility, layerStackId, requestedVisibility, outInputChannel, insetsState, activeControls);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outInputChannel.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        insetsState.readFromParcel(_reply);
                    }
                    _reply.readTypedArray(activeControls, InsetsSourceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addToDisplayAsUser(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, int userId, InsetsState requestedVisibility, InputChannel outInputChannel, InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    if (attrs != null) {
                        _data.writeInt(1);
                        attrs.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(viewVisibility);
                    _data.writeInt(layerStackId);
                    _data.writeInt(userId);
                    if (requestedVisibility != null) {
                        _data.writeInt(1);
                        requestedVisibility.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (activeControls == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(activeControls.length);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().addToDisplayAsUser(window, attrs, viewVisibility, layerStackId, userId, requestedVisibility, outInputChannel, insetsState, activeControls);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outInputChannel.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        insetsState.readFromParcel(_reply);
                    }
                    _reply.readTypedArray(activeControls, InsetsSourceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addToDisplayWithoutInputChannel(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, InsetsState insetsState) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    if (attrs != null) {
                        _data.writeInt(1);
                        attrs.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(viewVisibility);
                    _data.writeInt(layerStackId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().addToDisplayWithoutInputChannel(window, attrs, viewVisibility, layerStackId, insetsState);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        insetsState.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().remove(window);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int relayout(IWindow window, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, long frameNumber, ClientWindowFrames outFrames, MergedConfiguration outMergedConfiguration, SurfaceControl outSurfaceControl, InsetsState insetsState, InsetsSourceControl[] activeControls, Point outSurfaceSize) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    if (attrs != null) {
                        _data.writeInt(1);
                        attrs.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(requestedWidth);
                    _data.writeInt(requestedHeight);
                    _data.writeInt(viewVisibility);
                    _data.writeInt(flags);
                    _data.writeLong(frameNumber);
                    if (activeControls == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(activeControls.length);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().relayout(window, attrs, requestedWidth, requestedHeight, viewVisibility, flags, frameNumber, outFrames, outMergedConfiguration, outSurfaceControl, insetsState, activeControls, outSurfaceSize);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outFrames.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        outMergedConfiguration.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        outSurfaceControl.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        insetsState.readFromParcel(_reply);
                    }
                    _reply.readTypedArray(activeControls, InsetsSourceControl.CREATOR);
                    if (0 != _reply.readInt()) {
                        outSurfaceSize.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareToReplaceWindows(IBinder appToken, boolean childrenOnly) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(appToken);
                    _data.writeInt(childrenOnly ? 1 : 0);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().prepareToReplaceWindows(appToken, childrenOnly);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean outOfMemory(IWindow window) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().outOfMemory(window);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    _data.writeInt(touchableInsets);
                    if (contentInsets != null) {
                        _data.writeInt(1);
                        contentInsets.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (visibleInsets != null) {
                        _data.writeInt(1);
                        visibleInsets.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (touchableRegion != null) {
                        _data.writeInt(1);
                        touchableRegion.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setInsets(window, touchableInsets, contentInsets, visibleInsets, touchableRegion);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishDrawing(IWindow window, SurfaceControl.Transaction postDrawTransaction) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    if (postDrawTransaction != null) {
                        _data.writeInt(1);
                        postDrawTransaction.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().finishDrawing(window, postDrawTransaction);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInTouchMode(boolean showFocus) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(showFocus ? 1 : 0);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setInTouchMode(showFocus);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getInTouchMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().getInTouchMode();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean performHapticFeedback(int effectId, boolean always) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(effectId);
                    _data.writeInt(always ? 1 : 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().performHapticFeedback(effectId, always);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder performDrag(IWindow window, int flags, SurfaceControl surface2, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    _data.writeInt(flags);
                    if (surface2 != null) {
                        _data.writeInt(1);
                        surface2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(touchSource);
                    _data.writeFloat(touchX);
                    _data.writeFloat(touchY);
                    _data.writeFloat(thumbCenterX);
                    _data.writeFloat(thumbCenterY);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IBinder iBinder = Stub.getDefaultImpl().performDrag(window, flags, surface2, touchSource, touchX, touchY, thumbCenterX, thumbCenterY, data);
                        return iBinder;
                    }
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportDropResult(IWindow window, boolean consumed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    _data.writeInt(consumed ? 1 : 0);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportDropResult(window, consumed);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelDragAndDrop(IBinder dragToken, boolean skipAnimation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(dragToken);
                    _data.writeInt(skipAnimation ? 1 : 0);
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelDragAndDrop(dragToken, skipAnimation);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dragRecipientEntered(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dragRecipientEntered(window);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dragRecipientExited(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dragRecipientExited(window);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperPosition(IBinder windowToken, float x, float y, float xstep, float ystep) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeFloat(x);
                    _data.writeFloat(y);
                    _data.writeFloat(xstep);
                    _data.writeFloat(ystep);
                    boolean _status = this.mRemote.transact(18, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setWallpaperPosition(windowToken, x, y, xstep, ystep);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperZoomOut(IBinder windowToken, float scale) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeFloat(scale);
                    boolean _status = this.mRemote.transact(19, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setWallpaperZoomOut(windowToken, scale);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldZoomOutWallpaper(IBinder windowToken, boolean shouldZoom) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(shouldZoom ? 1 : 0);
                    boolean _status = this.mRemote.transact(20, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setShouldZoomOutWallpaper(windowToken, shouldZoom);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wallpaperOffsetsComplete(IBinder window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    boolean _status = this.mRemote.transact(21, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().wallpaperOffsetsComplete(window);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperDisplayOffset(IBinder windowToken, int x, int y) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    boolean _status = this.mRemote.transact(22, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setWallpaperDisplayOffset(windowToken, x, y);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle sendWallpaperCommand(IBinder window, String action2, int x, int y, int z, Bundle extras, boolean sync) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    _data.writeString(action2);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeInt(z);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(sync ? 1 : 0);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Bundle bundle = Stub.getDefaultImpl().sendWallpaperCommand(window, action2, x, y, z, extras, sync);
                        return bundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Bundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wallpaperCommandComplete(IBinder window, Bundle result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    if (result != null) {
                        _data.writeInt(1);
                        result.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(24, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().wallpaperCommandComplete(window, result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (rectangle != null) {
                        _data.writeInt(1);
                        rectangle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(25, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRectangleOnScreenRequested(token, rectangle);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IWindowId getWindowId(IBinder window) throws RemoteException {
                IWindowId _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IWindowId iWindowId = Stub.getDefaultImpl().getWindowId(window);
                        return iWindowId;
                    }
                    _reply.readException();
                    _result = IWindowId.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pokeDrawLock(IBinder window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().pokeDrawLock(window);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startMovingTask(IWindow window, float startX, float startY) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    _data.writeFloat(startX);
                    _data.writeFloat(startY);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startMovingTask(window, startX, startY);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishMovingTask(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    boolean _status = this.mRemote.transact(29, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().finishMovingTask(window);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePointerIcon(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    boolean _status = this.mRemote.transact(30, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updatePointerIcon(window);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateDisplayContentLocation(IWindow window, int x, int y, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(31, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateDisplayContentLocation(window, x, y, displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateTapExcludeRegion(IWindow window, Region region) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    if (region != null) {
                        _data.writeInt(1);
                        region.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(32, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateTapExcludeRegion(window, region);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insetsModified(IWindow window, InsetsState state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    if (state != null) {
                        _data.writeInt(1);
                        state.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(33, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().insetsModified(window, state);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportSystemGestureExclusionChanged(IWindow window, List<Rect> exclusionRects) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    _data.writeTypedList(exclusionRects);
                    boolean _status = this.mRemote.transact(34, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportSystemGestureExclusionChanged(window, exclusionRects);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantInputChannel(int displayId, SurfaceControl surface2, IWindow window, IBinder hostInputToken, int flags, int privateFlags, int type, InputChannel outInputChannel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    if (surface2 != null) {
                        _data.writeInt(1);
                        surface2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    _data.writeStrongBinder(hostInputToken);
                    _data.writeInt(flags);
                    _data.writeInt(privateFlags);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().grantInputChannel(displayId, surface2, window, hostInputToken, flags, privateFlags, type, outInputChannel);
                        return;
                    }
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        outInputChannel.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateInputChannel(IBinder channelToken, int displayId, SurfaceControl surface2, int flags, int privateFlags, Region region) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(channelToken);
                    _data.writeInt(displayId);
                    if (surface2 != null) {
                        _data.writeInt(1);
                        surface2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    _data.writeInt(privateFlags);
                    if (region != null) {
                        _data.writeInt(1);
                        region.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(36, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateInputChannel(channelToken, displayId, surface2, flags, privateFlags, region);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantEmbeddedWindowFocus(IWindow window, IBinder inputToken, boolean grantFocus) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    _data.writeStrongBinder(inputToken);
                    _data.writeInt(grantFocus ? 1 : 0);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().grantEmbeddedWindowFocus(window, inputToken, grantFocus);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generateDisplayHash(IWindow window, Rect boundsInWindow, String hashAlgorithm, RemoteCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window != null ? window.asBinder() : null);
                    if (boundsInWindow != null) {
                        _data.writeInt(1);
                        boundsInWindow.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(hashAlgorithm);
                    if (callback2 != null) {
                        _data.writeInt(1);
                        callback2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(38, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().generateDisplayHash(window, boundsInWindow, hashAlgorithm, callback2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindowSession {
        @Override
        public int addToDisplay(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, InsetsState requestedVisibility, InputChannel outInputChannel, InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
            return 0;
        }

        @Override
        public int addToDisplayAsUser(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, int userId, InsetsState requestedVisibility, InputChannel outInputChannel, InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
            return 0;
        }

        @Override
        public int addToDisplayWithoutInputChannel(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, InsetsState insetsState) throws RemoteException {
            return 0;
        }

        @Override
        public void remove(IWindow window) throws RemoteException {
        }

        @Override
        public int relayout(IWindow window, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, long frameNumber, ClientWindowFrames outFrames, MergedConfiguration outMergedConfiguration, SurfaceControl outSurfaceControl, InsetsState insetsState, InsetsSourceControl[] activeControls, Point outSurfaceSize) throws RemoteException {
            return 0;
        }

        @Override
        public void prepareToReplaceWindows(IBinder appToken, boolean childrenOnly) throws RemoteException {
        }

        @Override
        public boolean outOfMemory(IWindow window) throws RemoteException {
            return false;
        }

        @Override
        public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) throws RemoteException {
        }

        @Override
        public void finishDrawing(IWindow window, SurfaceControl.Transaction postDrawTransaction) throws RemoteException {
        }

        @Override
        public void setInTouchMode(boolean showFocus) throws RemoteException {
        }

        @Override
        public boolean getInTouchMode() throws RemoteException {
            return false;
        }

        @Override
        public boolean performHapticFeedback(int effectId, boolean always) throws RemoteException {
            return false;
        }

        @Override
        public IBinder performDrag(IWindow window, int flags, SurfaceControl surface2, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) throws RemoteException {
            return null;
        }

        @Override
        public void reportDropResult(IWindow window, boolean consumed) throws RemoteException {
        }

        @Override
        public void cancelDragAndDrop(IBinder dragToken, boolean skipAnimation) throws RemoteException {
        }

        @Override
        public void dragRecipientEntered(IWindow window) throws RemoteException {
        }

        @Override
        public void dragRecipientExited(IWindow window) throws RemoteException {
        }

        @Override
        public void setWallpaperPosition(IBinder windowToken, float x, float y, float xstep, float ystep) throws RemoteException {
        }

        @Override
        public void setWallpaperZoomOut(IBinder windowToken, float scale) throws RemoteException {
        }

        @Override
        public void setShouldZoomOutWallpaper(IBinder windowToken, boolean shouldZoom) throws RemoteException {
        }

        @Override
        public void wallpaperOffsetsComplete(IBinder window) throws RemoteException {
        }

        @Override
        public void setWallpaperDisplayOffset(IBinder windowToken, int x, int y) throws RemoteException {
        }

        @Override
        public Bundle sendWallpaperCommand(IBinder window, String action2, int x, int y, int z, Bundle extras, boolean sync) throws RemoteException {
            return null;
        }

        @Override
        public void wallpaperCommandComplete(IBinder window, Bundle result) throws RemoteException {
        }

        @Override
        public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) throws RemoteException {
        }

        @Override
        public IWindowId getWindowId(IBinder window) throws RemoteException {
            return null;
        }

        @Override
        public void pokeDrawLock(IBinder window) throws RemoteException {
        }

        @Override
        public boolean startMovingTask(IWindow window, float startX, float startY) throws RemoteException {
            return false;
        }

        @Override
        public void finishMovingTask(IWindow window) throws RemoteException {
        }

        @Override
        public void updatePointerIcon(IWindow window) throws RemoteException {
        }

        @Override
        public void updateDisplayContentLocation(IWindow window, int x, int y, int displayId) throws RemoteException {
        }

        @Override
        public void updateTapExcludeRegion(IWindow window, Region region) throws RemoteException {
        }

        @Override
        public void insetsModified(IWindow window, InsetsState state) throws RemoteException {
        }

        @Override
        public void reportSystemGestureExclusionChanged(IWindow window, List<Rect> exclusionRects) throws RemoteException {
        }

        @Override
        public void grantInputChannel(int displayId, SurfaceControl surface2, IWindow window, IBinder hostInputToken, int flags, int privateFlags, int type, InputChannel outInputChannel) throws RemoteException {
        }

        @Override
        public void updateInputChannel(IBinder channelToken, int displayId, SurfaceControl surface2, int flags, int privateFlags, Region region) throws RemoteException {
        }

        @Override
        public void grantEmbeddedWindowFocus(IWindow window, IBinder inputToken, boolean grantFocus) throws RemoteException {
        }

        @Override
        public void generateDisplayHash(IWindow window, Rect boundsInWindow, String hashAlgorithm, RemoteCallback callback2) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

