/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.IScrollCaptureCallbacks;
import android.view.Surface;

public interface IScrollCaptureConnection
extends IInterface {
    public static final String DESCRIPTOR = "android.view.IScrollCaptureConnection";

    public ICancellationSignal startCapture(Surface var1, IScrollCaptureCallbacks var2) throws RemoteException;

    public ICancellationSignal requestImage(Rect var1) throws RemoteException;

    public ICancellationSignal endCapture() throws RemoteException;

    public void close() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IScrollCaptureConnection {
        static final int TRANSACTION_startCapture = 1;
        static final int TRANSACTION_requestImage = 2;
        static final int TRANSACTION_endCapture = 3;
        static final int TRANSACTION_close = 4;

        public Stub() {
            this.attachInterface(this, IScrollCaptureConnection.DESCRIPTOR);
        }

        public static IScrollCaptureConnection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IScrollCaptureConnection.DESCRIPTOR);
            if (iin != null && iin instanceof IScrollCaptureConnection) {
                return (IScrollCaptureConnection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startCapture";
                }
                case 2: {
                    return "requestImage";
                }
                case 3: {
                    return "endCapture";
                }
                case 4: {
                    return "close";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IScrollCaptureConnection.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    Surface _arg0 = 0 != data.readInt() ? Surface.CREATOR.createFromParcel(data) : null;
                    IScrollCaptureCallbacks _arg1 = IScrollCaptureCallbacks.Stub.asInterface(data.readStrongBinder());
                    ICancellationSignal _result = this.startCapture(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    Rect _arg0 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    ICancellationSignal _result = this.requestImage(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ICancellationSignal _result = this.endCapture();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.close();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IScrollCaptureConnection impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IScrollCaptureConnection getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IScrollCaptureConnection {
            private IBinder mRemote;
            public static IScrollCaptureConnection sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IScrollCaptureConnection.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal startCapture(Surface surface2, IScrollCaptureCallbacks callbacks) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureConnection.DESCRIPTOR);
                    if (surface2 != null) {
                        _data.writeInt(1);
                        surface2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callbacks != null ? callbacks.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ICancellationSignal iCancellationSignal = Stub.getDefaultImpl().startCapture(surface2, callbacks);
                        return iCancellationSignal;
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal requestImage(Rect captureArea) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureConnection.DESCRIPTOR);
                    if (captureArea != null) {
                        _data.writeInt(1);
                        captureArea.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ICancellationSignal iCancellationSignal = Stub.getDefaultImpl().requestImage(captureArea);
                        return iCancellationSignal;
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal endCapture() throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureConnection.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ICancellationSignal iCancellationSignal = Stub.getDefaultImpl().endCapture();
                        return iCancellationSignal;
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureConnection.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().close();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IScrollCaptureConnection {
        @Override
        public ICancellationSignal startCapture(Surface surface2, IScrollCaptureCallbacks callbacks) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal requestImage(Rect captureArea) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal endCapture() throws RemoteException {
            return null;
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

