/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.RemoteAction;
import android.content.ComponentName;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IPinnedTaskListener
extends IInterface {
    public static final String DESCRIPTOR = "android.view.IPinnedTaskListener";

    public void onMovementBoundsChanged(boolean var1) throws RemoteException;

    public void onImeVisibilityChanged(boolean var1, int var2) throws RemoteException;

    public void onActionsChanged(ParceledListSlice<RemoteAction> var1) throws RemoteException;

    public void onActivityHidden(ComponentName var1) throws RemoteException;

    public void onAspectRatioChanged(float var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPinnedTaskListener {
        static final int TRANSACTION_onMovementBoundsChanged = 1;
        static final int TRANSACTION_onImeVisibilityChanged = 2;
        static final int TRANSACTION_onActionsChanged = 3;
        static final int TRANSACTION_onActivityHidden = 4;
        static final int TRANSACTION_onAspectRatioChanged = 5;

        public Stub() {
            this.attachInterface(this, IPinnedTaskListener.DESCRIPTOR);
        }

        public static IPinnedTaskListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPinnedTaskListener.DESCRIPTOR);
            if (iin != null && iin instanceof IPinnedTaskListener) {
                return (IPinnedTaskListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onMovementBoundsChanged";
                }
                case 2: {
                    return "onImeVisibilityChanged";
                }
                case 3: {
                    return "onActionsChanged";
                }
                case 4: {
                    return "onActivityHidden";
                }
                case 5: {
                    return "onAspectRatioChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPinnedTaskListener.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.onMovementBoundsChanged(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    this.onImeVisibilityChanged(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ParceledListSlice _arg0 = 0 != data.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(data) : null;
                    this.onActionsChanged(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    this.onActivityHidden(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    float _arg0 = data.readFloat();
                    this.onAspectRatioChanged(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IPinnedTaskListener impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IPinnedTaskListener getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPinnedTaskListener {
            private IBinder mRemote;
            public static IPinnedTaskListener sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPinnedTaskListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMovementBoundsChanged(boolean fromImeAdjustment) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPinnedTaskListener.DESCRIPTOR);
                    _data.writeInt(fromImeAdjustment ? 1 : 0);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onMovementBoundsChanged(fromImeAdjustment);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImeVisibilityChanged(boolean imeVisible, int imeHeight) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPinnedTaskListener.DESCRIPTOR);
                    _data.writeInt(imeVisible ? 1 : 0);
                    _data.writeInt(imeHeight);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onImeVisibilityChanged(imeVisible, imeHeight);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActionsChanged(ParceledListSlice<RemoteAction> actions2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPinnedTaskListener.DESCRIPTOR);
                    if (actions2 != null) {
                        _data.writeInt(1);
                        actions2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onActionsChanged(actions2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityHidden(ComponentName componentName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPinnedTaskListener.DESCRIPTOR);
                    if (componentName != null) {
                        _data.writeInt(1);
                        componentName.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onActivityHidden(componentName);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAspectRatioChanged(float aspectRatio) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPinnedTaskListener.DESCRIPTOR);
                    _data.writeFloat(aspectRatio);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAspectRatioChanged(aspectRatio);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPinnedTaskListener {
        @Override
        public void onMovementBoundsChanged(boolean fromImeAdjustment) throws RemoteException {
        }

        @Override
        public void onImeVisibilityChanged(boolean imeVisible, int imeHeight) throws RemoteException {
        }

        @Override
        public void onActionsChanged(ParceledListSlice<RemoteAction> actions2) throws RemoteException {
        }

        @Override
        public void onActivityHidden(ComponentName componentName) throws RemoteException {
        }

        @Override
        public void onAspectRatioChanged(float aspectRatio) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

