/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Handler;
import android.view.HandlerActionQueue_Delegate;
import com.android.internal.util.GrowingArrayUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class HandlerActionQueue {
    private HandlerAction[] mActions;
    private int mCount;

    public void post(Runnable action2) {
        this.postDelayed(action2, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelayed_Original(Runnable action2, long delayMillis) {
        HandlerAction handlerAction = new HandlerAction(action2, delayMillis);
        HandlerActionQueue handlerActionQueue = this;
        synchronized (handlerActionQueue) {
            if (this.mActions == null) {
                this.mActions = new HandlerAction[4];
            }
            this.mActions = GrowingArrayUtils.append(this.mActions, this.mCount, handlerAction);
            ++this.mCount;
        }
    }

    @LayoutlibDelegate
    public void postDelayed(Runnable runnable, long l) {
        HandlerActionQueue_Delegate.postDelayed(this, runnable, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallbacks(Runnable action2) {
        HandlerActionQueue handlerActionQueue = this;
        synchronized (handlerActionQueue) {
            int count = this.mCount;
            int j = 0;
            HandlerAction[] actions2 = this.mActions;
            for (int i = 0; i < count; ++i) {
                if (actions2[i].matches(action2)) continue;
                if (j != i) {
                    actions2[j] = actions2[i];
                }
                ++j;
            }
            this.mCount = j;
            while (j < count) {
                actions2[j] = null;
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeActions(Handler handler) {
        HandlerActionQueue handlerActionQueue = this;
        synchronized (handlerActionQueue) {
            HandlerAction[] actions2 = this.mActions;
            int count = this.mCount;
            for (int i = 0; i < count; ++i) {
                HandlerAction handlerAction = actions2[i];
                handler.postDelayed(handlerAction.action, handlerAction.delay);
            }
            this.mActions = null;
            this.mCount = 0;
        }
    }

    public int size() {
        return this.mCount;
    }

    public Runnable getRunnable(int index) {
        if (index >= this.mCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.mActions[index].action;
    }

    public long getDelay(int index) {
        if (index >= this.mCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.mActions[index].delay;
    }

    private static class HandlerAction {
        final Runnable action;
        final long delay;

        public HandlerAction(Runnable action2, long delay) {
            this.action = action2;
            this.delay = delay;
        }

        public boolean matches(Runnable otherAction) {
            return otherAction == null && this.action == null || this.action != null && this.action.equals(otherAction);
        }
    }
}

