/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.ColorSpace;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.BrightnessInfo;
import android.hardware.display.DeviceProductInfo;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.view.DisplayAddress;
import android.view.DisplayAdjustments;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.Display_Delegate;
import android.view.RoundedCorner;
import android.view.RoundedCorners;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;

public class Display {
    private static final String TAG = "Display";
    private static final boolean DEBUG = false;
    private final Object mLock = new Object();
    private final DisplayManagerGlobal mGlobal;
    private final int mDisplayId;
    private final int mFlags;
    private final int mType;
    private final int mOwnerUid;
    private final String mOwnerPackageName;
    private final Resources mResources;
    private DisplayAdjustments mDisplayAdjustments;
    @UnsupportedAppUsage
    private DisplayInfo mDisplayInfo;
    private boolean mIsValid;
    private final DisplayMetrics mTempMetrics = new DisplayMetrics();
    private static final int CACHED_APP_SIZE_DURATION_MILLIS = 20;
    private long mLastCachedAppSizeUpdate;
    private int mCachedAppWidthCompat;
    private int mCachedAppHeightCompat;
    private boolean mMayAdjustByFixedRotation;
    private Optional<Boolean> mIsRecentsComponent = Optional.empty();
    public static final int DEFAULT_DISPLAY = 0;
    public static final int INVALID_DISPLAY = -1;
    public static final int DEFAULT_DISPLAY_GROUP = 0;
    public static final int INVALID_DISPLAY_GROUP = -1;
    public static final int FLAG_SUPPORTS_PROTECTED_BUFFERS = 1;
    public static final int FLAG_SECURE = 2;
    public static final int FLAG_PRIVATE = 4;
    public static final int FLAG_PRESENTATION = 8;
    public static final int FLAG_ROUND = 16;
    public static final int FLAG_CAN_SHOW_WITH_INSECURE_KEYGUARD = 32;
    public static final int FLAG_SHOULD_SHOW_SYSTEM_DECORATIONS = 64;
    public static final int FLAG_TRUSTED = 128;
    public static final int FLAG_OWN_DISPLAY_GROUP = 256;
    public static final int FLAG_SCALING_DISABLED = 0x40000000;
    @UnsupportedAppUsage
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_INTERNAL = 1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int TYPE_EXTERNAL = 2;
    @UnsupportedAppUsage
    public static final int TYPE_WIFI = 3;
    public static final int TYPE_OVERLAY = 4;
    @UnsupportedAppUsage
    public static final int TYPE_VIRTUAL = 5;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_OFF = 1;
    public static final int STATE_ON = 2;
    public static final int STATE_DOZE = 3;
    public static final int STATE_DOZE_SUSPEND = 4;
    public static final int STATE_VR = 5;
    public static final int STATE_ON_SUSPEND = 6;
    public static final int COLOR_MODE_INVALID = -1;
    public static final int COLOR_MODE_DEFAULT = 0;
    public static final int COLOR_MODE_BT601_625 = 1;
    public static final int COLOR_MODE_BT601_625_UNADJUSTED = 2;
    public static final int COLOR_MODE_BT601_525 = 3;
    public static final int COLOR_MODE_BT601_525_UNADJUSTED = 4;
    public static final int COLOR_MODE_BT709 = 5;
    public static final int COLOR_MODE_DCI_P3 = 6;
    public static final int COLOR_MODE_SRGB = 7;
    public static final int COLOR_MODE_ADOBE_RGB = 8;
    public static final int COLOR_MODE_DISPLAY_P3 = 9;
    public static final int REMOVE_MODE_MOVE_CONTENT_TO_PRIMARY = 0;
    public static final int REMOVE_MODE_DESTROY_CONTENT = 1;
    public static final int DISPLAY_MODE_ID_FOR_FRAME_RATE_OVERRIDE = 255;

    public Display(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, DisplayAdjustments daj) {
        this(global, displayId, displayInfo, daj, null);
    }

    public Display(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, Resources res) {
        this(global, displayId, displayInfo, null, res);
    }

    private Display(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, DisplayAdjustments daj, Resources res) {
        this.mGlobal = global;
        this.mDisplayId = displayId;
        this.mDisplayInfo = displayInfo;
        this.mResources = res;
        this.mDisplayAdjustments = this.mResources != null ? new DisplayAdjustments(this.mResources.getConfiguration()) : (daj != null ? new DisplayAdjustments(daj) : new DisplayAdjustments());
        this.mIsValid = true;
        this.mFlags = displayInfo.flags;
        this.mType = displayInfo.type;
        this.mOwnerUid = displayInfo.ownerUid;
        this.mOwnerPackageName = displayInfo.ownerPackageName;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    public String getUniqueId() {
        return this.mDisplayInfo.uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mIsValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean getDisplayInfo(DisplayInfo outDisplayInfo) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            outDisplayInfo.copyFrom(this.mDisplayInfo);
            return this.mIsValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLayerStack() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.layerStack;
        }
    }

    public int getFlags() {
        return this.mFlags;
    }

    @UnsupportedAppUsage
    public int getType() {
        return this.mType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayAddress getAddress() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.address;
        }
    }

    public int getOwnerUid() {
        return this.mOwnerUid;
    }

    @UnsupportedAppUsage
    public String getOwnerPackageName() {
        return this.mOwnerPackageName;
    }

    @UnsupportedAppUsage
    public DisplayAdjustments getDisplayAdjustments() {
        DisplayAdjustments currentAdjustments;
        if (this.mResources != null && !this.mDisplayAdjustments.equals(currentAdjustments = this.mResources.getDisplayAdjustments())) {
            this.mDisplayAdjustments = new DisplayAdjustments(currentAdjustments);
        }
        return this.mDisplayAdjustments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getBrightnessDefault() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.brightnessDefault;
        }
    }

    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public BrightnessInfo getBrightnessInfo() {
        return this.mGlobal.getBrightnessInfo(this.mDisplayId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void getSize(Point outSize) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.getDisplayAdjustments());
            outSize.x = this.mTempMetrics.widthPixels;
            outSize.y = this.mTempMetrics.heightPixels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void getRectSize(Rect outSize) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.getDisplayAdjustments());
            outSize.set(0, 0, this.mTempMetrics.widthPixels, this.mTempMetrics.heightPixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCurrentSizeRange(Point outSmallestSize, Point outLargestSize) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            outSmallestSize.x = this.mDisplayInfo.smallestNominalAppWidth;
            outSmallestSize.y = this.mDisplayInfo.smallestNominalAppHeight;
            outLargestSize.x = this.mDisplayInfo.largestNominalAppWidth;
            outLargestSize.y = this.mDisplayInfo.largestNominalAppHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public int getMaximumSizeDimension() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return Math.max(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppWidthCompat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppHeightCompat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRotation() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mMayAdjustByFixedRotation ? this.getDisplayAdjustments().getRotation(this.mDisplayInfo.rotation) : this.mDisplayInfo.rotation;
        }
    }

    @Deprecated
    public int getOrientation() {
        return this.getRotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayCutout getCutout() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mMayAdjustByFixedRotation ? this.getDisplayAdjustments().getDisplayCutout(this.mDisplayInfo.displayCutout) : this.mDisplayInfo.displayCutout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"VisiblySynchronized"})
    public RoundedCorner getRoundedCorner(int position) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            RoundedCorners roundedCorners = this.mMayAdjustByFixedRotation ? this.getDisplayAdjustments().adjustRoundedCorner(this.mDisplayInfo.roundedCorners, this.mDisplayInfo.rotation, this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight) : this.mDisplayInfo.roundedCorners;
            return roundedCorners == null ? null : roundedCorners.getRoundedCorner(position);
        }
    }

    @Deprecated
    public int getPixelFormat() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getRefreshRate() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getRefreshRate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public float[] getSupportedRefreshRates() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getDefaultRefreshRates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mode getMode() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mode[] getSupportedModes() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            Mode[] modes = this.mDisplayInfo.supportedModes;
            return Arrays.copyOf(modes, modes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"VisiblySynchronized"})
    public boolean isMinimalPostProcessingSupported() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.minimalPostProcessingSupported;
        }
    }

    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_COLOR_MODE")
    public void requestColorMode(int colorMode) {
        this.mGlobal.requestColorMode(this.mDisplayId, colorMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColorMode() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.colorMode;
        }
    }

    public int getRemoveMode() {
        return this.mDisplayInfo.removeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HdrCapabilities getHdrCapabilities() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (this.mDisplayInfo.userDisabledHdrTypes.length == 0) {
                return this.mDisplayInfo.hdrCapabilities;
            }
            if (this.mDisplayInfo.hdrCapabilities == null) {
                return null;
            }
            ArraySet<Integer> enabledTypesSet = new ArraySet<Integer>();
            for (int supportedType : this.mDisplayInfo.hdrCapabilities.getSupportedHdrTypes()) {
                boolean typeDisabled = false;
                for (int userDisabledType : this.mDisplayInfo.userDisabledHdrTypes) {
                    if (supportedType != userDisabledType) continue;
                    typeDisabled = true;
                    break;
                }
                if (typeDisabled) continue;
                enabledTypesSet.add(supportedType);
            }
            int[] enabledTypes = new int[enabledTypesSet.size()];
            int index = 0;
            Iterator iterator = enabledTypesSet.iterator();
            while (iterator.hasNext()) {
                int enabledType = (Integer)iterator.next();
                enabledTypes[index++] = enabledType;
            }
            return new HdrCapabilities(enabledTypes, this.mDisplayInfo.hdrCapabilities.mMaxLuminance, this.mDisplayInfo.hdrCapabilities.mMaxAverageLuminance, this.mDisplayInfo.hdrCapabilities.mMinLuminance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getReportedHdrTypes() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (this.mDisplayInfo.hdrCapabilities == null) {
                return new int[0];
            }
            return this.mDisplayInfo.hdrCapabilities.getSupportedHdrTypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHdr() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            HdrCapabilities hdrCapabilities = this.getHdrCapabilities();
            if (hdrCapabilities == null) {
                return false;
            }
            return hdrCapabilities.getSupportedHdrTypes().length != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWideColorGamut() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.isWideColorGamut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorSpace getPreferredWideGamutColorSpace() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (this.mDisplayInfo.isWideColorGamut()) {
                return this.mGlobal.getPreferredWideGamutColorSpace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getSupportedColorModes() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            int[] colorModes = this.mDisplayInfo.supportedColorModes;
            return Arrays.copyOf(colorModes, colorModes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"VisiblySynchronized"})
    public ColorSpace[] getSupportedWideColorGamut() {
        Object object = this.mLock;
        synchronized (object) {
            ColorSpace[] defaultColorSpaces = new ColorSpace[]{};
            this.updateDisplayInfoLocked();
            if (!this.isWideColorGamut()) {
                return defaultColorSpaces;
            }
            int[] colorModes = this.getSupportedColorModes();
            ArrayList<ColorSpace> colorSpaces = new ArrayList<ColorSpace>();
            block7: for (int colorMode : colorModes) {
                switch (colorMode) {
                    case 6: {
                        colorSpaces.add(ColorSpace.get(ColorSpace.Named.DCI_P3));
                        continue block7;
                    }
                    case 9: {
                        colorSpaces.add(ColorSpace.get(ColorSpace.Named.DISPLAY_P3));
                    }
                }
            }
            return colorSpaces.toArray(defaultColorSpaces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAppVsyncOffsetNanos() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.appVsyncOffsetNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPresentationDeadlineNanos() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.presentationDeadlineNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceProductInfo getDeviceProductInfo() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.deviceProductInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void getMetrics(DisplayMetrics outMetrics) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(outMetrics, this.getDisplayAdjustments());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void getRealSize(Point outSize) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (this.shouldReportMaxBounds()) {
                Rect bounds2 = this.mResources.getConfiguration().windowConfiguration.getMaxBounds();
                outSize.x = bounds2.width();
                outSize.y = bounds2.height();
                return;
            }
            outSize.x = this.mDisplayInfo.logicalWidth;
            outSize.y = this.mDisplayInfo.logicalHeight;
            if (this.mMayAdjustByFixedRotation) {
                this.getDisplayAdjustments().adjustSize(outSize, this.mDisplayInfo.rotation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void getRealMetrics(DisplayMetrics outMetrics) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (this.shouldReportMaxBounds()) {
                this.mDisplayInfo.getMaxBoundsMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, this.mResources.getConfiguration());
                return;
            }
            this.mDisplayInfo.getLogicalMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
            if (this.mMayAdjustByFixedRotation) {
                this.getDisplayAdjustments().adjustMetrics(outMetrics, this.mDisplayInfo.rotation);
            }
        }
    }

    private boolean shouldReportMaxBounds() {
        if (this.mResources == null) {
            return false;
        }
        Configuration config = this.mResources.getConfiguration();
        return config != null && !config.windowConfiguration.getMaxBounds().isEmpty() && !this.isRecentsComponent();
    }

    boolean isRecentsComponent() {
        if (this.mIsRecentsComponent.isPresent()) {
            return this.mIsRecentsComponent.get();
        }
        if (this.mResources == null) {
            return false;
        }
        try {
            String recentsComponent = this.mResources.getString(17039985);
            if (recentsComponent == null) {
                return false;
            }
            String recentsPackage = ComponentName.unflattenFromString(recentsComponent).getPackageName();
            this.mIsRecentsComponent = Optional.of(recentsPackage != null && recentsPackage.equals(ActivityThread.currentPackageName()));
            return this.mIsRecentsComponent.get();
        }
        catch (Resources.NotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mIsValid ? this.mDisplayInfo.state : 0;
        }
    }

    public boolean hasAccess(int uid) {
        return Display.hasAccess(uid, this.mFlags, this.mOwnerUid, this.mDisplayId);
    }

    public static boolean hasAccess(int uid, int flags, int ownerUid, int displayId) {
        return (flags & 4) == 0 || uid == ownerUid || uid == 1000 || uid == 0 || DisplayManagerGlobal.getInstance().isUidPresentOnDisplay(uid, displayId);
    }

    public boolean isPublicPresentation() {
        return (this.mFlags & 0xC) == 8;
    }

    public boolean isTrusted() {
        return (this.mFlags & 0x80) == 128;
    }

    void updateDisplayInfoLocked_Original() {
        DisplayInfo newInfo = this.mGlobal.getDisplayInfo(this.mDisplayId);
        if (newInfo == null) {
            if (this.mIsValid) {
                this.mIsValid = false;
            }
        } else {
            this.mDisplayInfo = newInfo;
            if (!this.mIsValid) {
                this.mIsValid = true;
            }
        }
        this.mMayAdjustByFixedRotation = this.mResources != null && this.mResources.hasOverrideDisplayAdjustments();
    }

    @LayoutlibDelegate
    private void updateDisplayInfoLocked() {
        Display_Delegate.updateDisplayInfoLocked(this);
    }

    private void updateCachedAppSizeIfNeededLocked() {
        long now = SystemClock.uptimeMillis();
        if (now > this.mLastCachedAppSizeUpdate + 20L) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.getDisplayAdjustments());
            this.mCachedAppWidthCompat = this.mTempMetrics.widthPixels;
            this.mCachedAppHeightCompat = this.mTempMetrics.heightPixels;
            this.mLastCachedAppSizeUpdate = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            DisplayAdjustments adjustments = this.getDisplayAdjustments();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, adjustments);
            return "Display id " + this.mDisplayId + ": " + this.mDisplayInfo + (this.mMayAdjustByFixedRotation ? ", " + adjustments.getFixedRotationAdjustments() + ", " : ", ") + this.mTempMetrics + ", isValid=" + this.mIsValid;
        }
    }

    public static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "INTERNAL";
            }
            case 2: {
                return "EXTERNAL";
            }
            case 3: {
                return "WIFI";
            }
            case 4: {
                return "OVERLAY";
            }
            case 5: {
                return "VIRTUAL";
            }
        }
        return Integer.toString(type);
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "ON";
            }
            case 3: {
                return "DOZE";
            }
            case 4: {
                return "DOZE_SUSPEND";
            }
            case 5: {
                return "VR";
            }
            case 6: {
                return "ON_SUSPEND";
            }
        }
        return Integer.toString(state);
    }

    public static boolean isSuspendedState(int state) {
        return state == 1 || state == 4 || state == 6;
    }

    public static boolean isDozeState(int state) {
        return state == 3 || state == 4;
    }

    public static boolean isActiveState(int state) {
        return state == 2 || state == 5;
    }

    public static boolean isOffState(int state) {
        return state == 1;
    }

    public static boolean isOnState(int state) {
        return state == 2 || state == 5 || state == 6;
    }

    public static class HdrCapabilities
    implements Parcelable {
        public static final float INVALID_LUMINANCE = -1.0f;
        public static final int HDR_TYPE_DOLBY_VISION = 1;
        public static final int HDR_TYPE_HDR10 = 2;
        public static final int HDR_TYPE_HLG = 3;
        public static final int HDR_TYPE_HDR10_PLUS = 4;
        public static final int[] HDR_TYPES = new int[]{1, 2, 3, 4};
        private int[] mSupportedHdrTypes = new int[0];
        private float mMaxLuminance = -1.0f;
        private float mMaxAverageLuminance = -1.0f;
        private float mMinLuminance = -1.0f;
        public static final Parcelable.Creator<HdrCapabilities> CREATOR = new Parcelable.Creator<HdrCapabilities>(){

            @Override
            public HdrCapabilities createFromParcel(Parcel source) {
                return new HdrCapabilities(source);
            }

            public HdrCapabilities[] newArray(int size) {
                return new HdrCapabilities[size];
            }
        };

        public HdrCapabilities() {
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public HdrCapabilities(int[] supportedHdrTypes, float maxLuminance, float maxAverageLuminance, float minLuminance) {
            this.mSupportedHdrTypes = supportedHdrTypes;
            Arrays.sort(this.mSupportedHdrTypes);
            this.mMaxLuminance = maxLuminance;
            this.mMaxAverageLuminance = maxAverageLuminance;
            this.mMinLuminance = minLuminance;
        }

        public int[] getSupportedHdrTypes() {
            return this.mSupportedHdrTypes;
        }

        public float getDesiredMaxLuminance() {
            return this.mMaxLuminance;
        }

        public float getDesiredMaxAverageLuminance() {
            return this.mMaxAverageLuminance;
        }

        public float getDesiredMinLuminance() {
            return this.mMinLuminance;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HdrCapabilities)) {
                return false;
            }
            HdrCapabilities that = (HdrCapabilities)other;
            return Arrays.equals(this.mSupportedHdrTypes, that.mSupportedHdrTypes) && this.mMaxLuminance == that.mMaxLuminance && this.mMaxAverageLuminance == that.mMaxAverageLuminance && this.mMinLuminance == that.mMinLuminance;
        }

        public int hashCode() {
            int hash2 = 23;
            hash2 = hash2 * 17 + Arrays.hashCode(this.mSupportedHdrTypes);
            hash2 = hash2 * 17 + Float.floatToIntBits(this.mMaxLuminance);
            hash2 = hash2 * 17 + Float.floatToIntBits(this.mMaxAverageLuminance);
            hash2 = hash2 * 17 + Float.floatToIntBits(this.mMinLuminance);
            return hash2;
        }

        private HdrCapabilities(Parcel source) {
            this.readFromParcel(source);
        }

        public void readFromParcel(Parcel source) {
            int types = source.readInt();
            this.mSupportedHdrTypes = new int[types];
            for (int i = 0; i < types; ++i) {
                this.mSupportedHdrTypes[i] = source.readInt();
            }
            this.mMaxLuminance = source.readFloat();
            this.mMaxAverageLuminance = source.readFloat();
            this.mMinLuminance = source.readFloat();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mSupportedHdrTypes.length);
            for (int i = 0; i < this.mSupportedHdrTypes.length; ++i) {
                dest.writeInt(this.mSupportedHdrTypes[i]);
            }
            dest.writeFloat(this.mMaxLuminance);
            dest.writeFloat(this.mMaxAverageLuminance);
            dest.writeFloat(this.mMinLuminance);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "HdrCapabilities{mSupportedHdrTypes=" + Arrays.toString(this.mSupportedHdrTypes) + ", mMaxLuminance=" + this.mMaxLuminance + ", mMaxAverageLuminance=" + this.mMaxAverageLuminance + ", mMinLuminance=" + this.mMinLuminance + '}';
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface HdrType {
        }
    }

    public static class Mode
    implements Parcelable {
        public static final Mode[] EMPTY_ARRAY = new Mode[0];
        private final int mModeId;
        private final int mWidth;
        private final int mHeight;
        private final float mRefreshRate;
        private final float[] mAlternativeRefreshRates;
        public static final Parcelable.Creator<Mode> CREATOR = new Parcelable.Creator<Mode>(){

            @Override
            public Mode createFromParcel(Parcel in) {
                return new Mode(in);
            }

            public Mode[] newArray(int size) {
                return new Mode[size];
            }
        };

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public Mode(int modeId, int width, int height, float refreshRate) {
            this(modeId, width, height, refreshRate, new float[0]);
        }

        public Mode(int modeId, int width, int height, float refreshRate, float[] alternativeRefreshRates) {
            this.mModeId = modeId;
            this.mWidth = width;
            this.mHeight = height;
            this.mRefreshRate = refreshRate;
            this.mAlternativeRefreshRates = Arrays.copyOf(alternativeRefreshRates, alternativeRefreshRates.length);
            Arrays.sort(this.mAlternativeRefreshRates);
        }

        public int getModeId() {
            return this.mModeId;
        }

        public int getPhysicalWidth() {
            return this.mWidth;
        }

        public int getPhysicalHeight() {
            return this.mHeight;
        }

        public float getRefreshRate() {
            return this.mRefreshRate;
        }

        public float[] getAlternativeRefreshRates() {
            return this.mAlternativeRefreshRates;
        }

        public boolean matches(int width, int height, float refreshRate) {
            return this.mWidth == width && this.mHeight == height && Float.floatToIntBits(this.mRefreshRate) == Float.floatToIntBits(refreshRate);
        }

        public boolean equalsExceptRefreshRate(Mode other) {
            return this.mWidth == other.mWidth && this.mHeight == other.mHeight;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Mode)) {
                return false;
            }
            Mode that = (Mode)other;
            return this.mModeId == that.mModeId && this.matches(that.mWidth, that.mHeight, that.mRefreshRate) && Arrays.equals(this.mAlternativeRefreshRates, that.mAlternativeRefreshRates);
        }

        public int hashCode() {
            int hash2 = 1;
            hash2 = hash2 * 17 + this.mModeId;
            hash2 = hash2 * 17 + this.mWidth;
            hash2 = hash2 * 17 + this.mHeight;
            hash2 = hash2 * 17 + Float.floatToIntBits(this.mRefreshRate);
            hash2 = hash2 * 17 + Arrays.hashCode(this.mAlternativeRefreshRates);
            return hash2;
        }

        public String toString() {
            return "{" + "id=" + this.mModeId + ", width=" + this.mWidth + ", height=" + this.mHeight + ", fps=" + this.mRefreshRate + ", alternativeRefreshRates=" + Arrays.toString(this.mAlternativeRefreshRates) + "}";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        private Mode(Parcel in) {
            this(in.readInt(), in.readInt(), in.readInt(), in.readFloat(), in.createFloatArray());
        }

        @Override
        public void writeToParcel(Parcel out, int parcelableFlags) {
            out.writeInt(this.mModeId);
            out.writeInt(this.mWidth);
            out.writeInt(this.mHeight);
            out.writeFloat(this.mRefreshRate);
            out.writeFloatArray(this.mAlternativeRefreshRates);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorMode {
    }
}

