/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.view.Choreographer;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.Optional;

public class Choreographer_Delegate {
    @LayoutlibDelegate
    public static float getRefreshRate() {
        return 60.0f;
    }

    @LayoutlibDelegate
    public static void postCallbackDelayedInternal(Choreographer thiz, int callbackType, Object action2, Object token, long delayMillis) {
        BridgeContext context = RenderAction.getCurrentContext();
        if (context == null) {
            if (!Thread.currentThread().getName().equals("kotlinx.coroutines.DefaultExecutor")) {
                return;
            }
            ClassLoader moduleClassLoader = Choreographer_Delegate.findCallingClassLoader();
            if (moduleClassLoader == null) {
                return;
            }
            context = RenderAction.findContextFor(moduleClassLoader);
            if (context == null) {
                return;
            }
        }
        if (callbackType != 1) {
            return;
        }
        if (action2 == null) {
            Bridge.getLog().error("broken", "Callback with null action", null, null);
        }
        context.getSessionInteractiveData().getChoreographerCallbacks().add(action2, delayMillis);
    }

    @LayoutlibDelegate
    public static void removeCallbacksInternal(Choreographer thiz, int callbackType, Object action2, Object token) {
        BridgeContext context = RenderAction.getCurrentContext();
        if (context == null) {
            return;
        }
        if (callbackType != 1) {
            return;
        }
        if (action2 == null) {
            Bridge.getLog().error("broken", "Callback with null action", null, null);
        }
        context.getSessionInteractiveData().getChoreographerCallbacks().remove(action2);
    }

    @LayoutlibDelegate
    public static long getFrameTimeNanos(Choreographer thiz) {
        return System.nanoTime();
    }

    private static ClassLoader findCallingClassLoader() {
        ClassLoader current = Choreographer_Delegate.class.getClassLoader();
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        try {
            return walker.walk(stackFrameStream -> {
                Optional<StackWalker.StackFrame> stackFrame = stackFrameStream.filter(sf -> sf.getDeclaringClass().getClassLoader() != current).findFirst();
                return stackFrame.map(f -> f.getDeclaringClass().getClassLoader()).orElse(null);
            });
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

