/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.Binder;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.IUwbAdapter;
import android.uwb.RangingReport;
import android.uwb.SessionHandle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@SystemApi
public class RangingSession
implements AutoCloseable {
    private static final String TAG = "Uwb.RangingSession";
    private final SessionHandle mSessionHandle;
    private final IUwbAdapter mAdapter;
    private final Executor mExecutor;
    private final Callback mCallback;
    private State mState = State.INIT;

    public RangingSession(Executor executor, Callback callback2, IUwbAdapter adapter, SessionHandle sessionHandle) {
        this.mExecutor = executor;
        this.mCallback = callback2;
        this.mAdapter = adapter;
        this.mSessionHandle = sessionHandle;
    }

    public boolean isOpen() {
        return this.mState == State.IDLE || this.mState == State.ACTIVE;
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void start(PersistableBundle params) {
        if (this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.startRanging(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void reconfigure(PersistableBundle params) {
        if (this.mState != State.ACTIVE && this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.reconfigureRanging(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void stop() {
        if (this.mState != State.ACTIVE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.stopRanging(this.mSessionHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void close() {
        if (this.mState == State.CLOSED) {
            this.mExecutor.execute(() -> this.mCallback.onClosed(1, new PersistableBundle()));
            return;
        }
        try {
            this.mAdapter.closeRanging(this.mSessionHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void onRangingOpened() {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingOpened invoked for a closed session");
            return;
        }
        this.mState = State.IDLE;
        this.executeCallback(() -> this.mCallback.onOpened(this));
    }

    public void onRangingOpenFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingOpenFailed invoked for a closed session");
            return;
        }
        this.mState = State.CLOSED;
        this.executeCallback(() -> this.mCallback.onOpenFailed(reason, params));
    }

    public void onRangingStarted(PersistableBundle parameters) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingStarted invoked for a closed session");
            return;
        }
        this.mState = State.ACTIVE;
        this.executeCallback(() -> this.mCallback.onStarted(parameters));
    }

    public void onRangingStartFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingStartFailed invoked for a closed session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onStartFailed(reason, params));
    }

    public void onRangingReconfigured(PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingReconfigured invoked for a closed session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onReconfigured(params));
    }

    public void onRangingReconfigureFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingReconfigureFailed invoked for a closed session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onReconfigureFailed(reason, params));
    }

    public void onRangingStopped(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingStopped invoked for a closed session");
            return;
        }
        this.mState = State.IDLE;
        this.executeCallback(() -> this.mCallback.onStopped(reason, params));
    }

    public void onRangingStopFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingStopFailed invoked for a closed session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onStopFailed(reason, params));
    }

    public void onRangingClosed(int reason, PersistableBundle parameters) {
        this.mState = State.CLOSED;
        this.executeCallback(() -> this.mCallback.onClosed(reason, parameters));
    }

    public void onRangingResult(RangingReport report) {
        if (!this.isOpen()) {
            Log.w(TAG, "onRangingResult invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onReportReceived(report));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCallback(Runnable runnable) {
        long identity = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(runnable);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public static interface Callback {
        public static final int REASON_UNKNOWN = 0;
        public static final int REASON_LOCAL_REQUEST = 1;
        public static final int REASON_REMOTE_REQUEST = 2;
        public static final int REASON_BAD_PARAMETERS = 3;
        public static final int REASON_GENERIC_ERROR = 4;
        public static final int REASON_MAX_SESSIONS_REACHED = 5;
        public static final int REASON_SYSTEM_POLICY = 6;
        public static final int REASON_PROTOCOL_SPECIFIC_ERROR = 7;

        public void onOpened(RangingSession var1);

        public void onOpenFailed(int var1, PersistableBundle var2);

        public void onStarted(PersistableBundle var1);

        public void onStartFailed(int var1, PersistableBundle var2);

        public void onReconfigured(PersistableBundle var1);

        public void onReconfigureFailed(int var1, PersistableBundle var2);

        public void onStopped(int var1, PersistableBundle var2);

        public void onStopFailed(int var1, PersistableBundle var2);

        public void onClosed(int var1, PersistableBundle var2);

        public void onReportReceived(RangingReport var1);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }

    private static enum State {
        INIT,
        IDLE,
        ACTIVE,
        CLOSED;

    }
}

