/*
 * Decompiled with CFR 0.152.
 */
package android.util.proto;

import android.util.Log;
import android.util.proto.ProtoParseException;
import java.util.ArrayList;

public class EncodedBuffer {
    private static final String TAG = "EncodedBuffer";
    private final ArrayList<byte[]> mBuffers = new ArrayList();
    private final int mChunkSize;
    private int mBufferCount;
    private byte[] mWriteBuffer;
    private int mWriteIndex;
    private int mWriteBufIndex;
    private byte[] mReadBuffer;
    private int mReadBufIndex;
    private int mReadIndex;
    private int mReadLimit = -1;
    private int mReadableSize = -1;

    public EncodedBuffer() {
        this(0);
    }

    public EncodedBuffer(int chunkSize) {
        if (chunkSize <= 0) {
            chunkSize = 8192;
        }
        this.mChunkSize = chunkSize;
        this.mWriteBuffer = new byte[this.mChunkSize];
        this.mBuffers.add(this.mWriteBuffer);
        this.mBufferCount = 1;
    }

    public void startEditing() {
        this.mReadableSize = this.mWriteBufIndex * this.mChunkSize + this.mWriteIndex;
        this.mReadLimit = this.mWriteIndex;
        this.mWriteBuffer = this.mBuffers.get(0);
        this.mWriteIndex = 0;
        this.mWriteBufIndex = 0;
        this.mReadBuffer = this.mWriteBuffer;
        this.mReadBufIndex = 0;
        this.mReadIndex = 0;
    }

    public void rewindRead() {
        this.mReadBuffer = this.mBuffers.get(0);
        this.mReadBufIndex = 0;
        this.mReadIndex = 0;
    }

    public int getReadableSize() {
        return this.mReadableSize;
    }

    public int getSize() {
        return (this.mBufferCount - 1) * this.mChunkSize + this.mWriteIndex;
    }

    public int getReadPos() {
        return this.mReadBufIndex * this.mChunkSize + this.mReadIndex;
    }

    public void skipRead(int amount) {
        if (amount < 0) {
            throw new RuntimeException("skipRead with negative amount=" + amount);
        }
        if (amount == 0) {
            return;
        }
        if (amount <= this.mChunkSize - this.mReadIndex) {
            this.mReadIndex += amount;
        } else {
            this.mReadIndex = (amount -= this.mChunkSize - this.mReadIndex) % this.mChunkSize;
            if (this.mReadIndex == 0) {
                this.mReadIndex = this.mChunkSize;
                this.mReadBufIndex += amount / this.mChunkSize;
            } else {
                this.mReadBufIndex += 1 + amount / this.mChunkSize;
            }
            this.mReadBuffer = this.mBuffers.get(this.mReadBufIndex);
        }
    }

    public byte readRawByte() {
        if (this.mReadBufIndex > this.mBufferCount || this.mReadBufIndex == this.mBufferCount - 1 && this.mReadIndex >= this.mReadLimit) {
            throw new IndexOutOfBoundsException("Trying to read too much data mReadBufIndex=" + this.mReadBufIndex + " mBufferCount=" + this.mBufferCount + " mReadIndex=" + this.mReadIndex + " mReadLimit=" + this.mReadLimit);
        }
        if (this.mReadIndex >= this.mChunkSize) {
            ++this.mReadBufIndex;
            this.mReadBuffer = this.mBuffers.get(this.mReadBufIndex);
            this.mReadIndex = 0;
        }
        return this.mReadBuffer[this.mReadIndex++];
    }

    public long readRawUnsigned() {
        int bits = 0;
        long result = 0L;
        do {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << bits;
            if ((b & 0x80) != 0) continue;
            return result;
        } while ((bits += 7) <= 64);
        throw new ProtoParseException("Varint too long -- " + this.getDebugString());
    }

    public int readRawFixed32() {
        return this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8 | (this.readRawByte() & 0xFF) << 16 | (this.readRawByte() & 0xFF) << 24;
    }

    private void nextWriteBuffer() {
        ++this.mWriteBufIndex;
        if (this.mWriteBufIndex >= this.mBufferCount) {
            this.mWriteBuffer = new byte[this.mChunkSize];
            this.mBuffers.add(this.mWriteBuffer);
            ++this.mBufferCount;
        } else {
            this.mWriteBuffer = this.mBuffers.get(this.mWriteBufIndex);
        }
        this.mWriteIndex = 0;
    }

    public void writeRawByte(byte val) {
        if (this.mWriteIndex >= this.mChunkSize) {
            this.nextWriteBuffer();
        }
        this.mWriteBuffer[this.mWriteIndex++] = val;
    }

    public static int getRawVarint32Size(int val) {
        if ((val & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((val & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((val & 0xFFE00000) == 0) {
            return 3;
        }
        if ((val & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeRawVarint32(int val) {
        while (true) {
            if ((val & 0xFFFFFF80) == 0) {
                this.writeRawByte((byte)val);
                return;
            }
            this.writeRawByte((byte)(val & 0x7F | 0x80));
            val >>>= 7;
        }
    }

    public static int getRawZigZag32Size(int val) {
        return EncodedBuffer.getRawVarint32Size(EncodedBuffer.zigZag32(val));
    }

    public void writeRawZigZag32(int val) {
        this.writeRawVarint32(EncodedBuffer.zigZag32(val));
    }

    public static int getRawVarint64Size(long val) {
        if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((val & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((val & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((val & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((val & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((val & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((val & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((val & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((val & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void writeRawVarint64(long val) {
        while (true) {
            if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((byte)val);
                return;
            }
            this.writeRawByte((byte)(val & 0x7FL | 0x80L));
            val >>>= 7;
        }
    }

    public static int getRawZigZag64Size(long val) {
        return EncodedBuffer.getRawVarint64Size(EncodedBuffer.zigZag64(val));
    }

    public void writeRawZigZag64(long val) {
        this.writeRawVarint64(EncodedBuffer.zigZag64(val));
    }

    public void writeRawFixed32(int val) {
        this.writeRawByte((byte)val);
        this.writeRawByte((byte)(val >> 8));
        this.writeRawByte((byte)(val >> 16));
        this.writeRawByte((byte)(val >> 24));
    }

    public void writeRawFixed64(long val) {
        this.writeRawByte((byte)val);
        this.writeRawByte((byte)(val >> 8));
        this.writeRawByte((byte)(val >> 16));
        this.writeRawByte((byte)(val >> 24));
        this.writeRawByte((byte)(val >> 32));
        this.writeRawByte((byte)(val >> 40));
        this.writeRawByte((byte)(val >> 48));
        this.writeRawByte((byte)(val >> 56));
    }

    public void writeRawBuffer(byte[] val) {
        if (val != null && val.length > 0) {
            this.writeRawBuffer(val, 0, val.length);
        }
    }

    public void writeRawBuffer(byte[] val, int offset2, int length) {
        int amt;
        if (val == null) {
            return;
        }
        int n = amt = length < this.mChunkSize - this.mWriteIndex ? length : this.mChunkSize - this.mWriteIndex;
        if (amt > 0) {
            System.arraycopy(val, offset2, this.mWriteBuffer, this.mWriteIndex, amt);
            this.mWriteIndex += amt;
            length -= amt;
            offset2 += amt;
        }
        while (length > 0) {
            this.nextWriteBuffer();
            amt = length < this.mChunkSize ? length : this.mChunkSize;
            System.arraycopy(val, offset2, this.mWriteBuffer, this.mWriteIndex, amt);
            this.mWriteIndex += amt;
            length -= amt;
            offset2 += amt;
        }
    }

    public void writeFromThisBuffer(int srcOffset, int size) {
        if (this.mReadLimit < 0) {
            throw new IllegalStateException("writeFromThisBuffer before startEditing");
        }
        if (srcOffset < this.getWritePos()) {
            throw new IllegalArgumentException("Can only move forward in the buffer -- srcOffset=" + srcOffset + " size=" + size + " " + this.getDebugString());
        }
        if (srcOffset + size > this.mReadableSize) {
            throw new IllegalArgumentException("Trying to move more data than there is -- srcOffset=" + srcOffset + " size=" + size + " " + this.getDebugString());
        }
        if (size == 0) {
            return;
        }
        if (srcOffset == this.mWriteBufIndex * this.mChunkSize + this.mWriteIndex) {
            if (size <= this.mChunkSize - this.mWriteIndex) {
                this.mWriteIndex += size;
            } else {
                this.mWriteIndex = (size -= this.mChunkSize - this.mWriteIndex) % this.mChunkSize;
                if (this.mWriteIndex == 0) {
                    this.mWriteIndex = this.mChunkSize;
                    this.mWriteBufIndex += size / this.mChunkSize;
                } else {
                    this.mWriteBufIndex += 1 + size / this.mChunkSize;
                }
                this.mWriteBuffer = this.mBuffers.get(this.mWriteBufIndex);
            }
        } else {
            int readBufIndex = srcOffset / this.mChunkSize;
            byte[] readBuffer = this.mBuffers.get(readBufIndex);
            int readIndex = srcOffset % this.mChunkSize;
            while (size > 0) {
                if (this.mWriteIndex >= this.mChunkSize) {
                    this.nextWriteBuffer();
                }
                if (readIndex >= this.mChunkSize) {
                    readBuffer = this.mBuffers.get(++readBufIndex);
                    readIndex = 0;
                }
                int spaceInWriteBuffer = this.mChunkSize - this.mWriteIndex;
                int availableInReadBuffer = this.mChunkSize - readIndex;
                int amt = Math.min(size, Math.min(spaceInWriteBuffer, availableInReadBuffer));
                System.arraycopy(readBuffer, readIndex, this.mWriteBuffer, this.mWriteIndex, amt);
                this.mWriteIndex += amt;
                readIndex += amt;
                size -= amt;
            }
        }
    }

    public int getWritePos() {
        return this.mWriteBufIndex * this.mChunkSize + this.mWriteIndex;
    }

    public void rewindWriteTo(int writePos) {
        if (writePos > this.getWritePos()) {
            throw new RuntimeException("rewindWriteTo only can go backwards" + writePos);
        }
        this.mWriteBufIndex = writePos / this.mChunkSize;
        this.mWriteIndex = writePos % this.mChunkSize;
        if (this.mWriteIndex == 0 && this.mWriteBufIndex != 0) {
            this.mWriteIndex = this.mChunkSize;
            --this.mWriteBufIndex;
        }
        this.mWriteBuffer = this.mBuffers.get(this.mWriteBufIndex);
    }

    public int getRawFixed32At(int pos) {
        return 0xFF & this.mBuffers.get(pos / this.mChunkSize)[pos % this.mChunkSize] | (0xFF & this.mBuffers.get((pos + 1) / this.mChunkSize)[(pos + 1) % this.mChunkSize]) << 8 | (0xFF & this.mBuffers.get((pos + 2) / this.mChunkSize)[(pos + 2) % this.mChunkSize]) << 16 | (0xFF & this.mBuffers.get((pos + 3) / this.mChunkSize)[(pos + 3) % this.mChunkSize]) << 24;
    }

    public void editRawFixed32(int pos, int val) {
        this.mBuffers.get((int)(pos / this.mChunkSize))[pos % this.mChunkSize] = (byte)val;
        this.mBuffers.get((int)((pos + 1) / this.mChunkSize))[(pos + 1) % this.mChunkSize] = (byte)(val >> 8);
        this.mBuffers.get((int)((pos + 2) / this.mChunkSize))[(pos + 2) % this.mChunkSize] = (byte)(val >> 16);
        this.mBuffers.get((int)((pos + 3) / this.mChunkSize))[(pos + 3) % this.mChunkSize] = (byte)(val >> 24);
    }

    private static int zigZag32(int val) {
        return val << 1 ^ val >> 31;
    }

    private static long zigZag64(long val) {
        return val << 1 ^ val >> 63;
    }

    public byte[] getBytes(int size) {
        int bufIndex;
        byte[] result = new byte[size];
        int bufCount = size / this.mChunkSize;
        int writeIndex = 0;
        for (bufIndex = 0; bufIndex < bufCount; ++bufIndex) {
            System.arraycopy(this.mBuffers.get(bufIndex), 0, result, writeIndex, this.mChunkSize);
            writeIndex += this.mChunkSize;
        }
        int lastSize = size - bufCount * this.mChunkSize;
        if (lastSize > 0) {
            System.arraycopy(this.mBuffers.get(bufIndex), 0, result, writeIndex, lastSize);
        }
        return result;
    }

    public int getChunkCount() {
        return this.mBuffers.size();
    }

    public int getWriteIndex() {
        return this.mWriteIndex;
    }

    public int getWriteBufIndex() {
        return this.mWriteBufIndex;
    }

    public String getDebugString() {
        return "EncodedBuffer( mChunkSize=" + this.mChunkSize + " mBuffers.size=" + this.mBuffers.size() + " mBufferCount=" + this.mBufferCount + " mWriteIndex=" + this.mWriteIndex + " mWriteBufIndex=" + this.mWriteBufIndex + " mReadBufIndex=" + this.mReadBufIndex + " mReadIndex=" + this.mReadIndex + " mReadableSize=" + this.mReadableSize + " mReadLimit=" + this.mReadLimit + " )";
    }

    public void dumpBuffers(String tag) {
        int N = this.mBuffers.size();
        int start = 0;
        for (int i = 0; i < N; ++i) {
            start += EncodedBuffer.dumpByteString(tag, "{" + i + "} ", start, this.mBuffers.get(i));
        }
    }

    public static void dumpByteString(String tag, String prefix, byte[] buf) {
        EncodedBuffer.dumpByteString(tag, prefix, 0, buf);
    }

    private static int dumpByteString(String tag, String prefix, int start, byte[] buf) {
        StringBuilder sb = new StringBuilder();
        int length = buf.length;
        int lineLen = 16;
        for (int i = 0; i < length; ++i) {
            if (i % 16 == 0) {
                if (i != 0) {
                    Log.d(tag, sb.toString());
                    sb = new StringBuilder();
                }
                sb.append(prefix);
                sb.append('[');
                sb.append(start + i);
                sb.append(']');
                sb.append(' ');
            } else {
                sb.append(' ');
            }
            byte b = buf[i];
            byte c = (byte)(b >> 4 & 0xF);
            if (c < 10) {
                sb.append((char)(48 + c));
            } else {
                sb.append((char)(87 + c));
            }
            byte d = (byte)(b & 0xF);
            if (d < 10) {
                sb.append((char)(48 + d));
                continue;
            }
            sb.append((char)(87 + d));
        }
        Log.d(tag, sb.toString());
        return length;
    }
}

