/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.SystemClock;
import com.android.i18n.timezone.CountryTimeZones;
import com.android.i18n.timezone.TimeZoneFinder;
import com.android.i18n.timezone.ZoneInfoDb;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class TimeUtils {
    private static final SimpleDateFormat sLoggingFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat sDumpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final Instant MIN_USE_DATE_OF_TIMEZONE = Instant.ofEpochMilli(1546300800000L);
    public static final int HUNDRED_DAY_FIELD_LEN = 19;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    public static final long NANOS_PER_MS = 1000000L;
    private static final Object sFormatSync = new Object();
    private static char[] sFormatStr = new char[29];
    private static char[] sTmpFormatStr = new char[29];

    public static TimeZone getTimeZone(int offset2, boolean dst, long when, String country) {
        android.icu.util.TimeZone icuTimeZone = TimeUtils.getIcuTimeZone(offset2, dst, when, country);
        return icuTimeZone != null ? TimeZone.getTimeZone(icuTimeZone.getID()) : null;
    }

    private static android.icu.util.TimeZone getIcuTimeZone(int offsetMillis, boolean isDst, long whenMillis, String countryIso) {
        if (countryIso == null) {
            return null;
        }
        android.icu.util.TimeZone bias = android.icu.util.TimeZone.getDefault();
        CountryTimeZones countryTimeZones = TimeZoneFinder.getInstance().lookupCountryTimeZones(countryIso);
        if (countryTimeZones == null) {
            return null;
        }
        CountryTimeZones.OffsetResult offsetResult = countryTimeZones.lookupByOffsetWithBias(whenMillis, bias, offsetMillis, isDst);
        return offsetResult != null ? offsetResult.getTimeZone() : null;
    }

    public static List<String> getTimeZoneIdsForCountryCode(String countryCode) {
        if (countryCode == null) {
            throw new NullPointerException("countryCode == null");
        }
        TimeZoneFinder timeZoneFinder = TimeZoneFinder.getInstance();
        CountryTimeZones countryTimeZones = timeZoneFinder.lookupCountryTimeZones(countryCode.toLowerCase());
        if (countryTimeZones == null) {
            return null;
        }
        ArrayList<String> timeZoneIds = new ArrayList<String>();
        for (CountryTimeZones.TimeZoneMapping timeZoneMapping : countryTimeZones.getTimeZoneMappings()) {
            if (!timeZoneMapping.isShownInPickerAt(MIN_USE_DATE_OF_TIMEZONE)) continue;
            timeZoneIds.add(timeZoneMapping.getTimeZoneId());
        }
        return Collections.unmodifiableList(timeZoneIds);
    }

    public static String getTimeZoneDatabaseVersion() {
        return ZoneInfoDb.getInstance().getVersion();
    }

    private static int accumField(int amt, int suffix, boolean always, int zeropad) {
        if (amt > 999) {
            int num = 0;
            while (amt != 0) {
                ++num;
                amt /= 10;
            }
            return num + suffix;
        }
        if (amt > 99 || always && zeropad >= 3) {
            return 3 + suffix;
        }
        if (amt > 9 || always && zeropad >= 2) {
            return 2 + suffix;
        }
        if (always || amt > 0) {
            return 1 + suffix;
        }
        return 0;
    }

    private static int printFieldLocked(char[] formatStr, int amt, char suffix, int pos, boolean always, int zeropad) {
        if (always || amt > 0) {
            int startPos = pos;
            if (amt > 999) {
                int tmp;
                for (tmp = 0; amt != 0 && tmp < sTmpFormatStr.length; ++tmp, amt /= 10) {
                    int dig = amt % 10;
                    TimeUtils.sTmpFormatStr[tmp] = (char)(dig + 48);
                }
                --tmp;
                while (tmp >= 0) {
                    formatStr[pos] = sTmpFormatStr[tmp];
                    ++pos;
                    --tmp;
                }
            } else {
                int dig;
                if (always && zeropad >= 3 || amt > 99) {
                    dig = amt / 100;
                    formatStr[pos] = (char)(dig + 48);
                    ++pos;
                    amt -= dig * 100;
                }
                if (always && zeropad >= 2 || amt > 9 || startPos != pos) {
                    dig = amt / 10;
                    formatStr[pos] = (char)(dig + 48);
                    ++pos;
                    amt -= dig * 10;
                }
                formatStr[pos] = (char)(amt + 48);
                ++pos;
            }
            formatStr[pos] = suffix;
            ++pos;
        }
        return pos;
    }

    private static int formatDurationLocked(long duration, int fieldLen) {
        int prefix;
        if (sFormatStr.length < fieldLen) {
            sFormatStr = new char[fieldLen];
        }
        char[] formatStr = sFormatStr;
        if (duration == 0L) {
            int pos = 0;
            --fieldLen;
            while (pos < fieldLen) {
                formatStr[pos++] = 32;
            }
            formatStr[pos] = 48;
            return pos + 1;
        }
        if (duration > 0L) {
            prefix = 43;
        } else {
            prefix = 45;
            duration = -duration;
        }
        int millis = (int)(duration % 1000L);
        int seconds = (int)Math.floor(duration / 1000L);
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (seconds >= 86400) {
            days = seconds / 86400;
            seconds -= days * 86400;
        }
        if (seconds >= 3600) {
            hours = seconds / 3600;
            seconds -= hours * 3600;
        }
        if (seconds >= 60) {
            minutes = seconds / 60;
            seconds -= minutes * 60;
        }
        int pos = 0;
        if (fieldLen != 0) {
            int myLen;
            myLen += TimeUtils.accumField(millis, 2, true, (myLen += TimeUtils.accumField(seconds, 1, (myLen += TimeUtils.accumField(minutes, 1, (myLen += TimeUtils.accumField(hours, 1, (myLen = TimeUtils.accumField(days, 1, false, 0)) > 0, 2)) > 0, 2)) > 0, 2)) > 0 ? 3 : 0) + 1;
            while (myLen < fieldLen) {
                formatStr[pos] = 32;
                ++pos;
                ++myLen;
            }
        }
        formatStr[pos] = prefix;
        int start = ++pos;
        boolean zeropad = fieldLen != 0;
        pos = TimeUtils.printFieldLocked(formatStr, days, 'd', pos, false, 0);
        pos = TimeUtils.printFieldLocked(formatStr, hours, 'h', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printFieldLocked(formatStr, minutes, 'm', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printFieldLocked(formatStr, seconds, 's', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printFieldLocked(formatStr, millis, 'm', pos, true, zeropad && pos != start ? 3 : 0);
        formatStr[pos] = 115;
        return pos + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatDuration(long duration, StringBuilder builder2) {
        Object object = sFormatSync;
        synchronized (object) {
            int len = TimeUtils.formatDurationLocked(duration, 0);
            builder2.append(sFormatStr, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatDuration(long duration, StringBuilder builder2, int fieldLen) {
        Object object = sFormatSync;
        synchronized (object) {
            int len = TimeUtils.formatDurationLocked(duration, fieldLen);
            builder2.append(sFormatStr, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static void formatDuration(long duration, PrintWriter pw, int fieldLen) {
        Object object = sFormatSync;
        synchronized (object) {
            int len = TimeUtils.formatDurationLocked(duration, fieldLen);
            pw.print(new String(sFormatStr, 0, len));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDuration(long duration) {
        Object object = sFormatSync;
        synchronized (object) {
            int len = TimeUtils.formatDurationLocked(duration, 0);
            return new String(sFormatStr, 0, len);
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static void formatDuration(long duration, PrintWriter pw) {
        TimeUtils.formatDuration(duration, pw, 0);
    }

    public static void formatDuration(long time, long now, PrintWriter pw) {
        if (time == 0L) {
            pw.print("--");
            return;
        }
        TimeUtils.formatDuration(time - now, pw, 0);
    }

    public static String formatUptime(long time) {
        return TimeUtils.formatTime(time, SystemClock.uptimeMillis());
    }

    public static String formatRealtime(long time) {
        return TimeUtils.formatTime(time, SystemClock.elapsedRealtime());
    }

    public static String formatTime(long time, long referenceTime) {
        long diff = time - referenceTime;
        if (diff > 0L) {
            return time + " (in " + diff + " ms)";
        }
        if (diff < 0L) {
            return time + " (" + -diff + " ms ago)";
        }
        return time + " (now)";
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static String logTimeOfDay(long millis) {
        Calendar c = Calendar.getInstance();
        if (millis >= 0L) {
            c.setTimeInMillis(millis);
            return String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c);
        }
        return Long.toString(millis);
    }

    public static String formatForLogging(long millis) {
        if (millis <= 0L) {
            return "unknown";
        }
        return sLoggingFormat.format(new Date(millis));
    }

    public static void dumpTime(PrintWriter pw, long time) {
        pw.print(sDumpDateFormat.format(new Date(time)));
    }

    public static boolean isTimeBetween(LocalTime reference2, LocalTime start, LocalTime end) {
        return !(reference2.isBefore(start) && reference2.isAfter(end) || reference2.isBefore(end) && reference2.isBefore(start) && start.isBefore(end)) && (!reference2.isAfter(end) || !reference2.isAfter(start) || !start.isBefore(end));
    }

    public static void dumpTimeWithDelta(PrintWriter pw, long time, long now) {
        pw.print(sDumpDateFormat.format(new Date(time)));
        if (time == now) {
            pw.print(" (now)");
        } else {
            pw.print(" (");
            TimeUtils.formatDuration(time, now, pw);
            pw.print(")");
        }
    }
}

