/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;

public class Range<T extends Comparable<? super T>> {
    private final T mLower;
    private final T mUpper;

    public Range(T lower, T upper) {
        this.mLower = (Comparable)Preconditions.checkNotNull(lower, "lower must not be null");
        this.mUpper = (Comparable)Preconditions.checkNotNull(upper, "upper must not be null");
        if (lower.compareTo(upper) > 0) {
            throw new IllegalArgumentException("lower must be less than or equal to upper");
        }
    }

    public static <T extends Comparable<? super T>> Range<T> create(T lower, T upper) {
        return new Range<T>(lower, upper);
    }

    public T getLower() {
        return this.mLower;
    }

    public T getUpper() {
        return this.mUpper;
    }

    public boolean contains(T value2) {
        Preconditions.checkNotNull(value2, "value must not be null");
        boolean gteLower = value2.compareTo(this.mLower) >= 0;
        boolean lteUpper = value2.compareTo(this.mUpper) <= 0;
        return gteLower && lteUpper;
    }

    public boolean contains(Range<T> range) {
        Preconditions.checkNotNull(range, "value must not be null");
        boolean gteLower = range.mLower.compareTo(this.mLower) >= 0;
        boolean lteUpper = range.mUpper.compareTo(this.mUpper) <= 0;
        return gteLower && lteUpper;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Range) {
            Range other = (Range)obj;
            return this.mLower.equals(other.mLower) && this.mUpper.equals(other.mUpper);
        }
        return false;
    }

    public T clamp(T value2) {
        Preconditions.checkNotNull(value2, "value must not be null");
        if (value2.compareTo(this.mLower) < 0) {
            return this.mLower;
        }
        if (value2.compareTo(this.mUpper) > 0) {
            return this.mUpper;
        }
        return value2;
    }

    public Range<T> intersect(Range<T> range) {
        Preconditions.checkNotNull(range, "range must not be null");
        int cmpLower = range.mLower.compareTo(this.mLower);
        int cmpUpper = range.mUpper.compareTo(this.mUpper);
        if (cmpLower <= 0 && cmpUpper >= 0) {
            return this;
        }
        if (cmpLower >= 0 && cmpUpper <= 0) {
            return range;
        }
        return Range.create(cmpLower <= 0 ? this.mLower : range.mLower, cmpUpper >= 0 ? this.mUpper : range.mUpper);
    }

    public Range<T> intersect(T lower, T upper) {
        Preconditions.checkNotNull(lower, "lower must not be null");
        Preconditions.checkNotNull(upper, "upper must not be null");
        int cmpLower = lower.compareTo(this.mLower);
        int cmpUpper = upper.compareTo(this.mUpper);
        if (cmpLower <= 0 && cmpUpper >= 0) {
            return this;
        }
        return Range.create(cmpLower <= 0 ? this.mLower : lower, cmpUpper >= 0 ? this.mUpper : upper);
    }

    public Range<T> extend(Range<T> range) {
        Preconditions.checkNotNull(range, "range must not be null");
        int cmpLower = range.mLower.compareTo(this.mLower);
        int cmpUpper = range.mUpper.compareTo(this.mUpper);
        if (cmpLower <= 0 && cmpUpper >= 0) {
            return range;
        }
        if (cmpLower >= 0 && cmpUpper <= 0) {
            return this;
        }
        return Range.create(cmpLower >= 0 ? this.mLower : range.mLower, cmpUpper <= 0 ? this.mUpper : range.mUpper);
    }

    public Range<T> extend(T lower, T upper) {
        Preconditions.checkNotNull(lower, "lower must not be null");
        Preconditions.checkNotNull(upper, "upper must not be null");
        int cmpLower = lower.compareTo(this.mLower);
        int cmpUpper = upper.compareTo(this.mUpper);
        if (cmpLower >= 0 && cmpUpper <= 0) {
            return this;
        }
        return Range.create(cmpLower >= 0 ? this.mLower : lower, cmpUpper <= 0 ? this.mUpper : upper);
    }

    public Range<T> extend(T value2) {
        Preconditions.checkNotNull(value2, "value must not be null");
        return this.extend(value2, value2);
    }

    public String toString() {
        return String.format("[%s, %s]", this.mLower, this.mUpper);
    }

    public int hashCode() {
        return HashCodeHelpers.hashCodeGeneric(this.mLower, this.mUpper);
    }
}

