/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import com.android.tools.layoutlib.java.LinkedHashMap_Delegate;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache<K, V> {
    @UnsupportedAppUsage
    private final LinkedHashMap<K, V> map;
    private int size;
    private int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public LruCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            this.maxSize = maxSize;
        }
        this.trimToSize(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        V mapValue;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            mapValue = this.map.get(key);
            if (mapValue != null) {
                ++this.hitCount;
                return mapValue;
            }
            ++this.missCount;
        }
        V createdValue = this.create(key);
        if (createdValue == null) {
            return null;
        }
        LruCache lruCache2 = this;
        synchronized (lruCache2) {
            ++this.createCount;
            mapValue = this.map.put(key, createdValue);
            if (mapValue != null) {
                this.map.put(key, mapValue);
            } else {
                this.size += this.safeSizeOf(key, createdValue);
            }
        }
        if (mapValue != null) {
            this.entryRemoved(false, key, createdValue, mapValue);
            return mapValue;
        }
        this.trimToSize(this.maxSize);
        return createdValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value2) {
        V previous;
        if (key == null || value2 == null) {
            throw new NullPointerException("key == null || value == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            ++this.putCount;
            this.size += this.safeSizeOf(key, value2);
            previous = this.map.put(key, value2);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, value2);
        }
        this.trimToSize(this.maxSize);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V value2;
            K key;
            LruCache lruCache = this;
            synchronized (lruCache) {
                if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize) {
                    break;
                }
                Map.Entry<K, V> toEvict = LinkedHashMap_Delegate.eldest(this.map);
                if (toEvict == null) {
                    break;
                }
                key = toEvict.getKey();
                value2 = toEvict.getValue();
                this.map.remove(key);
                this.size -= this.safeSizeOf(key, value2);
                ++this.evictionCount;
            }
            this.entryRemoved(true, key, value2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        Object previous;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            previous = this.map.remove(key);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, null);
        }
        return previous;
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int safeSizeOf(K key, V value2) {
        int result = this.sizeOf(key, value2);
        if (result < 0) {
            throw new IllegalStateException("Negative size: " + key + "=" + value2);
        }
        return result;
    }

    protected int sizeOf(K key, V value2) {
        return 1;
    }

    public void evictAll() {
        this.trimToSize(-1);
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized int maxSize() {
        return this.maxSize;
    }

    public synchronized int hitCount() {
        return this.hitCount;
    }

    public synchronized int missCount() {
        return this.missCount;
    }

    public synchronized int createCount() {
        return this.createCount;
    }

    public synchronized int putCount() {
        return this.putCount;
    }

    public synchronized int evictionCount() {
        return this.evictionCount;
    }

    public synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    public synchronized String toString() {
        int accesses = this.hitCount + this.missCount;
        int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.maxSize, this.hitCount, this.missCount, hitPercent);
    }
}

