/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.util.NoSuchElementException;
import libcore.util.EmptyArray;

public class LongArrayQueue {
    private long[] mValues;
    private int mSize;
    private int mHead;
    private int mTail;

    public LongArrayQueue(int initialCapacity) {
        this.mValues = initialCapacity == 0 ? EmptyArray.LONG : ArrayUtils.newUnpaddedLongArray(initialCapacity);
        this.mSize = 0;
        this.mTail = 0;
        this.mHead = 0;
    }

    public LongArrayQueue() {
        this(16);
    }

    private void grow() {
        if (this.mSize < this.mValues.length) {
            throw new IllegalStateException("Queue not full yet!");
        }
        int newSize = GrowingArrayUtils.growSize(this.mSize);
        long[] newArray = ArrayUtils.newUnpaddedLongArray(newSize);
        int r = this.mValues.length - this.mHead;
        System.arraycopy(this.mValues, this.mHead, newArray, 0, r);
        System.arraycopy(this.mValues, 0, newArray, r, this.mHead);
        this.mValues = newArray;
        this.mHead = 0;
        this.mTail = this.mSize;
    }

    public int size() {
        return this.mSize;
    }

    public void clear() {
        this.mSize = 0;
        this.mTail = 0;
        this.mHead = 0;
    }

    public void addLast(long value2) {
        if (this.mSize == this.mValues.length) {
            this.grow();
        }
        this.mValues[this.mTail] = value2;
        this.mTail = (this.mTail + 1) % this.mValues.length;
        ++this.mSize;
    }

    public long removeFirst() {
        if (this.mSize == 0) {
            throw new NoSuchElementException("Queue is empty!");
        }
        long ret = this.mValues[this.mHead];
        this.mHead = (this.mHead + 1) % this.mValues.length;
        --this.mSize;
        return ret;
    }

    public long get(int position) {
        if (position < 0 || position >= this.mSize) {
            throw new IndexOutOfBoundsException("Index " + position + " not valid for a queue of size " + this.mSize);
        }
        int index = (this.mHead + position) % this.mValues.length;
        return this.mValues[index];
    }

    public long peekFirst() {
        if (this.mSize == 0) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return this.mValues[this.mHead];
    }

    public long peekLast() {
        if (this.mSize == 0) {
            throw new NoSuchElementException("Queue is empty!");
        }
        int index = this.mTail == 0 ? this.mValues.length - 1 : this.mTail - 1;
        return this.mValues[index];
    }

    public String toString() {
        if (this.mSize <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 64);
        buffer.append('{');
        buffer.append(this.get(0));
        for (int i = 1; i < this.mSize; ++i) {
            buffer.append(", ");
            buffer.append(this.get(i));
        }
        buffer.append('}');
        return buffer.toString();
    }
}

