/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import libcore.util.EmptyArray;

public class IntArray
implements Cloneable {
    private static final int MIN_CAPACITY_INCREMENT = 12;
    private int[] mValues;
    private int mSize;

    private IntArray(int[] array2, int size) {
        this.mValues = array2;
        this.mSize = Preconditions.checkArgumentInRange(size, 0, array2.length, "size");
    }

    public IntArray() {
        this(10);
    }

    public IntArray(int initialCapacity) {
        this.mValues = initialCapacity == 0 ? EmptyArray.INT : ArrayUtils.newUnpaddedIntArray(initialCapacity);
        this.mSize = 0;
    }

    public static IntArray wrap(int[] array2) {
        return new IntArray(array2, array2.length);
    }

    public static IntArray fromArray(int[] array2, int size) {
        return IntArray.wrap(Arrays.copyOf(array2, size));
    }

    public void resize(int newSize) {
        Preconditions.checkArgumentNonnegative(newSize);
        if (newSize <= this.mValues.length) {
            Arrays.fill(this.mValues, newSize, this.mValues.length, 0);
        } else {
            this.ensureCapacity(newSize - this.mSize);
        }
        this.mSize = newSize;
    }

    public void add(int value2) {
        this.add(this.mSize, value2);
    }

    public void add(int index, int value2) {
        this.ensureCapacity(1);
        int rightSegment = this.mSize - index;
        ++this.mSize;
        ArrayUtils.checkBounds(this.mSize, index);
        if (rightSegment != 0) {
            System.arraycopy(this.mValues, index, this.mValues, index + 1, rightSegment);
        }
        this.mValues[index] = value2;
    }

    public int binarySearch(int value2) {
        return ContainerHelpers.binarySearch(this.mValues, this.mSize, value2);
    }

    public void addAll(IntArray values2) {
        int count = values2.mSize;
        this.ensureCapacity(count);
        System.arraycopy(values2.mValues, 0, this.mValues, this.mSize, count);
        this.mSize += count;
    }

    public void addAll(int[] values2) {
        int count = values2.length;
        this.ensureCapacity(count);
        System.arraycopy(values2, 0, this.mValues, this.mSize, count);
        this.mSize += count;
    }

    private void ensureCapacity(int count) {
        int currentSize = this.mSize;
        int minCapacity = currentSize + count;
        if (minCapacity >= this.mValues.length) {
            int targetCap = currentSize + (currentSize < 6 ? 12 : currentSize >> 1);
            int newCapacity = targetCap > minCapacity ? targetCap : minCapacity;
            int[] newValues = ArrayUtils.newUnpaddedIntArray(newCapacity);
            System.arraycopy(this.mValues, 0, newValues, 0, currentSize);
            this.mValues = newValues;
        }
    }

    public void clear() {
        this.mSize = 0;
    }

    public IntArray clone() throws CloneNotSupportedException {
        IntArray clone = (IntArray)super.clone();
        clone.mValues = (int[])this.mValues.clone();
        return clone;
    }

    public int get(int index) {
        ArrayUtils.checkBounds(this.mSize, index);
        return this.mValues[index];
    }

    public void set(int index, int value2) {
        ArrayUtils.checkBounds(this.mSize, index);
        this.mValues[index] = value2;
    }

    public int indexOf(int value2) {
        int n = this.mSize;
        for (int i = 0; i < n; ++i) {
            if (this.mValues[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public void remove(int index) {
        ArrayUtils.checkBounds(this.mSize, index);
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - index - 1);
        --this.mSize;
    }

    public int size() {
        return this.mSize;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.mValues, this.mSize);
    }
}

