/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.Context;
import android.os.SystemProperties;
import android.provider.Settings;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FeatureFlagUtils {
    public static final String FFLAG_PREFIX = "sys.fflag.";
    public static final String FFLAG_OVERRIDE_PREFIX = "sys.fflag.override.";
    public static final String PERSIST_PREFIX = "persist.sys.fflag.override.";
    public static final String HEARING_AID_SETTINGS = "settings_bluetooth_hearing_aid";
    public static final String SETTINGS_WIFITRACKER2 = "settings_wifitracker2";
    public static final String SETTINGS_DO_NOT_RESTORE_PRESERVED = "settings_do_not_restore_preserved";
    public static final String SETTINGS_PROVIDER_MODEL = "settings_provider_model";
    public static final String SETTINGS_USE_NEW_BACKUP_ELIGIBILITY_RULES = "settings_use_new_backup_eligibility_rules";
    public static final String SETTINGS_ENABLE_SECURITY_HUB = "settings_enable_security_hub";
    private static final Map<String, String> DEFAULT_FLAGS = new HashMap<String, String>();
    private static final Set<String> PERSISTENT_FLAGS;

    public static boolean isEnabled(Context context, String feature) {
        String value2;
        if (context != null && !TextUtils.isEmpty(value2 = Settings.Global.getString(context.getContentResolver(), feature))) {
            return Boolean.parseBoolean(value2);
        }
        value2 = SystemProperties.get(FeatureFlagUtils.getSystemPropertyPrefix(feature) + feature);
        if (!TextUtils.isEmpty(value2)) {
            return Boolean.parseBoolean(value2);
        }
        value2 = FeatureFlagUtils.getAllFeatureFlags().get(feature);
        return Boolean.parseBoolean(value2);
    }

    public static void setEnabled(Context context, String feature, boolean enabled) {
        SystemProperties.set(FeatureFlagUtils.getSystemPropertyPrefix(feature) + feature, enabled ? "true" : "false");
    }

    public static Map<String, String> getAllFeatureFlags() {
        return DEFAULT_FLAGS;
    }

    private static String getSystemPropertyPrefix(String feature) {
        return PERSISTENT_FLAGS.contains(feature) ? PERSIST_PREFIX : FFLAG_OVERRIDE_PREFIX;
    }

    static {
        DEFAULT_FLAGS.put("settings_audio_switcher", "true");
        DEFAULT_FLAGS.put("settings_systemui_theme", "true");
        DEFAULT_FLAGS.put(HEARING_AID_SETTINGS, "false");
        DEFAULT_FLAGS.put("settings_wifi_details_datausage_header", "false");
        DEFAULT_FLAGS.put("settings_skip_direction_mutable", "true");
        DEFAULT_FLAGS.put(SETTINGS_WIFITRACKER2, "true");
        DEFAULT_FLAGS.put("settings_controller_loading_enhancement", "true");
        DEFAULT_FLAGS.put("settings_conditionals", "false");
        DEFAULT_FLAGS.put(SETTINGS_DO_NOT_RESTORE_PRESERVED, "true");
        DEFAULT_FLAGS.put("settings_tether_all_in_one", "false");
        DEFAULT_FLAGS.put("settings_contextual_home", "false");
        DEFAULT_FLAGS.put(SETTINGS_PROVIDER_MODEL, "true");
        DEFAULT_FLAGS.put(SETTINGS_USE_NEW_BACKUP_ELIGIBILITY_RULES, "true");
        DEFAULT_FLAGS.put(SETTINGS_ENABLE_SECURITY_HUB, "true");
        PERSISTENT_FLAGS = new HashSet<String>();
        PERSISTENT_FLAGS.add(SETTINGS_PROVIDER_MODEL);
    }
}

