/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.util.ContainerHelpers;
import android.util.Log;
import android.util.MapCollections;
import android.util.Slog;
import android.util.UtilConfig;
import com.android.internal.util.ArrayUtils;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import libcore.util.EmptyArray;

public class ArrayMap<K, V>
implements Map<K, V> {
    private static final boolean DEBUG = false;
    private static final String TAG = "ArrayMap";
    private static final boolean CONCURRENT_MODIFICATION_EXCEPTIONS = true;
    private static final int BASE_SIZE = 4;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static final int CACHE_SIZE = 10;
    @UnsupportedAppUsage(maxTargetSdk=28)
    static final int[] EMPTY_IMMUTABLE_INTS = new int[0];
    @UnsupportedAppUsage(maxTargetSdk=28)
    public static final ArrayMap EMPTY = new ArrayMap(-1);
    @UnsupportedAppUsage(maxTargetSdk=28)
    static Object[] mBaseCache;
    @UnsupportedAppUsage(maxTargetSdk=28)
    static int mBaseCacheSize;
    @UnsupportedAppUsage(maxTargetSdk=28)
    static Object[] mTwiceBaseCache;
    @UnsupportedAppUsage(maxTargetSdk=28)
    static int mTwiceBaseCacheSize;
    private static final Object sBaseCacheLock;
    private static final Object sTwiceBaseCacheLock;
    private final boolean mIdentityHashCode;
    @UnsupportedAppUsage(maxTargetSdk=28)
    int[] mHashes;
    @UnsupportedAppUsage(maxTargetSdk=28)
    Object[] mArray;
    @UnsupportedAppUsage(maxTargetSdk=28)
    int mSize;
    private MapCollections<K, V> mCollections;

    private static int binarySearchHashes(int[] hashes, int N, int hash2) {
        try {
            return ContainerHelpers.binarySearch(hashes, N, hash2);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ConcurrentModificationException();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    int indexOf(Object key, int hash2) {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = ArrayMap.binarySearchHashes(this.mHashes, N, hash2);
        if (index < 0) {
            return index;
        }
        if (key.equals(this.mArray[index << 1])) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == hash2; ++end) {
            if (!key.equals(this.mArray[end << 1])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == hash2; --i) {
            if (!key.equals(this.mArray[i << 1])) continue;
            return i;
        }
        return ~end;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    int indexOfNull() {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = ArrayMap.binarySearchHashes(this.mHashes, N, 0);
        if (index < 0) {
            return index;
        }
        if (null == this.mArray[index << 1]) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == 0; ++end) {
            if (null != this.mArray[end << 1]) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == 0; --i) {
            if (null != this.mArray[i << 1]) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28)
    private void allocArrays(int size) {
        if (this.mHashes == EMPTY_IMMUTABLE_INTS) {
            throw new UnsupportedOperationException("ArrayMap is immutable");
        }
        if (size == 8) {
            Object object = sTwiceBaseCacheLock;
            synchronized (object) {
                if (mTwiceBaseCache != null) {
                    Object[] array2 = mTwiceBaseCache;
                    this.mArray = array2;
                    try {
                        mTwiceBaseCache = (Object[])array2[0];
                        this.mHashes = (int[])array2[1];
                        if (this.mHashes != null) {
                            array2[1] = null;
                            array2[0] = null;
                            --mTwiceBaseCacheSize;
                            return;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    Slog.wtf(TAG, "Found corrupt ArrayMap cache: [0]=" + array2[0] + " [1]=" + array2[1]);
                    mTwiceBaseCache = null;
                    mTwiceBaseCacheSize = 0;
                }
            }
        }
        if (size == 4) {
            Object object = sBaseCacheLock;
            synchronized (object) {
                if (mBaseCache != null) {
                    Object[] array3 = mBaseCache;
                    this.mArray = array3;
                    try {
                        mBaseCache = (Object[])array3[0];
                        this.mHashes = (int[])array3[1];
                        if (this.mHashes != null) {
                            array3[1] = null;
                            array3[0] = null;
                            --mBaseCacheSize;
                            return;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    Slog.wtf(TAG, "Found corrupt ArrayMap cache: [0]=" + array3[0] + " [1]=" + array3[1]);
                    mBaseCache = null;
                    mBaseCacheSize = 0;
                }
            }
        }
        this.mHashes = new int[size];
        this.mArray = new Object[size << 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static void freeArrays(int[] hashes, Object[] array2, int size) {
        if (hashes.length == 8) {
            Object object = sTwiceBaseCacheLock;
            synchronized (object) {
                if (mTwiceBaseCacheSize < 10) {
                    array2[0] = mTwiceBaseCache;
                    array2[1] = hashes;
                    for (int i = (size << 1) - 1; i >= 2; --i) {
                        array2[i] = null;
                    }
                    mTwiceBaseCache = array2;
                    ++mTwiceBaseCacheSize;
                }
            }
        }
        if (hashes.length == 4) {
            Object object = sBaseCacheLock;
            synchronized (object) {
                if (mBaseCacheSize < 10) {
                    array2[0] = mBaseCache;
                    array2[1] = hashes;
                    for (int i = (size << 1) - 1; i >= 2; --i) {
                        array2[i] = null;
                    }
                    mBaseCache = array2;
                    ++mBaseCacheSize;
                }
            }
        }
    }

    public ArrayMap() {
        this(0, false);
    }

    public ArrayMap(int capacity) {
        this(capacity, false);
    }

    public ArrayMap(int capacity, boolean identityHashCode) {
        this.mIdentityHashCode = identityHashCode;
        if (capacity < 0) {
            this.mHashes = EMPTY_IMMUTABLE_INTS;
            this.mArray = EmptyArray.OBJECT;
        } else if (capacity == 0) {
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
        } else {
            this.allocArrays(capacity);
        }
        this.mSize = 0;
    }

    public ArrayMap(ArrayMap<K, V> map2) {
        this();
        if (map2 != null) {
            this.putAll(map2);
        }
    }

    @Override
    public void clear() {
        if (this.mSize > 0) {
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            int osize = this.mSize;
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            this.mSize = 0;
            ArrayMap.freeArrays(ohashes, oarray, osize);
        }
        if (this.mSize > 0) {
            throw new ConcurrentModificationException();
        }
    }

    public void erase() {
        if (this.mSize > 0) {
            int N = this.mSize << 1;
            Object[] array2 = this.mArray;
            for (int i = 0; i < N; ++i) {
                array2[i] = null;
            }
            this.mSize = 0;
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        int osize = this.mSize;
        if (this.mHashes.length < minimumCapacity) {
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(minimumCapacity);
            if (this.mSize > 0) {
                System.arraycopy(ohashes, 0, this.mHashes, 0, osize);
                System.arraycopy(oarray, 0, this.mArray, 0, osize << 1);
            }
            ArrayMap.freeArrays(ohashes, oarray, osize);
        }
        if (this.mSize != osize) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOfKey(key) >= 0;
    }

    public int indexOfKey(Object key) {
        return key == null ? this.indexOfNull() : this.indexOf(key, this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode());
    }

    public int indexOfValue(Object value2) {
        int N = this.mSize * 2;
        Object[] array2 = this.mArray;
        if (value2 == null) {
            for (int i = 1; i < N; i += 2) {
                if (array2[i] != null) continue;
                return i >> 1;
            }
        } else {
            for (int i = 1; i < N; i += 2) {
                if (!value2.equals(array2[i])) continue;
                return i >> 1;
            }
        }
        return -1;
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.indexOfValue(value2) >= 0;
    }

    @Override
    public V get(Object key) {
        int index = this.indexOfKey(key);
        return (V)(index >= 0 ? this.mArray[(index << 1) + 1] : null);
    }

    public K keyAt(int index) {
        if (index >= this.mSize && UtilConfig.sThrowExceptionForUpperArrayOutOfBounds) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (K)this.mArray[index << 1];
    }

    public V valueAt(int index) {
        if (index >= this.mSize && UtilConfig.sThrowExceptionForUpperArrayOutOfBounds) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (V)this.mArray[(index << 1) + 1];
    }

    public V setValueAt(int index, V value2) {
        if (index >= this.mSize && UtilConfig.sThrowExceptionForUpperArrayOutOfBounds) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        index = (index << 1) + 1;
        Object old = this.mArray[index];
        this.mArray[index] = value2;
        return (V)old;
    }

    @Override
    public boolean isEmpty() {
        return this.mSize <= 0;
    }

    @Override
    public V put(K key, V value2) {
        int index;
        int hash2;
        int osize = this.mSize;
        if (key == null) {
            hash2 = 0;
            index = this.indexOfNull();
        } else {
            hash2 = this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode();
            index = this.indexOf(key, hash2);
        }
        if (index >= 0) {
            index = (index << 1) + 1;
            Object old = this.mArray[index];
            this.mArray[index] = value2;
            return (V)old;
        }
        index ^= 0xFFFFFFFF;
        if (osize >= this.mHashes.length) {
            int n = osize >= 8 ? osize + (osize >> 1) : (osize >= 4 ? 8 : 4);
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(n);
            if (osize != this.mSize) {
                throw new ConcurrentModificationException();
            }
            if (this.mHashes.length > 0) {
                System.arraycopy(ohashes, 0, this.mHashes, 0, ohashes.length);
                System.arraycopy(oarray, 0, this.mArray, 0, oarray.length);
            }
            ArrayMap.freeArrays(ohashes, oarray, osize);
        }
        if (index < osize) {
            System.arraycopy(this.mHashes, index, this.mHashes, index + 1, osize - index);
            System.arraycopy(this.mArray, index << 1, this.mArray, index + 1 << 1, this.mSize - index << 1);
        }
        if (osize != this.mSize || index >= this.mHashes.length) {
            throw new ConcurrentModificationException();
        }
        this.mHashes[index] = hash2;
        this.mArray[index << 1] = key;
        this.mArray[(index << 1) + 1] = value2;
        ++this.mSize;
        return null;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public void append(K key, V value2) {
        int hash2;
        int index = this.mSize;
        int n = key == null ? 0 : (hash2 = this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode());
        if (index >= this.mHashes.length) {
            throw new IllegalStateException("Array is full");
        }
        if (index > 0 && this.mHashes[index - 1] > hash2) {
            RuntimeException e = new RuntimeException("here");
            e.fillInStackTrace();
            Log.w(TAG, "New hash " + hash2 + " is before end of array hash " + this.mHashes[index - 1] + " at index " + index + " key " + key, e);
            this.put(key, value2);
            return;
        }
        this.mSize = index + 1;
        this.mHashes[index] = hash2;
        this.mArray[index <<= 1] = key;
        this.mArray[index + 1] = value2;
    }

    public void validate() {
        int N = this.mSize;
        if (N <= 1) {
            return;
        }
        int basehash = this.mHashes[0];
        int basei = 0;
        for (int i = 1; i < N; ++i) {
            int hash2 = this.mHashes[i];
            if (hash2 != basehash) {
                basehash = hash2;
                basei = i;
                continue;
            }
            Object cur = this.mArray[i << 1];
            for (int j = i - 1; j >= basei; --j) {
                Object prev = this.mArray[j << 1];
                if (cur == prev) {
                    throw new IllegalArgumentException("Duplicate key in ArrayMap: " + cur);
                }
                if (cur == null || prev == null || !cur.equals(prev)) continue;
                throw new IllegalArgumentException("Duplicate key in ArrayMap: " + cur);
            }
        }
    }

    @Override
    public void putAll(ArrayMap<? extends K, ? extends V> array2) {
        int N = array2.mSize;
        this.ensureCapacity(this.mSize + N);
        if (this.mSize == 0) {
            if (N > 0) {
                System.arraycopy(array2.mHashes, 0, this.mHashes, 0, N);
                System.arraycopy(array2.mArray, 0, this.mArray, 0, N << 1);
                this.mSize = N;
            }
        } else {
            for (int i = 0; i < N; ++i) {
                this.put(array2.keyAt(i), array2.valueAt(i));
            }
        }
    }

    @Override
    public V remove(Object key) {
        int index = this.indexOfKey(key);
        if (index >= 0) {
            return this.removeAt(index);
        }
        return null;
    }

    public V removeAt(int index) {
        int nsize;
        if (index >= this.mSize && UtilConfig.sThrowExceptionForUpperArrayOutOfBounds) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Object old = this.mArray[(index << 1) + 1];
        int osize = this.mSize;
        if (osize <= 1) {
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            ArrayMap.freeArrays(ohashes, oarray, osize);
            nsize = 0;
        } else {
            nsize = osize - 1;
            if (this.mHashes.length > 8 && this.mSize < this.mHashes.length / 3) {
                int n = osize > 8 ? osize + (osize >> 1) : 8;
                int[] ohashes = this.mHashes;
                Object[] oarray = this.mArray;
                this.allocArrays(n);
                if (osize != this.mSize) {
                    throw new ConcurrentModificationException();
                }
                if (index > 0) {
                    System.arraycopy(ohashes, 0, this.mHashes, 0, index);
                    System.arraycopy(oarray, 0, this.mArray, 0, index << 1);
                }
                if (index < nsize) {
                    System.arraycopy(ohashes, index + 1, this.mHashes, index, nsize - index);
                    System.arraycopy(oarray, index + 1 << 1, this.mArray, index << 1, nsize - index << 1);
                }
            } else {
                if (index < nsize) {
                    System.arraycopy(this.mHashes, index + 1, this.mHashes, index, nsize - index);
                    System.arraycopy(this.mArray, index + 1 << 1, this.mArray, index << 1, nsize - index << 1);
                }
                this.mArray[nsize << 1] = null;
                this.mArray[(nsize << 1) + 1] = null;
            }
        }
        if (osize != this.mSize) {
            throw new ConcurrentModificationException();
        }
        this.mSize = nsize;
        return (V)old;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            if (this.size() != map2.size()) {
                return false;
            }
            try {
                for (int i = 0; i < this.mSize; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    Object theirs = map2.get(key);
                    if (!(mine == null ? theirs != null || !map2.containsKey(key) : !mine.equals(theirs))) continue;
                    return false;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int[] hashes = this.mHashes;
        Object[] array2 = this.mArray;
        int result = 0;
        int i = 0;
        int v = 1;
        int s = this.mSize;
        while (i < s) {
            Object value2 = array2[v];
            result += hashes[i] ^ (value2 == null ? 0 : value2.hashCode());
            ++i;
            v += 2;
        }
        return result;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            K key;
            if (i > 0) {
                buffer.append(", ");
            }
            if ((key = this.keyAt(i)) != this) {
                buffer.append(key);
            } else {
                buffer.append("(this Map)");
            }
            buffer.append('=');
            V value2 = this.valueAt(i);
            if (value2 != this) {
                buffer.append(ArrayUtils.deepToString(value2));
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        return buffer.toString();
    }

    private MapCollections<K, V> getCollection() {
        if (this.mCollections == null) {
            this.mCollections = new MapCollections<K, V>(){

                @Override
                protected int colGetSize() {
                    return ArrayMap.this.mSize;
                }

                @Override
                protected Object colGetEntry(int index, int offset2) {
                    return ArrayMap.this.mArray[(index << 1) + offset2];
                }

                @Override
                protected int colIndexOfKey(Object key) {
                    return ArrayMap.this.indexOfKey(key);
                }

                @Override
                protected int colIndexOfValue(Object value2) {
                    return ArrayMap.this.indexOfValue(value2);
                }

                @Override
                protected Map<K, V> colGetMap() {
                    return ArrayMap.this;
                }

                @Override
                protected void colPut(K key, V value2) {
                    ArrayMap.this.put(key, value2);
                }

                @Override
                protected V colSetValue(int index, V value2) {
                    return ArrayMap.this.setValueAt(index, value2);
                }

                @Override
                protected void colRemoveAt(int index) {
                    ArrayMap.this.removeAt(index);
                }

                @Override
                protected void colClear() {
                    ArrayMap.this.clear();
                }
            };
        }
        return this.mCollections;
    }

    public boolean containsAll(Collection<?> collection) {
        return MapCollections.containsAllHelper(this, collection);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        this.ensureCapacity(this.mSize + map2.size());
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean removeAll(Collection<?> collection) {
        return MapCollections.removeAllHelper(this, collection);
    }

    public boolean retainAll(Collection<?> collection) {
        return MapCollections.retainAllHelper(this, collection);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getCollection().getEntrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.getCollection().getKeySet();
    }

    @Override
    public Collection<V> values() {
        return this.getCollection().getValues();
    }

    static {
        sBaseCacheLock = new Object();
        sTwiceBaseCacheLock = new Object();
    }
}

