/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.AutoText;
import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.BaseKeyListener;
import android.text.method.CharacterPickerDialog;
import android.text.method.TextKeyListener;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.View;

public class QwertyKeyListener
extends BaseKeyListener {
    private static QwertyKeyListener[] sInstance = new QwertyKeyListener[TextKeyListener.Capitalize.values().length * 2];
    private static QwertyKeyListener sFullKeyboardInstance;
    private TextKeyListener.Capitalize mAutoCap;
    private boolean mAutoText;
    private boolean mFullKeyboard;
    private static SparseArray<String> PICKER_SETS;

    private QwertyKeyListener(TextKeyListener.Capitalize cap, boolean autoText, boolean fullKeyboard) {
        this.mAutoCap = cap;
        this.mAutoText = autoText;
        this.mFullKeyboard = fullKeyboard;
    }

    public QwertyKeyListener(TextKeyListener.Capitalize cap, boolean autoText) {
        this(cap, autoText, false);
    }

    public static QwertyKeyListener getInstance(boolean autoText, TextKeyListener.Capitalize cap) {
        int off = cap.ordinal() * 2 + (autoText ? 1 : 0);
        if (sInstance[off] == null) {
            QwertyKeyListener.sInstance[off] = new QwertyKeyListener(cap, autoText);
        }
        return sInstance[off];
    }

    public static QwertyKeyListener getInstanceForFullKeyboard() {
        if (sFullKeyboardInstance == null) {
            sFullKeyboardInstance = new QwertyKeyListener(TextKeyListener.Capitalize.NONE, false, true);
        }
        return sFullKeyboardInstance;
    }

    @Override
    public int getInputType() {
        return QwertyKeyListener.makeTextContentType(this.mAutoCap, this.mAutoText);
    }

    @Override
    public boolean onKeyDown(View view, Editable content2, int keyCode, KeyEvent event) {
        char c;
        int count;
        int pref = 0;
        if (view != null) {
            pref = TextKeyListener.getInstance().getPrefs(view.getContext());
        }
        int a = Selection.getSelectionStart(content2);
        int b = Selection.getSelectionEnd(content2);
        int selStart = Math.min(a, b);
        int selEnd = Math.max(a, b);
        if (selStart < 0 || selEnd < 0) {
            selEnd = 0;
            selStart = 0;
            Selection.setSelection(content2, 0, 0);
        }
        int activeStart = content2.getSpanStart(TextKeyListener.ACTIVE);
        int activeEnd = content2.getSpanEnd(TextKeyListener.ACTIVE);
        int i = event.getUnicodeChar(QwertyKeyListener.getMetaState((CharSequence)content2, event));
        if (!this.mFullKeyboard && (count = event.getRepeatCount()) > 0 && selStart == selEnd && selStart > 0 && ((c = content2.charAt(selStart - 1)) == i || c == Character.toUpperCase(i)) && view != null && this.showCharacterPicker(view, content2, c, false, count)) {
            QwertyKeyListener.resetMetaState(content2);
            return true;
        }
        if (i == 61185) {
            if (view != null) {
                this.showCharacterPicker(view, content2, '\uef01', true, 1);
            }
            QwertyKeyListener.resetMetaState(content2);
            return true;
        }
        if (i == 61184) {
            int start;
            if (selStart == selEnd) {
                for (start = selEnd; start > 0 && selEnd - start < 4 && Character.digit(content2.charAt(start - 1), 16) >= 0; --start) {
                }
            } else {
                start = selStart;
            }
            int ch = -1;
            try {
                String hex = TextUtils.substring(content2, start, selEnd);
                ch = Integer.parseInt(hex, 16);
            }
            catch (NumberFormatException hex) {
                // empty catch block
            }
            if (ch >= 0) {
                selStart = start;
                Selection.setSelection(content2, selStart, selEnd);
                i = ch;
            } else {
                i = 0;
            }
        }
        if (i != 0) {
            boolean dead = false;
            if ((i & Integer.MIN_VALUE) != 0) {
                dead = true;
                i &= Integer.MAX_VALUE;
            }
            if (activeStart == selStart && activeEnd == selEnd) {
                boolean replace = false;
                if (selEnd - selStart - 1 == 0) {
                    char accent = content2.charAt(selStart);
                    int composed = KeyEvent.getDeadChar(accent, i);
                    if (composed != 0) {
                        i = composed;
                        replace = true;
                        dead = false;
                    }
                }
                if (!replace) {
                    Selection.setSelection(content2, selEnd);
                    content2.removeSpan(TextKeyListener.ACTIVE);
                    selStart = selEnd;
                }
            }
            if ((pref & 1) != 0 && Character.isLowerCase(i) && TextKeyListener.shouldCap(this.mAutoCap, content2, selStart)) {
                int where = content2.getSpanEnd(TextKeyListener.CAPPED);
                int flags = content2.getSpanFlags(TextKeyListener.CAPPED);
                if (where == selStart && (flags >> 16 & 0xFFFF) == i) {
                    content2.removeSpan(TextKeyListener.CAPPED);
                } else {
                    flags = i << 16;
                    i = Character.toUpperCase(i);
                    if (selStart == 0) {
                        content2.setSpan(TextKeyListener.CAPPED, 0, 0, 0x11 | flags);
                    } else {
                        content2.setSpan(TextKeyListener.CAPPED, selStart - 1, selStart, 0x21 | flags);
                    }
                }
            }
            if (selStart != selEnd) {
                Selection.setSelection(content2, selEnd);
            }
            content2.setSpan(OLD_SEL_START, selStart, selStart, 17);
            content2.replace(selStart, selEnd, String.valueOf((char)i));
            int oldStart = content2.getSpanStart(OLD_SEL_START);
            selEnd = Selection.getSelectionEnd(content2);
            if (oldStart < selEnd) {
                content2.setSpan(TextKeyListener.LAST_TYPED, oldStart, selEnd, 33);
                if (dead) {
                    Selection.setSelection(content2, oldStart, selEnd);
                    content2.setSpan(TextKeyListener.ACTIVE, oldStart, selEnd, 33);
                }
            }
            QwertyKeyListener.adjustMetaAfterKeypress(content2);
            if ((pref & 2) != 0 && this.mAutoText && (i == 32 || i == 9 || i == 10 || i == 44 || i == 46 || i == 33 || i == 63 || i == 34 || Character.getType(i) == 22) && content2.getSpanEnd(TextKeyListener.INHIBIT_REPLACEMENT) != oldStart) {
                char c2;
                int x;
                for (x = oldStart; x > 0 && ((c2 = content2.charAt(x - 1)) == '\'' || Character.isLetter(c2)); --x) {
                }
                String rep = this.getReplacement(content2, x, oldStart, view);
                if (rep != null) {
                    Replaced[] repl = content2.getSpans(0, content2.length(), Replaced.class);
                    for (int a2 = 0; a2 < repl.length; ++a2) {
                        content2.removeSpan(repl[a2]);
                    }
                    char[] orig = new char[oldStart - x];
                    TextUtils.getChars(content2, x, oldStart, orig, 0);
                    content2.setSpan(new Replaced(orig), x, oldStart, 33);
                    content2.replace(x, oldStart, rep);
                }
            }
            if ((pref & 4) != 0 && this.mAutoText && (selEnd = Selection.getSelectionEnd(content2)) - 3 >= 0 && content2.charAt(selEnd - 1) == ' ' && content2.charAt(selEnd - 2) == ' ') {
                char c3 = content2.charAt(selEnd - 3);
                for (int j = selEnd - 3; j > 0 && (c3 == '\"' || Character.getType(c3) == 22); --j) {
                    c3 = content2.charAt(j - 1);
                }
                if (Character.isLetter(c3) || Character.isDigit(c3)) {
                    content2.replace(selEnd - 2, selEnd - 1, ".");
                }
            }
            return true;
        }
        if (keyCode == 67 && (event.hasNoModifiers() || event.hasModifiers(2)) && selStart == selEnd) {
            Replaced[] repl;
            int consider = 1;
            if (content2.getSpanEnd(TextKeyListener.LAST_TYPED) == selStart && content2.charAt(selStart - 1) != '\n') {
                consider = 2;
            }
            if ((repl = content2.getSpans(selStart - consider, selStart, Replaced.class)).length > 0) {
                int st = content2.getSpanStart(repl[0]);
                int en = content2.getSpanEnd(repl[0]);
                String old = new String(repl[0].mText);
                content2.removeSpan(repl[0]);
                if (selStart >= en) {
                    content2.setSpan(TextKeyListener.INHIBIT_REPLACEMENT, en, en, 34);
                    content2.replace(st, en, old);
                    en = content2.getSpanStart(TextKeyListener.INHIBIT_REPLACEMENT);
                    if (en - 1 >= 0) {
                        content2.setSpan(TextKeyListener.INHIBIT_REPLACEMENT, en - 1, en, 33);
                    } else {
                        content2.removeSpan(TextKeyListener.INHIBIT_REPLACEMENT);
                    }
                } else {
                    QwertyKeyListener.adjustMetaAfterKeypress(content2);
                    return super.onKeyDown(view, content2, keyCode, event);
                }
                QwertyKeyListener.adjustMetaAfterKeypress(content2);
                return true;
            }
        }
        return super.onKeyDown(view, content2, keyCode, event);
    }

    private String getReplacement(CharSequence src, int start, int end, View view) {
        String out;
        int len = end - start;
        boolean changecase = false;
        String replacement = AutoText.get(src, start, end, view);
        if (replacement == null) {
            String key = TextUtils.substring(src, start, end).toLowerCase();
            replacement = AutoText.get(key, 0, end - start, view);
            changecase = true;
            if (replacement == null) {
                return null;
            }
        }
        int caps = 0;
        if (changecase) {
            for (int j = start; j < end; ++j) {
                if (!Character.isUpperCase(src.charAt(j))) continue;
                ++caps;
            }
        }
        if ((out = caps == 0 ? replacement : (caps == 1 ? QwertyKeyListener.toTitleCase(replacement) : (caps == len ? replacement.toUpperCase() : QwertyKeyListener.toTitleCase(replacement)))).length() == len && TextUtils.regionMatches(src, start, out, 0, len)) {
            return null;
        }
        return out;
    }

    public static void markAsReplaced(Spannable content2, int start, int end, String original) {
        Replaced[] repl = content2.getSpans(0, content2.length(), Replaced.class);
        for (int a = 0; a < repl.length; ++a) {
            content2.removeSpan(repl[a]);
        }
        int len = original.length();
        char[] orig = new char[len];
        original.getChars(0, len, orig, 0);
        content2.setSpan(new Replaced(orig), start, end, 33);
    }

    private boolean showCharacterPicker(View view, Editable content2, char c, boolean insert, int count) {
        String set = PICKER_SETS.get(c);
        if (set == null) {
            return false;
        }
        if (count == 1) {
            new CharacterPickerDialog(view.getContext(), view, content2, set, insert).show();
        }
        return true;
    }

    private static String toTitleCase(String src) {
        return Character.toUpperCase(src.charAt(0)) + src.substring(1);
    }

    static {
        PICKER_SETS = new SparseArray();
        PICKER_SETS.put(65, "\u00c0\u00c1\u00c2\u00c4\u00c6\u00c3\u00c5\u0104\u0100");
        PICKER_SETS.put(67, "\u00c7\u0106\u010c");
        PICKER_SETS.put(68, "\u010e");
        PICKER_SETS.put(69, "\u00c8\u00c9\u00ca\u00cb\u0118\u011a\u0112");
        PICKER_SETS.put(71, "\u011e");
        PICKER_SETS.put(76, "\u0141");
        PICKER_SETS.put(73, "\u00cc\u00cd\u00ce\u00cf\u012a\u0130");
        PICKER_SETS.put(78, "\u00d1\u0143\u0147");
        PICKER_SETS.put(79, "\u00d8\u0152\u00d5\u00d2\u00d3\u00d4\u00d6\u014c");
        PICKER_SETS.put(82, "\u0158");
        PICKER_SETS.put(83, "\u015a\u0160\u015e");
        PICKER_SETS.put(84, "\u0164");
        PICKER_SETS.put(85, "\u00d9\u00da\u00db\u00dc\u016e\u016a");
        PICKER_SETS.put(89, "\u00dd\u0178");
        PICKER_SETS.put(90, "\u0179\u017b\u017d");
        PICKER_SETS.put(97, "\u00e0\u00e1\u00e2\u00e4\u00e6\u00e3\u00e5\u0105\u0101");
        PICKER_SETS.put(99, "\u00e7\u0107\u010d");
        PICKER_SETS.put(100, "\u010f");
        PICKER_SETS.put(101, "\u00e8\u00e9\u00ea\u00eb\u0119\u011b\u0113");
        PICKER_SETS.put(103, "\u011f");
        PICKER_SETS.put(105, "\u00ec\u00ed\u00ee\u00ef\u012b\u0131");
        PICKER_SETS.put(108, "\u0142");
        PICKER_SETS.put(110, "\u00f1\u0144\u0148");
        PICKER_SETS.put(111, "\u00f8\u0153\u00f5\u00f2\u00f3\u00f4\u00f6\u014d");
        PICKER_SETS.put(114, "\u0159");
        PICKER_SETS.put(115, "\u00a7\u00df\u015b\u0161\u015f");
        PICKER_SETS.put(116, "\u0165");
        PICKER_SETS.put(117, "\u00f9\u00fa\u00fb\u00fc\u016f\u016b");
        PICKER_SETS.put(121, "\u00fd\u00ff");
        PICKER_SETS.put(122, "\u017a\u017c\u017e");
        PICKER_SETS.put(61185, "\u2026\u00a5\u2022\u00ae\u00a9\u00b1[]{}\\|");
        PICKER_SETS.put(47, "\\");
        PICKER_SETS.put(49, "\u00b9\u00bd\u2153\u00bc\u215b");
        PICKER_SETS.put(50, "\u00b2\u2154");
        PICKER_SETS.put(51, "\u00b3\u00be\u215c");
        PICKER_SETS.put(52, "\u2074");
        PICKER_SETS.put(53, "\u215d");
        PICKER_SETS.put(55, "\u215e");
        PICKER_SETS.put(48, "\u207f\u2205");
        PICKER_SETS.put(36, "\u00a2\u00a3\u20ac\u00a5\u20a3\u20a4\u20b1");
        PICKER_SETS.put(37, "\u2030");
        PICKER_SETS.put(42, "\u2020\u2021");
        PICKER_SETS.put(45, "\u2013\u2014");
        PICKER_SETS.put(43, "\u00b1");
        PICKER_SETS.put(40, "[{<");
        PICKER_SETS.put(41, "]}>");
        PICKER_SETS.put(33, "\u00a1");
        PICKER_SETS.put(34, "\u201c\u201d\u00ab\u00bb\u02dd");
        PICKER_SETS.put(63, "\u00bf");
        PICKER_SETS.put(44, "\u201a\u201e");
        PICKER_SETS.put(61, "\u2260\u2248\u221e");
        PICKER_SETS.put(60, "\u2264\u00ab\u2039");
        PICKER_SETS.put(62, "\u2265\u00bb\u203a");
    }

    static class Replaced
    implements NoCopySpan {
        private char[] mText;

        public Replaced(char[] text) {
            this.mText = text;
        }
    }
}

