/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.icu.lang.UCharacter;
import android.icu.text.DecimalFormatSymbols;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.NumberKeyListener;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;

public class DigitsKeyListener
extends NumberKeyListener {
    private char[] mAccepted;
    private boolean mNeedsAdvancedInput;
    private final boolean mSign;
    private final boolean mDecimal;
    private final boolean mStringMode;
    private final Locale mLocale;
    private static final String DEFAULT_DECIMAL_POINT_CHARS = ".";
    private static final String DEFAULT_SIGN_CHARS = "-+";
    private static final char HYPHEN_MINUS = '-';
    private static final char MINUS_SIGN = '\u2212';
    private static final char EN_DASH = '\u2013';
    private String mDecimalPointChars = ".";
    private String mSignChars = "-+";
    private static final int SIGN = 1;
    private static final int DECIMAL = 2;
    private static final char[][] COMPATIBILITY_CHARACTERS = new char[][]{{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+', '.'}};
    private static final Object sLocaleCacheLock = new Object();
    @GuardedBy(value={"sLocaleCacheLock"})
    private static final HashMap<Locale, DigitsKeyListener[]> sLocaleInstanceCache = new HashMap();
    private static final Object sStringCacheLock = new Object();
    @GuardedBy(value={"sStringCacheLock"})
    private static final HashMap<String, DigitsKeyListener> sStringInstanceCache = new HashMap();

    @Override
    protected char[] getAcceptedChars() {
        return this.mAccepted;
    }

    private boolean isSignChar(char c) {
        return this.mSignChars.indexOf(c) != -1;
    }

    private boolean isDecimalPointChar(char c) {
        return this.mDecimalPointChars.indexOf(c) != -1;
    }

    @Deprecated
    public DigitsKeyListener() {
        this(null, false, false);
    }

    @Deprecated
    public DigitsKeyListener(boolean sign, boolean decimal) {
        this(null, sign, decimal);
    }

    public DigitsKeyListener(Locale locale) {
        this(locale, false, false);
    }

    private void setToCompat() {
        this.mDecimalPointChars = DEFAULT_DECIMAL_POINT_CHARS;
        this.mSignChars = DEFAULT_SIGN_CHARS;
        int kind = (this.mSign ? 1 : 0) | (this.mDecimal ? 2 : 0);
        this.mAccepted = COMPATIBILITY_CHARACTERS[kind];
        this.mNeedsAdvancedInput = false;
    }

    private void calculateNeedForAdvancedInput() {
        int kind = (this.mSign ? 1 : 0) | (this.mDecimal ? 2 : 0);
        this.mNeedsAdvancedInput = !ArrayUtils.containsAll(COMPATIBILITY_CHARACTERS[kind], this.mAccepted);
    }

    private static String stripBidiControls(String sign) {
        String result = "";
        for (int i = 0; i < sign.length(); ++i) {
            char c = sign.charAt(i);
            if (UCharacter.hasBinaryProperty(c, 2)) continue;
            result = result.isEmpty() ? String.valueOf(c) : result + c;
        }
        return result;
    }

    public DigitsKeyListener(Locale locale, boolean sign, boolean decimal) {
        this.mSign = sign;
        this.mDecimal = decimal;
        this.mStringMode = false;
        this.mLocale = locale;
        if (locale == null) {
            this.setToCompat();
            return;
        }
        LinkedHashSet<Character> chars = new LinkedHashSet<Character>();
        boolean success = NumberKeyListener.addDigits(chars, locale);
        if (!success) {
            this.setToCompat();
            return;
        }
        if (sign || decimal) {
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            if (sign) {
                String minusString = DigitsKeyListener.stripBidiControls(symbols.getMinusSignString());
                String plusString = DigitsKeyListener.stripBidiControls(symbols.getPlusSignString());
                if (minusString.length() > 1 || plusString.length() > 1) {
                    this.setToCompat();
                    return;
                }
                char minus = minusString.charAt(0);
                char plus = plusString.charAt(0);
                chars.add(Character.valueOf(minus));
                chars.add(Character.valueOf(plus));
                this.mSignChars = "" + minus + plus;
                if (minus == '\u2212' || minus == '\u2013') {
                    chars.add(Character.valueOf('-'));
                    this.mSignChars = this.mSignChars + '-';
                }
            }
            if (decimal) {
                String separatorString = symbols.getDecimalSeparatorString();
                if (separatorString.length() > 1) {
                    this.setToCompat();
                    return;
                }
                Character separatorChar = Character.valueOf(separatorString.charAt(0));
                chars.add(separatorChar);
                this.mDecimalPointChars = separatorChar.toString();
            }
        }
        this.mAccepted = NumberKeyListener.collectionToArray(chars);
        this.calculateNeedForAdvancedInput();
    }

    private DigitsKeyListener(String accepted) {
        this.mSign = false;
        this.mDecimal = false;
        this.mStringMode = true;
        this.mLocale = null;
        this.mAccepted = new char[accepted.length()];
        accepted.getChars(0, accepted.length(), this.mAccepted, 0);
        this.mNeedsAdvancedInput = false;
    }

    @Deprecated
    public static DigitsKeyListener getInstance() {
        return DigitsKeyListener.getInstance(false, false);
    }

    @Deprecated
    public static DigitsKeyListener getInstance(boolean sign, boolean decimal) {
        return DigitsKeyListener.getInstance(null, sign, decimal);
    }

    public static DigitsKeyListener getInstance(Locale locale) {
        return DigitsKeyListener.getInstance(locale, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DigitsKeyListener getInstance(Locale locale, boolean sign, boolean decimal) {
        int kind = (sign ? 1 : 0) | (decimal ? 2 : 0);
        Object object = sLocaleCacheLock;
        synchronized (object) {
            DigitsKeyListener[] cachedValue = sLocaleInstanceCache.get(locale);
            if (cachedValue != null && cachedValue[kind] != null) {
                return cachedValue[kind];
            }
            if (cachedValue == null) {
                cachedValue = new DigitsKeyListener[4];
                sLocaleInstanceCache.put(locale, cachedValue);
            }
            cachedValue[kind] = new DigitsKeyListener(locale, sign, decimal);
            return cachedValue[kind];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DigitsKeyListener getInstance(String accepted) {
        DigitsKeyListener result;
        Object object = sStringCacheLock;
        synchronized (object) {
            result = sStringInstanceCache.get(accepted);
            if (result == null) {
                result = new DigitsKeyListener(accepted);
                sStringInstanceCache.put(accepted, result);
            }
        }
        return result;
    }

    public static DigitsKeyListener getInstance(Locale locale, DigitsKeyListener listener2) {
        if (listener2.mStringMode) {
            return listener2;
        }
        return DigitsKeyListener.getInstance(locale, listener2.mSign, listener2.mDecimal);
    }

    @Override
    public int getInputType() {
        int contentType;
        if (this.mNeedsAdvancedInput) {
            contentType = 1;
        } else {
            contentType = 2;
            if (this.mSign) {
                contentType |= 0x1000;
            }
            if (this.mDecimal) {
                contentType |= 0x2000;
            }
        }
        return contentType;
    }

    @Override
    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        char c;
        int i;
        CharSequence out = super.filter(source, start, end, dest, dstart, dend);
        if (!this.mSign && !this.mDecimal) {
            return out;
        }
        if (out != null) {
            source = out;
            start = 0;
            end = out.length();
        }
        int sign = -1;
        int decimal = -1;
        int dlen = dest.length();
        for (i = 0; i < dstart; ++i) {
            c = dest.charAt(i);
            if (this.isSignChar(c)) {
                sign = i;
                continue;
            }
            if (!this.isDecimalPointChar(c)) continue;
            decimal = i;
        }
        for (i = dend; i < dlen; ++i) {
            c = dest.charAt(i);
            if (this.isSignChar(c)) {
                return "";
            }
            if (!this.isDecimalPointChar(c)) continue;
            decimal = i;
        }
        SpannableStringBuilder stripped = null;
        for (int i2 = end - 1; i2 >= start; --i2) {
            char c2 = source.charAt(i2);
            boolean strip = false;
            if (this.isSignChar(c2)) {
                if (i2 != start || dstart != 0) {
                    strip = true;
                } else if (sign >= 0) {
                    strip = true;
                } else {
                    sign = i2;
                }
            } else if (this.isDecimalPointChar(c2)) {
                if (decimal >= 0) {
                    strip = true;
                } else {
                    decimal = i2;
                }
            }
            if (!strip) continue;
            if (end == start + 1) {
                return "";
            }
            if (stripped == null) {
                stripped = new SpannableStringBuilder(source, start, end);
            }
            stripped.delete(i2 - start, i2 + 1 - start);
        }
        if (stripped != null) {
            return stripped;
        }
        if (out != null) {
            return out;
        }
        return null;
    }
}

