/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.icu.text.DateFormatSymbols;
import android.icu.text.DateTimePatternGenerator;
import android.provider.Settings;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.format.DateFormat_Delegate;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateFormat {
    @Deprecated
    public static final char QUOTE = '\'';
    @Deprecated
    public static final char AM_PM = 'a';
    @Deprecated
    public static final char CAPITAL_AM_PM = 'A';
    @Deprecated
    public static final char DATE = 'd';
    @Deprecated
    public static final char DAY = 'E';
    @Deprecated
    public static final char HOUR = 'h';
    @Deprecated
    public static final char HOUR_OF_DAY = 'k';
    @Deprecated
    public static final char MINUTE = 'm';
    @Deprecated
    public static final char MONTH = 'M';
    @Deprecated
    public static final char STANDALONE_MONTH = 'L';
    @Deprecated
    public static final char SECONDS = 's';
    @Deprecated
    public static final char TIME_ZONE = 'z';
    @Deprecated
    public static final char YEAR = 'y';
    private static final Object sLocaleLock = new Object();
    private static Locale sIs24HourLocale;
    private static boolean sIs24Hour;
    static final long DISALLOW_DUPLICATE_FIELD_IN_SKELETON = 170233598L;

    public static boolean is24HourFormat_Original(Context context) {
        return DateFormat.is24HourFormat(context, context.getUserId());
    }

    @LayoutlibDelegate
    public static boolean is24HourFormat(Context context) {
        return DateFormat_Delegate.is24HourFormat(context);
    }

    @UnsupportedAppUsage
    public static boolean is24HourFormat_Original(Context context, int userHandle) {
        String value2 = Settings.System.getStringForUser(context.getContentResolver(), "time_12_24", userHandle);
        if (value2 != null) {
            return value2.equals("24");
        }
        return DateFormat.is24HourLocale(context.getResources().getConfiguration().locale);
    }

    @LayoutlibDelegate
    public static boolean is24HourFormat(Context context, int n) {
        return DateFormat_Delegate.is24HourFormat(context, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean is24HourLocale(Locale locale) {
        boolean is24Hour;
        Object object = sLocaleLock;
        synchronized (object) {
            if (sIs24HourLocale != null && sIs24HourLocale.equals(locale)) {
                return sIs24Hour;
            }
        }
        java.text.DateFormat natural = java.text.DateFormat.getTimeInstance(1, locale);
        if (natural instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)natural;
            String pattern = sdf.toPattern();
            is24Hour = DateFormat.hasDesignator(pattern, 'H');
        } else {
            is24Hour = false;
        }
        Object object2 = sLocaleLock;
        synchronized (object2) {
            sIs24HourLocale = locale;
            sIs24Hour = is24Hour;
        }
        return is24Hour;
    }

    public static String getBestDateTimePattern(Locale locale, String skeleton) {
        DateTimePatternGenerator dtpg = DateTimePatternGenerator.getInstance(locale);
        boolean allowDuplicateFields = !CompatChanges.isChangeEnabled(170233598L);
        return dtpg.getBestPattern(skeleton, 0, allowDuplicateFields);
    }

    public static java.text.DateFormat getTimeFormat(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return new SimpleDateFormat(DateFormat.getTimeFormatString(context), locale);
    }

    @UnsupportedAppUsage
    public static String getTimeFormatString(Context context) {
        return DateFormat.getTimeFormatString(context, context.getUserId());
    }

    @UnsupportedAppUsage
    public static String getTimeFormatString(Context context, int userHandle) {
        DateTimePatternGenerator dtpg = DateTimePatternGenerator.getInstance(context.getResources().getConfiguration().locale);
        return DateFormat.is24HourFormat(context, userHandle) ? dtpg.getBestPattern("Hm") : dtpg.getBestPattern("hm");
    }

    public static java.text.DateFormat getDateFormat(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return java.text.DateFormat.getDateInstance(3, locale);
    }

    public static java.text.DateFormat getLongDateFormat(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return java.text.DateFormat.getDateInstance(1, locale);
    }

    public static java.text.DateFormat getMediumDateFormat(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return java.text.DateFormat.getDateInstance(2, locale);
    }

    public static char[] getDateFormatOrder(Context context) {
        return DateFormat.getDateFormatOrder(DateFormat.getDateFormatString(context));
    }

    public static char[] getDateFormatOrder(String pattern) {
        char[] result = new char[3];
        int resultIndex = 0;
        boolean sawDay = false;
        boolean sawMonth = false;
        boolean sawYear = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == 'd' || ch == 'L' || ch == 'M' || ch == 'y') {
                if (ch == 'd' && !sawDay) {
                    result[resultIndex++] = 100;
                    sawDay = true;
                    continue;
                }
                if (!(ch != 'L' && ch != 'M' || sawMonth)) {
                    result[resultIndex++] = 77;
                    sawMonth = true;
                    continue;
                }
                if (ch != 'y' || sawYear) continue;
                result[resultIndex++] = 121;
                sawYear = true;
                continue;
            }
            if (ch == 'G') continue;
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                throw new IllegalArgumentException("Bad pattern character '" + ch + "' in " + pattern);
            }
            if (ch != '\'') continue;
            if (i < pattern.length() - 1 && pattern.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            if ((i = pattern.indexOf(39, i + 1)) == -1) {
                throw new IllegalArgumentException("Bad quoting in " + pattern);
            }
            ++i;
        }
        return result;
    }

    private static String getDateFormatString(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        java.text.DateFormat df = java.text.DateFormat.getDateInstance(3, locale);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        throw new AssertionError((Object)"!(df instanceof SimpleDateFormat)");
    }

    public static CharSequence format(CharSequence inFormat, long inTimeInMillis) {
        return DateFormat.format(inFormat, new Date(inTimeInMillis));
    }

    public static CharSequence format(CharSequence inFormat, Date inDate) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(inDate);
        return DateFormat.format(inFormat, c);
    }

    @UnsupportedAppUsage
    public static boolean hasSeconds(CharSequence inFormat) {
        return DateFormat.hasDesignator(inFormat, 's');
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean hasDesignator(CharSequence inFormat, char designator) {
        if (inFormat == null) {
            return false;
        }
        int length = inFormat.length();
        boolean insideQuote = false;
        for (int i = 0; i < length; ++i) {
            char c = inFormat.charAt(i);
            if (c == '\'') {
                insideQuote = !insideQuote;
                continue;
            }
            if (insideQuote || c != designator) continue;
            return true;
        }
        return false;
    }

    public static CharSequence format(CharSequence inFormat, Calendar inDate) {
        int count;
        SpannableStringBuilder s = new SpannableStringBuilder(inFormat);
        DateFormatSymbols dfs = DateFormat.getIcuDateFormatSymbols(AndroidLocale.getDefault());
        String[] amPm = dfs.getAmPmStrings();
        int len = inFormat.length();
        for (int i = 0; i < len; i += count) {
            String replacement;
            count = 1;
            char c = s.charAt(i);
            if (c == '\'') {
                count = DateFormat.appendQuotedText(s, i);
                len = s.length();
                continue;
            }
            while (i + count < len && s.charAt(i + count) == c) {
                ++count;
            }
            switch (c) {
                case 'A': 
                case 'a': {
                    replacement = amPm[inDate.get(9) - 0];
                    break;
                }
                case 'd': {
                    replacement = DateFormat.zeroPad(inDate.get(5), count);
                    break;
                }
                case 'E': 
                case 'c': {
                    replacement = DateFormat.getDayOfWeekString(dfs, inDate.get(7), count, c);
                    break;
                }
                case 'K': 
                case 'h': {
                    int hour = inDate.get(10);
                    if (c == 'h' && hour == 0) {
                        hour = 12;
                    }
                    replacement = DateFormat.zeroPad(hour, count);
                    break;
                }
                case 'H': 
                case 'k': {
                    int hour = inDate.get(11);
                    replacement = DateFormat.zeroPad(hour, count);
                    break;
                }
                case 'L': 
                case 'M': {
                    replacement = DateFormat.getMonthString(dfs, inDate.get(2), count, c);
                    break;
                }
                case 'm': {
                    replacement = DateFormat.zeroPad(inDate.get(12), count);
                    break;
                }
                case 's': {
                    replacement = DateFormat.zeroPad(inDate.get(13), count);
                    break;
                }
                case 'y': {
                    replacement = DateFormat.getYearString(inDate.get(1), count);
                    break;
                }
                case 'z': {
                    replacement = DateFormat.getTimeZoneString(inDate, count);
                    break;
                }
                default: {
                    replacement = null;
                }
            }
            if (replacement == null) continue;
            s.replace(i, i + count, replacement);
            count = replacement.length();
            len = s.length();
        }
        if (inFormat instanceof Spanned) {
            return new SpannedString(s);
        }
        return s.toString();
    }

    private static String getDayOfWeekString(DateFormatSymbols dfs, int day, int count, int kind) {
        int context;
        boolean standalone = kind == 99;
        int n = context = standalone ? 1 : 0;
        int width = count == 5 ? 2 : (count == 4 ? 1 : 0);
        return dfs.getWeekdays(context, width)[day];
    }

    private static String getMonthString(DateFormatSymbols dfs, int month, int count, int kind) {
        int monthContext;
        boolean standalone = kind == 76;
        int n = monthContext = standalone ? 1 : 0;
        if (count == 5) {
            return dfs.getMonths(monthContext, 2)[month];
        }
        if (count == 4) {
            return dfs.getMonths(monthContext, 1)[month];
        }
        if (count == 3) {
            return dfs.getMonths(monthContext, 0)[month];
        }
        return DateFormat.zeroPad(month + 1, count);
    }

    private static String getTimeZoneString(Calendar inDate, int count) {
        TimeZone tz = inDate.getTimeZone();
        if (count < 2) {
            return DateFormat.formatZoneOffset(inDate.get(16) + inDate.get(15), count);
        }
        boolean dst = inDate.get(16) != 0;
        return tz.getDisplayName(dst, 0);
    }

    private static String formatZoneOffset(int offset2, int count) {
        StringBuilder tb = new StringBuilder();
        if ((offset2 /= 1000) < 0) {
            tb.insert(0, "-");
            offset2 = -offset2;
        } else {
            tb.insert(0, "+");
        }
        int hours = offset2 / 3600;
        int minutes = offset2 % 3600 / 60;
        tb.append(DateFormat.zeroPad(hours, 2));
        tb.append(DateFormat.zeroPad(minutes, 2));
        return tb.toString();
    }

    private static String getYearString(int year, int count) {
        return count <= 2 ? DateFormat.zeroPad(year % 100, 2) : String.format(AndroidLocale.getDefault(), "%d", year);
    }

    public static int appendQuotedText(SpannableStringBuilder formatString, int index) {
        int length = formatString.length();
        if (index + 1 < length && formatString.charAt(index + 1) == '\'') {
            formatString.delete(index, index + 1);
            return 1;
        }
        int count = 0;
        formatString.delete(index, index + 1);
        --length;
        while (index < length) {
            char c = formatString.charAt(index);
            if (c == '\'') {
                if (index + 1 < length && formatString.charAt(index + 1) == '\'') {
                    formatString.delete(index, index + 1);
                    --length;
                    ++count;
                    ++index;
                    continue;
                }
                formatString.delete(index, index + 1);
                break;
            }
            ++index;
            ++count;
        }
        return count;
    }

    private static String zeroPad(int inValue, int inMinDigits) {
        return String.format(AndroidLocale.getDefault(), "%0" + inMinDigits + "d", inValue);
    }

    public static DateFormatSymbols getIcuDateFormatSymbols(Locale locale) {
        return new DateFormatSymbols(android.icu.util.GregorianCalendar.class, locale);
    }
}

